/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora.export;

import gate.AnnotationSet;
import gate.Document;
import gate.DocumentExporter;
import gate.Factory;
import gate.FeatureMap;
import gate.SimpleAnnotationSet;
import gate.annotation.AnnotationSetImpl;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.util.InvalidOffsetException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@CreoleResource(name="Inline XML Exporter", tool=true, autoinstances={@AutoInstance}, icon="InlineXML")
public class InlineXMLExporter
extends DocumentExporter {
    private static final long serialVersionUID = -9072204691197080958L;
    private String annotationSetName;
    private String rootElement;
    private String encoding;
    private List<String> annotationTypes;
    private Boolean includeFeatures;
    private Boolean includeOriginalMarkups;

    public InlineXMLExporter() {
        super("Inline XML", "xml", "text/xml");
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @RunTime
    @CreoleParameter(defaultValue="UTF-8")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    @RunTime
    @Optional
    @CreoleParameter
    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    @RunTime
    @Optional
    @CreoleParameter
    public void setAnnotationSetName(String annotationSetName) {
        this.annotationSetName = annotationSetName;
    }

    public List<String> getAnnotationTypes() {
        return this.annotationTypes;
    }

    @RunTime
    @CreoleParameter(defaultValue="Person;Location;Organization")
    public void setAnnotationTypes(List<String> annotationTypes) {
        this.annotationTypes = annotationTypes;
    }

    public Boolean getIncludeOriginalMarkups() {
        return this.includeOriginalMarkups;
    }

    @RunTime
    @CreoleParameter(defaultValue="false")
    public void setIncludeOriginalMarkups(Boolean includeOriginalMarkups) {
        this.includeOriginalMarkups = includeOriginalMarkups;
    }

    public Boolean getIncludeFeatures() {
        return this.includeFeatures;
    }

    @RunTime
    @CreoleParameter(defaultValue="true")
    public void setIncludeFeatures(Boolean includeFeatures) {
        this.includeFeatures = includeFeatures;
    }

    @Override
    public void export(Document doc, OutputStream out, FeatureMap options) throws IOException {
        AnnotationSetImpl backupOriginalMarkups;
        Set originalMarkups;
        block9: {
            Integer rootID = null;
            SimpleAnnotationSet withRoot = null;
            originalMarkups = null;
            backupOriginalMarkups = null;
            try {
                AnnotationSet allAnnots = doc.getAnnotations((String)options.get("annotationSetName"));
                if (!((Boolean)options.get("includeOriginalMarkups")).booleanValue()) {
                    originalMarkups = doc.getAnnotations("Original markups");
                    backupOriginalMarkups = new AnnotationSetImpl((AnnotationSet)originalMarkups);
                    originalMarkups.clear();
                }
                HashSet<String> types2Export = new HashSet<String>((List)options.get("annotationTypes"));
                AnnotationSet annots2Export = allAnnots.get(types2Export);
                withRoot = new AnnotationSetImpl(doc);
                withRoot.addAll(annots2Export);
                String rootType = (String)options.get("rootElement");
                if (rootType != null && !"".equals(rootType)) {
                    rootID = withRoot.add(0L, doc.getContent().size(), (String)options.get("rootElement"), Factory.newFeatureMap());
                }
                OutputStreamWriter writer = new OutputStreamWriter(out, (String)options.get("encoding"));
                writer.write(doc.toXml(withRoot, (Boolean)options.get("includeFeatures")));
                writer.flush();
                if (rootID == null) break block9;
            }
            catch (InvalidOffsetException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (rootID != null) {
                        withRoot.remove(withRoot.get(rootID));
                    }
                    if (backupOriginalMarkups != null) {
                        originalMarkups.addAll(backupOriginalMarkups);
                    }
                    throw throwable;
                }
            }
            withRoot.remove(withRoot.get(rootID));
        }
        if (backupOriginalMarkups != null) {
            originalMarkups.addAll(backupOriginalMarkups);
        }
    }
}

