/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.Resource;
import gate.TextualDocument;
import gate.corpora.DocumentImpl;
import gate.corpora.DocumentStaxUtils;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.corpora.TextualDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.event.StatusListener;
import gate.util.DocumentFormatException;
import gate.util.Out;
import gate.xml.XmlDocumentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@CreoleResource(name="GATE XML Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class XmlDocumentFormat
extends TextualDocumentFormat {
    private static final long serialVersionUID = 3205973554326782116L;
    private static XMLInputFactory staxFactory;

    @Override
    public Boolean supportsRepositioning() {
        return Boolean.TRUE;
    }

    @Override
    public void unpackMarkup(Document doc) throws DocumentFormatException {
        this.unpackMarkup(doc, null, null);
    }

    @Override
    public void unpackMarkup(Document doc, RepositioningInfo repInfo, RepositioningInfo ampCodingInfo) throws DocumentFormatException {
        boolean gateFormat;
        if (doc == null || doc.getSourceUrl() == null && doc.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        StatusListener statusListener = new StatusListener(){

            @Override
            public void statusChanged(String text) {
                XmlDocumentFormat.this.fireStatusChanged(text);
            }
        };
        String content = doc.getContent().toString();
        if (content.length() > 2048) {
            content = content.substring(0, 2048);
        }
        if (gateFormat = XmlDocumentFormat.isGateXmlFormat(content)) {
            this.unpackGateFormatMarkup(doc, statusListener);
        } else {
            this.unpackGeneralXmlMarkup(doc, repInfo, ampCodingInfo, statusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackGateFormatMarkup(Document doc, StatusListener statusListener) throws DocumentFormatException {
        boolean docHasContentButNoValidURL = XmlDocumentFormat.hasContentButNoValidUrl(doc);
        try {
            Reader inputReader = null;
            InputStream inputStream = null;
            XMLStreamReader xsr = null;
            if (docHasContentButNoValidURL) {
                inputReader = new StringReader(doc.getContent().toString());
                xsr = XmlDocumentFormat.getInputFactory().createXMLStreamReader(inputReader);
            } else if (doc instanceof TextualDocument) {
                String encoding = ((TextualDocument)doc).getEncoding();
                inputReader = new InputStreamReader(doc.getSourceUrl().openStream(), encoding);
                xsr = XmlDocumentFormat.getInputFactory().createXMLStreamReader(doc.getSourceUrl().toExternalForm(), inputReader);
            } else {
                inputStream = doc.getSourceUrl().openStream();
                xsr = XmlDocumentFormat.getInputFactory().createXMLStreamReader(doc.getSourceUrl().toExternalForm(), inputStream);
            }
            xsr.nextTag();
            try {
                DocumentStaxUtils.readGateXmlDocument(xsr, doc, statusListener);
            }
            finally {
                xsr.close();
                if (inputStream != null) {
                    inputStream.close();
                }
                if (inputReader != null) {
                    inputReader.close();
                }
            }
        }
        catch (XMLStreamException e) {
            doc.getFeatures().put("parsingError", Boolean.TRUE);
            Boolean bThrow = (Boolean)doc.getFeatures().get("throwExceptionOnFormatError");
            if (bThrow != null && bThrow.booleanValue()) {
                throw new DocumentFormatException(e);
            }
            Out.println("Warning: Document remains unparsed. \n\n  Stack Dump: ");
            e.printStackTrace(Out.getPrintWriter());
        }
        catch (IOException ioe) {
            throw new DocumentFormatException("I/O exception for " + doc.getSourceUrl().toString(), ioe);
        }
    }

    private static XMLInputFactory getInputFactory() throws XMLStreamException {
        if (staxFactory == null) {
            staxFactory = XMLInputFactory.newInstance();
            staxFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            staxFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            staxFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            staxFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        }
        return staxFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackGeneralXmlMarkup(Document doc, RepositioningInfo repInfo, RepositioningInfo ampCodingInfo, StatusListener statusListener) throws DocumentFormatException {
        boolean docHasContentButNoValidURL = XmlDocumentFormat.hasContentButNoValidUrl(doc);
        XmlDocumentHandler xmlDocHandler = null;
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(true);
            SAXParser xmlParser = saxParserFactory.newSAXParser();
            xmlDocHandler = new XmlDocumentHandler(doc, this.markupElementsMap, this.element2StringMap);
            xmlDocHandler.addStatusListener(statusListener);
            xmlDocHandler.setRepositioningInfo(repInfo);
            xmlDocHandler.setAmpCodingInfo(ampCodingInfo);
            XMLReader newxmlParser = xmlParser.getXMLReader();
            newxmlParser.setFeature("http://xml.org/sax/features/validation", false);
            newxmlParser.setFeature("http://xml.org/sax/features/namespaces", true);
            newxmlParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            newxmlParser.setContentHandler(xmlDocHandler);
            newxmlParser.setErrorHandler(xmlDocHandler);
            newxmlParser.setDTDHandler(xmlDocHandler);
            newxmlParser.setEntityResolver(xmlDocHandler);
            try (Reader docReader = null;){
                InputSource is;
                if (docHasContentButNoValidURL) {
                    is = new InputSource(new StringReader(doc.getContent().toString()));
                } else if (doc instanceof TextualDocument) {
                    String docEncoding = ((TextualDocument)doc).getEncoding();
                    docReader = new InputStreamReader(doc.getSourceUrl().openStream(), docEncoding);
                    is = new InputSource(docReader);
                    is.setSystemId(doc.getSourceUrl().toString());
                } else {
                    is = new InputSource(doc.getSourceUrl().toString());
                }
                newxmlParser.parse(is);
            }
            ((DocumentImpl)doc).setNextAnnotationId(xmlDocHandler.getCustomObjectsId());
        }
        catch (ParserConfigurationException e) {
            throw new DocumentFormatException("XML parser configuration exception ", e);
        }
        catch (SAXException e) {
            doc.getFeatures().put("parsingError", Boolean.TRUE);
            Boolean bThrow = (Boolean)doc.getFeatures().get("throwExceptionOnFormatError");
            if (bThrow != null && bThrow.booleanValue()) {
                throw new DocumentFormatException(e);
            }
            Out.println("Warning: Document remains unparsed. \n\n  Stack Dump: ");
            e.printStackTrace(Out.getPrintWriter());
        }
        catch (IOException e) {
            throw new DocumentFormatException("I/O exception for " + doc.getSourceUrl(), e);
        }
        finally {
            if (xmlDocHandler != null) {
                xmlDocHandler.removeStatusListener(statusListener);
            }
        }
    }

    protected static boolean isGateXmlFormat(String content) {
        return content.indexOf("<GateDocument") != -1 || content.indexOf(" GateDocument") != -1;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        MimeType mime = new MimeType("text", "xml");
        mimeString2ClassHandlerMap.put(mime.getType() + "/" + mime.getSubtype(), this);
        mimeString2mimeTypeMap.put(mime.getType() + "/" + mime.getSubtype(), mime);
        mimeString2mimeTypeMap.put("application/xml", mime);
        suffixes2mimeTypeMap.put("xml", mime);
        suffixes2mimeTypeMap.put("xhtm", mime);
        suffixes2mimeTypeMap.put("xhtml", mime);
        magic2mimeTypeMap.put("<?xml", mime);
        this.setMimeType(mime);
        return this;
    }
}

