/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;

public class MimeType {
    protected String type;
    protected String subtype;
    protected Map<String, String> parameters;

    public MimeType(String type, String subType) {
        this.type = type;
        this.subtype = subType;
        this.parameters = new HashMap<String, String>();
    }

    public MimeType(String raw) throws MimeTypeParseException {
        javax.activation.MimeType parsed = new javax.activation.MimeType(raw);
        this.type = parsed.getPrimaryType();
        this.subtype = parsed.getSubType();
        this.parameters = new HashMap<String, String>();
        MimeTypeParameterList params = parsed.getParameters();
        Enumeration paramNames = params.getNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            System.out.println(name + "/" + params.get(name));
            this.parameters.put(name, params.get(name));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MimeType other = (MimeType)obj;
        if (this.subtype == null ? other.subtype != null : !this.subtype.equals(other.subtype)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subtype == null ? 0 : this.subtype.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public void addParameter(String param, String value) {
        this.parameters.put(param, value);
    }

    public String getParameterValue(String name) {
        return this.parameters.get(name);
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public String toString() {
        return this.type + "/" + this.subtype;
    }
}

