/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Controller;
import gate.Corpus;
import gate.Document;
import gate.DocumentContent;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.SimpleAnnotation;
import gate.SimpleDocument;
import gate.annotation.AnnotationSetImpl;
import gate.annotation.ImmutableAnnotationSetImpl;
import gate.creole.ConditionalSerialController;
import gate.creole.Plugin;
import gate.creole.RunningStrategy;
import gate.util.FeatureBearer;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.slf4j.Logger;

public class Utils {
    public static final OffsetComparator OFFSET_COMPARATOR = new OffsetComparator();
    private static final Set<String> alreadyLoggedMessages = Collections.synchronizedSet(new HashSet());
    private static Pattern nsQNamePattern = Pattern.compile("^(.*:)(.+)$");
    private static final Pattern varnamePattern = Pattern.compile("(\\$\\$?)([a-zA-Z]*)\\{([^}]+)\\}");

    public static int length(SimpleAnnotation ann) {
        long len = Utils.lengthLong(ann);
        if (len > Integer.MAX_VALUE) {
            throw new GateRuntimeException("Length of annotation too big to be returned as an int: " + len);
        }
        return (int)len;
    }

    public static long lengthLong(SimpleAnnotation ann) {
        return ann.getEndNode().getOffset() - ann.getStartNode().getOffset();
    }

    public static int length(Document doc) {
        long len = doc.getContent().size();
        if (len > Integer.MAX_VALUE) {
            throw new GateRuntimeException("Length of document too big to be returned as an int: " + len);
        }
        return (int)len;
    }

    public static long lengthLong(Document doc) {
        return doc.getContent().size();
    }

    public static DocumentContent contentFor(SimpleDocument doc, SimpleAnnotation ann) {
        try {
            return doc.getContent().getContent(ann.getStartNode().getOffset(), ann.getEndNode().getOffset());
        }
        catch (InvalidOffsetException ex) {
            throw new GateRuntimeException(ex.getMessage());
        }
    }

    public static String stringFor(Document doc, SimpleAnnotation ann) {
        try {
            return doc.getContent().getContent(ann.getStartNode().getOffset(), ann.getEndNode().getOffset()).toString();
        }
        catch (InvalidOffsetException ex) {
            throw new GateRuntimeException(ex.getMessage(), ex);
        }
    }

    public static String cleanStringFor(Document doc, SimpleAnnotation ann) {
        return Utils.cleanString(Utils.stringFor(doc, ann));
    }

    public static String stringFor(Document doc, Long start, Long end) {
        try {
            return doc.getContent().getContent(start, end).toString();
        }
        catch (InvalidOffsetException ex) {
            throw new GateRuntimeException(ex.getMessage());
        }
    }

    public static String cleanStringFor(Document doc, Long start, Long end) {
        return Utils.cleanString(Utils.stringFor(doc, start, end));
    }

    public static DocumentContent contentFor(SimpleDocument doc, AnnotationSet anns) {
        try {
            return doc.getContent().getContent(anns.firstNode().getOffset(), anns.lastNode().getOffset());
        }
        catch (InvalidOffsetException ex) {
            throw new GateRuntimeException(ex.getMessage());
        }
    }

    public static String stringFor(Document doc, AnnotationSet anns) {
        try {
            return doc.getContent().getContent(anns.firstNode().getOffset(), anns.lastNode().getOffset()).toString();
        }
        catch (InvalidOffsetException ex) {
            throw new GateRuntimeException(ex.getMessage());
        }
    }

    public static String cleanStringFor(Document doc, AnnotationSet anns) {
        return Utils.cleanString(Utils.stringFor(doc, anns));
    }

    public static String cleanString(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("\\s+", " ").trim();
    }

    public static Long start(SimpleAnnotation a) {
        return a.getStartNode() == null ? null : a.getStartNode().getOffset();
    }

    public static Long start(AnnotationSet as) {
        return as.firstNode() == null ? null : as.firstNode().getOffset();
    }

    public static Long start(SimpleDocument d) {
        return 0L;
    }

    public static Long end(SimpleAnnotation a) {
        return a.getEndNode() == null ? null : a.getEndNode().getOffset();
    }

    public static Long end(AnnotationSet as) {
        return as.lastNode() == null ? null : as.lastNode().getOffset();
    }

    public static Long end(SimpleDocument d) {
        return d.getContent().size();
    }

    public static AnnotationSet getAnnotationsAtOffset(AnnotationSet annotationSet, Long atOffset) {
        AnnotationSet tmp = annotationSet.get(atOffset);
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        for (Annotation ann : tmp) {
            if (!ann.getStartNode().getOffset().equals(atOffset)) continue;
            ret.add(ann);
        }
        return Factory.createImmutableAnnotationSet(annotationSet.getDocument(), ret);
    }

    public static AnnotationSet getAnnotationsEndingAtOffset(AnnotationSet annotationSet, Long endOffset) {
        ArrayList<Annotation> endsAt = new ArrayList<Annotation>();
        Long start = endOffset > 0L ? endOffset - 1L : 0L;
        Long end = endOffset + 1L;
        AnnotationSet annotations = annotationSet.get(start, end);
        for (Annotation a : annotations) {
            if (!a.getEndNode().getOffset().equals(endOffset)) continue;
            endsAt.add(a);
        }
        return Factory.createImmutableAnnotationSet(annotationSet.getDocument(), endsAt);
    }

    public static AnnotationSet getContainedAnnotations(AnnotationSet sourceAnnotationSet, Annotation containingAnnotation) {
        return Utils.getContainedAnnotations(sourceAnnotationSet, containingAnnotation, "");
    }

    public static AnnotationSet getContainedAnnotations(AnnotationSet sourceAnnotationSet, Annotation containingAnnotation, String targetType) {
        if (targetType.equals("")) {
            return sourceAnnotationSet.getContained(containingAnnotation.getStartNode().getOffset(), containingAnnotation.getEndNode().getOffset());
        }
        return sourceAnnotationSet.getContained(containingAnnotation.getStartNode().getOffset(), containingAnnotation.getEndNode().getOffset()).get(targetType);
    }

    public static AnnotationSet getContainedAnnotations(AnnotationSet sourceAnnotationSet, AnnotationSet containingAnnotationSet) {
        return Utils.getContainedAnnotations(sourceAnnotationSet, containingAnnotationSet, "");
    }

    public static AnnotationSet getContainedAnnotations(AnnotationSet sourceAnnotationSet, AnnotationSet containingAnnotationSet, String targetType) {
        if (containingAnnotationSet.isEmpty() || sourceAnnotationSet.isEmpty()) {
            return Factory.createImmutableAnnotationSet(sourceAnnotationSet.getDocument(), null);
        }
        if (targetType.equals("")) {
            return sourceAnnotationSet.getContained(containingAnnotationSet.firstNode().getOffset(), containingAnnotationSet.lastNode().getOffset());
        }
        return sourceAnnotationSet.getContained(containingAnnotationSet.firstNode().getOffset(), containingAnnotationSet.lastNode().getOffset()).get(targetType);
    }

    public static AnnotationSet getCoveringAnnotations(AnnotationSet sourceAnnotationSet, Annotation coveredAnnotation) {
        return Utils.getCoveringAnnotations(sourceAnnotationSet, coveredAnnotation, "");
    }

    public static AnnotationSet getCoveringAnnotations(AnnotationSet sourceAnnotationSet, Annotation coveredAnnotation, String targetType) {
        return sourceAnnotationSet.getCovering(targetType, coveredAnnotation.getStartNode().getOffset(), coveredAnnotation.getEndNode().getOffset());
    }

    public static AnnotationSet getCoveringAnnotations(AnnotationSet sourceAnnotationSet, AnnotationSet coveredAnnotationSet) {
        return Utils.getCoveringAnnotations(sourceAnnotationSet, coveredAnnotationSet, "");
    }

    public static AnnotationSet getCoveringAnnotations(AnnotationSet sourceAnnotationSet, AnnotationSet coveredAnnotationSet, String targetType) {
        if (coveredAnnotationSet.isEmpty() || sourceAnnotationSet.isEmpty()) {
            return Factory.createImmutableAnnotationSet(sourceAnnotationSet.getDocument(), null);
        }
        return sourceAnnotationSet.getCovering(targetType, coveredAnnotationSet.firstNode().getOffset(), coveredAnnotationSet.lastNode().getOffset());
    }

    public static AnnotationSet getOverlappingAnnotations(AnnotationSet sourceAnnotationSet, Annotation overlappedAnnotation) {
        return Utils.getOverlappingAnnotations(sourceAnnotationSet, overlappedAnnotation, "");
    }

    public static AnnotationSet getOverlappingAnnotations(AnnotationSet sourceAnnotationSet, Annotation overlappedAnnotation, String targetType) {
        if (targetType == null || targetType.isEmpty()) {
            return sourceAnnotationSet.get(overlappedAnnotation.getStartNode().getOffset(), overlappedAnnotation.getEndNode().getOffset());
        }
        return sourceAnnotationSet.get(targetType, overlappedAnnotation.getStartNode().getOffset(), overlappedAnnotation.getEndNode().getOffset());
    }

    public static AnnotationSet getOverlappingAnnotations(AnnotationSet sourceAnnotationSet, AnnotationSet overlappedAnnotationSet) {
        return Utils.getOverlappingAnnotations(sourceAnnotationSet, overlappedAnnotationSet, "");
    }

    public static AnnotationSet getOverlappingAnnotations(AnnotationSet sourceAnnotationSet, AnnotationSet overlappedAnnotationSet, String targetType) {
        if (overlappedAnnotationSet.isEmpty() || sourceAnnotationSet.isEmpty()) {
            return Factory.createImmutableAnnotationSet(sourceAnnotationSet.getDocument(), null);
        }
        if (targetType == null || targetType.isEmpty()) {
            return sourceAnnotationSet.get(overlappedAnnotationSet.firstNode().getOffset(), overlappedAnnotationSet.lastNode().getOffset());
        }
        return sourceAnnotationSet.get(targetType, overlappedAnnotationSet.firstNode().getOffset(), overlappedAnnotationSet.lastNode().getOffset());
    }

    public static List<Annotation> inDocumentOrder(AnnotationSet as) {
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        if (as != null) {
            ret.addAll(as);
            Collections.sort(ret, OFFSET_COMPARATOR);
        }
        return ret;
    }

    public static FeatureMap featureMap(Object ... values) {
        FeatureMap fm = Factory.newFeatureMap();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                fm.put(values[i], values[++i]);
            }
        }
        return fm;
    }

    public static FeatureMap toFeatureMap(Map<?, ?> map) {
        FeatureMap fm = Factory.newFeatureMap();
        fm.putAll(map);
        return fm;
    }

    public static boolean isEnabled(Controller controller, ProcessingResource pr) {
        Collection<ProcessingResource> prs = controller.getPRs();
        if (!prs.contains(pr)) {
            return false;
        }
        if (controller instanceof ConditionalSerialController) {
            List<RunningStrategy> rss = ((ConditionalSerialController)controller).getRunningStrategies();
            for (RunningStrategy rs : rss) {
                if (!rs.getPR().equals(pr) || rs.getRunMode() == 2) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static RunningStrategy getRunningStrategy(Controller controller, ProcessingResource pr) {
        if (controller instanceof ConditionalSerialController) {
            List<RunningStrategy> rss = ((ConditionalSerialController)controller).getRunningStrategies();
            for (RunningStrategy rs : rss) {
                if (rs.getPR() != pr) continue;
                return rs;
            }
        }
        return null;
    }

    @Deprecated
    public static void logOnce(org.apache.log4j.Logger logger, Level level, String message) {
        if (!alreadyLoggedMessages.contains(message)) {
            try {
                logger.log((Priority)level, (Object)message);
            }
            catch (Exception e) {
                System.err.println("Failed to access logger through deprecated gate.Utils.logOnce method.\nLog message was: " + message);
            }
            alreadyLoggedMessages.add(message);
        }
    }

    public static void logOnce(Logger logger, org.slf4j.event.Level level, String message) {
        if (!alreadyLoggedMessages.contains(message)) {
            switch (level) {
                case TRACE: {
                    logger.trace(message);
                    break;
                }
                case DEBUG: {
                    logger.debug(message);
                    break;
                }
                case INFO: {
                    logger.info(message);
                    break;
                }
                case WARN: {
                    logger.warn(message);
                    break;
                }
                case ERROR: {
                    logger.error(message);
                    break;
                }
            }
            alreadyLoggedMessages.add(message);
        }
    }

    public static boolean isLoggedOnce(String message) {
        boolean isThere = alreadyLoggedMessages.contains(message);
        if (!isThere) {
            alreadyLoggedMessages.add(message);
        }
        return isThere;
    }

    public static Annotation getOnlyAnn(AnnotationSet annset) {
        if (annset.size() != 1) {
            throw new GateRuntimeException("Annotation set does not contain exactly 1 annotation but " + annset.size());
        }
        return annset.iterator().next();
    }

    public static Integer addAnn(AnnotationSet outSet, AnnotationSet spanSet, String type, FeatureMap fm) {
        try {
            return outSet.add(Utils.start(spanSet), Utils.end(spanSet), type, fm);
        }
        catch (InvalidOffsetException ex) {
            throw new GateRuntimeException("Offset error when trying to add new annotation: ", ex);
        }
    }

    public static Integer addAnn(AnnotationSet outSet, long startOffset, long endOffset, String type, FeatureMap fm) {
        try {
            return outSet.add(startOffset, endOffset, type, fm);
        }
        catch (InvalidOffsetException ex) {
            throw new GateRuntimeException("Offset error when trying to add new annotation: ", ex);
        }
    }

    public static Integer addAnn(AnnotationSet outSet, Annotation spanAnn, String type, FeatureMap fm) {
        try {
            return outSet.add(Utils.start(spanAnn), Utils.end(spanAnn), type, fm);
        }
        catch (InvalidOffsetException ex) {
            throw new GateRuntimeException("Offset error adding new annotation: ", ex);
        }
    }

    public static String expandUriString(String toExpand, Map<String, String> prefixes) {
        String baseUri = prefixes.get("");
        if (baseUri != null && prefixes.size() == 1) {
            return baseUri + toExpand;
        }
        Matcher m = nsQNamePattern.matcher(toExpand);
        if (m.matches()) {
            String prefix = m.group(1);
            String lname = m.group(2);
            String uriPrefix = prefixes.get(prefix);
            if (uriPrefix == null) {
                throw new GateRuntimeException("name prefix not found in prefix map for  " + toExpand);
            }
            return uriPrefix + lname;
        }
        if (baseUri == null) {
            throw new GateRuntimeException("No base Uri in prefix map for " + toExpand);
        }
        return baseUri + toExpand;
    }

    public static String shortenUriString(String uriString, Map<String, String> prefixes) {
        String uriPrefix = "";
        String namePrefix = "";
        for (Map.Entry<String, String> entry : prefixes.entrySet()) {
            String np = entry.getKey();
            String uri = entry.getValue();
            if (!uriString.startsWith(uri)) continue;
            uriPrefix = uri;
            namePrefix = np;
            break;
        }
        if (uriPrefix.equals("")) {
            throw new GateRuntimeException("No prefix found in prefixes map for " + uriString);
        }
        return namePrefix + uriString.substring(uriPrefix.length());
    }

    public static AnnotationSet getCoextensiveAnnotations(AnnotationSet source, AnnotationSet coextSet) {
        return Utils.getCoextensiveAnnotationsWorker(source, null, Utils.start(coextSet), Utils.end(coextSet));
    }

    public static AnnotationSet getCoextensiveAnnotations(AnnotationSet source, AnnotationSet coextSet, String type) {
        return Utils.getCoextensiveAnnotationsWorker(source, type, Utils.start(coextSet), Utils.end(coextSet));
    }

    public static AnnotationSet getCoextensiveAnnotations(AnnotationSet source, Annotation coextAnn) {
        return Utils.getCoextensiveAnnotationsWorker(source, null, Utils.start(coextAnn), Utils.end(coextAnn));
    }

    public static AnnotationSet getCoextensiveAnnotations(AnnotationSet source, Annotation coextAnn, String type) {
        return Utils.getCoextensiveAnnotationsWorker(source, type, Utils.start(coextAnn), Utils.end(coextAnn));
    }

    private static AnnotationSet getCoextensiveAnnotationsWorker(AnnotationSet source, String type, long start, long end) {
        if (source instanceof AnnotationSetImpl) {
            AnnotationSet ret = ((AnnotationSetImpl)source).getStrict(start, end);
            if (type != null) {
                return ret.get(type);
            }
            return ret;
        }
        AnnotationSet annset = source.getContained(start, end);
        ArrayList<Annotation> annotationsToAdd = new ArrayList<Annotation>();
        for (Annotation ann : annset) {
            if (Utils.start(ann) != start || Utils.end(ann) != end || type != null && !ann.getType().equals(type)) continue;
            annotationsToAdd.add(ann);
        }
        return Factory.createImmutableAnnotationSet(source.getDocument(), annotationsToAdd);
    }

    public static String replaceVariablesInString(String string, Object ... sources) {
        if (string == null || string.isEmpty() || string.length() < 6) {
            return string;
        }
        Matcher matcher = varnamePattern.matcher(string);
        int findFrom = 0;
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(string.length() * 2);
        while (findFrom < string.length() && matcher.find(findFrom)) {
            String dollars = matcher.group(1);
            String type = matcher.group(2);
            String varname = matcher.group(3);
            int matchStart = matcher.start();
            if (matchStart - lastEnd > 0) {
                sb.append(string.substring(lastEnd, matchStart));
            }
            lastEnd = matcher.end();
            Object value = null;
            if (type.equals("env")) {
                value = System.getenv().get(varname);
            } else if (type.equals("prop")) {
                value = System.getProperties().get(varname);
            } else {
                for (Object source : sources) {
                    if (type.isEmpty()) {
                        if (source instanceof Map) {
                            value = ((Map)source).get(varname);
                        }
                    } else if (type.equals("pr") && source instanceof ProcessingResource) {
                        value = ((FeatureBearer)source).getFeatures().get(varname);
                    } else if (type.equals("pr_parm") && source instanceof ProcessingResource) {
                        try {
                            value = ((ProcessingResource)source).getParameterValue(varname);
                        }
                        catch (Exception exception) {}
                    } else if (type.equals("doc") && source instanceof Document) {
                        value = ((FeatureBearer)source).getFeatures().get(varname);
                    } else if (type.equals("controller") && source instanceof Controller) {
                        value = ((FeatureBearer)source).getFeatures().get(varname);
                    } else if (type.equals("corpus") && source instanceof Corpus) {
                        value = ((FeatureBearer)source).getFeatures().get(varname);
                    } else if (type.equals("resource") && source instanceof Resource) {
                        value = ((FeatureBearer)source).getFeatures().get(varname);
                    }
                    if (value != null) break;
                }
            }
            if (value != null) {
                String replacement = value.toString();
                if (dollars.equals("$$")) {
                    replacement = Utils.replaceVariablesInString(replacement, sources);
                }
                sb.append(replacement);
            } else {
                sb.append(matcher.group());
            }
            findFrom = matcher.end();
        }
        if (lastEnd < string.length()) {
            sb.append(string.substring(lastEnd));
        }
        return sb.toString();
    }

    @Deprecated
    public static void loadPlugin(String dirName) {
        File gatehome = Gate.getGateHome();
        if (gatehome == null) {
            throw new GateRuntimeException("Cannot load Plugin, Gate home location not known");
        }
        File pluginDir = new File(new File(gatehome, "plugins"), dirName);
        Utils.loadPlugin(pluginDir);
    }

    public static void loadPlugin(File pluginDir) {
        try {
            Gate.getCreoleRegister().registerPlugin(new Plugin.Directory(pluginDir.toURI().toURL()));
        }
        catch (Exception ex) {
            throw new GateRuntimeException("Could not register plugin directory " + pluginDir, ex);
        }
    }

    public static AnnotationSet minus(AnnotationSet origSet, Annotation ... except) {
        return Utils.minus(origSet, Arrays.asList(except));
    }

    public static AnnotationSet minus(AnnotationSet origSet, Collection<Annotation> exceptions) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Annotation exception : exceptions) {
            ids.add(exception.getId());
        }
        ArrayList<Annotation> tmp = new ArrayList<Annotation>();
        for (Annotation ann : origSet) {
            if (ids.contains(ann.getId())) continue;
            tmp.add(ann);
        }
        return new ImmutableAnnotationSetImpl(origSet.getDocument(), tmp);
    }

    public static AnnotationSet plus(AnnotationSet origSet, Annotation ... toAdd) {
        return Utils.plus(origSet, Arrays.asList(toAdd));
    }

    public static AnnotationSet plus(AnnotationSet origSet, Collection<Annotation> toAdd) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Annotation orig : origSet) {
            ids.add(orig.getId());
        }
        ArrayList<Annotation> tmp = new ArrayList<Annotation>();
        tmp.addAll(origSet);
        for (Annotation ann : toAdd) {
            if (ids.contains(ann.getId())) continue;
            tmp.add(ann);
        }
        return new ImmutableAnnotationSetImpl(origSet.getDocument(), tmp);
    }

    public static AnnotationSet intersect(AnnotationSet origSet, Annotation ... others) {
        return Utils.intersect(origSet, Arrays.asList(others));
    }

    public static AnnotationSet intersect(AnnotationSet origSet, Collection<Annotation> others) {
        if (others.isEmpty()) {
            return new ImmutableAnnotationSetImpl(origSet.getDocument(), null);
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Annotation other : others) {
            ids.add(other.getId());
        }
        ArrayList<Annotation> tmp = new ArrayList<Annotation>();
        for (Annotation ann : origSet) {
            if (!ids.contains(ann.getId())) continue;
            tmp.add(ann);
        }
        return new ImmutableAnnotationSetImpl(origSet.getDocument(), tmp);
    }

    public static URL resolveURL(String url) throws IOException {
        return Utils.resolveURL(new URL(url));
    }

    public static URL resolveURL(URL url) throws IOException {
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            return url;
        }
        URL resourceUrl = url;
        HashSet<String> seenUrls = new HashSet<String>();
        int followedRedirects = 0;
        block3: while (followedRedirects++ < 20) {
            if (!seenUrls.add(resourceUrl.toExternalForm())) {
                throw new IOException("Redirection loop detected for URL " + url);
            }
            HttpURLConnection conn = (HttpURLConnection)resourceUrl.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setInstanceFollowRedirects(false);
            switch (conn.getResponseCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    String location = conn.getHeaderField("Location");
                    location = URLDecoder.decode(location, "UTF-8");
                    URL newUrl = new URL(resourceUrl, location);
                    if (!newUrl.getProtocol().equalsIgnoreCase("http") && !newUrl.getProtocol().equalsIgnoreCase("https")) break;
                    resourceUrl = newUrl;
                    continue block3;
                }
            }
            return resourceUrl;
        }
        throw new IOException("Too many redirects for " + url);
    }
}

