/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class RightArrowIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 6.0E-7f, 2.4E-6f));
        float alpha__0_0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = RightArrowIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(9.980795, 5.6512823);
        shape.curveTo(13.588514, 12.335122, 18.469658, 17.89442, 23.148842, 23.289017);
        shape.curveTo(26.29942, 25.620867, 29.718521, 26.974924, 32.886387, 29.236801);
        shape.curveTo(34.257393, 30.116407, 35.64088, 30.939497, 37.0, 31.843424);
        shape.lineTo(29.72529, 38.211636);
        shape.curveTo(28.37573, 37.3847, 27.039936, 36.520565, 25.682573, 35.715267);
        shape.curveTo(22.479568, 33.356033, 18.937826, 32.1422, 15.893375, 29.384539);
        shape.curveTo(11.125596, 23.56273, 6.216308, 17.65201, 2.1252918, 11.012199);
        shape.lineTo(9.980795, 5.6512823);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_0;
        g.setTransform(defaultTransform__0_0_0_0);
        g.setClip(clip__0_0_0_0);
        float alpha__0_0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = RightArrowIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(9.855503, 58.560352);
        shape.curveTo(13.463222, 51.876514, 18.344366, 46.317215, 23.02355, 40.92262);
        shape.curveTo(26.174128, 38.59077, 29.59323, 37.23671, 32.761097, 34.974834);
        shape.curveTo(34.132095, 34.09523, 35.515587, 33.27214, 36.874706, 32.368214);
        shape.lineTo(29.599998, 26.0);
        shape.curveTo(28.250439, 26.826939, 26.914644, 27.69107, 25.557278, 28.496367);
        shape.curveTo(22.35427, 30.855604, 18.812534, 32.069435, 15.768083, 34.8271);
        shape.curveTo(11.000304, 40.648907, 6.0910163, 46.559628, 2.0, 53.199436);
        shape.lineTo(9.855503, 58.560352);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_1;
        g.setTransform(defaultTransform__0_0_0_1);
        g.setClip(clip__0_0_0_1);
        float alpha__0_0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = RightArrowIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(33.705154, 5.6512823);
        shape.curveTo(37.237316, 12.335122, 42.01624, 17.89442, 46.59743, 23.289017);
        shape.curveTo(49.682034, 25.620867, 53.02953, 26.974924, 56.131054, 29.236801);
        shape.curveTo(57.473343, 30.116407, 58.82786, 30.939497, 60.15852, 31.843424);
        shape.lineTo(53.036156, 38.211636);
        shape.curveTo(51.714863, 37.3847, 50.40704, 36.520565, 49.0781, 35.715267);
        shape.curveTo(45.942173, 33.356033, 42.474606, 32.1422, 39.49391, 29.384539);
        shape.curveTo(34.825977, 23.56273, 30.019503, 17.65201, 26.014158, 11.012199);
        shape.lineTo(33.705154, 5.6512823);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_2;
        g.setTransform(defaultTransform__0_0_0_2);
        g.setClip(clip__0_0_0_2);
        float alpha__0_0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_0_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = RightArrowIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(33.546635, 58.560352);
        shape.curveTo(37.078796, 51.876514, 41.85772, 46.317215, 46.43891, 40.92262);
        shape.curveTo(49.523514, 38.59077, 52.871014, 37.23671, 55.972534, 34.974834);
        shape.curveTo(57.314823, 34.09523, 58.669342, 33.27214, 60.0, 32.368214);
        shape.lineTo(52.87764, 26.0);
        shape.curveTo(51.556343, 26.826939, 50.24852, 27.69107, 48.919582, 28.496367);
        shape.curveTo(45.783653, 30.855604, 42.316086, 32.069435, 39.335392, 34.8271);
        shape.curveTo(34.667458, 40.648907, 29.860983, 46.559628, 25.855639, 53.199436);
        shape.lineTo(33.546635, 58.560352);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_3;
        g.setTransform(defaultTransform__0_0_0_3);
        g.setClip(clip__0_0_0_3);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 3;
    }

    public static int getOrigY() {
        return 6;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public RightArrowIcon() {
        this(RightArrowIcon.getOrigWidth(), RightArrowIcon.getOrigHeight(), false);
    }

    public RightArrowIcon(boolean disabled) {
        this(RightArrowIcon.getOrigWidth(), RightArrowIcon.getOrigHeight(), disabled);
    }

    public RightArrowIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public RightArrowIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public RightArrowIcon(int width, int height) {
        this(width, height, false);
    }

    public RightArrowIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)RightArrowIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)RightArrowIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        RightArrowIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

