/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ParamIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -334.09375f, -572.6532f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(0.9989053f, 0.0f, 0.0f, 1.0010959f, 1.0000017f, 0.0f));
        float alpha__0_0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = ParamIcon.getColor(255, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(360.67456, 601.0472);
        shape.lineTo(353.55737, 601.0472);
        shape.lineTo(353.55737, 600.0811);
        shape.curveTo(353.55737, 599.00336, 353.77423, 598.0505, 354.20798, 597.2224);
        shape.curveTo(354.6417, 596.3812, 355.55518, 595.31665, 356.9484, 594.02856);
        shape.lineTo(358.21017, 592.8851);
        shape.curveTo(358.95935, 592.2016, 359.5048, 591.5576, 359.84653, 590.95294);
        shape.curveTo(360.2014, 590.3484, 360.3788, 589.7438, 360.37885, 589.13916);
        shape.curveTo(360.3788, 588.2191, 360.0634, 587.5028, 359.4325, 586.9902);
        shape.curveTo(358.8016, 586.4645, 357.921, 586.2016, 356.79065, 586.20154);
        shape.curveTo(355.726, 586.20154, 354.57596, 586.425, 353.34048, 586.8719);
        shape.curveTo(352.10498, 587.30566, 350.81693, 587.95624, 349.4763, 588.82367);
        shape.lineTo(349.4763, 582.63306);
        shape.curveTo(351.06665, 582.08105, 352.519, 581.67365, 353.83334, 581.4107);
        shape.curveTo(355.14767, 581.1479, 356.41602, 581.0164, 357.6384, 581.0164);
        shape.curveTo(360.8454, 581.0164, 363.29007, 581.67365, 364.97247, 582.988);
        shape.curveTo(366.65482, 584.2892, 367.496, 586.195, 367.49603, 588.7054);
        shape.curveTo(367.496, 589.99347, 367.23972, 591.1501, 366.72714, 592.1753);
        shape.curveTo(366.21454, 593.1874, 365.34048, 594.27826, 364.105, 595.448);
        shape.lineTo(362.84323, 596.5718);
        shape.curveTo(361.94946, 597.38666, 361.36456, 598.0439, 361.08856, 598.54333);
        shape.curveTo(360.81253, 599.02966, 360.67453, 599.56854, 360.67453, 600.16);
        shape.lineTo(360.67453, 601.0472);
        shape.moveTo(353.55734, 603.965);
        shape.lineTo(360.67453, 603.965);
        shape.lineTo(360.67453, 610.98364);
        shape.lineTo(353.55734, 610.98364);
        shape.lineTo(353.55734, 603.965);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_0;
        g.setTransform(defaultTransform__0_0_0_0);
        g.setClip(clip__0_0_0_0);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = ParamIcon.getColor(46, 0, 255, 255, disabled);
        stroke = new BasicStroke(4.0f, 1, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(348.6776, 577.27594);
        shape.lineTo(338.09375, 597.3842);
        shape.lineTo(348.84836, 616.0306);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = ParamIcon.getColor(46, 0, 255, 255, disabled);
        stroke = new BasicStroke(4.0f, 1, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(367.26447, 577.27594);
        shape.lineTo(377.84833, 597.3842);
        shape.lineTo(367.09372, 616.0306);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 2;
    }

    public static int getOrigY() {
        return 3;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public ParamIcon() {
        this(ParamIcon.getOrigWidth(), ParamIcon.getOrigHeight(), false);
    }

    public ParamIcon(boolean disabled) {
        this(ParamIcon.getOrigWidth(), ParamIcon.getOrigHeight(), disabled);
    }

    public ParamIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public ParamIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public ParamIcon(int width, int height) {
        this(width, height, false);
    }

    public ParamIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)ParamIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)ParamIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        ParamIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

