/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class PRIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(0.844092f, 1.037574f, -1.071672f, 0.817236f, 49.641f, -14.10304f));
        paint = PRIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(35.454544, 31.636364);
        shape.curveTo(35.454544, 33.343426, 34.111397, 34.727272, 32.454544, 34.727272);
        shape.curveTo(30.79769, 34.727272, 29.454544, 33.343426, 29.454544, 31.636364);
        shape.curveTo(29.454544, 29.929302, 30.79769, 28.545456, 32.454544, 28.545456);
        shape.curveTo(34.111397, 28.545456, 35.454544, 29.929302, 35.454544, 31.636364);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.071672f, -0.817236f, 0.844092f, 1.037574f, -11.76057f, 9.955788f));
        float alpha__0_0_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_0 = g.getClip();
        AffineTransform defaultTransform__0_0_1_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = PRIcon.getColor(254, 95, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(16.212381, 27.727272);
        shape.curveTo(16.212381, 37.306908, 21.443377, 39.42822, 14.267971, 39.3118);
        shape.curveTo(7.283471, 39.19848, 12.541548, 40.280865, 12.541548, 28.33759);
        shape.curveTo(12.541548, 16.394318, 3.8165436, 10.656669, 14.169959, 10.999999);
        shape.curveTo(25.69642, 11.389293, 16.212381, 15.783999, 16.212381, 27.727272);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = PRIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0165293f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(16.212381, 27.727272);
        shape.curveTo(16.212381, 37.306908, 21.443377, 39.42822, 14.267971, 39.3118);
        shape.curveTo(7.283471, 39.19848, 12.541548, 40.280865, 12.541548, 28.33759);
        shape.curveTo(12.541548, 16.394318, 3.8165436, 10.656669, 14.169959, 10.999999);
        shape.curveTo(25.69642, 11.389293, 16.212381, 15.783999, 16.212381, 27.727272);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_0;
        g.setTransform(defaultTransform__0_0_1_0);
        g.setClip(clip__0_0_1_0);
        float alpha__0_0_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = PRIcon.getColor(255, 173, 93, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(11.349432, 13.03125);
        shape.curveTo(11.811704, 18.211111, 15.275704, 24.783306, 13.870202, 30.83242);
        shape.curveTo(11.06945, 36.654816, 17.314505, 40.248535, 15.295091, 32.881847);
        shape.curveTo(13.673667, 26.299482, 15.904064, 19.79117, 17.818182, 13.59375);
        shape.curveTo(15.805742, 12.776059, 13.489641, 12.879791, 11.349432, 13.03125);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1_1;
        g.setTransform(defaultTransform__0_0_1_1);
        g.setClip(clip__0_0_1_1);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 2;
    }

    public static int getOrigY() {
        return 0;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public PRIcon() {
        this(PRIcon.getOrigWidth(), PRIcon.getOrigHeight(), false);
    }

    public PRIcon(boolean disabled) {
        this(PRIcon.getOrigWidth(), PRIcon.getOrigHeight(), disabled);
    }

    public PRIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public PRIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public PRIcon(int width, int height) {
        this(width, height, false);
    }

    public PRIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)PRIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)PRIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        PRIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

