/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class EditIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 22.559887f, 5.3478956f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 60.78337f, 49.43458f));
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.8453473f, 0.0f, 0.0f, 1.8453473f, -63.092373f, -26.159695f));
        float alpha__0_0_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_0 = g.getClip();
        AffineTransform defaultTransform__0_0_1_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_1_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_1_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(28.078697204589844, 12.338077545166016), new Point2D.Double(30.432113647460938, 14.691494941711426), new float[]{0.0f, 1.0f}, new Color[]{EditIcon.getColor(252, 175, 62, 255, disabled), EditIcon.getColor(206, 92, 0, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 6.39225f, 12.18459f));
        shape = new GeneralPath();
        shape.moveTo(25.89225, 30.18459);
        shape.lineTo(42.89225, 13.184589);
        shape.curveTo(45.0673, 13.54455, 45.97697, 14.916815, 46.39225, 16.68459);
        shape.lineTo(29.39225, 33.68459);
        shape.lineTo(24.776133, 34.389095);
        shape.lineTo(25.89225, 30.18459);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = new LinearGradientPaint(new Point2D.Double(23.44780921936035, 21.481258392333984), new Point2D.Double(22.81021499633789, 22.118852615356445), new float[]{0.0f, 1.0f}, new Color[]{EditIcon.getColor(206, 92, 0, 255, disabled), EditIcon.getColor(206, 92, 0, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 6.39225f, 12.18459f));
        stroke = new BasicStroke(1.0f, 0, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(25.89225, 30.18459);
        shape.lineTo(42.89225, 13.184589);
        shape.curveTo(45.0673, 13.54455, 45.97697, 14.916815, 46.39225, 16.68459);
        shape.lineTo(29.39225, 33.68459);
        shape.lineTo(24.776133, 34.389095);
        shape.lineTo(25.89225, 30.18459);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_0_0;
        g.setTransform(defaultTransform__0_0_1_0_0);
        g.setClip(clip__0_0_1_0_0);
        float alpha__0_0_1_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.28235295f));
        Shape clip__0_0_1_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = EditIcon.getColor(255, 255, 255, 255, disabled);
        stroke = new BasicStroke(1.0000006f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.792248, 30.68459);
        shape.lineTo(43.289997, 14.28684);
        shape.curveTo(44.37974, 14.465276, 44.80726, 15.274784, 45.289997, 16.28684);
        shape.lineTo(28.892248, 32.78459);
        shape.lineTo(25.592245, 33.684593);
        shape.lineTo(26.792246, 30.68459);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_0_1;
        g.setTransform(defaultTransform__0_0_1_0_1);
        g.setClip(clip__0_0_1_0_1);
        origAlpha = alpha__0_0_1_0;
        g.setTransform(defaultTransform__0_0_1_0);
        g.setClip(clip__0_0_1_0);
        float alpha__0_0_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_1_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1_0 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(26.3792724609375, 34.38983917236328), new Point2D.Double(25.485055923461914, 32.71437454223633), new float[]{0.0f, 1.0f}, new Color[]{EditIcon.getColor(233, 185, 110, 255, disabled), EditIcon.getColor(255, 255, 255, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(24.549578, 34.633026);
        shape.lineTo(26.2159, 30.452717);
        shape.curveTo(26.2159, 30.452717, 27.415436, 30.698076, 28.148077, 31.427805);
        shape.curveTo(28.880718, 32.157536, 29.146467, 33.37163, 29.146467, 33.37163);
        shape.lineTo(24.549578, 34.633022);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1_1_0;
        g.setTransform(defaultTransform__0_0_1_1_0);
        g.setClip(clip__0_0_1_1_0);
        float alpha__0_0_1_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 6.39225f, 12.18459f));
        paint = EditIcon.getColor(233, 185, 110, 255, disabled);
        stroke = new BasicStroke(1.0f, 1, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(23.0, 21.5);
        shape.lineTo(17.5, 23.0);
        shape.lineTo(19.5, 18.0);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_1_1;
        g.setTransform(defaultTransform__0_0_1_1_1);
        g.setClip(clip__0_0_1_1_1);
        float alpha__0_0_1_1_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1_2 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = EditIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(23.95475, 33.68459);
        shape.lineTo(23.0485, 35.93459);
        shape.lineTo(25.39225, 35.27834);
        shape.curveTo(25.39425, 35.2465, 25.39225, 35.21693, 25.39225, 35.18459);
        shape.curveTo(25.39225, 34.382465, 24.746943, 33.72479, 23.95475, 33.68459);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1_1_2;
        g.setTransform(defaultTransform__0_0_1_1_2);
        g.setClip(clip__0_0_1_1_2);
        origAlpha = alpha__0_0_1_1;
        g.setTransform(defaultTransform__0_0_1_1);
        g.setClip(clip__0_0_1_1);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 3;
    }

    public static int getOrigY() {
        return 3;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public EditIcon() {
        this(EditIcon.getOrigWidth(), EditIcon.getOrigHeight(), false);
    }

    public EditIcon(boolean disabled) {
        this(EditIcon.getOrigWidth(), EditIcon.getOrigHeight(), disabled);
    }

    public EditIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public EditIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public EditIcon(int width, int height) {
        this(width, height, false);
    }

    public EditIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)EditIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)EditIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        EditIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

