/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class DeleteIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(0.93984205f, 0.0f, 0.0f, 0.93984205f, 6.9498577f, 7.4525294f));
        float alpha__0_0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DeleteIcon.getColor(204, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(11.318692, 9.224057);
        shape.curveTo(16.641998, 14.693048, 22.769247, 19.123652, 29.210663, 22.931107);
        shape.lineTo(27.441566, 24.159845);
        shape.curveTo(21.101864, 20.04489, 15.052508, 15.498993, 9.184082, 10.652117);
        shape.lineTo(11.318692, 9.224057);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = DeleteIcon.getColor(204, 0, 0, 255, disabled);
        stroke = new BasicStroke(2.589229f, 1, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(11.318692, 9.224057);
        shape.curveTo(16.641998, 14.693048, 22.769247, 19.123652, 29.210663, 22.931107);
        shape.lineTo(27.441566, 24.159845);
        shape.curveTo(21.101864, 20.04489, 15.052508, 15.498993, 9.184082, 10.652117);
        shape.lineTo(11.318692, 9.224057);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_0;
        g.setTransform(defaultTransform__0_0_0_0);
        g.setClip(clip__0_0_0_0);
        float alpha__0_0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = DeleteIcon.getColor(204, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(26.73892, 8.921057);
        shape.curveTo(21.867632, 15.95255, 15.247359, 21.0812, 7.906515, 25.28163);
        shape.lineTo(10.087564, 23.520857);
        shape.curveTo(8.724112, 24.379297, 25.574486, 11.804168, 23.852076, 10.207903);
        shape.lineTo(26.73892, 8.921057);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = DeleteIcon.getColor(204, 0, 0, 255, disabled);
        stroke = new BasicStroke(2.5892284f, 1, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.73892, 8.921057);
        shape.curveTo(21.867632, 15.95255, 15.247359, 21.0812, 7.906515, 25.28163);
        shape.lineTo(10.087564, 23.520857);
        shape.curveTo(8.724112, 24.379297, 25.574486, 11.804168, 23.852076, 10.207903);
        shape.lineTo(26.73892, 8.921057);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_1;
        g.setTransform(defaultTransform__0_0_0_1);
        g.setClip(clip__0_0_0_1);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 14;
    }

    public static int getOrigY() {
        return 15;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public DeleteIcon() {
        this(DeleteIcon.getOrigWidth(), DeleteIcon.getOrigHeight(), false);
    }

    public DeleteIcon(boolean disabled) {
        this(DeleteIcon.getOrigWidth(), DeleteIcon.getOrigHeight(), disabled);
    }

    public DeleteIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public DeleteIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public DeleteIcon(int width, int height) {
        this(width, height, false);
    }

    public DeleteIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)DeleteIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)DeleteIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        DeleteIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

