/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.ResourceInstantiationException;
import gate.gui.FeaturesSchemaEditor;
import gate.gui.MainFrame;
import gate.util.FeatureBearer;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FeatureMapEditorDialog
extends JDialog {
    FeatureBearer tempFMHolder = new FeatureBearer(){
        private FeatureMap fm;

        @Override
        public void setFeatures(FeatureMap map) {
            this.fm = map;
        }

        @Override
        public FeatureMap getFeatures() {
            return this.fm;
        }
    };
    FeaturesSchemaEditor fmView;
    JButton okButton;
    JButton cancelButton;
    boolean userCancelled;

    public FeatureMapEditorDialog(Component owner, FeatureMap data) {
        super(MainFrame.getInstance());
        this.setLocationRelativeTo(owner);
        this.initLocalData(data);
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData(FeatureMap data) {
        if (data != null) {
            FeatureMap fm = Factory.newFeatureMap();
            fm.putAll(data);
            this.tempFMHolder.setFeatures(fm);
        }
    }

    protected void initGuiComponents() {
        this.setMinimumSize(new Dimension(150, 300));
        this.getContentPane().setLayout(new BorderLayout());
        this.fmView = new FeaturesSchemaEditor();
        try {
            this.fmView.init();
        }
        catch (ResourceInstantiationException rie) {
            throw new GateRuntimeException("FeaturesSchemaEditor.init() threw ResourceInstantiationException!", rie);
        }
        this.fmView.setTarget(this.tempFMHolder);
        Dimension preferredSize = this.fmView.getPreferredSize();
        if (preferredSize.height < 150) {
            preferredSize.height = 150;
        } else if (preferredSize.height > 300) {
            preferredSize.height = 300;
        }
        this.fmView.setPreferredSize(preferredSize);
        JPanel fmViewPanel = new JPanel(new BorderLayout());
        fmViewPanel.add((Component)this.fmView, "Center");
        fmViewPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)fmViewPanel, "Center");
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.add(Box.createHorizontalGlue());
        this.okButton = new JButton("OK");
        buttonsBox.add(this.okButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton("Cancel");
        buttonsBox.add(this.cancelButton);
        buttonsBox.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)buttonsBox, "South");
    }

    protected void initListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureMapEditorDialog.this.userCancelled = false;
                FeatureMapEditorDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureMapEditorDialog.this.userCancelled = true;
                FeatureMapEditorDialog.this.setVisible(false);
            }
        });
    }

    public FeatureMap showDialog() {
        this.pack();
        this.userCancelled = true;
        this.setModal(true);
        super.setVisible(true);
        return this.userCancelled ? null : this.tempFMHolder.getFeatures();
    }

    public static void main(String[] args) {
        try {
            Gate.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame("Foo frame");
        FeatureMapEditorDialog dialog = new FeatureMapEditorDialog((Component)frame, null);
        frame.setSize(300, 300);
        frame.setVisible(true);
        System.out.println(dialog.showDialog());
    }
}

