/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.PhrasePositions;
import gate.creole.annic.apache.lucene.search.PhraseScorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

final class ExactPhraseScorer
extends PhraseScorer {
    int patternSize = 0;

    ExactPhraseScorer(Weight weight, TermPositions[] tps, Similarity similarity, byte[] norms) throws IOException {
        super(weight, tps, similarity, norms);
    }

    ExactPhraseScorer(Weight weight, TermPositions[] tps, Vector positions, int totalTerms, Similarity similarity, byte[] norms, Searcher searcher) throws IOException {
        super(weight, tps, positions, similarity, norms, searcher);
        this.patternSize = totalTerms;
    }

    @Override
    protected final float phraseFreq() throws IOException {
        PhrasePositions pp = this.first;
        while (pp != null) {
            pp.firstPosition();
            this.pq.put(pp);
            pp = pp.next;
        }
        this.pqToList();
        int freq = 0;
        ArrayList<Integer> firstPositions = new ArrayList<Integer>();
        while (true) {
            if (this.first.position < this.last.position) {
                do {
                    if (this.first.nextPosition()) continue;
                    if (this.searcher instanceof IndexSearcher) {
                        ((IndexSearcher)this.searcher).setFirstTermPositions(1, this.first.doc, firstPositions, this.patternSize, freq);
                    }
                    return freq;
                } while (this.first.position < this.last.position);
                this.firstToLast();
                continue;
            }
            firstPositions.add(new Integer(this.first.position));
            ++freq;
            if (!this.last.nextPosition()) break;
        }
        if (this.searcher instanceof IndexSearcher) {
            ((IndexSearcher)this.searcher).setFirstTermPositions(1, this.first.doc, firstPositions, this.patternSize, freq);
        }
        return freq;
    }
}

