/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.SegmentReader;
import gate.creole.annic.apache.lucene.index.SegmentTermDocs;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.store.InputStream;
import java.io.IOException;

final class SegmentTermPositions
extends SegmentTermDocs
implements TermPositions {
    private InputStream proxStream;
    private int proxCount;
    private int position;

    SegmentTermPositions(SegmentReader p) throws IOException {
        super(p);
        this.proxStream = (InputStream)this.parent.proxStream.clone();
    }

    @Override
    final void seek(TermInfo ti) throws IOException {
        super.seek(ti);
        if (ti != null) {
            this.proxStream.seek(ti.proxPointer);
        }
        this.proxCount = 0;
    }

    @Override
    public final void close() throws IOException {
        super.close();
        this.proxStream.close();
    }

    @Override
    public final int nextPosition() throws IOException {
        --this.proxCount;
        return this.position += this.proxStream.readVInt();
    }

    @Override
    protected final void skippingDoc() throws IOException {
        for (int f = this.freq; f > 0; --f) {
            this.proxStream.readVInt();
        }
    }

    @Override
    public final boolean next() throws IOException {
        for (int f = this.proxCount; f > 0; --f) {
            this.proxStream.readVInt();
        }
        if (super.next()) {
            this.proxCount = this.freq;
            this.position = 0;
            return true;
        }
        return false;
    }

    @Override
    public final int read(int[] docs, int[] freqs) throws IOException {
        throw new UnsupportedOperationException("TermPositions does not support processing multiple documents in one call. Use TermDocs instead.");
    }

    @Override
    protected void skipProx(long proxPointer) throws IOException {
        this.proxStream.seek(proxPointer);
        this.proxCount = 0;
    }
}

