/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.SegmentMergeInfo;
import gate.creole.annic.apache.lucene.index.SegmentMergeQueue;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import java.io.IOException;

class MultiTermEnum
extends TermEnum {
    private SegmentMergeQueue queue;
    private Term term;
    private int docFreq;

    public MultiTermEnum(IndexReader[] readers, int[] starts, Term t) throws IOException {
        this.queue = new SegmentMergeQueue(readers.length);
        for (int i = 0; i < readers.length; ++i) {
            IndexReader reader = readers[i];
            TermEnum termEnum = t != null ? reader.terms(t) : reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(starts[i], termEnum, reader);
            if (t == null ? smi.next() : termEnum.term() != null) {
                this.queue.put(smi);
                continue;
            }
            smi.close();
        }
        if (t != null && this.queue.size() > 0) {
            this.next();
        }
    }

    @Override
    public boolean next() throws IOException {
        SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
        if (top == null) {
            this.term = null;
            return false;
        }
        this.term = top.term;
        this.docFreq = 0;
        while (top != null && this.term.indexCompareTo(top.term) == 0) {
            this.queue.pop();
            this.docFreq += top.termEnum.docFreq();
            if (top.next()) {
                this.queue.put(top);
            } else {
                top.close();
            }
            top = (SegmentMergeInfo)this.queue.top();
        }
        return true;
    }

    @Override
    public Term term() {
        return this.term;
    }

    @Override
    public int docFreq() {
        return this.docFreq;
    }

    @Override
    public void close() throws IOException {
        this.queue.close();
    }
}

