/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Gate;
import gate.Resource;
import gate.Utils;
import gate.creole.ResourceReference;
import gate.creole.metadata.CreoleResource;
import gate.util.asm.AnnotationVisitor;
import gate.util.asm.ClassReader;
import gate.util.asm.ClassVisitor;
import gate.util.asm.Type;
import gate.util.asm.commons.EmptyVisitor;
import gate.util.maven.SimpleMavenCache;
import gate.util.maven.SimpleModelResolver;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.resolution.ModelResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class Plugin {
    protected Vector<DownloadListener> downloadListeners = null;
    protected static final Logger log = Logger.getLogger(Plugin.class);
    private static GenericVersionScheme versionScheme = new GenericVersionScheme();
    protected transient boolean valid = true;
    protected transient URL baseURL;
    protected transient String name;
    protected transient String description;
    protected transient String version;
    protected transient String minGateVersion;
    protected transient List<Gate.ResourceInfo> resourceInfoList = null;
    protected transient Set<Plugin> requiredPlugins = null;

    public void addDownloadListener(DownloadListener listener) {
        Vector v;
        Vector vector = v = this.downloadListeners == null ? new Vector(2) : (Vector)this.downloadListeners.clone();
        if (!v.contains(listener)) {
            v.addElement(listener);
            this.downloadListeners = v;
        }
    }

    public void removeDownloadListener(DownloadListener listener) {
        if (this.downloadListeners != null && this.downloadListeners.contains(listener)) {
            Vector v = (Vector)this.downloadListeners.clone();
            v.removeElement(listener);
            this.downloadListeners = v;
        }
    }

    protected void fireDownloadStarted(String name) {
        if (this.downloadListeners != null) {
            for (DownloadListener listener : this.downloadListeners) {
                listener.downloadStarted(name);
            }
        }
    }

    protected void fireDownloadSucceeded(String name) {
        if (this.downloadListeners != null) {
            for (DownloadListener listener : this.downloadListeners) {
                listener.downloadSucceeded(name);
            }
        }
    }

    protected void fireDownloadFailed(String name, Throwable cause) {
        if (this.downloadListeners != null) {
            for (DownloadListener listener : this.downloadListeners) {
                listener.downloadFailed(name, cause);
            }
        }
    }

    protected void fireDownloadProgressed(String name, long totalBytes, long transferredBytes) {
        if (this.downloadListeners != null) {
            for (DownloadListener listener : this.downloadListeners) {
                listener.downloadProgressed(name, totalBytes, transferredBytes);
            }
        }
    }

    public abstract Document getCreoleXML() throws Exception;

    public Document getMetadataXML() throws Exception {
        return this.getCreoleXML();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    public String getMinimumGateVersion() {
        return this.minGateVersion;
    }

    public Set<Plugin> getRequiredPlugins() {
        if (this.requiredPlugins == null) {
            this.parseCreole();
        }
        return this.requiredPlugins;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseURL == null ? 0 : this.baseURL.hashCode());
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Plugin other = (Plugin)obj;
        return !(this.baseURL == null ? other.baseURL != null : !this.baseURL.equals(other.baseURL));
    }

    public List<Gate.ResourceInfo> getResourceInfoList() {
        if (this.resourceInfoList == null) {
            this.parseCreole();
        }
        return this.resourceInfoList;
    }

    public URL getBaseURL() {
        if (this.baseURL == null) {
            try {
                this.getCreoleXML();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to determine base URL", e);
            }
        }
        return this.baseURL;
    }

    public URI getBaseURI() throws URISyntaxException {
        return this.getBaseURL().toURI();
    }

    public boolean isValid() {
        this.getResourceInfoList();
        if (Gate.VERSION == null || this.minGateVersion == null || this.minGateVersion.isEmpty()) {
            Utils.logOnce(log, Level.DEBUG, "unable to check minimum GATE version, plugins may not load or might produce errors");
            return this.valid;
        }
        try {
            boolean validGateVersion;
            Version pluginVersion = versionScheme.parseVersion(this.minGateVersion);
            boolean bl = validGateVersion = Gate.VERSION.compareTo((Object)pluginVersion) >= 0;
            if (!validGateVersion) {
                Utils.logOnce(log, Level.WARN, this.getName() + " is not compatible with this version of GATE, requires at least GATE" + pluginVersion.toString());
            }
            this.valid = this.valid && validGateVersion;
        }
        catch (InvalidVersionSpecificationException e) {
            Utils.logOnce(log, Level.DEBUG, "unable to parse minimum GATE version, plugin, " + this.getName() + ", may not load or might produce errors");
        }
        return this.valid;
    }

    public void copyResources(File dir) throws IOException, URISyntaxException {
        throw new UnsupportedOperationException("This plugin does not contain any resources that can be copied");
    }

    public boolean hasResources() {
        return false;
    }

    public static Plugin getPlugin(Class<?> clazz) throws IOException {
        URL creoleURL = clazz.getResource("/creole.xml");
        if (creoleURL == null) {
            return null;
        }
        URL baseURL = new URL(creoleURL, ".");
        for (Plugin plugin : Gate.getCreoleRegister().getPlugins()) {
            if (!plugin.getBaseURL().equals(baseURL)) continue;
            return plugin;
        }
        return null;
    }

    protected void parseCreole() {
        this.valid = true;
        this.resourceInfoList = new ArrayList<Gate.ResourceInfo>();
        this.requiredPlugins = new LinkedHashSet<Plugin>();
        String relativePathMarker = "$relpath$";
        String gatehomePathMarker = "$gatehome$";
        String gatepluginsPathMarker = "$gateplugins$";
        try {
            Document creoleDoc = this.getMetadataXML();
            this.minGateVersion = creoleDoc.getRootElement().getAttributeValue("GATE-MIN", "");
            this.version = creoleDoc.getRootElement().getAttributeValue("VERSION", "");
            this.description = creoleDoc.getRootElement().getAttributeValue("DESCRIPTION");
            this.name = creoleDoc.getRootElement().getAttributeValue("NAME");
            LinkedHashMap<String, Gate.ResourceInfo> resInfos = new LinkedHashMap<String, Gate.ResourceInfo>();
            ArrayList<Element> jobsList = new ArrayList<Element>();
            ArrayList<String> jarsToScan = new ArrayList<String>();
            ArrayList<String> allJars = new ArrayList<String>();
            jobsList.add(creoleDoc.getRootElement());
            while (!jobsList.isEmpty()) {
                Element currentElem = (Element)jobsList.remove(0);
                if (currentElem.getName().equalsIgnoreCase("JAR")) {
                    List attrs = currentElem.getAttributes();
                    for (Attribute attr : attrs) {
                        if (!attr.getName().equalsIgnoreCase("SCAN") || !attr.getBooleanValue()) continue;
                        jarsToScan.add(currentElem.getTextTrim());
                        break;
                    }
                    allJars.add(currentElem.getTextTrim());
                    continue;
                }
                if (currentElem.getName().equalsIgnoreCase("RESOURCE")) {
                    String resName = currentElem.getChildTextTrim("NAME");
                    String resClass = currentElem.getChildTextTrim("CLASS");
                    String resComment = currentElem.getChildTextTrim("COMMENT");
                    if (resInfos.containsKey(resClass)) continue;
                    Gate.ResourceInfo rHandler = new Gate.ResourceInfo(resName, resClass, resComment);
                    resInfos.put(resClass, rHandler);
                    continue;
                }
                if (currentElem.getName().equalsIgnoreCase("REQUIRES")) {
                    if (currentElem.getAttribute("GROUP") != null) {
                        this.requiredPlugins.add(new Maven(currentElem.getAttributeValue("GROUP"), currentElem.getAttributeValue("ARTIFACT"), currentElem.getAttributeValue("VERSION")));
                        continue;
                    }
                    URL url = null;
                    String urlString = currentElem.getTextTrim();
                    if (urlString.startsWith(relativePathMarker)) {
                        url = new URL(this.getBaseURL(), urlString.substring(relativePathMarker.length()));
                    } else {
                        if (urlString.startsWith(gatehomePathMarker)) {
                            throw new IOException("$gatehome$ variable no longer supported in REQUIRES element");
                        }
                        if (urlString.startsWith(gatepluginsPathMarker)) {
                            throw new IOException("$gateplugins$ variable no longer supported in REQUIRES element");
                        }
                        url = new URL(this.getBaseURL(), urlString);
                    }
                    this.requiredPlugins.add(new Directory(url));
                    Utils.logOnce(log, Level.WARN, "Dependencies on other plugins via URL is deprecated (" + this.getName() + " plugin)");
                    continue;
                }
                ArrayList<Element> newJobsList = new ArrayList<Element>(currentElem.getChildren());
                newJobsList.addAll(jobsList);
                jobsList = newJobsList;
            }
            for (String jarFile : jarsToScan) {
                URL jarUrl = new URL(this.getBaseURL(), jarFile);
                this.scanJar(jarUrl, resInfos);
            }
            ArrayList<Gate.ResourceInfo> incompleteResInfos = new ArrayList<Gate.ResourceInfo>();
            for (Gate.ResourceInfo ri : resInfos.values()) {
                if (ri.getResourceName() != null) continue;
                incompleteResInfos.add(ri);
            }
            if (!incompleteResInfos.isEmpty()) {
                this.fillInResInfos(incompleteResInfos, allJars);
            }
            for (Gate.ResourceInfo ri : incompleteResInfos) {
                if (ri.getResourceName() != null) continue;
                ri.setResourceName(ri.getResourceClassName().substring(ri.getResourceClassName().lastIndexOf(46) + 1));
            }
            this.resourceInfoList.addAll(resInfos.values());
        }
        catch (IOException ioe) {
            this.valid = false;
            log.error((Object)("Problem while parsing plugin " + this.toString() + "!\n" + ioe.toString() + "\nPlugin not available!"));
        }
        catch (JDOMException jde) {
            this.valid = false;
            log.error((Object)("Problem while parsing plugin " + this.toString() + "!\n" + jde.toString() + "\nPlugin not available!"));
        }
        catch (Exception e) {
            this.valid = false;
            log.error((Object)("Problem while parsing plugin " + this.toString() + "!\n" + e.toString() + "\nPlugin not available!"));
        }
    }

    protected void scanJar(URL jarUrl, Map<String, Gate.ResourceInfo> resInfos) throws IOException {
        JarInputStream jarInput = new JarInputStream(jarUrl.openStream(), false);
        JarEntry entry = null;
        while ((entry = jarInput.getNextJarEntry()) != null) {
            String className;
            String entryName = entry.getName();
            if (entryName == null || !entryName.endsWith(".class") || resInfos.containsKey(className = entryName.substring(0, entryName.length() - 6).replace('/', '.'))) continue;
            ClassReader classReader = new ClassReader((InputStream)jarInput);
            Gate.ResourceInfo resInfo = new Gate.ResourceInfo(null, className, null);
            ResourceInfoVisitor visitor = new ResourceInfoVisitor(resInfo);
            classReader.accept((ClassVisitor)visitor, 7);
            if (!visitor.isCreoleResource()) continue;
            resInfos.put(className, resInfo);
        }
        jarInput.close();
    }

    protected void fillInResInfos(List<Gate.ResourceInfo> incompleteResInfos, List<String> allJars) throws IOException {
        URL[] jarUrls = new URL[allJars.size()];
        for (int i = 0; i < jarUrls.length; ++i) {
            jarUrls[i] = new URL(this.getBaseURL(), allJars.get(i));
        }
        try (URLClassLoader tempClassLoader = new URLClassLoader(jarUrls, Gate.class.getClassLoader());){
            for (Gate.ResourceInfo ri : incompleteResInfos) {
                String classFile = ri.getResourceClassName().replace('.', '/') + ".class";
                InputStream classStream = tempClassLoader.getResourceAsStream(classFile);
                if (classStream == null) continue;
                ClassReader classReader = new ClassReader(classStream);
                ResourceInfoVisitor visitor = new ResourceInfoVisitor(ri);
                classReader.accept((ClassVisitor)visitor, 7);
                classStream.close();
            }
        }
    }

    public static class Component
    extends Plugin {
        private Class<? extends Resource> resourceClass;

        public Component(Class<? extends Resource> resourceClass) throws MalformedURLException {
            this.resourceClass = resourceClass;
            this.baseURL = new URL(resourceClass.getResource("/gate/creole/CreoleRegisterImpl.class"), ".");
        }

        @Override
        public String getName() {
            return this.resourceClass.getName();
        }

        @Override
        public Document getCreoleXML() throws Exception, JDOMException {
            Document doc = new Document();
            Element element = new Element("CREOLE-DIRECTORY");
            doc.addContent((Content)element);
            Element element2 = element;
            element = new Element("CREOLE");
            element2.addContent((Content)element);
            Element element3 = element;
            element = new Element("RESOURCE");
            element3.addContent((Content)element);
            Element classElement = new Element("CLASS");
            classElement.setText(this.resourceClass.getName());
            element.addContent((Content)classElement);
            return doc;
        }
    }

    protected static class ResourceInfoVisitor
    extends EmptyVisitor {
        private Gate.ResourceInfo resInfo;
        private boolean foundCreoleResource = false;
        private boolean isAbstract = false;
        private static final String CREOLE_RESOURCE_DESC = Type.getDescriptor(CreoleResource.class);

        public ResourceInfoVisitor(Gate.ResourceInfo resInfo) {
            this.resInfo = resInfo;
        }

        public boolean isCreoleResource() {
            return this.foundCreoleResource && !this.isAbstract;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isAbstract = (access & 0x600) != 0;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(CREOLE_RESOURCE_DESC)) {
                this.foundCreoleResource = true;
                return new AnnotationVisitor(327680){

                    public void visit(String name, Object value) {
                        if (name.equals("name") && resInfo.getResourceName() == null) {
                            resInfo.setResourceName((String)value);
                        } else if (name.equals("comment") && resInfo.getResourceComment() == null) {
                            resInfo.setResourceComment((String)value);
                        }
                    }

                    public AnnotationVisitor visitAnnotation(String name, String desc) {
                        return this;
                    }
                };
            }
            return super.visitAnnotation(desc, visible);
        }
    }

    public static class Maven
    extends Plugin
    implements Serializable,
    TransferListener {
        private static final long serialVersionUID = -6944695755723023537L;
        private String group;
        private String artifact;
        private String version;
        private transient URL artifactURL;
        private transient URL metadataArtifactURL;

        public Maven(String group, String artifact, String version) {
            this.group = group;
            this.artifact = artifact;
            ((Plugin)this).version = this.version = version;
            this.name = artifact;
        }

        @Override
        public String getName() {
            if (this.name == null) {
                try {
                    this.getMetadataXML();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.name == null) {
                    this.name = this.artifact;
                }
            }
            return this.name;
        }

        @Override
        public URI getBaseURI() throws URISyntaxException {
            return new URI("creole://" + this.group + ";" + this.artifact + ";" + this.version + "/");
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
            result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Maven)) {
                return false;
            }
            Maven other = (Maven)obj;
            if (this.artifact == null ? other.artifact != null : !this.artifact.equals(other.artifact)) {
                return false;
            }
            if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        @Override
        public void copyResources(File dir) throws URISyntaxException, IOException {
            if (!this.hasResources()) {
                throw new UnsupportedOperationException("this plugin doesn't have any resources you can copy as you would know had you called hasResources first :P");
            }
            final Path target = Paths.get(dir.toURI());
            try (FileSystem zipFs = FileSystems.newFileSystem(this.getArtifactURL().toURI(), new HashMap());){
                final Path pathInZip = zipFs.getPath("/resources", new String[0]);
                Files.walkFileTree(pathInZip, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                        Path relativePathInZip = pathInZip.relativize(filePath);
                        Path targetPath = target.resolve(relativePathInZip.toString());
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        Files.copy(filePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void walkResources(FileVisitor<? super Path> visitor) throws URISyntaxException, IOException {
            try (FileSystem zipFs = FileSystems.newFileSystem(this.artifactURL.toURI(), new HashMap());){
                Path resourcesPath = zipFs.getPath("/resources", new String[0]);
                if (Files.isDirectory(resourcesPath, new LinkOption[0])) {
                    Files.walkFileTree(resourcesPath, visitor);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasResources() {
            try (FileSystem zipFs = FileSystems.newFileSystem(this.getMetadataArtifactURL().toURI(), new HashMap());){
                Path pathInZip = zipFs.getPath("/resources", new String[0]);
                boolean bl = Files.isDirectory(pathInZip, new LinkOption[0]);
                return bl;
            }
            catch (Exception e) {
                return false;
            }
        }

        protected URL getMetadataArtifactURL() throws Exception {
            if (this.metadataArtifactURL != null) {
                return this.metadataArtifactURL;
            }
            if (this.artifactURL != null) {
                return this.artifactURL;
            }
            this.getMetadataXML();
            return this.metadataArtifactURL;
        }

        protected URL getArtifactURL() throws Exception {
            if (this.artifactURL == null) {
                this.getCreoleXML();
            }
            return this.artifactURL;
        }

        @Override
        public Document getMetadataXML() throws Exception {
            DefaultArtifact artifactObj = new DefaultArtifact(this.group, this.artifact, "creole", "jar", this.version);
            List<RemoteRepository> repos = gate.util.maven.Utils.getRepositoryList();
            ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)artifactObj, repos, null);
            RepositorySystem repoSystem = gate.util.maven.Utils.getRepositorySystem();
            SimpleMavenCache workspace = null;
            List<ResourceReference> persistenceURLStack = PersistenceManager.currentPersistenceURLStack();
            ArrayList<File> workspaces = new ArrayList<File>();
            if (persistenceURLStack != null && !persistenceURLStack.isEmpty()) {
                for (ResourceReference rr : persistenceURLStack) {
                    try {
                        File file = gate.util.Files.fileFromURL(rr.toURL());
                        File cache = new File(file.getParentFile(), "maven-cache.gate");
                        if (!cache.exists() || !cache.isDirectory()) continue;
                        workspaces.add(cache);
                    }
                    catch (IllegalArgumentException file) {}
                }
            }
            workspaces.addAll(gate.util.maven.Utils.getExtraCacheDirectories());
            if (!workspaces.isEmpty()) {
                workspace = new SimpleMavenCache(workspaces.toArray(new File[workspaces.size()]));
            }
            DefaultRepositorySystemSession repoSession = gate.util.maven.Utils.getRepositorySession(repoSystem, workspace);
            try {
                ArtifactResult artifactResult = repoSystem.resolveArtifact((RepositorySystemSession)repoSession, artifactRequest);
                this.metadataArtifactURL = new URL("jar:" + artifactResult.getArtifact().getFile().toURI().toURL() + "!/");
                URL expandedCreoleUrl = new URL(this.metadataArtifactURL, "META-INF/gate/creole.xml");
                try {
                    InputStream creoleStream = expandedCreoleUrl.openStream();
                    Throwable throwable = null;
                    if (creoleStream != null) {
                        if (throwable != null) {
                            try {
                                creoleStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            creoleStream.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new IOException(expandedCreoleUrl.toExternalForm() + " does not exist so this artifact is not a GATE plugin");
                }
                SAXBuilder builder = new SAXBuilder(false);
                Document creoleDoc = builder.build(expandedCreoleUrl);
                if (creoleDoc.getRootElement().getAttributeValue("NAME") == null || creoleDoc.getRootElement().getAttributeValue("VERSION") == null) {
                    return this.getCreoleXML();
                }
                return creoleDoc;
            }
            catch (IOException | ArtifactResolutionException e) {
                e.printStackTrace();
                return this.getCreoleXML();
            }
        }

        @Override
        public Document getCreoleXML() throws Exception {
            DefaultArtifact artifactObj = new DefaultArtifact(this.group, this.artifact, "jar", this.version);
            Dependency dependency = new Dependency((Artifact)artifactObj, "runtime");
            List<RemoteRepository> repos = gate.util.maven.Utils.getRepositoryList();
            ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)artifactObj, repos, null);
            RepositorySystem repoSystem = gate.util.maven.Utils.getRepositorySystem();
            SimpleMavenCache workspace = null;
            List<ResourceReference> persistenceURLStack = PersistenceManager.currentPersistenceURLStack();
            ArrayList<File> workspaces = new ArrayList<File>();
            if (persistenceURLStack != null && !persistenceURLStack.isEmpty()) {
                for (ResourceReference rr : persistenceURLStack) {
                    try {
                        File file = gate.util.Files.fileFromURL(rr.toURL());
                        File cache = new File(file.getParentFile(), "maven-cache.gate");
                        if (!cache.exists() || !cache.isDirectory()) continue;
                        workspaces.add(cache);
                    }
                    catch (IllegalArgumentException file) {}
                }
            }
            workspaces.addAll(gate.util.maven.Utils.getExtraCacheDirectories());
            if (!workspaces.isEmpty()) {
                workspace = new SimpleMavenCache(workspaces.toArray(new File[workspaces.size()]));
            }
            DefaultRepositorySystemSession repoSession = gate.util.maven.Utils.getRepositorySession(repoSystem, workspace);
            repoSession.setTransferListener((TransferListener)this);
            ArtifactResult artifactResult = repoSystem.resolveArtifact((RepositorySystemSession)repoSession, artifactRequest);
            this.metadataArtifactURL = this.artifactURL = new URL("jar:" + artifactResult.getArtifact().getFile().toURI().toURL() + "!/");
            this.baseURL = this.artifactURL;
            URL directoryXmlFileUrl = new URL(this.artifactURL, "creole.xml");
            InputStream creoleStream = null;
            try {
                creoleStream = directoryXmlFileUrl.openStream();
            }
            catch (IOException ioe) {
                throw new IOException(directoryXmlFileUrl.toExternalForm() + " does not exist so this artifact is not a GATE plugin");
            }
            CollectRequest collectRequest = new CollectRequest(dependency, repos);
            DependencyNode node = repoSystem.collectDependencies((RepositorySystemSession)repoSession, collectRequest).getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            DependencyResult result = repoSystem.resolveDependencies((RepositorySystemSession)repoSession, dependencyRequest);
            SAXBuilder builder = new SAXBuilder(false);
            Document jdomDoc = builder.build(creoleStream, this.getBaseURL().toExternalForm());
            Element creoleRoot = jdomDoc.getRootElement();
            for (ArtifactResult ar : result.getArtifactResults()) {
                Element jarElement = new Element("JAR");
                jarElement.setText(ar.getArtifact().getFile().toURI().toURL().toExternalForm());
                if (ar.getArtifact().equals(artifactResult.getArtifact())) {
                    jarElement.setAttribute("SCAN", "true");
                }
                creoleRoot.addContent((Content)jarElement);
            }
            artifactObj = new SubArtifact((Artifact)artifactObj, "", "pom");
            artifactRequest.setArtifact((Artifact)artifactObj);
            artifactResult = repoSystem.resolveArtifact((RepositorySystemSession)repoSession, artifactRequest);
            DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
            req.setProcessPlugins(false);
            req.setPomFile(artifactResult.getArtifact().getFile());
            req.setSystemProperties(System.getProperties());
            req.setModelResolver((ModelResolver)new SimpleModelResolver(repoSystem, (RepositorySystemSession)repoSession, repos));
            req.setValidationLevel(0);
            DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
            Model model = modelBuilder.build((ModelBuildingRequest)req).getEffectiveModel();
            if (model.getDescription() != null && model.getDescription().trim().equals("")) {
                jdomDoc.getRootElement().setAttribute("DESCRIPTION", model.getDescription());
            }
            jdomDoc.getRootElement().setAttribute("VERSION", this.version);
            if (model.getName() != null && !model.getName().trim().equals("")) {
                jdomDoc.getRootElement().setAttribute("NAME", model.getName());
            } else {
                jdomDoc.getRootElement().setAttribute("NAME", model.getArtifactId());
            }
            String creoleMinGate = jdomDoc.getRootElement().getAttributeValue("GATE-MIN");
            if (creoleMinGate == null) {
                for (org.apache.maven.model.Dependency effectiveDependency : model.getDependencies()) {
                    if (!effectiveDependency.getGroupId().equals("uk.ac.gate") || !effectiveDependency.getArtifactId().equals("gate-core")) continue;
                    jdomDoc.getRootElement().setAttribute("GATE-MIN", effectiveDependency.getVersion());
                    break;
                }
            }
            return jdomDoc;
        }

        public String getGroup() {
            return this.group;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        }

        public void transferStarted(TransferEvent event) throws TransferCancelledException {
            this.fireDownloadStarted(event.getResource().getFile().getName());
        }

        public void transferProgressed(TransferEvent event) throws TransferCancelledException {
            this.fireDownloadProgressed(event.getResource().getFile().getName(), event.getResource().getContentLength(), event.getTransferredBytes());
        }

        public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
            this.fireDownloadFailed(event.getResource().getFile().getName(), event.getException());
        }

        public void transferSucceeded(TransferEvent event) {
            this.fireDownloadSucceeded(event.getResource().getFile().getName());
        }

        public void transferFailed(TransferEvent event) {
            this.fireDownloadFailed(event.getResource().getFile().getName(), event.getException());
        }
    }

    public static class Directory
    extends Plugin {
        public Directory(URL directoryURL) {
            this.baseURL = Gate.normaliseCreoleUrl(directoryURL);
        }

        @Override
        public Document getCreoleXML() throws Exception {
            SAXBuilder builder = new SAXBuilder(false);
            URL creoleFileURL = new URL(this.getBaseURL(), "creole.xml");
            return builder.build(creoleFileURL);
        }

        @Override
        public String getName() {
            int lastSlash;
            if (this.name != null) {
                return this.name;
            }
            this.name = this.getBaseURL().getPath();
            if (this.name.endsWith("/")) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
            if ((lastSlash = this.name.lastIndexOf("/")) != -1) {
                this.name = this.name.substring(lastSlash + 1);
            }
            try {
                this.name = new URI(this.name).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return this.name;
        }
    }

    public static interface DownloadListener {
        public void downloadStarted(String var1);

        public void downloadProgressed(String var1, long var2, long var4);

        public void downloadSucceeded(String var1);

        public void downloadFailed(String var1, Throwable var2);
    }
}

