/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ParameterList
implements Serializable {
    private static final long serialVersionUID = -2690236156403182440L;
    private static final boolean DEBUG = false;
    protected List<List<Parameter>> runtimeParameters = new ArrayList<List<Parameter>>();
    protected List<List<Parameter>> initimeParameters = new ArrayList<List<Parameter>>();
    protected boolean fullyDefaulted = false;

    public List<List<Parameter>> getRuntimeParameters() {
        return this.runtimeParameters;
    }

    public List<List<Parameter>> getInitimeParameters() {
        return this.initimeParameters;
    }

    public boolean add(List<Parameter> disjunction) {
        boolean status = false;
        Iterator<Parameter> iter = disjunction.iterator();
        Parameter param = iter.next();
        status = param.isRuntime() ? this.runtimeParameters.add(disjunction) : this.initimeParameters.add(disjunction);
        return status;
    }

    public boolean addAll(List<Parameter> c) {
        boolean status = false;
        Iterator<Parameter> iter = c.iterator();
        while (iter.hasNext()) {
            ArrayList<Parameter> disj = new ArrayList<Parameter>();
            Parameter param = iter.next();
            disj.add(param);
            status = this.add(disj);
        }
        return status;
    }

    public FeatureMap getRuntimeDefaults() throws ParameterException {
        return this.getDefaults(this.runtimeParameters);
    }

    public FeatureMap getInitimeDefaults() throws ParameterException {
        return this.getDefaults(this.initimeParameters);
    }

    public FeatureMap getDefaults(List<List<Parameter>> parameters) throws ParameterException {
        FeatureMap defaults = Factory.newFeatureMap();
        Iterator<List<Parameter>> disjIter = parameters.iterator();
        block0: while (disjIter.hasNext()) {
            boolean optional = false;
            List<Parameter> paramDisj = disjIter.next();
            Iterator<Parameter> paramsIter = paramDisj.iterator();
            while (paramsIter.hasNext()) {
                Object defaultValue;
                Parameter param = paramsIter.next();
                if (!optional) {
                    optional = param.isOptional();
                }
                if ((defaultValue = param.calculateDefaultValue()) == null) {
                    if (optional || paramsIter.hasNext()) continue;
                    this.fullyDefaulted = false;
                    continue;
                }
                defaults.put(param.getName(), defaultValue);
                continue block0;
            }
        }
        return defaults;
    }

    public boolean isFullyDefaulted() {
        return this.fullyDefaulted;
    }

    public String toString() {
        Iterator<Parameter> iter2;
        List<Parameter> paramDisj;
        StringBuffer s = new StringBuffer(Strings.getNl() + "  ParameterList:");
        Iterator<List<Parameter>> iter = this.getRuntimeParameters().iterator();
        if (iter.hasNext()) {
            s.append(Strings.getNl() + "  runtime params=");
        }
        while (iter.hasNext()) {
            s.append(Strings.getNl() + "    ");
            paramDisj = iter.next();
            iter2 = paramDisj.iterator();
            while (iter2.hasNext()) {
                s.append(iter2.next() + Strings.getNl() + "    ");
            }
        }
        iter = this.getInitimeParameters().iterator();
        if (iter.hasNext()) {
            s.append(Strings.getNl() + "  initime params=");
        }
        while (iter.hasNext()) {
            s.append(Strings.getNl() + "    ");
            paramDisj = iter.next();
            iter2 = paramDisj.iterator();
            while (iter2.hasNext()) {
                s.append(iter2.next() + Strings.getNl() + "    ");
            }
        }
        return s.toString();
    }
}

