/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.Err;
import gate.util.persistence.AbstractPersistence;
import gate.util.persistence.PersistenceManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CollectionPersistence
extends AbstractPersistence {
    protected List<Serializable> localList;
    protected Class<?> collectionType;
    static final long serialVersionUID = 7908364068699089834L;

    @Override
    public void extractDataFromSource(Object source) throws PersistenceException {
        if (!(source instanceof Collection)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + Collection.class.getName() + " objects!\n" + source.getClass().getName() + " is not a " + Collection.class.getName());
        }
        this.collectionType = source.getClass();
        Collection coll = (Collection)source;
        this.localList = new ArrayList<Serializable>(coll.size());
        Iterator elemIter = coll.iterator();
        while (elemIter.hasNext()) {
            this.localList.add(PersistenceManager.getPersistentRepresentation(elemIter.next()));
        }
    }

    @Override
    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        ArrayList<String> exceptionsOccurred = new ArrayList<String>();
        ArrayList<Object> result = null;
        try {
            result = (ArrayList<Object>)this.collectionType.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList<Object>(this.localList.size());
        }
        for (Serializable local : this.localList) {
            try {
                result.add(PersistenceManager.getTransientRepresentation(local, this.containingControllerName, this.initParamOverrides));
            }
            catch (PersistenceException pe) {
                exceptionsOccurred.add(pe.getMessage());
                pe.printStackTrace(Err.getPrintWriter());
            }
            catch (ResourceInstantiationException rie) {
                exceptionsOccurred.add(rie.getMessage());
                rie.printStackTrace(Err.getPrintWriter());
            }
        }
        if (exceptionsOccurred.size() > 0) {
            throw new PersistenceException("Some resources cannot be restored:\n" + Arrays.toString(exceptionsOccurred.toArray(new String[exceptionsOccurred.size()])).replaceAll("[\\]\\[]", "").replaceAll(", ", "\n"));
        }
        return result;
    }
}

