/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Err;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

public class Strings {
    private static char padChar = (char)32;
    private static String newline = System.getProperty("line.separator");
    private static String pathSep = System.getProperty("path.separator");
    private static String fileSep = System.getProperty("file.separator");

    public static String getNl() {
        return newline;
    }

    public static String getPathSep() {
        return pathSep;
    }

    public static String getFileSep() {
        return fileSep;
    }

    public static String addPadding(String pad, int n) {
        StringBuffer s = new StringBuffer(pad);
        for (int i = 0; i < n; ++i) {
            s.append(padChar);
        }
        return s.toString();
    }

    public static String addLineNumbers(String text) {
        return Strings.addLineNumbers(text, 1);
    }

    public static String addLineNumbers(String text, int startLine) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String line = null;
        StringBuffer result = new StringBuffer();
        try {
            int lineNum = startLine;
            while ((line = reader.readLine()) != null) {
                String pad = lineNum < 10 ? " " : "";
                result.append(pad + lineNum + "  " + line + Strings.getNl());
                ++lineNum;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString();
    }

    public static String unescape(String str) {
        if (str == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder unicodeStr = new StringBuilder(4);
        boolean inUnicode = false;
        boolean hadSlash = false;
        for (char ch : str.toCharArray()) {
            if (inUnicode) {
                unicodeStr.append(ch);
                if (unicodeStr.length() != 4) continue;
                try {
                    int unicodeValue = Integer.parseInt(unicodeStr.toString(), 16);
                    sb.append((char)unicodeValue);
                    unicodeStr.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Couldn't parse unicode value: " + unicodeStr, e);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            sb.append(ch);
        }
        if (hadSlash) {
            sb.append('\\');
        }
        return sb.toString();
    }

    public static String humanReadableByteCount(long bytes, boolean base10) {
        int unit;
        int n = unit = base10 ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (base10 ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (base10 ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof Collection) {
            return Arrays.deepToString(((Collection)object).toArray());
        }
        return object.toString();
    }

    public static String toString(LinkedHashSet<String> set) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (String element : set) {
            String escapedElement = element.replaceAll(",", "\\\\,");
            builder.append(escapedElement).append(", ");
        }
        if (builder.length() > 1) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("]");
        return builder.toString();
    }

    public static String toString(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String escapedKey = entry.getKey().replaceAll("=", "\\\\=").replaceAll(",", "\\\\,");
            String escapedValue = entry.getValue().replaceAll("=", "\\\\=").replaceAll(",", "\\\\,");
            builder.append(escapedKey).append("=").append(escapedValue).append(", ");
        }
        if (builder.length() > 1) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("}");
        return builder.toString();
    }

    public static LinkedHashSet<String> toSet(String string, String separator) {
        int separatorIndex;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (string == null || string.length() < 3) {
            return set;
        }
        String value = string.substring(0, string.length() - 1);
        int index = 1;
        int startIndex = 1;
        while ((separatorIndex = value.indexOf(separator, index)) != -1) {
            if (value.charAt(separatorIndex - 1) != '\\') {
                set.add(value.substring(startIndex, separatorIndex).replaceAll("\\\\" + separator.charAt(0), "" + separator.charAt(0)));
                startIndex = separatorIndex + separator.length();
            }
            index = separatorIndex + separator.length();
        }
        set.add(value.substring(startIndex));
        return set;
    }

    public static Map<String, String> toMap(String string) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (string == null || string.length() < 3) {
            return map;
        }
        LinkedHashSet<String> firstList = Strings.toSet(string, ", ");
        for (String element : firstList) {
            LinkedHashSet<String> secondList = Strings.toSet("[" + element + "]", "=");
            if (secondList.size() == 2) {
                Iterator iterator = secondList.iterator();
                map.put((String)iterator.next(), (String)iterator.next());
                continue;
            }
            Err.prln("Ignoring element: [" + element + "]");
            Err.prln("Expecting: [key=value]");
        }
        return map;
    }

    public static String crop(String text, int maxLength) {
        if (text.length() > maxLength) {
            text = text.substring(0, maxLength / 2 - 2) + "..." + text.substring(text.length() - maxLength / 2);
        }
        return text;
    }
}

