/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Executable;
import gate.creole.ExecutionException;
import gate.util.Benchmarkable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Benchmark {
    protected static boolean benchmarkingEnabled = false;
    public static final String CORPUS_NAME_FEATURE = "corpusName";
    public static final String APPLICATION_NAME_FEATURE = "applicationName";
    public static final String DOCUMENT_NAME_FEATURE = "documentName";
    public static final String PR_NAME_FEATURE = "prName";
    public static final String MESSAGE_FEATURE = "message";
    public static final String PR_PREFIX = "pr_";
    public static final String DOCUMENT_LOADED = "documentLoaded";
    public static final String DOCUMENT_SAVED = "documentSaved";
    public static final String WRITING_FVS_TO_DISK = "writingFVsToDisk";
    public static final String ANNOTS_TO_NLP_FEATURES = "annotsToNlpFeatures";
    public static final String NLP_FEATURES_TO_FVS = "nlpFeaturesToFVs";
    public static final String READING_LEARNING_INFO = "readingLearningInfo";
    public static final String MODEL_APPLICATION = "modelApplication";
    public static final String WRITING_NGRAM_MODEL = "writingNgramModel";
    public static final String TERM_DOC_STATS = "termDocStats";
    public static final String FILTERING = "filtering";
    public static final String MODEL_TRAINING = "modelTraining";
    public static final String EVALUATION = "evaluation";
    public static final String NLP_LABELS_TO_DATA_LABELS = "nlpLabelsToDataLabels";
    public static final String READING_NLP_FEATURES = "readingNlpFeatures";
    public static final String READING_FVS = "readingFVs";
    public static final String WEKA_MODEL_TRAINING = "wekaModelTraining";
    public static final String PAUM_MODEL_TRAINING = "paumModelTraining";
    public static final String READING_CHUNK_LEARNING_DATA = "readingChunkLearningData";
    public static final String WEKA_MODEL_APPLICATION = "wekaModelApplication";
    public static final String PAUM_MODEL_APPLICATION = "paumModelApplication";
    public static final String POST_PROCESSING = "postProcessing";
    public static final Logger logger = Logger.getLogger(Benchmark.class);

    public static long startPoint() {
        return System.currentTimeMillis();
    }

    public static long startPoint(String benchmarkID) {
        long time = Benchmark.startPoint();
        if (benchmarkingEnabled) {
            logger.info((Object)(time + " START " + benchmarkID));
        }
        return time;
    }

    public static void checkPoint(long startTime, String benchmarkID, Object objectInvokingThisCheckPoint, Map<Object, Object> benchmarkingFeatures) {
        if (!benchmarkingEnabled) {
            return;
        }
        long processingTime = System.currentTimeMillis() - startTime;
        Benchmark.logCheckPoint(String.valueOf(processingTime), benchmarkID, objectInvokingThisCheckPoint, benchmarkingFeatures);
    }

    public static void checkPointWithDuration(long totalTime, String benchmarkID, Object objectInvokingThisCheckPoint, Map<Object, Object> benchmarkingFeatures) {
        if (!benchmarkingEnabled) {
            return;
        }
        Benchmark.logCheckPoint(String.valueOf(totalTime), benchmarkID, objectInvokingThisCheckPoint, benchmarkingFeatures);
    }

    public static void checkPoint(String benchmarkID, Object objectInvokingThisCheckPoint, Map<Object, Object> benchmarkingFeatures) {
        if (!benchmarkingEnabled) {
            return;
        }
        Benchmark.logCheckPoint("END", benchmarkID, objectInvokingThisCheckPoint, benchmarkingFeatures);
    }

    private static void logCheckPoint(String processingTimeOrFlag, String benchmarkID, Object objectInvokingThisCheckPoint, Map<Object, Object> benchmarkingFeatures) {
        StringBuilder messageToLog = new StringBuilder();
        messageToLog.append("" + System.currentTimeMillis() + " ");
        messageToLog.append(processingTimeOrFlag + " " + benchmarkID + " " + objectInvokingThisCheckPoint.getClass().getName() + " ");
        if (benchmarkingFeatures == null) {
            messageToLog.append("{}");
        } else {
            messageToLog.append(benchmarkingFeatures.toString().replaceAll("\n", "")).append("\n");
        }
        logger.info((Object)messageToLog.toString());
    }

    public static String createBenchmarkId(String resourceName, String parentBenchmarkID) {
        if (parentBenchmarkID != null) {
            if (resourceName != null) {
                return (parentBenchmarkID + "." + resourceName.replaceAll("\\.", "_")).replaceAll("[ ]+", "_");
            }
            return (parentBenchmarkID + ".null").replaceAll("[ ]+", "_");
        }
        if (resourceName != null) {
            return resourceName.replaceAll("[ .]+", "_");
        }
        return "null";
    }

    public static boolean isBenchmarkingEnabled() {
        return benchmarkingEnabled;
    }

    public static void setBenchmarkingEnabled(boolean benchmarkingEnabled) {
        Benchmark.benchmarkingEnabled = benchmarkingEnabled;
    }

    public static void executeWithBenchmarking(Executable executable, String benchmarkID, Object objectInvokingThisCheckPoint, Map<Object, Object> benchmarkingFeatures) throws ExecutionException {
        if (!benchmarkingEnabled) {
            executable.execute();
        } else {
            long startTime = Benchmark.startPoint();
            String savedBenchmarkID = null;
            try {
                if (executable instanceof Benchmarkable) {
                    savedBenchmarkID = ((Benchmarkable)((Object)executable)).getBenchmarkId();
                    ((Benchmarkable)((Object)executable)).setBenchmarkId(benchmarkID);
                }
                executable.execute();
            }
            catch (Exception e) {
                HashMap<Object, Object> tempFeatures = new HashMap<Object, Object>();
                if (benchmarkingFeatures != null) {
                    tempFeatures.putAll(benchmarkingFeatures);
                }
                tempFeatures.put("exceptionThrown", e);
                Benchmark.checkPoint(startTime, benchmarkID, objectInvokingThisCheckPoint, tempFeatures);
                if (e instanceof ExecutionException) {
                    throw (ExecutionException)e;
                }
                throw (RuntimeException)e;
            }
            finally {
                if (savedBenchmarkID != null) {
                    ((Benchmarkable)((Object)executable)).setBenchmarkId(savedBenchmarkID);
                }
            }
            Benchmark.checkPoint(startTime, benchmarkID, objectInvokingThisCheckPoint, benchmarkingFeatures);
        }
    }
}

