/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.util.GateRuntimeException;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class AnnotationDiffer {
    public Set<Annotation> correctAnnotations;
    public Set<Annotation> partiallyCorrectAnnotations;
    public Set<Annotation> missingAnnotations;
    public Set<Annotation> spuriousAnnotations;
    public static final int CORRECT_TYPE = 0;
    public static final int PARTIALLY_CORRECT_TYPE = 1;
    public static final int MISSING_TYPE = 2;
    public static final int SPURIOUS_TYPE = 3;
    public static final int MISMATCH_TYPE = 4;
    private static final int CORRECT_VALUE = 3;
    private static final int PARTIALLY_CORRECT_VALUE = 2;
    private static final int MISMATCH_VALUE = 1;
    private static final int WRONG_VALUE = 0;
    private Set<?> significantFeaturesSet;
    protected int correctMatches;
    protected int partiallyCorrectMatches;
    protected int missing;
    protected int spurious;
    protected List<Annotation> keyList;
    protected List<Annotation> responseList;
    protected List<List<Pairing>> keyChoices;
    protected List<List<Pairing>> responseChoices;
    protected List<Pairing> possibleChoices;
    protected List<Pairing> finalChoices;

    public AnnotationDiffer(Collection<AnnotationDiffer> differs) {
        this.correctMatches = 0;
        this.partiallyCorrectMatches = 0;
        this.missing = 0;
        this.spurious = 0;
        int keyCount = 0;
        int responseCount = 0;
        for (AnnotationDiffer differ : differs) {
            this.correctMatches += differ.getCorrectMatches();
            this.partiallyCorrectMatches += differ.getPartiallyCorrectMatches();
            this.missing += differ.getMissing();
            this.spurious += differ.getSpurious();
            keyCount += differ.getKeysCount();
            responseCount += differ.getResponsesCount();
        }
        this.keyList = new ArrayList<Annotation>(Collections.nCopies(keyCount, null));
        this.responseList = new ArrayList<Annotation>(Collections.nCopies(responseCount, null));
    }

    public AnnotationDiffer() {
    }

    public List<Pairing> calculateDiff(Collection<Annotation> key, Collection<Annotation> response) {
        PairingImpl choice;
        int i;
        this.keyList = key == null || key.size() == 0 ? new ArrayList<Annotation>() : new ArrayList<Annotation>(key);
        this.responseList = response == null || response.size() == 0 ? new ArrayList<Annotation>() : new ArrayList<Annotation>(response);
        if (this.correctAnnotations != null) {
            this.correctAnnotations.clear();
        } else {
            this.correctAnnotations = new HashSet<Annotation>();
        }
        if (this.partiallyCorrectAnnotations != null) {
            this.partiallyCorrectAnnotations.clear();
        } else {
            this.partiallyCorrectAnnotations = new HashSet<Annotation>();
        }
        if (this.missingAnnotations != null) {
            this.missingAnnotations.clear();
        } else {
            this.missingAnnotations = new HashSet<Annotation>();
        }
        if (this.spuriousAnnotations != null) {
            this.spuriousAnnotations.clear();
        } else {
            this.spuriousAnnotations = new HashSet<Annotation>();
        }
        this.keyChoices = new ArrayList<List<Pairing>>(this.keyList.size());
        this.keyChoices.addAll(Collections.nCopies(this.keyList.size(), null));
        this.responseChoices = new ArrayList<List<Pairing>>(this.responseList.size());
        this.responseChoices.addAll(Collections.nCopies(this.responseList.size(), null));
        this.possibleChoices = new ArrayList<Pairing>();
        for (i = 0; i < this.keyList.size(); ++i) {
            for (int j = 0; j < this.responseList.size(); ++j) {
                Annotation keyAnn = this.keyList.get(i);
                Annotation resAnn = this.responseList.get(j);
                PairingImpl choice2 = null;
                if (keyAnn.coextensive(resAnn)) {
                    choice2 = keyAnn.isCompatible(resAnn, this.significantFeaturesSet) ? new PairingImpl(i, j, 3) : new PairingImpl(i, j, 1);
                } else if (keyAnn.overlaps(resAnn)) {
                    choice2 = keyAnn.isPartiallyCompatible(resAnn, this.significantFeaturesSet) ? new PairingImpl(i, j, 2) : new PairingImpl(i, j, 0);
                }
                if (choice2 == null) continue;
                this.addPairing(choice2, i, this.keyChoices);
                this.addPairing(choice2, j, this.responseChoices);
                this.possibleChoices.add(choice2);
            }
        }
        Collections.sort(this.possibleChoices, new PairingScoreComparator());
        Collections.reverse(this.possibleChoices);
        this.finalChoices = new ArrayList<Pairing>();
        this.correctMatches = 0;
        this.partiallyCorrectMatches = 0;
        this.missing = 0;
        this.spurious = 0;
        block8: while (!this.possibleChoices.isEmpty()) {
            PairingImpl bestChoice = (PairingImpl)this.possibleChoices.remove(0);
            bestChoice.consume();
            this.finalChoices.add(bestChoice);
            switch (bestChoice.value) {
                case 3: {
                    this.correctAnnotations.add(bestChoice.getResponse());
                    ++this.correctMatches;
                    bestChoice.setType(0);
                    continue block8;
                }
                case 2: {
                    this.partiallyCorrectAnnotations.add(bestChoice.getResponse());
                    ++this.partiallyCorrectMatches;
                    bestChoice.setType(1);
                    continue block8;
                }
                case 1: {
                    this.missingAnnotations.add(bestChoice.getKey());
                    ++this.missing;
                    this.spuriousAnnotations.add(bestChoice.getResponse());
                    ++this.spurious;
                    bestChoice.setType(4);
                    continue block8;
                }
                case 0: {
                    if (bestChoice.getKey() != null) {
                        if (this.missingAnnotations == null) {
                            this.missingAnnotations = new HashSet<Annotation>();
                        }
                        this.missingAnnotations.add(bestChoice.getKey());
                        ++this.missing;
                        bestChoice.setType(2);
                    }
                    if (bestChoice.getResponse() == null) continue block8;
                    if (this.spuriousAnnotations == null) {
                        this.spuriousAnnotations = new HashSet<Annotation>();
                    }
                    this.spuriousAnnotations.add(bestChoice.getResponse());
                    ++this.spurious;
                    bestChoice.setType(3);
                    continue block8;
                }
            }
            throw new GateRuntimeException("Invalid pairing type: " + bestChoice.value);
        }
        for (i = 0; i < this.keyChoices.size(); ++i) {
            List<Pairing> aList = this.keyChoices.get(i);
            if (aList != null && !aList.isEmpty()) continue;
            if (this.missingAnnotations == null) {
                this.missingAnnotations = new HashSet<Annotation>();
            }
            this.missingAnnotations.add(this.keyList.get(i));
            choice = new PairingImpl(i, -1, 0);
            choice.setType(2);
            this.finalChoices.add(choice);
            ++this.missing;
        }
        for (i = 0; i < this.responseChoices.size(); ++i) {
            List<Pairing> aList = this.responseChoices.get(i);
            if (aList != null && !aList.isEmpty()) continue;
            if (this.spuriousAnnotations == null) {
                this.spuriousAnnotations = new HashSet<Annotation>();
            }
            this.spuriousAnnotations.add(this.responseList.get(i));
            choice = new PairingImpl(-1, i, 0);
            choice.setType(3);
            this.finalChoices.add(choice);
            ++this.spurious;
        }
        return this.finalChoices;
    }

    public double getPrecisionStrict() {
        if (this.responseList.size() == 0) {
            return 1.0;
        }
        return (double)this.correctMatches / (double)this.responseList.size();
    }

    public double getRecallStrict() {
        if (this.keyList.size() == 0) {
            return 1.0;
        }
        return (double)this.correctMatches / (double)this.keyList.size();
    }

    public double getPrecisionLenient() {
        if (this.responseList.size() == 0) {
            return 1.0;
        }
        return ((double)this.correctMatches + (double)this.partiallyCorrectMatches) / (double)this.responseList.size();
    }

    public double getPrecisionAverage() {
        return (this.getPrecisionLenient() + this.getPrecisionStrict()) / 2.0;
    }

    public double getRecallLenient() {
        if (this.keyList.size() == 0) {
            return 1.0;
        }
        return ((double)this.correctMatches + (double)this.partiallyCorrectMatches) / (double)this.keyList.size();
    }

    public double getRecallAverage() {
        return (this.getRecallLenient() + this.getRecallStrict()) / 2.0;
    }

    public double getFMeasureStrict(double beta) {
        double recall;
        double betaSq = beta * beta;
        double precision = this.getPrecisionStrict();
        double answer = (betaSq + 1.0) * precision * (recall = this.getRecallStrict()) / (betaSq * precision + recall);
        if (Double.isNaN(answer)) {
            answer = 0.0;
        }
        return answer;
    }

    public double getFMeasureLenient(double beta) {
        double recall;
        double betaSq = beta * beta;
        double precision = this.getPrecisionLenient();
        double answer = (betaSq + 1.0) * precision * (recall = this.getRecallLenient()) / (betaSq * precision + recall);
        if (Double.isNaN(answer)) {
            answer = 0.0;
        }
        return answer;
    }

    public double getFMeasureAverage(double beta) {
        double answer = (this.getFMeasureLenient(beta) + this.getFMeasureStrict(beta)) / 2.0;
        return answer;
    }

    public int getCorrectMatches() {
        return this.correctMatches;
    }

    public int getPartiallyCorrectMatches() {
        return this.partiallyCorrectMatches;
    }

    public int getMissing() {
        return this.missing;
    }

    public int getSpurious() {
        return this.spurious;
    }

    public int getFalsePositivesStrict() {
        return this.responseList.size() - this.correctMatches;
    }

    public int getFalsePositivesLenient() {
        return this.responseList.size() - this.correctMatches - this.partiallyCorrectMatches;
    }

    public int getKeysCount() {
        return this.keyList.size();
    }

    public int getResponsesCount() {
        return this.responseList.size();
    }

    public void printMissmatches() {
        List<Pairing> aList;
        int i;
        for (Pairing aChoice : this.finalChoices) {
            switch (aChoice.getValue()) {
                case 2: {
                    System.out.println("Missmatch (partially correct):");
                    System.out.println("Key: " + this.keyList.get(aChoice.getKeyIndex()).toString());
                    System.out.println("Response: " + this.responseList.get(aChoice.getResponseIndex()).toString());
                }
            }
        }
        for (i = 0; i < this.keyChoices.size(); ++i) {
            aList = this.keyChoices.get(i);
            if (aList != null && !aList.isEmpty()) continue;
            System.out.println("Missed Key: " + this.keyList.get(i).toString());
        }
        for (i = 0; i < this.responseChoices.size(); ++i) {
            aList = this.responseChoices.get(i);
            if (aList != null && !aList.isEmpty()) continue;
            System.out.println("Spurious Response: " + this.responseList.get(i).toString());
        }
    }

    void sanityCheck() throws Exception {
        Pairing aChoice;
        List<Pairing> otherChoices;
        for (List<Pairing> choices : this.keyChoices) {
            if (choices == null) continue;
            if (choices.size() > 1) {
                throw new Exception("Multiple choices found!");
            }
            if (choices.isEmpty() || (otherChoices = this.responseChoices.get((aChoice = choices.get(0)).getResponseIndex())) != null && otherChoices.size() == 1 && otherChoices.get(0) == aChoice) continue;
            throw new Exception("Reciprocity error!");
        }
        for (List<Pairing> choices : this.responseChoices) {
            if (choices == null) continue;
            if (choices.size() > 1) {
                throw new Exception("Multiple choices found!");
            }
            if (choices.isEmpty()) continue;
            aChoice = choices.get(0);
            otherChoices = this.keyChoices.get(aChoice.getKeyIndex());
            if (otherChoices == null) {
                throw new Exception("Reciprocity error : null!");
            }
            if (otherChoices.size() != 1) {
                throw new Exception("Reciprocity error: not 1!");
            }
            if (otherChoices.get(0) == aChoice) continue;
            throw new Exception("Reciprocity error: different!");
        }
    }

    protected void addPairing(Pairing pairing, int index, List<List<Pairing>> listOfPairings) {
        List<Pairing> existingChoices = listOfPairings.get(index);
        if (existingChoices == null) {
            existingChoices = new ArrayList<Pairing>();
            listOfPairings.set(index, existingChoices);
        }
        existingChoices.add(pairing);
    }

    public Set<?> getSignificantFeaturesSet() {
        return this.significantFeaturesSet;
    }

    public void setSignificantFeaturesSet(Set<String> significantFeaturesSet) {
        this.significantFeaturesSet = significantFeaturesSet;
    }

    public Set<Annotation> getAnnotationsOfType(int type) {
        switch (type) {
            case 0: {
                return this.correctAnnotations == null ? new HashSet() : this.correctAnnotations;
            }
            case 1: {
                return this.partiallyCorrectAnnotations == null ? new HashSet() : this.partiallyCorrectAnnotations;
            }
            case 3: {
                return this.spuriousAnnotations == null ? new HashSet() : this.spuriousAnnotations;
            }
            case 2: {
                return this.missingAnnotations == null ? new HashSet() : this.missingAnnotations;
            }
        }
        return new HashSet<Annotation>();
    }

    public String getAnnotationType() {
        if (!this.keyList.isEmpty()) {
            return this.keyList.iterator().next().getType();
        }
        if (!this.responseList.isEmpty()) {
            return this.responseList.iterator().next().getType();
        }
        return "";
    }

    public List<String> getMeasuresRow(Object[] measures, String title) {
        NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);
        f.setMaximumFractionDigits(4);
        f.setMinimumFractionDigits(4);
        f.setRoundingMode(RoundingMode.HALF_UP);
        ArrayList<String> row = new ArrayList<String>();
        row.add(title);
        row.add(Integer.toString(this.getCorrectMatches()));
        row.add(Integer.toString(this.getMissing()));
        row.add(Integer.toString(this.getSpurious()));
        row.add(Integer.toString(this.getPartiallyCorrectMatches()));
        for (Object object : measures) {
            String measure = (String)object;
            double beta = Double.valueOf(measure.substring(1, measure.indexOf(45)));
            if (measure.endsWith("strict")) {
                row.add(f.format(this.getPrecisionStrict()));
                row.add(f.format(this.getRecallStrict()));
                row.add(f.format(this.getFMeasureStrict(beta)));
                continue;
            }
            if (measure.endsWith("lenient")) {
                row.add(f.format(this.getPrecisionLenient()));
                row.add(f.format(this.getRecallLenient()));
                row.add(f.format(this.getFMeasureLenient(beta)));
                continue;
            }
            if (!measure.endsWith("average")) continue;
            row.add(f.format(this.getPrecisionAverage()));
            row.add(f.format(this.getRecallAverage()));
            row.add(f.format(this.getFMeasureAverage(beta)));
        }
        return row;
    }

    public static class PairingOffsetComparator
    implements Comparator<Pairing>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Pairing first, Pairing second) {
            int res;
            Long start2;
            Long start1;
            Annotation key1 = first.getKey();
            Annotation key2 = second.getKey();
            Annotation res1 = first.getResponse();
            Annotation res2 = second.getResponse();
            Long l = start1 = key1 == null ? null : key1.getStartNode().getOffset();
            if (start1 == null) {
                start1 = res1.getStartNode().getOffset();
            }
            Long l2 = start2 = key2 == null ? null : key2.getStartNode().getOffset();
            if (start2 == null) {
                start2 = res2.getStartNode().getOffset();
            }
            if ((res = start1.compareTo(start2)) == 0) {
                res = second.getType() - first.getType();
            }
            return res;
        }
    }

    protected static class PairingScoreComparator
    implements Comparator<Pairing>,
    Serializable {
        private static final long serialVersionUID = 7386841422038756873L;

        protected PairingScoreComparator() {
        }

        @Override
        public int compare(Pairing first, Pairing second) {
            int res = first.getScore() - second.getScore();
            if (res == 0) {
                res = first.getType() - second.getType();
            }
            if (res == 0) {
                res = (first.getKey() == null ? 0 : 1) + (first.getResponse() == null ? 0 : 1) + (second.getKey() == null ? 0 : -1) + (second.getResponse() == null ? 0 : -1);
            }
            return res;
        }
    }

    public class PairingImpl
    implements Pairing {
        int keyIndex;
        int responseIndex;
        int type;
        int value;
        int score;
        boolean scoreCalculated;

        PairingImpl(int keyIndex, int responseIndex, int value) {
            this.keyIndex = keyIndex;
            this.responseIndex = responseIndex;
            this.value = value;
            this.scoreCalculated = false;
        }

        @Override
        public int getScore() {
            if (this.scoreCalculated) {
                return this.score;
            }
            this.calculateScore();
            return this.score;
        }

        @Override
        public int getKeyIndex() {
            return this.keyIndex;
        }

        @Override
        public int getResponseIndex() {
            return this.responseIndex;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public Annotation getKey() {
            return this.keyIndex == -1 ? null : AnnotationDiffer.this.keyList.get(this.keyIndex);
        }

        @Override
        public Annotation getResponse() {
            return this.responseIndex == -1 ? null : AnnotationDiffer.this.responseList.get(this.responseIndex);
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public void setType(int type) {
            this.type = type;
        }

        public void consume() {
            AnnotationDiffer.this.possibleChoices.remove(this);
            List<Pairing> sameKeyChoices = AnnotationDiffer.this.keyChoices.get(this.keyIndex);
            sameKeyChoices.remove(this);
            AnnotationDiffer.this.possibleChoices.removeAll(sameKeyChoices);
            List<Pairing> sameResponseChoices = AnnotationDiffer.this.responseChoices.get(this.responseIndex);
            sameResponseChoices.remove(this);
            AnnotationDiffer.this.possibleChoices.removeAll(sameResponseChoices);
            for (Pairing item : new ArrayList<Pairing>(sameKeyChoices)) {
                item.remove();
            }
            for (Pairing item : new ArrayList<Pairing>(sameResponseChoices)) {
                item.remove();
            }
            sameKeyChoices.add(this);
            sameResponseChoices.add(this);
        }

        @Override
        public void remove() {
            List<Pairing> fromKey = AnnotationDiffer.this.keyChoices.get(this.keyIndex);
            fromKey.remove(this);
            List<Pairing> fromResponse = AnnotationDiffer.this.responseChoices.get(this.responseIndex);
            fromResponse.remove(this);
        }

        void calculateScore() {
            HashSet conflictSet = new HashSet();
            conflictSet.addAll(AnnotationDiffer.this.responseChoices.get(this.responseIndex));
            conflictSet.addAll(AnnotationDiffer.this.keyChoices.get(this.keyIndex));
            conflictSet.remove(this);
            this.score = this.value;
            for (Pairing item : conflictSet) {
                this.score -= item.getValue();
            }
            this.scoreCalculated = true;
        }
    }

    public static interface Pairing {
        public Annotation getKey();

        public int getResponseIndex();

        public int getValue();

        public int getKeyIndex();

        public int getScore();

        public void setType(int var1);

        public void remove();

        public Annotation getResponse();

        public int getType();
    }
}

