/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class JapeIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(15.198459, 24.04854);
        shape.quadTo(15.198459, 26.689165, 13.625542, 27.902708);
        shape.quadTo(12.234917, 28.96, 9.484917, 28.96);
        shape.lineTo(5.5005417, 28.96);
        shape.lineTo(5.5005417, 27.05375);
        shape.lineTo(9.484917, 27.05375);
        shape.quadTo(11.339084, 27.05375, 12.219292, 26.496458);
        shape.quadTo(13.292209, 25.793333, 13.292209, 24.04854);
        shape.lineTo(13.292209, 18.032915);
        shape.lineTo(15.198459, 18.032915);
        shape.lineTo(15.198459, 24.04854);
        shape.closePath();
        shape.moveTo(31.292942, 28.96);
        shape.lineTo(28.845024, 28.944374);
        shape.lineTo(27.006483, 25.887083);
        shape.lineTo(21.818983, 25.887083);
        shape.lineTo(22.970024, 24.001665);
        shape.lineTo(25.865858, 24.001665);
        shape.lineTo(23.964815, 20.845415);
        shape.lineTo(19.037733, 28.944374);
        shape.lineTo(16.589815, 28.944374);
        shape.lineTo(22.522108, 19.074583);
        shape.quadTo(22.746065, 18.689165, 23.147108, 18.36625);
        shape.quadTo(23.626274, 18.001665, 24.01169, 18.001665);
        shape.quadTo(24.428358, 18.001665, 24.876274, 18.350624);
        shape.quadTo(25.26169, 18.657915, 25.501274, 19.074583);
        shape.lineTo(31.292942, 28.96);
        shape.closePath();
        shape.moveTo(44.221725, 21.970415);
        shape.quadTo(44.221725, 23.762083, 42.909225, 24.86625);
        shape.quadTo(41.690475, 25.887083, 39.851933, 25.887083);
        shape.lineTo(35.034225, 25.887083);
        shape.lineTo(35.034225, 24.001665);
        shape.lineTo(40.154015, 24.001665);
        shape.quadTo(41.101933, 24.001665, 41.739952, 23.44177);
        shape.quadTo(42.377975, 22.881874, 42.377975, 21.949583);
        shape.quadTo(42.377975, 21.0225, 41.739952, 20.478228);
        shape.quadTo(41.101933, 19.933958, 40.154015, 19.933958);
        shape.lineTo(33.914433, 19.933958);
        shape.lineTo(33.914433, 28.96);
        shape.lineTo(32.01339, 28.96);
        shape.lineTo(32.01339, 18.032915);
        shape.lineTo(39.851933, 18.032915);
        shape.quadTo(41.690475, 18.032915, 42.909225, 19.074583);
        shape.quadTo(44.221725, 20.157915, 44.221725, 21.970415);
        shape.closePath();
        shape.moveTo(54.524834, 24.36625);
        shape.lineTo(48.28525, 24.36625);
        shape.lineTo(48.28525, 22.465208);
        shape.lineTo(54.524834, 22.465208);
        shape.lineTo(54.524834, 24.36625);
        shape.closePath();
        shape.moveTo(55.019627, 28.96);
        shape.lineTo(45.582127, 28.96);
        shape.lineTo(45.582127, 18.032915);
        shape.lineTo(55.019627, 18.032915);
        shape.lineTo(55.019627, 19.933958);
        shape.lineTo(47.483166, 19.933958);
        shape.lineTo(47.483166, 27.05375);
        shape.lineTo(55.019627, 27.05375);
        shape.lineTo(55.019627, 28.96);
        shape.closePath();
        paint = JapeIcon.getColor(0, 0, 0, 255, disabled);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_0 = g.getClip();
        AffineTransform defaultTransform__0_0_1_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = JapeIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(31.614834, 30.370502);
        shape.curveTo(32.388325, 31.440418, 33.434837, 32.330322, 34.43805, 33.193863);
        shape.curveTo(35.11353, 33.567135, 35.84658, 33.783886, 36.52577, 34.145954);
        shape.curveTo(36.81971, 34.28676, 37.11633, 34.418514, 37.407722, 34.56321);
        shape.lineTo(35.848034, 35.582603);
        shape.curveTo(35.55869, 35.45023, 35.272297, 35.311905, 34.981277, 35.183);
        shape.curveTo(34.294556, 34.805344, 33.53521, 34.61104, 32.882484, 34.169605);
        shape.curveTo(31.860277, 33.23768, 30.807732, 32.29152, 29.93062, 31.228651);
        shape.lineTo(31.614834, 30.370502);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1_0;
        g.setTransform(defaultTransform__0_0_1_0);
        g.setClip(clip__0_0_1_0);
        float alpha__0_0_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = JapeIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(12.5, 34.7879);
        shape.curveTo(36.5, 34.333355, 36.5, 34.7879, 36.5, 34.7879);
        g.setPaint(paint);
        g.fill(shape);
        paint = JapeIcon.getColor(255, 97, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(12.5, 34.7879);
        shape.curveTo(36.5, 34.333355, 36.5, 34.7879, 36.5, 34.7879);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_1;
        g.setTransform(defaultTransform__0_0_1_1);
        g.setClip(clip__0_0_1_1);
        float alpha__0_0_1_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_2 = g.getClip();
        AffineTransform defaultTransform__0_0_1_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = JapeIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(31.707111, 39.0);
        shape.curveTo(32.480602, 37.930084, 33.527115, 37.04018, 34.530327, 36.17664);
        shape.curveTo(35.205807, 35.803368, 35.938858, 35.586617, 36.618046, 35.22455);
        shape.curveTo(36.911987, 35.083744, 37.208607, 34.95199, 37.5, 34.807293);
        shape.lineTo(35.94031, 33.7879);
        shape.curveTo(35.650967, 33.920273, 35.364574, 34.058598, 35.073555, 34.187508);
        shape.curveTo(34.386833, 34.565163, 33.627487, 34.759464, 32.974762, 35.200897);
        shape.curveTo(31.952555, 36.132824, 30.90001, 37.078983, 30.0229, 38.14185);
        shape.lineTo(31.707111, 39.0);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1_2;
        g.setTransform(defaultTransform__0_0_1_2);
        g.setClip(clip__0_0_1_2);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_2_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2_0 = g.getClip();
        AffineTransform defaultTransform__0_0_2_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = JapeIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(49.114834, 38.0);
        shape.curveTo(49.888325, 39.069916, 50.934837, 39.95982, 51.93805, 40.82336);
        shape.curveTo(52.61353, 41.196632, 53.34658, 41.413383, 54.02577, 41.77545);
        shape.curveTo(54.31971, 41.916256, 54.61633, 42.04801, 54.907722, 42.192707);
        shape.lineTo(53.348034, 43.2121);
        shape.curveTo(53.05869, 43.079727, 52.772297, 42.941402, 52.481277, 42.812492);
        shape.curveTo(51.794556, 42.434837, 51.03521, 42.240536, 50.382484, 41.799103);
        shape.curveTo(49.360275, 40.867176, 48.30773, 39.921017, 47.430622, 38.85815);
        shape.lineTo(49.114834, 38.0);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2_0;
        g.setTransform(defaultTransform__0_0_2_0);
        g.setClip(clip__0_0_2_0);
        float alpha__0_0_2_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2_1 = g.getClip();
        AffineTransform defaultTransform__0_0_2_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = JapeIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(30.0, 42.417397);
        shape.curveTo(54.0, 41.962852, 54.0, 42.417397, 54.0, 42.417397);
        g.setPaint(paint);
        g.fill(shape);
        paint = JapeIcon.getColor(255, 97, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(30.0, 42.417397);
        shape.curveTo(54.0, 41.962852, 54.0, 42.417397, 54.0, 42.417397);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2_1;
        g.setTransform(defaultTransform__0_0_2_1);
        g.setClip(clip__0_0_2_1);
        float alpha__0_0_2_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = JapeIcon.getColor(255, 105, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(49.20711, 46.629498);
        shape.curveTo(49.980602, 45.55958, 51.027115, 44.669678, 52.030327, 43.806137);
        shape.curveTo(52.705807, 43.432865, 53.438858, 43.216114, 54.118046, 42.854046);
        shape.curveTo(54.411987, 42.71324, 54.708607, 42.581486, 55.0, 42.43679);
        shape.lineTo(53.44031, 41.417397);
        shape.curveTo(53.150967, 41.54977, 52.864574, 41.688095, 52.573555, 41.817);
        shape.curveTo(51.886833, 42.194656, 51.127487, 42.38896, 50.474762, 42.830395);
        shape.curveTo(49.452557, 43.76232, 48.40001, 44.70848, 47.5229, 45.771347);
        shape.lineTo(49.20711, 46.629498);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2_2;
        g.setTransform(defaultTransform__0_0_2_2);
        g.setClip(clip__0_0_2_2);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 6;
    }

    public static int getOrigY() {
        return 19;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public JapeIcon() {
        this(JapeIcon.getOrigWidth(), JapeIcon.getOrigHeight(), false);
    }

    public JapeIcon(boolean disabled) {
        this(JapeIcon.getOrigWidth(), JapeIcon.getOrigHeight(), disabled);
    }

    public JapeIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public JapeIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public JapeIcon(int width, int height) {
        this(width, height, false);
    }

    public JapeIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)JapeIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)JapeIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        JapeIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

