/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.FeatureMap;
import gate.Node;
import gate.annotation.AnnotationImpl;
import gate.annotation.NodeImpl;
import gate.gui.docview.AnnotationSetsView;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.MouseInputAdapter;
import org.apache.commons.lang.StringEscapeUtils;

public class AnnotationStack
extends JPanel {
    ArrayList<StackRow> stackRows;
    int maxTextLength = 150;
    int maxFeatureValueLength = 30;
    JButton lastRowButton;
    String text = "";
    int expressionStartOffset = 0;
    int expressionEndOffset = 0;
    int contextBeforeSize = 10;
    int contextAfterSize = 10;
    String expressionTooltip = "";
    StackMouseListener textMouseListener;
    StackMouseListener headerMouseListener;
    StackMouseListener annotationMouseListener;
    public static final int CROP_START = 0;
    public static final int CROP_MIDDLE = 1;
    public static final int CROP_END = 2;

    public AnnotationStack() {
        this.init();
    }

    public AnnotationStack(int maxTextLength, int maxFeatureValueLength) {
        this.maxTextLength = maxTextLength;
        this.maxFeatureValueLength = maxFeatureValueLength;
        this.init();
    }

    void init() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.stackRows = new ArrayList();
        this.textMouseListener = new StackMouseListener();
        this.headerMouseListener = new StackMouseListener();
        this.annotationMouseListener = new StackMouseListener();
    }

    public void addRow(String set, String type, String feature, JButton lastColumnButton, String shortcut, int crop) {
        this.stackRows.add(new StackRow(set, type, feature, lastColumnButton, shortcut, crop));
    }

    public void addAnnotation(int startOffset, int endOffset, String type, FeatureMap features) {
        this.stackRows.get(this.stackRows.size() - 1).addAnnotation(StackAnnotation.createAnnotation(startOffset, endOffset, type, features));
    }

    public void addAnnotation(Annotation annotation) {
        this.stackRows.get(this.stackRows.size() - 1).addAnnotation(StackAnnotation.createAnnotation(annotation));
    }

    public void clearAllRows() {
        this.stackRows.clear();
    }

    public void drawStack() {
        this.removeAll();
        boolean textTooLong = this.text.length() > this.maxTextLength;
        int upperBound = this.text.length() - this.maxTextLength / 2;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        JLabel labelTitle = new JLabel("Context");
        labelTitle.setOpaque(true);
        labelTitle.setBackground(Color.WHITE);
        labelTitle.setBorder(new CompoundBorder(new EtchedBorder(1, new Color(250, 250, 250), new Color(250, 250, 250).darker()), new EmptyBorder(new Insets(0, 2, 0, 2))));
        labelTitle.setToolTipText("Expression and its context.");
        this.add((Component)labelTitle, gbc);
        gbc.insets = new Insets(10, 0, 10, 0);
        int expressionStart = this.contextBeforeSize;
        int expressionEnd = this.text.length() - this.contextAfterSize;
        for (int charNum = 0; charNum < this.text.length(); ++charNum) {
            gbc.gridx = charNum + 1;
            if (textTooLong) {
                if (charNum == this.maxTextLength / 2) {
                    this.add((Component)new JLabel("..."), gbc);
                    charNum = upperBound + 1;
                    continue;
                }
                if (charNum > upperBound) {
                    gbc.gridx -= upperBound - this.maxTextLength / 2 + 1;
                }
            }
            JLabel label = new JLabel(this.text.substring(charNum, charNum + 1));
            if (charNum >= expressionStart && charNum < expressionEnd) {
                label.setBackground(new Color(240, 201, 184));
            } else {
                label.setBackground(Color.WHITE);
            }
            label.setOpaque(true);
            int start = this.text.lastIndexOf(" ", charNum);
            int end = this.text.indexOf(" ", charNum);
            String word = this.text.substring(start == -1 ? 0 : start, end == -1 ? this.text.length() : end);
            label.addMouseListener(this.textMouseListener.createListener(word));
            this.add((Component)label, gbc);
        }
        for (StackRow stackRow : this.stackRows) {
            String shortcut;
            String type = stackRow.getType();
            String feature = stackRow.getFeature();
            if (feature == null) {
                feature = "";
            }
            if ((shortcut = stackRow.getShortcut()) == null) {
                shortcut = "";
            }
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(0, 0, 3, 0);
            JLabel annotationTypeAndFeature = new JLabel();
            String typeAndFeature = type + (feature.equals("") ? "" : ".") + feature;
            annotationTypeAndFeature.setText(!shortcut.equals("") ? shortcut : (stackRow.getSet() != null ? stackRow.getSet() + "#" + typeAndFeature : typeAndFeature));
            annotationTypeAndFeature.setOpaque(true);
            annotationTypeAndFeature.setBackground(Color.WHITE);
            annotationTypeAndFeature.setBorder(new CompoundBorder(new EtchedBorder(1, new Color(250, 250, 250), new Color(250, 250, 250).darker()), new EmptyBorder(new Insets(0, 2, 0, 2))));
            if (feature.equals("")) {
                annotationTypeAndFeature.addMouseListener(this.headerMouseListener.createListener(type));
            } else {
                annotationTypeAndFeature.addMouseListener(this.headerMouseListener.createListener(type, feature));
            }
            gbc.insets = new Insets(0, 10, 3, 10);
            this.add((Component)annotationTypeAndFeature, gbc);
            gbc.insets = new Insets(0, 0, 3, 0);
            HashMap<Integer, TreeSet<Integer>> gridSet = new HashMap<Integer, TreeSet<Integer>>();
            int gridyMax = gbc.gridy;
            for (StackAnnotation ann : stackRow.getAnnotations()) {
                int oldGridy;
                String value;
                gbc.gridx = ann.getStartNode().getOffset().intValue() - this.expressionStartOffset + this.contextBeforeSize + 1;
                gbc.gridwidth = ann.getEndNode().getOffset().intValue() - ann.getStartNode().getOffset().intValue();
                if (gbc.gridx == 0) {
                    --gbc.gridwidth;
                    gbc.gridx = 1;
                } else if (gbc.gridx < 0) {
                    gbc.gridwidth += gbc.gridx - 1;
                    gbc.gridx = 1;
                }
                if (gbc.gridx + gbc.gridwidth > this.text.length()) {
                    gbc.gridwidth = this.text.length() - gbc.gridx + 1;
                }
                if (textTooLong) {
                    if (gbc.gridx > upperBound + 1) {
                        gbc.gridx -= upperBound - this.maxTextLength / 2 + 1;
                    } else if (gbc.gridx > this.maxTextLength / 2) {
                        if (gbc.gridx + gbc.gridwidth <= upperBound + 3) continue;
                        gbc.gridwidth -= upperBound - gbc.gridx + 2;
                        gbc.gridx = this.maxTextLength / 2 + 2;
                    } else if (gbc.gridx + gbc.gridwidth >= this.maxTextLength / 2) {
                        gbc.gridwidth = gbc.gridx + gbc.gridwidth < upperBound ? this.maxTextLength / 2 - gbc.gridx + 1 : (gbc.gridwidth -= upperBound - this.maxTextLength / 2 + 1);
                    }
                }
                if (gbc.gridwidth == 0) {
                    gbc.gridwidth = 1;
                }
                JLabel label = new JLabel();
                Object object = ann.getFeatures().get(feature);
                String string = value = object == null ? " " : Strings.toString(object);
                if (value.length() > this.maxFeatureValueLength) {
                    label.setToolTipText(value.length() > 500 ? "<html><textarea rows=\"30\" cols=\"40\" readonly=\"readonly\">" + value.replaceAll("(.{50,60})\\b", "$1\n") + "</textarea></html>" : (value.length() > 100 ? "<html><table width=\"500\" border=\"0\" cellspacing=\"0\"><tr><td>" + value.replaceAll("\n", "<br>") + "</td></tr></table></html>" : value));
                    value = stackRow.getCrop() == 0 ? "..." + value.substring(value.length() - this.maxFeatureValueLength - 1) : (stackRow.getCrop() == 2 ? value.substring(0, this.maxFeatureValueLength - 2) + "..." : value.substring(0, this.maxFeatureValueLength / 2) + "..." + value.substring(value.length() - this.maxFeatureValueLength / 2));
                }
                label.setText(value);
                label.setBackground(AnnotationSetsView.getColor(stackRow.getSet(), ann.getType()));
                label.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                label.setOpaque(true);
                label.addMouseListener(this.annotationMouseListener.createListener(stackRow.getSet(), type, String.valueOf(ann.getId())));
                if (!ann.getFeatures().isEmpty()) {
                    String width = Strings.toString((Object)ann.getFeatures()).length() > 100 ? "500" : "100%";
                    String toolTip = "<html><table width=\"" + width + "\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">";
                    Color color = (Color)UIManager.get("ToolTip.background");
                    float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                    color = Color.getHSBColor(hsb[0], hsb[1], Math.max(0.0f, hsb[2] - hsb[2] * 0.075f));
                    String hexColor = Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue());
                    boolean odd = false;
                    ArrayList features = new ArrayList(ann.getFeatures().keySet());
                    Collections.sort(features, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            return o1.toString().compareToIgnoreCase(o2.toString());
                        }
                    });
                    for (Object key : features) {
                        String fv = Strings.toString(ann.getFeatures().get(key));
                        toolTip = toolTip + "<tr align=\"left\"" + (odd ? " bgcolor=\"#" + hexColor + "\"" : "") + "><td><strong>" + key + "</strong></td><td>" + (fv.length() > 500 ? "<textarea rows=\"20\" cols=\"40\" cellspacing=\"0\">" + StringEscapeUtils.escapeHtml((String)fv.replaceAll("(.{50,60})\\b", "$1\n")) + "</textarea>" : StringEscapeUtils.escapeHtml((String)fv).replaceAll("\n", "<br>")) + "</td></tr>";
                        odd = !odd;
                    }
                    label.setToolTipText(toolTip + "</table></html>");
                } else {
                    label.setToolTipText("No features.");
                }
                if (!feature.equals("")) {
                    label.addMouseListener(this.annotationMouseListener.createListener(stackRow.getSet(), type, feature, Strings.toString(ann.getFeatures().get(feature)), String.valueOf(ann.getId())));
                }
                for (int y = oldGridy = gbc.gridy; y <= gridyMax + 1; ++y) {
                    boolean xSpanIsEmpty = true;
                    for (int x = gbc.gridx; x < gbc.gridx + gbc.gridwidth && xSpanIsEmpty; ++x) {
                        xSpanIsEmpty = !gridSet.containsKey(x) || !((TreeSet)gridSet.get(x)).contains(y);
                    }
                    if (!xSpanIsEmpty) continue;
                    gbc.gridy = y;
                    break;
                }
                for (int x = gbc.gridx; x < gbc.gridx + gbc.gridwidth; ++x) {
                    TreeSet<Integer> ts = (TreeSet<Integer>)gridSet.get(x);
                    if (ts == null) {
                        ts = new TreeSet<Integer>();
                    }
                    ts.add(gbc.gridy);
                    gridSet.put(x, ts);
                }
                this.add((Component)label, gbc);
                gridyMax = Math.max(gridyMax, gbc.gridy);
                gbc.gridy = oldGridy;
            }
            gbc.gridwidth = 1;
            if (stackRow.getLastColumnButton() != null) {
                gbc.gridx = Math.min(this.text.length(), this.maxTextLength) + 1;
                gbc.insets = new Insets(0, 10, 3, 0);
                gbc.fill = 0;
                gbc.anchor = 17;
                this.add((Component)stackRow.getLastColumnButton(), gbc);
                gbc.insets = new Insets(0, 0, 3, 0);
                gbc.fill = 1;
                gbc.anchor = 10;
            }
            gbc.gridy = gridyMax;
        }
        if (this.lastRowButton != null) {
            gbc.insets = new Insets(0, 10, 0, 10);
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.lastRowButton, gbc);
        }
        ++gbc.gridy;
        gbc.gridx = Math.min(this.text.length(), this.maxTextLength) + 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JLabel(""), gbc);
        this.validate();
        this.updateUI();
    }

    public void setLastRowButton(JButton lastRowButton) {
        this.lastRowButton = lastRowButton;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setExpressionStartOffset(int expressionStartOffset) {
        this.expressionStartOffset = expressionStartOffset;
    }

    public void setExpressionEndOffset(int expressionEndOffset) {
        this.expressionEndOffset = expressionEndOffset;
    }

    public void setContextBeforeSize(int contextBeforeSize) {
        this.contextBeforeSize = contextBeforeSize;
    }

    public void setContextAfterSize(int contextAfterSize) {
        this.contextAfterSize = contextAfterSize;
    }

    public void setExpressionTooltip(String expressionTooltip) {
        this.expressionTooltip = expressionTooltip;
    }

    public void setTextMouseListener(StackMouseListener textMouseListener) {
        this.textMouseListener = textMouseListener;
    }

    public void setHeaderMouseListener(StackMouseListener headerMouseListener) {
        this.headerMouseListener = headerMouseListener;
    }

    public void setAnnotationMouseListener(StackMouseListener annotationMouseListener) {
        this.annotationMouseListener = annotationMouseListener;
    }

    class StackRow {
        String set;
        String type;
        String feature;
        Set<StackAnnotation> annotations;
        JButton lastColumnButton;
        String shortcut;
        int crop;

        StackRow(String set, String type, String feature, JButton lastColumnButton, String shortcut, int crop) {
            this.set = set;
            this.type = type;
            this.feature = feature;
            this.annotations = new HashSet<StackAnnotation>();
            this.lastColumnButton = lastColumnButton;
            this.shortcut = shortcut;
            this.crop = crop;
        }

        public String getSet() {
            return this.set;
        }

        public String getType() {
            return this.type;
        }

        public String getFeature() {
            return this.feature;
        }

        public Set<StackAnnotation> getAnnotations() {
            return this.annotations;
        }

        public JButton getLastColumnButton() {
            return this.lastColumnButton;
        }

        public String getShortcut() {
            return this.shortcut;
        }

        public int getCrop() {
            return this.crop;
        }

        public void addAnnotation(StackAnnotation annotation) {
            this.annotations.add(annotation);
        }
    }

    private static class StackAnnotation
    extends AnnotationImpl {
        StackAnnotation(Integer id, Node start, Node end, String type, FeatureMap features) {
            super(id, start, end, type, features);
        }

        static StackAnnotation createAnnotation(int startOffset, int endOffset, String type, FeatureMap features) {
            NodeImpl startNode = new NodeImpl(-1, Long.valueOf(startOffset));
            NodeImpl endNode = new NodeImpl(-1, Long.valueOf(endOffset));
            return new StackAnnotation(-1, startNode, endNode, type, features);
        }

        static StackAnnotation createAnnotation(Annotation annotation) {
            return new StackAnnotation(annotation.getId(), annotation.getStartNode(), annotation.getEndNode(), annotation.getType(), annotation.getFeatures());
        }
    }

    public static class StackMouseListener
    extends MouseInputAdapter {
        public MouseInputAdapter createListener(String ... parameters) {
            return null;
        }
    }
}

