/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.util.Out;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TextAttributesChooser
extends JDialog {
    JComboBox<String> fontFamilyCombo;
    JComboBox<String> fontSizeCombo;
    JCheckBox boldChk;
    JCheckBox italicChk;
    JCheckBox underlineChk;
    JCheckBox subscriptChk;
    JCheckBox superscriptChk;
    JCheckBox strikethroughChk;
    JCheckBox useForegroundChk;
    JCheckBox useBackgroundChk;
    JColorChooser fgChooser;
    JColorChooser bgChooser;
    JTextPane sampleText;
    JButton okButton;
    JButton cancelButton;
    MutableAttributeSet currentStyle;
    boolean choice;

    public TextAttributesChooser(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TextAttributesChooser(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TextAttributesChooser() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        int i;
        this.sampleText = new JTextPane();
        this.sampleText.setText("Type your own sample here...");
        if (this.currentStyle == null) {
            StyleContext context = new StyleContext();
            this.currentStyle = context.addStyle(null, null);
            this.currentStyle.addAttributes(this.sampleText.getInputAttributes());
        }
        Box contents = Box.createVerticalBox();
        JTabbedPane firstLevel = new JTabbedPane();
        Box fontBox = Box.createVerticalBox();
        this.fontFamilyCombo = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.fontFamilyCombo.setSelectedItem(StyleConstants.getFontFamily(this.currentStyle));
        this.fontSizeCombo = new JComboBox<String>(new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26"});
        this.fontSizeCombo.setSelectedItem(new Integer(StyleConstants.getFontSize(this.currentStyle)).toString());
        this.fontSizeCombo.setEditable(true);
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        box.add(this.fontFamilyCombo);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.fontSizeCombo);
        box.add(Box.createHorizontalGlue());
        box.setBorder(BorderFactory.createTitledBorder("Font"));
        fontBox.add(box);
        box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        Box box1 = Box.createVerticalBox();
        this.boldChk = new JCheckBox("<html><b>Bold</b></html>");
        this.boldChk.setSelected(StyleConstants.isBold(this.currentStyle));
        box1.add(this.boldChk);
        this.underlineChk = new JCheckBox("<html><u>Underline</u></html>");
        this.underlineChk.setSelected(StyleConstants.isUnderline(this.currentStyle));
        box.add(box1);
        box1 = Box.createVerticalBox();
        this.italicChk = new JCheckBox("<html><i>Italic</i></html>");
        this.italicChk.setSelected(StyleConstants.isItalic(this.currentStyle));
        box1.add(this.italicChk);
        this.subscriptChk = new JCheckBox("<html>T<sub>Subscript</sub></html>");
        this.subscriptChk.setSelected(StyleConstants.isSubscript(this.currentStyle));
        this.superscriptChk = new JCheckBox("<html>T<sup>Superscript</sup></html>");
        this.superscriptChk.setSelected(StyleConstants.isSuperscript(this.currentStyle));
        this.strikethroughChk = new JCheckBox("<html><strike>Strikethrough</strike></html>");
        this.strikethroughChk.setSelected(StyleConstants.isStrikeThrough(this.currentStyle));
        box.add(box1);
        box.add(Box.createHorizontalGlue());
        box.setBorder(BorderFactory.createTitledBorder("Effects"));
        fontBox.add(box);
        box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        this.useForegroundChk = new JCheckBox("Use foreground colour");
        this.useForegroundChk.setSelected(false);
        box.add(this.useForegroundChk);
        this.useBackgroundChk = new JCheckBox("Use background colour");
        this.useBackgroundChk.setSelected(false);
        box.add(this.useBackgroundChk);
        box.add(Box.createHorizontalGlue());
        box.setBorder(BorderFactory.createTitledBorder("Use Colours"));
        fontBox.add(box);
        fontBox.add(Box.createVerticalGlue());
        firstLevel.add("Font", fontBox);
        this.fgChooser = new JColorChooser(StyleConstants.getForeground(this.currentStyle));
        JTabbedPane tp = new JTabbedPane();
        AbstractColorChooserPanel[] panels = this.fgChooser.getChooserPanels();
        for (i = 0; i < panels.length; ++i) {
            tp.add(panels[i].getDisplayName(), panels[i]);
        }
        firstLevel.add("Foreground", tp);
        this.bgChooser = new JColorChooser(StyleConstants.getBackground(this.currentStyle));
        tp = new JTabbedPane();
        panels = this.bgChooser.getChooserPanels();
        for (i = 0; i < panels.length; ++i) {
            tp.add(panels[i].getDisplayName(), panels[i]);
        }
        firstLevel.add("Background", tp);
        contents.add(firstLevel);
        JPanel secondLevel = new JPanel();
        secondLevel.setBorder(BorderFactory.createTitledBorder("Sample"));
        JScrollPane scroller = new JScrollPane(this.sampleText);
        scroller.setPreferredSize(new Dimension(400, 50));
        secondLevel.add(scroller);
        secondLevel.add(Box.createHorizontalGlue());
        contents.add(secondLevel);
        Box thirdLevel = Box.createHorizontalBox();
        this.okButton = new JButton("OK");
        thirdLevel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        thirdLevel.add(this.cancelButton);
        contents.add(thirdLevel);
        this.getContentPane().add((Component)contents, "Center");
        this.fontFamilyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleConstants.setFontFamily(TextAttributesChooser.this.currentStyle, (String)TextAttributesChooser.this.fontFamilyCombo.getSelectedItem());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.fontSizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Integer.parseInt((String)TextAttributesChooser.this.fontSizeCombo.getSelectedItem());
                }
                catch (NumberFormatException nfe) {
                    TextAttributesChooser.this.fontSizeCombo.setSelectedIndex(3);
                }
                StyleConstants.setFontSize(TextAttributesChooser.this.currentStyle, Integer.parseInt((String)TextAttributesChooser.this.fontSizeCombo.getSelectedItem()));
                TextAttributesChooser.this.updateSample();
            }
        });
        this.boldChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleConstants.setBold(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.boldChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.italicChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleConstants.setItalic(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.italicChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.underlineChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextAttributesChooser.this.underlineChk.isSelected()) {
                    TextAttributesChooser.this.strikethroughChk.setSelected(false);
                }
                StyleConstants.setUnderline(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.underlineChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.strikethroughChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextAttributesChooser.this.strikethroughChk.isSelected()) {
                    TextAttributesChooser.this.underlineChk.setSelected(false);
                }
                StyleConstants.setStrikeThrough(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.strikethroughChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.superscriptChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextAttributesChooser.this.superscriptChk.isSelected()) {
                    TextAttributesChooser.this.subscriptChk.setSelected(false);
                }
                StyleConstants.setSuperscript(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.superscriptChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.subscriptChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextAttributesChooser.this.subscriptChk.isSelected()) {
                    TextAttributesChooser.this.superscriptChk.setSelected(false);
                }
                StyleConstants.setSubscript(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.subscriptChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.fgChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StyleConstants.setForeground(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.fgChooser.getColor());
                TextAttributesChooser.this.useForegroundChk.setSelected(true);
                TextAttributesChooser.this.updateSample();
            }
        });
        this.useForegroundChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextAttributesChooser.this.useForegroundChk.isSelected()) {
                    StyleConstants.setForeground(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.fgChooser.getColor());
                } else {
                    TextAttributesChooser.this.currentStyle.removeAttribute(StyleConstants.Foreground);
                }
                TextAttributesChooser.this.updateSample();
            }
        });
        this.bgChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StyleConstants.setBackground(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.bgChooser.getColor());
                TextAttributesChooser.this.useBackgroundChk.setSelected(true);
                TextAttributesChooser.this.updateSample();
            }
        });
        this.useBackgroundChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextAttributesChooser.this.useBackgroundChk.isSelected()) {
                    StyleConstants.setBackground(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.bgChooser.getColor());
                } else {
                    TextAttributesChooser.this.currentStyle.removeAttribute(StyleConstants.Background);
                }
                TextAttributesChooser.this.updateSample();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                TextAttributesChooser.this.updateSample();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextAttributesChooser.this.choice = true;
                TextAttributesChooser.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextAttributesChooser.this.choice = false;
                TextAttributesChooser.this.setVisible(false);
            }
        });
    }

    public AttributeSet show(AttributeSet style) {
        this.currentStyle = new SimpleAttributeSet(style);
        this.updateData();
        this.updateSample();
        this.setModal(true);
        super.setVisible(true);
        if (this.choice) {
            return this.currentStyle;
        }
        return style;
    }

    protected void updateData() {
        this.fontFamilyCombo.setSelectedItem(StyleConstants.getFontFamily(this.currentStyle));
        this.fontSizeCombo.setSelectedItem(new Integer(StyleConstants.getFontSize(this.currentStyle)).toString());
        this.boldChk.setSelected(StyleConstants.isBold(this.currentStyle));
        this.italicChk.setSelected(StyleConstants.isItalic(this.currentStyle));
        this.italicChk.setSelected(StyleConstants.isItalic(this.currentStyle));
        this.underlineChk.setSelected(StyleConstants.isUnderline(this.currentStyle));
        this.subscriptChk.setSelected(StyleConstants.isSubscript(this.currentStyle));
        this.superscriptChk.setSelected(StyleConstants.isSuperscript(this.currentStyle));
        this.strikethroughChk.setSelected(StyleConstants.isStrikeThrough(this.currentStyle));
        if (this.currentStyle.isDefined(StyleConstants.Foreground)) {
            this.fgChooser.setColor(StyleConstants.getForeground(this.currentStyle));
            this.useForegroundChk.setSelected(true);
        } else {
            this.useForegroundChk.setSelected(false);
        }
        if (this.currentStyle.isDefined(StyleConstants.Background)) {
            this.bgChooser.setColor(StyleConstants.getBackground(this.currentStyle));
            this.useBackgroundChk.setSelected(true);
        } else {
            this.useBackgroundChk.setSelected(false);
        }
    }

    protected void updateSample() {
        if (this.sampleText.getSelectedText() != null && this.sampleText.getSelectedText().length() > 0) {
            this.sampleText.setCharacterAttributes(this.currentStyle, true);
        } else {
            this.sampleText.selectAll();
            this.sampleText.setCharacterAttributes(this.currentStyle, true);
            this.sampleText.setSelectionStart(0);
            this.sampleText.setSelectionEnd(0);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame frame = new JFrame("Frame");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            final TextAttributesChooser dialog = new TextAttributesChooser(frame, "Dialog", false);
            JButton btn = new JButton("Display Dialog");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Style style = new StyleContext().addStyle(null, null);
                    StyleConstants.setBackground(style, Color.white);
                    Out.println(dialog.show(style));
                }
            });
            frame.getContentPane().add(btn);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

