/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.DocumentFormat;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.BooleanRenderer;
import gate.gui.FeatureMapEditorDialog;
import gate.gui.ListEditorDialog;
import gate.gui.MainFrame;
import gate.gui.ParameterDisjunction;
import gate.gui.ResourceRenderer;
import gate.swing.ResourceReferenceChooser;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.NameBearer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class ResourceParametersEditor
extends XJTable
implements CreoleListener {
    ParametersTableModel tableModel;
    Resource resource;
    ResourceData resourceData;
    static XJFileChooser fileChooser;
    static ResourceReferenceChooser resourceReferenceChooser;
    String fileChooserResource;
    protected List<ParameterDisjunction> parameterDisjunctions;
    protected boolean editable = true;

    public ResourceParametersEditor() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.setSortable(true);
        this.setSortedColumn(0);
        this.setComparator(0, new ParameterDisjunctionComparator());
        this.setTabSkipUneditableCell(true);
        this.setEditCellAsSoonAsFocus(true);
    }

    public void init(Resource resource, ResourceData resourceData, List<List<Parameter>> parameters) {
        this.cleanup();
        this.resource = resource;
        this.resourceData = resourceData;
        if (parameters != null) {
            this.parameterDisjunctions = new ArrayList<ParameterDisjunction>(parameters.size());
            for (int i = 0; i < parameters.size(); ++i) {
                this.parameterDisjunctions.add(new ParameterDisjunction(resource, parameters.get(i)));
            }
        } else {
            this.parameterDisjunctions = null;
        }
        this.tableModel.fireTableDataChanged();
        fileChooser = MainFrame.getFileChooser();
        resourceReferenceChooser = MainFrame.getResourceReferenceChooser();
        this.fileChooserResource = resource != null ? resource.getClass().getName() : fileChooser.getResource();
    }

    public void init(Resource resource, List<List<Parameter>> parameters) {
        this.init(resource, null, parameters);
    }

    protected void initLocalData() {
        this.resource = null;
        this.parameterDisjunctions = null;
        this.resourceData = null;
    }

    protected void initGuiComponents() {
        this.tableModel = new ParametersTableModel();
        this.setModel(this.tableModel);
        this.getColumnModel().getColumn(0).setCellRenderer(new ParameterDisjunctionRenderer());
        this.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer());
        this.getColumnModel().getColumn(2).setCellRenderer(new BooleanRenderer());
        this.getColumnModel().getColumn(3).setCellRenderer(new ParameterValueRenderer());
        this.getColumnModel().getColumn(0).setCellEditor(new ParameterDisjunctionEditor());
        this.getColumnModel().getColumn(3).setCellEditor(new ParameterValueEditor());
        this.setAutoResizeMode(3);
        this.setSurrendersFocusOnKeystroke(true);
    }

    protected void initListeners() {
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        if (this.parameterDisjunctions != null && this.parameterDisjunctions.size() > 0) {
            for (int i = 0; i < this.parameterDisjunctions.size(); ++i) {
                this.parameterDisjunctions.get(i).cleanup();
            }
        }
        this.resource = null;
        this.resourceData = null;
    }

    public void setParameters() throws ResourceInstantiationException {
        if (this.resource == null || this.parameterDisjunctions == null) {
            return;
        }
        if (this.getEditingColumn() != -1 && this.getEditingRow() != -1) {
            this.editingStopped(new ChangeEvent(this.getCellEditor(this.getEditingRow(), this.getEditingColumn())));
        }
        for (int i = 0; i < this.parameterDisjunctions.size(); ++i) {
            ParameterDisjunction pDisj = this.parameterDisjunctions.get(i);
            this.resource.setParameterValue(pDisj.getName(), pDisj.getValue());
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public FeatureMap getParameterValues() {
        if (this.getEditingColumn() != -1 && this.getEditingRow() != -1) {
            this.editingStopped(new ChangeEvent(this.getCellEditor(this.getEditingRow(), this.getEditingColumn())));
        }
        FeatureMap values = Factory.newFeatureMap();
        if (this.parameterDisjunctions != null) {
            for (int i = 0; i < this.parameterDisjunctions.size(); ++i) {
                ParameterDisjunction pDisj = this.parameterDisjunctions.get(i);
                values.put(pDisj.getName(), pDisj.getValue());
            }
        }
        return values;
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
        this.repaint();
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        this.repaint();
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
        this.repaint();
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    void removeCreoleListenerLink() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        if (this.parameterDisjunctions != null && this.parameterDisjunctions.size() > 0) {
            for (int i = 0; i < this.parameterDisjunctions.size(); ++i) {
                this.parameterDisjunctions.get(i).removeCreoleListenerLink();
            }
        }
    }

    protected String textForList(Collection<?> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        StringBuilder res = new StringBuilder("[");
        for (Object elem : list) {
            if (elem != null) {
                res.append(elem instanceof NameBearer ? ((NameBearer)elem).getName() : elem.toString()).append(", ");
                continue;
            }
            res.append("<null>, ");
        }
        res.delete(res.length() - 2, res.length() - 1);
        res.append("]");
        return res.toString();
    }

    protected String textForFeatureMap(FeatureMap fm) {
        return fm == null ? "" : fm.toString();
    }

    private static Window findWindow(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return ResourceParametersEditor.findWindow(component.getParent());
    }

    class ParameterValueEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        String type;
        JComboBox combo = new JComboBox();
        JTextField textField;
        JTextField textFieldBoolean;
        ListEditorDialog listEditor = null;
        Collection<?> listValue;
        FeatureMapEditorDialog fmEditor = null;
        FeatureMap fmValue;
        boolean comboUsed;
        boolean listUsed;
        boolean fmUsed;
        JButton fileButton;
        JButton rrButton;
        JButton listButton;
        JButton fmButton;
        JPanel textButtonBox;

        ParameterValueEditor() {
            this.combo.setRenderer(new ResourceRenderer());
            this.combo.setEditable(false);
            this.textField = new JTextField(20);
            this.fileButton = new JButton(MainFrame.getIcon("open-file"));
            this.fileButton.setToolTipText("Browse the file system");
            this.fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setDialogTitle("Select a file");
                    fileChooser.setResource(ResourceParametersEditor.this.fileChooserResource);
                    int res = fileChooser.showOpenDialog(ResourceParametersEditor.this);
                    if (res == 0) {
                        try {
                            ParameterValueEditor.this.textField.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        ParameterValueEditor.this.fireEditingStopped();
                    } else {
                        ParameterValueEditor.this.fireEditingCanceled();
                    }
                }
            });
            this.rrButton = new JButton(MainFrame.getIcon("open-file"));
            this.rrButton.setToolTipText("Browse the file system and plugins");
            this.rrButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    resourceReferenceChooser.setResource(ResourceParametersEditor.this.fileChooserResource);
                    String uri = ParameterValueEditor.this.textField.getText();
                    if (uri != null && !"".equals(uri)) {
                        resourceReferenceChooser.setSelectedResource(uri);
                    }
                    if ((uri = resourceReferenceChooser.showDialog(ResourceParametersEditor.findWindow(ResourceParametersEditor.this), "Select a file")) != null) {
                        ParameterValueEditor.this.textField.setText(uri);
                        ParameterValueEditor.this.fireEditingStopped();
                    } else {
                        ParameterValueEditor.this.fireEditingCanceled();
                    }
                }
            });
            this.listButton = new JButton(MainFrame.getIcon("edit-list"));
            this.listButton.setToolTipText("Edit the list");
            this.listButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List returnedList = ParameterValueEditor.this.listEditor.showDialog();
                    if (returnedList != null) {
                        ParameterValueEditor.this.listValue = returnedList;
                        ParameterValueEditor.this.fireEditingStopped();
                    } else {
                        ParameterValueEditor.this.fireEditingCanceled();
                    }
                }
            });
            this.fmButton = new JButton(MainFrame.getIcon("edit-list"));
            this.fmButton.setToolTipText("Edit the feature map");
            this.fmButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeatureMap returnedFM = ParameterValueEditor.this.fmEditor.showDialog();
                    if (returnedFM != null) {
                        ParameterValueEditor.this.fmValue = returnedFM;
                        ParameterValueEditor.this.fireEditingStopped();
                    } else {
                        ParameterValueEditor.this.fireEditingCanceled();
                    }
                }
            });
            this.textButtonBox = new JPanel();
            this.textButtonBox.setLayout(new BoxLayout(this.textButtonBox, 0));
            this.textButtonBox.setOpaque(false);
            this.textFieldBoolean = new JTextField();
            this.textFieldBoolean.setEditable(false);
            this.textFieldBoolean.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Boolean value = Boolean.valueOf(ParameterValueEditor.this.textFieldBoolean.getText());
                    value = value == false;
                    ParameterValueEditor.this.textFieldBoolean.setText(value.toString());
                }
            });
            this.textFieldBoolean.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    Boolean value = Boolean.valueOf(ParameterValueEditor.this.textFieldBoolean.getText());
                    value = value == false;
                    ParameterValueEditor.this.textFieldBoolean.setText(value.toString());
                }
            });
            this.textButtonBox.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (!ParameterValueEditor.this.comboUsed) {
                        ParameterValueEditor.this.textField.requestFocusInWindow();
                    }
                }
            });
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JTextField textField = (JTextField)e.getSource();
                    if (e.getKeyCode() == 9 && textField.getParent().getComponentCount() == 3) {
                        textField.getParent().getComponent(2).requestFocusInWindow();
                        e.consume();
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comboUsed = false;
            this.listUsed = false;
            this.fmUsed = false;
            ParameterDisjunction pDisj = (ParameterDisjunction)table.getValueAt(row, ResourceParametersEditor.this.convertColumnIndexToView(0));
            this.type = pDisj.getType();
            this.combo.setToolTipText(pDisj.getComment());
            this.textField.setToolTipText(pDisj.getComment());
            this.textFieldBoolean.setToolTipText(pDisj.getComment());
            if (Gate.isGateType(this.type)) {
                this.comboUsed = true;
                ArrayList<Object> values = new ArrayList<Object>();
                try {
                    values.addAll(Gate.getCreoleRegister().getAllInstances(this.type));
                }
                catch (GateException ge) {
                    ge.printStackTrace(Err.getPrintWriter());
                }
                values.add(0, "<none>");
                this.combo.setModel(new DefaultComboBoxModel<Object>(values.toArray()));
                this.combo.setSelectedItem(value == null ? "<none>" : value);
                return this.combo;
            }
            Class<?> typeClass = null;
            try {
                typeClass = Class.forName(this.type, true, Gate.getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            this.textField.setText(value == null ? "" : value.toString());
            if (this.type.equals("java.net.URL")) {
                fileChooser.resetChoosableFileFilters();
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                Parameter param = pDisj.getParameter();
                Set<String> sufixes = null;
                if (ResourceParametersEditor.this.resourceData != null && param.getName().equals("sourceUrl") && ResourceParametersEditor.this.resourceData.getClassName().equals(DocumentImpl.class.getName())) {
                    sufixes = DocumentFormat.getSupportedFileSuffixes();
                }
                if (sufixes == null || sufixes.isEmpty()) {
                    sufixes = param.getSuffixes();
                }
                if (sufixes != null) {
                    ExtensionFileFilter fileFilter = new ExtensionFileFilter();
                    Iterator<String> sufIter = sufixes.iterator();
                    while (sufIter.hasNext()) {
                        fileFilter.addExtension(sufIter.next());
                    }
                    fileFilter.setDescription("Known file types " + sufixes.toString());
                    fileChooser.addChoosableFileFilter(fileFilter);
                    fileChooser.setFileFilter(fileFilter);
                }
                this.textField.setEditable(true);
                this.textButtonBox.removeAll();
                this.textButtonBox.add(this.textField);
                this.textButtonBox.add(Box.createHorizontalStrut(5));
                this.textButtonBox.add(this.fileButton);
                return this.textButtonBox;
            }
            if (this.type.equals("gate.creole.ResourceReference")) {
                Parameter param = pDisj.getParameter();
                Set<String> sufixes = null;
                if (ResourceParametersEditor.this.resourceData != null && param.getName().equals("sourceUrl") && ResourceParametersEditor.this.resourceData.getClassName().equals(DocumentImpl.class.getName())) {
                    sufixes = DocumentFormat.getSupportedFileSuffixes();
                }
                if (sufixes == null || sufixes.isEmpty()) {
                    sufixes = param.getSuffixes();
                }
                if (sufixes != null) {
                    resourceReferenceChooser.setSuffixes(sufixes);
                }
                this.textField.setEditable(true);
                this.textButtonBox.removeAll();
                this.textButtonBox.add(this.textField);
                this.textButtonBox.add(Box.createHorizontalStrut(5));
                this.textButtonBox.add(this.rrButton);
                return this.textButtonBox;
            }
            if (this.type.equals("java.lang.Boolean")) {
                this.textFieldBoolean.setText(value == null ? "false" : value.toString());
                return this.textFieldBoolean;
            }
            if (typeClass != null && Collection.class.isAssignableFrom(typeClass)) {
                this.listUsed = true;
                Parameter param = pDisj.getParameter();
                this.listValue = (Collection)value;
                this.listEditor = new ListEditorDialog(SwingUtilities.getAncestorOfClass(Window.class, ResourceParametersEditor.this), (Collection)value, typeClass, param.getItemClassName());
                this.textField.setEditable(false);
                this.textField.setText(ResourceParametersEditor.this.textForList((Collection)value));
                this.textButtonBox.removeAll();
                this.textButtonBox.add(this.textField);
                this.textButtonBox.add(Box.createHorizontalStrut(5));
                this.textButtonBox.add(this.listButton);
                return this.textButtonBox;
            }
            if (typeClass != null && FeatureMap.class.isAssignableFrom(typeClass)) {
                this.fmUsed = true;
                this.fmValue = (FeatureMap)value;
                this.fmEditor = new FeatureMapEditorDialog(SwingUtilities.getAncestorOfClass(Window.class, ResourceParametersEditor.this), (FeatureMap)value);
                this.textField.setEditable(false);
                this.textField.setText(ResourceParametersEditor.this.textForFeatureMap((FeatureMap)value));
                this.textButtonBox.removeAll();
                this.textButtonBox.add(this.textField);
                this.textButtonBox.add(Box.createHorizontalStrut(5));
                this.textButtonBox.add(this.fmButton);
                return this.textButtonBox;
            }
            if (typeClass != null && typeClass.isEnum()) {
                this.comboUsed = true;
                try {
                    Method getValuesMethod = typeClass.getMethod("values", new Class[0]);
                    Object[] enumValues = (Object[])getValuesMethod.invoke(null, new Object[0]);
                    Object[] comboValues = null;
                    Parameter param = pDisj.getParameter();
                    if (param.isOptional()) {
                        comboValues = new Object[enumValues.length + 1];
                        comboValues[0] = "<none>";
                        System.arraycopy(enumValues, 0, comboValues, 1, enumValues.length);
                    } else {
                        comboValues = enumValues;
                    }
                    this.combo.setModel(new DefaultComboBoxModel<Object>(comboValues));
                    this.combo.setSelectedItem(value == null ? "<none>" : value);
                    return this.combo;
                }
                catch (Exception ex) {
                    throw new GateRuntimeException("Error calling \"values\" method of an enum type", ex);
                }
            }
            this.textField.setEditable(true);
            return this.textField;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.comboUsed) {
                Object value = this.combo.getSelectedItem();
                return value == "<none>" ? null : value;
            }
            if (this.listUsed) {
                return this.listValue;
            }
            if (this.fmUsed) {
                return this.fmValue;
            }
            if (this.type.equals("java.lang.Boolean")) {
                return Boolean.valueOf(this.textFieldBoolean.getText());
            }
            return this.textField.getText();
        }
    }

    class ParameterDisjunctionEditor
    extends DefaultCellEditor {
        JComboBox combo;
        ParameterDisjunction pDisj;

        public ParameterDisjunctionEditor() {
            super(new JComboBox());
            this.combo = (JComboBox)super.getComponent();
            class CustomRenderer
            extends JLabel
            implements ListCellRenderer {
                public CustomRenderer() {
                    this.setOpaque(true);
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (isSelected) {
                        this.setBackground(list.getSelectionBackground());
                        this.setForeground(list.getSelectionForeground());
                    } else {
                        this.setBackground(list.getBackground());
                        this.setForeground(list.getForeground());
                    }
                    this.setFont(list.getFont());
                    this.setText((String)value);
                    this.setIcon(MainFrame.getIcon("param"));
                    Parameter[] params = ParameterDisjunctionEditor.this.pDisj.getParameters();
                    for (int i = 0; i < params.length; ++i) {
                        ResourceData rData;
                        Parameter param = params[i];
                        if (!param.getName().equals(value)) continue;
                        String type = param.getTypeName();
                        if (!Gate.getCreoleRegister().containsKey(type) || (rData = (ResourceData)Gate.getCreoleRegister().get(type)) == null) break;
                        this.setIcon(MainFrame.getIcon(rData.getIcon(), rData.getResourceClassLoader()));
                        break;
                    }
                    return this;
                }
            }
            this.combo.setRenderer(new CustomRenderer());
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterDisjunctionEditor.this.pDisj.setSelectedIndex(ParameterDisjunctionEditor.this.combo.getSelectedIndex());
                    ParameterDisjunctionEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.pDisj = (ParameterDisjunction)value;
            DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(this.pDisj.getNames());
            this.combo.setModel(comboModel);
            this.combo.setSelectedIndex(this.pDisj.getSelectedIndex());
            return this.combo;
        }

        @Override
        public Object getCellEditorValue() {
            this.pDisj.setSelectedIndex(this.combo.getSelectedIndex());
            return this.pDisj;
        }

        @Override
        public boolean stopCellEditing() {
            this.combo.hidePopup();
            return super.stopCellEditing();
        }
    }

    class ParameterDisjunctionComparator
    implements Comparator<ParameterDisjunction> {
        ParameterDisjunctionComparator() {
        }

        @Override
        public int compare(ParameterDisjunction pDisj1, ParameterDisjunction pDisj2) {
            return pDisj1.getName().compareTo(pDisj2.getName());
        }
    }

    class ParameterValueRenderer
    extends DefaultTableCellRenderer {
        JButton fileButton = new JButton(MainFrame.getIcon("open-file"));
        JButton listButton;
        JButton fmButton;
        JComboBox combo;
        JPanel textButtonBox;
        JTextField textField;

        public ParameterValueRenderer() {
            this.fileButton.setToolTipText("Browse the file system");
            this.listButton = new JButton(MainFrame.getIcon("edit-list"));
            this.listButton.setToolTipText("Edit the list");
            this.fmButton = new JButton(MainFrame.getIcon("edit-list"));
            this.fmButton.setToolTipText("Edit the feature map");
            this.textField = new JTextField(){

                @Override
                public Dimension getMinimumSize() {
                    Dimension size = this.getPreferredSize();
                    if (size.width < 300) {
                        size.width = 300;
                    }
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    if ((double)size.width > 0.95 * (double)screenSize.width) {
                        size.width = 0 * screenSize.width;
                    }
                    return size;
                }
            };
            this.textButtonBox = new JPanel();
            this.textButtonBox.setLayout(new BoxLayout(this.textButtonBox, 0));
            this.textButtonBox.setOpaque(false);
            this.combo = new JComboBox();
            this.combo.setRenderer(new ResourceRenderer());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ParameterDisjunction pDisj = (ParameterDisjunction)table.getValueAt(row, ResourceParametersEditor.this.convertColumnIndexToView(0));
            String type = pDisj.getType();
            this.combo.setToolTipText(pDisj.getComment());
            this.textField.setToolTipText(pDisj.getComment());
            this.textButtonBox.setToolTipText(pDisj.getComment());
            if (Gate.isGateType(type)) {
                if (ResourceParametersEditor.this.isEditable()) {
                    this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{value == null ? "<none>" : value}));
                    return this.combo;
                }
                String text = value == null ? "<none>" : value.toString();
                this.textField.setText(text);
                return this.textField;
            }
            Class<?> typeClass = null;
            try {
                typeClass = Class.forName(type, true, Gate.getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            String text = value == null ? "" : value.toString();
            this.textField.setText(text);
            if (type.equals("java.net.URL") || type.equals("gate.creole.ResourceReference")) {
                if (ResourceParametersEditor.this.isEditable()) {
                    this.textButtonBox.removeAll();
                    this.textField.setText(text);
                    this.textButtonBox.add(this.textField);
                    this.textButtonBox.add(Box.createHorizontalStrut(5));
                    this.textButtonBox.add(this.fileButton);
                    return this.textButtonBox;
                }
                return this.textField;
            }
            if (typeClass != null && Collection.class.isAssignableFrom(typeClass)) {
                this.textField.setText(ResourceParametersEditor.this.textForList((Collection)value));
                if (ResourceParametersEditor.this.isEditable()) {
                    this.textButtonBox.removeAll();
                    this.textButtonBox.add(this.textField);
                    this.textButtonBox.add(Box.createHorizontalStrut(5));
                    this.textButtonBox.add(this.listButton);
                    return this.textButtonBox;
                }
            } else if (typeClass != null && FeatureMap.class.isAssignableFrom(typeClass)) {
                this.textField.setText(ResourceParametersEditor.this.textForFeatureMap((FeatureMap)value));
                if (ResourceParametersEditor.this.isEditable()) {
                    this.textButtonBox.removeAll();
                    this.textButtonBox.add(this.textField);
                    this.textButtonBox.add(Box.createHorizontalStrut(5));
                    this.textButtonBox.add(this.fmButton);
                    return this.textButtonBox;
                }
            } else {
                if (typeClass != null && typeClass.isEnum()) {
                    if (ResourceParametersEditor.this.isEditable()) {
                        this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{value == null ? "<none>" : value}));
                        return this.combo;
                    }
                    return this.textField;
                }
                return this.textField;
            }
            return this.textField;
        }
    }

    class ParameterDisjunctionRenderer
    extends DefaultTableCellRenderer {
        JComboBox combo = new JComboBox();
        Icon icon = null;
        String text;

        public ParameterDisjunctionRenderer() {
            class CustomRenderer
            extends JLabel
            implements ListCellRenderer {
                CustomRenderer() {
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.setText(ParameterDisjunctionRenderer.this.text);
                    this.setIcon(ParameterDisjunctionRenderer.this.icon);
                    return this;
                }
            }
            this.combo.setRenderer(new CustomRenderer());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ResourceData rData;
            ParameterDisjunction pDisj = (ParameterDisjunction)value;
            this.text = pDisj.getName();
            String type = pDisj.getType();
            if (Gate.isGateType(type) && (rData = (ResourceData)Gate.getCreoleRegister().get(type)) != null) {
                this.icon = MainFrame.getIcon(rData.getIcon(), rData.getResourceClassLoader());
            }
            if (pDisj.size() > 1) {
                this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{this.text}));
                return this.combo;
            }
            super.getTableCellRendererComponent(table, this.text, isSelected, hasFocus, row, column);
            if (this.icon == null) {
                this.icon = MainFrame.getIcon("param");
            }
            this.setIcon(this.icon);
            return this;
        }
    }

    protected class ParametersTableModel
    extends AbstractTableModel {
        protected ParametersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterDisjunction.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Required";
                }
                case 3: {
                    return "Value";
                }
            }
            return "?";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ResourceParametersEditor.this.parameterDisjunctions.get(rowIndex).size() > 1;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return ResourceParametersEditor.this.editable;
                }
            }
            return false;
        }

        @Override
        public int getRowCount() {
            return ResourceParametersEditor.this.parameterDisjunctions == null ? 0 : ResourceParametersEditor.this.parameterDisjunctions.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ParameterDisjunction pDisj = ResourceParametersEditor.this.parameterDisjunctions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return pDisj;
                }
                case 1: {
                    String paramType = pDisj.getType();
                    return paramType.substring(paramType.lastIndexOf(46) + 1);
                }
                case 2: {
                    return pDisj.isRequired();
                }
                case 3: {
                    return pDisj.getValue();
                }
            }
            return "?";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ParameterDisjunction pDisj = ResourceParametersEditor.this.parameterDisjunctions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (aValue instanceof ParameterDisjunction || !(aValue instanceof Integer)) break;
                    pDisj.setSelectedIndex((Integer)aValue);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    Object oldValue = pDisj.getValue();
                    if (Objects.equals(oldValue, aValue)) break;
                    pDisj.setValue(aValue);
                    if (ResourceParametersEditor.this == null || ResourceParametersEditor.this.resource == null) break;
                    try {
                        ResourceParametersEditor.this.resource.setParameterValue(pDisj.getName(), pDisj.getValue());
                    }
                    catch (ResourceInstantiationException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
            ResourceParametersEditor.this.tableModel.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

