/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.gui.AnnotationDiffGUI;
import gate.gui.MainFrame;
import gate.resources.img.svg.AnnotationDiffIcon;
import gate.resources.img.svg.DocumentIcon;
import gate.resources.img.svg.DownloadIcon;
import gate.resources.img.svg.HelpIcon;
import gate.resources.img.svg.ProgressIcon;
import gate.resources.img.svg.RefreshIcon;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.AnnotationDiffer;
import gate.util.ClassificationMeasures;
import gate.util.ExtensionFileFilter;
import gate.util.OntologyMeasures;
import gate.util.OptionsMap;
import gate.util.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.Position;

@CreoleResource(name="Corpus Quality Assurance", guiType=GuiType.LARGE, resourceDisplayed="gate.Corpus", mainViewer=false, helpURL="http://gate.ac.uk/userguide/sec:eval:corpusqualityassurance")
public class CorpusQualityAssurance
extends AbstractVisualResource
implements CorpusListener {
    protected Corpus corpus;
    protected boolean corpusChanged;
    protected TreeSet<String> types;
    protected final Map<String, TreeMap<String, TreeMap<String, TreeSet<String>>>> docsSetsTypesFeatures = Collections.synchronizedMap(new LinkedHashMap());
    protected ArrayList<HashMap<String, AnnotationDiffer>> differsByDocThenType = new ArrayList();
    protected ArrayList<String> documentNames = new ArrayList();
    protected String keySetName;
    protected String responseSetName;
    protected Object[] typesSelected;
    protected Object[] featuresSelected;
    protected Timer timer = new Timer("CorpusQualityAssurance", true);
    protected TimerTask timerTask;
    protected Thread readSetsTypesFeaturesThread;
    protected int measuresType;
    protected static final int FSCORE_MEASURES = 0;
    protected static final int CLASSIFICATION_MEASURES = 1;
    protected Collator collator;
    protected Comparator<String> doubleComparator;
    protected Comparator<String> totalComparator;
    protected OptionsMap userConfig = Gate.getUserConfig();
    protected URL bdmFileUrl;
    protected XJTable documentTable;
    protected DefaultTableModel documentTableModel;
    protected XJTable annotationTable;
    protected DefaultTableModel annotationTableModel;
    protected XJTable document2Table;
    protected DefaultTableModel document2TableModel;
    protected XJTable confusionTable;
    protected DefaultTableModel confusionTableModel;
    protected JTabbedPane tableTabbedPane;
    protected JList setList;
    protected JList typeList;
    protected JList featureList;
    protected JToggleButton optionsButton;
    protected JTabbedPane measureTabbedPane;
    protected JList measureList;
    protected JList measure2List;
    protected JCheckBox setCheck;
    protected JCheckBox typeCheck;
    protected JCheckBox featureCheck;
    protected JProgressBar progressBar;
    protected JCheckBox verboseOptionCheckBox;
    protected OpenDocumentAction openDocumentAction;
    protected OpenAnnotationDiffAction openAnnotationDiffAction;
    protected ExportToHtmlAction exportToHtmlAction;
    protected ReloadCacheAction reloadCacheAction;
    protected CompareAction compareAction;

    @Override
    public Resource init() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
        this.collator = Collator.getInstance(Locale.ENGLISH);
        this.collator.setStrength(2);
        this.documentTableModel = new DefaultTableModel();
        this.documentTableModel.addColumn("Document");
        this.documentTableModel.addColumn("Match");
        this.documentTableModel.addColumn("Only A");
        this.documentTableModel.addColumn("Only B");
        this.documentTableModel.addColumn("Overlap");
        this.annotationTableModel = new DefaultTableModel();
        this.annotationTableModel.addColumn("Annotation");
        this.annotationTableModel.addColumn("Match");
        this.annotationTableModel.addColumn("Only A");
        this.annotationTableModel.addColumn("Only B");
        this.annotationTableModel.addColumn("Overlap");
        this.document2TableModel = new DefaultTableModel();
        this.document2TableModel.addColumn("Document");
        this.document2TableModel.addColumn("Agreed");
        this.document2TableModel.addColumn("Total");
        this.confusionTableModel = new DefaultTableModel();
        this.types = new TreeSet<Object>(this.collator);
        this.corpusChanged = false;
        this.measuresType = 0;
        this.doubleComparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1 == null || s2 == null) {
                    return 0;
                }
                if (s1.equals("")) {
                    return 1;
                }
                if (s2.equals("")) {
                    return -1;
                }
                return Double.valueOf(s1).compareTo(Double.valueOf(s2));
            }
        };
        this.totalComparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1 == null || s2 == null) {
                    return 0;
                }
                if (s1.equals("Micro summary")) {
                    return s2.equals("Macro summary") ? -1 : 1;
                }
                if (s1.equals("Macro summary")) {
                    return s2.equals("Micro summary") ? -1 : 1;
                }
                if (s2.equals("Micro summary")) {
                    return s1.equals("Macro summary") ? 1 : -1;
                }
                if (s2.equals("Macro summary")) {
                    return s1.equals("Micro summary") ? 1 : -1;
                }
                return s1.compareTo(s2);
            }
        };
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        JPanel sidePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        sidePanel.add(Box.createVerticalStrut(5), gbc);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.openDocumentAction = new OpenDocumentAction();
        toolbar.add(this.openDocumentAction);
        this.openDocumentAction.setEnabled(false);
        this.openAnnotationDiffAction = new OpenAnnotationDiffAction();
        toolbar.add(this.openAnnotationDiffAction);
        this.openAnnotationDiffAction.setEnabled(false);
        this.exportToHtmlAction = new ExportToHtmlAction();
        toolbar.add(this.exportToHtmlAction);
        this.reloadCacheAction = new ReloadCacheAction();
        toolbar.add(this.reloadCacheAction);
        toolbar.add(new HelpAction());
        gbc.anchor = 18;
        sidePanel.add((Component)toolbar, gbc);
        gbc.anchor = 11;
        sidePanel.add(Box.createVerticalStrut(5), gbc);
        JLabel label = new JLabel("Annotation Sets A/Key & B/Response");
        label.setToolTipText("aka 'Key & Response sets'");
        gbc.fill = 1;
        sidePanel.add((Component)label, gbc);
        sidePanel.add(Box.createVerticalStrut(2), gbc);
        this.setList = new JList();
        this.setList.setSelectionModel(new ToggleSelectionABModel(this.setList));
        this.setList.setPrototypeCellValue("present in every document");
        this.setList.setVisibleRowCount(4);
        gbc.weighty = 1.0;
        sidePanel.add((Component)new JScrollPane(this.setList), gbc);
        gbc.weighty = 0.0;
        sidePanel.add(Box.createVerticalStrut(2), gbc);
        this.setCheck = new JCheckBox("present in every document", false);
        this.setCheck.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorpusQualityAssurance.this.updateSetList();
            }
        });
        sidePanel.add((Component)this.setCheck, gbc);
        sidePanel.add(Box.createVerticalStrut(5), gbc);
        label = new JLabel("Annotation Types");
        label.setToolTipText("Annotation types to compare");
        sidePanel.add((Component)label, gbc);
        sidePanel.add(Box.createVerticalStrut(2), gbc);
        this.typeList = new JList();
        this.typeList.setSelectionModel(new ToggleSelectionModel());
        this.typeList.setPrototypeCellValue("present in every document");
        this.typeList.setVisibleRowCount(4);
        gbc.weighty = 1.0;
        sidePanel.add((Component)new JScrollPane(this.typeList), gbc);
        gbc.weighty = 0.0;
        sidePanel.add(Box.createVerticalStrut(2), gbc);
        this.typeCheck = new JCheckBox("present in every selected set", false);
        this.typeCheck.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorpusQualityAssurance.this.setList.getListSelectionListeners()[0].valueChanged(null);
            }
        });
        sidePanel.add((Component)this.typeCheck, gbc);
        sidePanel.add(Box.createVerticalStrut(5), gbc);
        label = new JLabel("Annotation Features");
        label.setToolTipText("Annotation features to compare");
        sidePanel.add((Component)label, gbc);
        sidePanel.add(Box.createVerticalStrut(2), gbc);
        this.featureList = new JList();
        this.featureList.setSelectionModel(new ToggleSelectionModel());
        this.featureList.setPrototypeCellValue("present in every document");
        this.featureList.setVisibleRowCount(4);
        gbc.weighty = 1.0;
        sidePanel.add((Component)new JScrollPane(this.featureList), gbc);
        gbc.weighty = 0.0;
        sidePanel.add(Box.createVerticalStrut(2), gbc);
        this.featureCheck = new JCheckBox("present in every selected type", false);
        this.featureCheck.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorpusQualityAssurance.this.typeList.getListSelectionListeners()[0].valueChanged(null);
            }
        });
        sidePanel.add((Component)this.featureCheck, gbc);
        sidePanel.add(Box.createVerticalStrut(5), gbc);
        label = new JLabel("Measures");
        label.setToolTipText("Measures used to compare annotations");
        this.optionsButton = new JToggleButton("Options");
        this.optionsButton.setMargin(new Insets(1, 1, 1, 1));
        JPanel labelButtonPanel = new JPanel(new BorderLayout());
        labelButtonPanel.add((Component)label, "West");
        labelButtonPanel.add((Component)this.optionsButton, "East");
        sidePanel.add((Component)labelButtonPanel, gbc);
        sidePanel.add(Box.createVerticalStrut(2), gbc);
        final JScrollPane measureScrollPane = new JScrollPane();
        this.measureList = new JList();
        this.measureList.setSelectionModel(new ToggleSelectionModel());
        String prefix = this.getClass().getName() + '.';
        double beta = this.userConfig.getDouble(prefix + "fscorebeta") == null ? 1.0 : this.userConfig.getDouble(prefix + "fscorebeta");
        double beta2 = this.userConfig.getDouble(prefix + "fscorebeta2") == null ? 0.5 : this.userConfig.getDouble(prefix + "fscorebeta2");
        String fscore = "F" + beta + "-score ";
        String fscore2 = "F" + beta2 + "-score ";
        this.measureList.setModel(new ExtendedListModel(new String[]{fscore + "strict", fscore + "lenient", fscore + "average", fscore + "strict BDM", fscore + "lenient BDM", fscore + "average BDM", fscore2 + "strict", fscore2 + "lenient", fscore2 + "average", fscore2 + "strict BDM", fscore2 + "lenient BDM", fscore2 + "average BDM"}));
        this.measureList.setPrototypeCellValue("present in every document");
        this.measureList.setVisibleRowCount(4);
        measureScrollPane.setViewportView(this.measureList);
        final JScrollPane measure2ScrollPane = new JScrollPane();
        this.measure2List = new JList();
        this.measure2List.setSelectionModel(new ToggleSelectionModel());
        this.measure2List.setModel(new ExtendedListModel(new String[]{"Observed agreement", "Cohen's Kappa", "Pi's Kappa"}));
        this.measure2List.setPrototypeCellValue("present in every document");
        this.measure2List.setVisibleRowCount(4);
        measure2ScrollPane.setViewportView(this.measure2List);
        this.measureTabbedPane = new JTabbedPane();
        this.measureTabbedPane.addTab("F-Score", null, measureScrollPane, "Inter-annotator agreement");
        this.measureTabbedPane.addTab("Classification", null, measure2ScrollPane, "Classification agreement");
        gbc.weighty = 1.0;
        sidePanel.add((Component)this.measureTabbedPane, gbc);
        gbc.weighty = 0.0;
        sidePanel.add(Box.createVerticalStrut(5), gbc);
        sidePanel.add(Box.createVerticalGlue(), gbc);
        final JPanel measureOptionsPanel = new JPanel();
        measureOptionsPanel.setLayout(new BoxLayout(measureOptionsPanel, 1));
        JPanel betaPanel = new JPanel();
        betaPanel.setLayout(new BoxLayout(betaPanel, 0));
        JLabel betaLabel = new JLabel("Fscore Beta 1:");
        final JSpinner betaSpinner = new JSpinner(new SpinnerNumberModel(beta, 0.0, 1.0, 0.1));
        betaSpinner.setToolTipText("<html>Relative weight of precision and recall.<ul><li>1 weights equally precision and recall<li>0.5 weights precision twice as much as recall<li>2 weights recall twice as much as precision</ul></html>");
        betaPanel.add(betaLabel);
        betaPanel.add(Box.createHorizontalStrut(5));
        betaPanel.add(betaSpinner);
        betaPanel.add(Box.createHorizontalGlue());
        measureOptionsPanel.add(betaPanel);
        betaSpinner.setMaximumSize(new Dimension(Integer.MAX_VALUE, Math.round((float)betaLabel.getPreferredSize().height * 1.5f)));
        JPanel beta2Panel = new JPanel();
        beta2Panel.setLayout(new BoxLayout(beta2Panel, 0));
        JLabel beta2Label = new JLabel("Fscore Beta 2:");
        final JSpinner beta2Spinner = new JSpinner(new SpinnerNumberModel(beta2, 0.0, 1.0, 0.1));
        beta2Spinner.setToolTipText(betaSpinner.getToolTipText());
        beta2Panel.add(beta2Label);
        beta2Panel.add(Box.createHorizontalStrut(5));
        beta2Panel.add(beta2Spinner);
        beta2Panel.add(Box.createHorizontalGlue());
        measureOptionsPanel.add(beta2Panel);
        beta2Spinner.setMaximumSize(new Dimension(Integer.MAX_VALUE, Math.round((float)beta2Label.getPreferredSize().height * 1.5f)));
        JPanel bdmFilePanel = new JPanel();
        bdmFilePanel.setLayout(new BoxLayout(bdmFilePanel, 0));
        JLabel bdmFileLabel = new JLabel("BDM file:");
        JButton bdmFileButton = new JButton(new SetBdmFileAction());
        bdmFilePanel.add(bdmFileLabel);
        bdmFilePanel.add(Box.createHorizontalStrut(5));
        bdmFilePanel.add(bdmFileButton);
        bdmFilePanel.add(Box.createHorizontalGlue());
        measureOptionsPanel.add(bdmFilePanel);
        final JPanel measure2OptionsPanel = new JPanel();
        measure2OptionsPanel.setLayout(new BoxLayout(measure2OptionsPanel, 1));
        JPanel verbosePanel = new JPanel();
        verbosePanel.setLayout(new BoxLayout(verbosePanel, 0));
        boolean verbose = this.userConfig.getBoolean(prefix + "verbose") == null ? false : this.userConfig.getBoolean(prefix + "verbose");
        this.verboseOptionCheckBox = new JCheckBox("Output ignored annotations", verbose);
        verbosePanel.add(this.verboseOptionCheckBox);
        verbosePanel.add(Box.createHorizontalGlue());
        measure2OptionsPanel.add(verbosePanel);
        this.optionsButton.setAction(new AbstractAction("Options"){
            int[] selectedIndices;

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton button = (JToggleButton)e.getSource();
                if (button.isSelected()) {
                    if (CorpusQualityAssurance.this.measuresType == 0) {
                        this.selectedIndices = CorpusQualityAssurance.this.measureList.getSelectedIndices();
                        measureScrollPane.setViewportView(measureOptionsPanel);
                    } else if (CorpusQualityAssurance.this.measuresType == 1) {
                        this.selectedIndices = CorpusQualityAssurance.this.measure2List.getSelectedIndices();
                        measure2ScrollPane.setViewportView(measure2OptionsPanel);
                    }
                } else {
                    String prefix = this.getClass().getEnclosingClass().getName() + '.';
                    if (CorpusQualityAssurance.this.measuresType == 0) {
                        String fscore = "F" + betaSpinner.getValue() + "-score ";
                        String fscore2 = "F" + beta2Spinner.getValue() + "-score ";
                        CorpusQualityAssurance.this.measureList.setModel(new ExtendedListModel(new String[]{fscore + "strict", fscore + "lenient", fscore + "average", fscore + "strict BDM", fscore + "lenient BDM", fscore + "average BDM", fscore2 + "strict", fscore2 + "lenient", fscore2 + "average", fscore2 + "strict BDM", fscore2 + "lenient BDM", fscore2 + "average BDM"}));
                        CorpusQualityAssurance.this.userConfig.put((Object)(prefix + "fscorebeta"), betaSpinner.getValue());
                        CorpusQualityAssurance.this.userConfig.put((Object)(prefix + "fscorebeta2"), beta2Spinner.getValue());
                        measureScrollPane.setViewportView(CorpusQualityAssurance.this.measureList);
                        CorpusQualityAssurance.this.measureList.setSelectedIndices(this.selectedIndices);
                    } else if (CorpusQualityAssurance.this.measuresType == 1) {
                        CorpusQualityAssurance.this.userConfig.put((Object)(prefix + "verbose"), (Object)CorpusQualityAssurance.this.verboseOptionCheckBox.isSelected());
                        measure2ScrollPane.setViewportView(CorpusQualityAssurance.this.measure2List);
                        CorpusQualityAssurance.this.measure2List.setSelectedIndices(this.selectedIndices);
                    }
                }
            }
        });
        this.compareAction = new CompareAction();
        JButton compareButton = new JButton(this.compareAction);
        this.compareAction.setEnabled(false);
        sidePanel.add((Component)compareButton, gbc);
        sidePanel.add(Box.createVerticalStrut(5), gbc);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        sidePanel.add((Component)this.progressBar, gbc);
        sidePanel.add(Box.createVerticalStrut(5), gbc);
        this.annotationTable = new XJTable(){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent event) {
                        int index = this.columnModel.getColumnIndexAtX(event.getPoint().x);
                        if (index == -1) {
                            return null;
                        }
                        int modelIndex = this.columnModel.getColumn(index).getModelIndex();
                        String columnName = this.table.getModel().getColumnName(modelIndex);
                        return CorpusQualityAssurance.this.createToolTipFromColumnName(columnName);
                    }
                };
            }
        };
        this.annotationTable.setModel(this.annotationTableModel);
        this.annotationTable.setSortable(false);
        this.annotationTable.setEnableHidingColumns(true);
        this.annotationTable.setAutoResizeMode(4);
        this.documentTable = new XJTable(){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent event) {
                        int index = this.columnModel.getColumnIndexAtX(event.getPoint().x);
                        if (index == -1) {
                            return null;
                        }
                        int modelIndex = this.columnModel.getColumn(index).getModelIndex();
                        String columnName = this.table.getModel().getColumnName(modelIndex);
                        return CorpusQualityAssurance.this.createToolTipFromColumnName(columnName);
                    }
                };
            }
        };
        this.documentTable.setModel(this.documentTableModel);
        this.documentTable.setSortable(false);
        this.documentTable.setEnableHidingColumns(true);
        this.documentTable.setAutoResizeMode(4);
        this.document2Table = new XJTable(){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.document2Table.setModel(this.document2TableModel);
        this.confusionTable = new XJTable(){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.confusionTable.setModel(this.confusionTableModel);
        this.confusionTable.setSortable(false);
        this.tableTabbedPane = new JTabbedPane();
        this.tableTabbedPane.addTab("Corpus statistics", null, new JScrollPane(this.annotationTable), "Compare each annotation type for the whole corpus");
        this.tableTabbedPane.addTab("Document statistics", null, new JScrollPane(this.documentTable), "Compare each documents in the corpus with theirs annotations");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.8);
        splitPane.setLeftComponent(this.tableTabbedPane);
        splitPane.setRightComponent(new JScrollPane(sidePanel));
        this.add(splitPane);
    }

    protected void initListeners() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (!CorpusQualityAssurance.this.isShowing() || !CorpusQualityAssurance.this.corpusChanged) {
                    return;
                }
                if (CorpusQualityAssurance.this.timerTask != null) {
                    CorpusQualityAssurance.this.timerTask.cancel();
                }
                Date timeToRun = new Date(System.currentTimeMillis() + 1000L);
                CorpusQualityAssurance.this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        CorpusQualityAssurance.this.readSetsTypesFeatures(0);
                    }
                };
                CorpusQualityAssurance.this.timer.schedule(CorpusQualityAssurance.this.timerTask, timeToRun);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.setList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CorpusQualityAssurance.this.typesSelected == null) {
                    CorpusQualityAssurance.this.typesSelected = CorpusQualityAssurance.this.typeList.getSelectedValues();
                }
                CorpusQualityAssurance.this.typeList.setModel(new ExtendedListModel());
                CorpusQualityAssurance.this.keySetName = ((ToggleSelectionABModel)CorpusQualityAssurance.this.setList.getSelectionModel()).getSelectedValueA();
                CorpusQualityAssurance.this.responseSetName = ((ToggleSelectionABModel)CorpusQualityAssurance.this.setList.getSelectionModel()).getSelectedValueB();
                if (CorpusQualityAssurance.this.keySetName == null || CorpusQualityAssurance.this.responseSetName == null || CorpusQualityAssurance.this.setList.getSelectionModel().getValueIsAdjusting()) {
                    CorpusQualityAssurance.this.compareAction.setEnabled(false);
                    return;
                }
                CorpusQualityAssurance.this.setList.setEnabled(false);
                CorpusQualityAssurance.this.setCheck.setEnabled(false);
                TreeSet<String> someTypes = new TreeSet<String>();
                boolean firstLoop = true;
                Object[] objectArray = CorpusQualityAssurance.this.docsSetsTypesFeatures;
                synchronized (CorpusQualityAssurance.this.docsSetsTypesFeatures) {
                    for (TreeMap<String, TreeMap<String, TreeSet<String>>> setsTypesFeatures : CorpusQualityAssurance.this.docsSetsTypesFeatures.values()) {
                        TreeMap<String, TreeSet<String>> typesFeatures = setsTypesFeatures.get(CorpusQualityAssurance.this.keySetName.equals("[Default set]") ? "" : CorpusQualityAssurance.this.keySetName);
                        if (typesFeatures != null) {
                            if (CorpusQualityAssurance.this.typeCheck.isSelected() && !firstLoop) {
                                someTypes.retainAll(typesFeatures.keySet());
                            } else {
                                someTypes.addAll(typesFeatures.keySet());
                            }
                        } else if (CorpusQualityAssurance.this.typeCheck.isSelected()) break;
                        typesFeatures = setsTypesFeatures.get(CorpusQualityAssurance.this.responseSetName.equals("[Default set]") ? "" : CorpusQualityAssurance.this.responseSetName);
                        if (typesFeatures != null) {
                            if (CorpusQualityAssurance.this.typeCheck.isSelected()) {
                                someTypes.retainAll(typesFeatures.keySet());
                            } else {
                                someTypes.addAll(typesFeatures.keySet());
                            }
                        } else if (CorpusQualityAssurance.this.typeCheck.isSelected()) break;
                        firstLoop = false;
                    }
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    CorpusQualityAssurance.this.typeList.setModel(new ExtendedListModel(someTypes.toArray()));
                    if (someTypes.size() > 0) {
                        for (Object value : CorpusQualityAssurance.this.typesSelected) {
                            int index = CorpusQualityAssurance.this.typeList.getNextMatch((String)value, 0, Position.Bias.Forward);
                            if (index == -1) continue;
                            CorpusQualityAssurance.this.typeList.setSelectedIndex(index);
                        }
                    }
                    CorpusQualityAssurance.this.typesSelected = null;
                    CorpusQualityAssurance.this.setList.setEnabled(true);
                    CorpusQualityAssurance.this.setCheck.setEnabled(true);
                    if (CorpusQualityAssurance.this.measuresType == 0) {
                        CorpusQualityAssurance.this.compareAction.setEnabled(true);
                    }
                    return;
                }
            }
        });
        this.typeList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CorpusQualityAssurance.this.featuresSelected == null) {
                    CorpusQualityAssurance.this.featuresSelected = CorpusQualityAssurance.this.featureList.getSelectedValues();
                }
                CorpusQualityAssurance.this.featureList.setModel(new ExtendedListModel());
                if (CorpusQualityAssurance.this.typeList.getSelectedValues().length == 0 || CorpusQualityAssurance.this.typeList.getSelectionModel().getValueIsAdjusting()) {
                    return;
                }
                HashSet<String> typeNames = new HashSet<String>();
                for (Object type : CorpusQualityAssurance.this.typeList.getSelectedValues()) {
                    typeNames.add((String)type);
                }
                CorpusQualityAssurance.this.typeList.setEnabled(false);
                CorpusQualityAssurance.this.typeCheck.setEnabled(false);
                TreeSet<Object> features = new TreeSet<Object>(CorpusQualityAssurance.this.collator);
                boolean firstLoop = true;
                Object[] objectArray = CorpusQualityAssurance.this.docsSetsTypesFeatures;
                synchronized (CorpusQualityAssurance.this.docsSetsTypesFeatures) {
                    for (TreeMap<String, TreeMap<String, TreeSet<String>>> sets : CorpusQualityAssurance.this.docsSetsTypesFeatures.values()) {
                        TreeMap<String, TreeSet<String>> typesFeatures = sets.get(CorpusQualityAssurance.this.keySetName.equals("[Default set]") ? "" : CorpusQualityAssurance.this.keySetName);
                        if (typesFeatures != null) {
                            for (String typeName : typesFeatures.keySet()) {
                                if (!typeNames.contains(typeName)) continue;
                                if (CorpusQualityAssurance.this.featureCheck.isSelected() && !firstLoop) {
                                    features.retainAll((Collection)typesFeatures.get(typeName));
                                    continue;
                                }
                                features.addAll((Collection<Object>)typesFeatures.get(typeName));
                            }
                        } else if (CorpusQualityAssurance.this.featureCheck.isSelected()) break;
                        if ((typesFeatures = sets.get(CorpusQualityAssurance.this.responseSetName.equals("[Default set]") ? "" : CorpusQualityAssurance.this.responseSetName)) != null) {
                            for (String typeName : typesFeatures.keySet()) {
                                if (!typeNames.contains(typeName)) continue;
                                if (CorpusQualityAssurance.this.featureCheck.isSelected()) {
                                    features.retainAll((Collection)typesFeatures.get(typeName));
                                    continue;
                                }
                                features.addAll((Collection<Object>)typesFeatures.get(typeName));
                            }
                        } else if (CorpusQualityAssurance.this.featureCheck.isSelected()) break;
                        firstLoop = false;
                    }
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    CorpusQualityAssurance.this.featureList.setModel(new ExtendedListModel(features.toArray()));
                    if (features.size() > 0) {
                        for (Object value : CorpusQualityAssurance.this.featuresSelected) {
                            int index = CorpusQualityAssurance.this.featureList.getNextMatch((String)value, 0, Position.Bias.Forward);
                            if (index == -1) continue;
                            CorpusQualityAssurance.this.featureList.setSelectedIndex(index);
                        }
                    }
                    CorpusQualityAssurance.this.featuresSelected = null;
                    CorpusQualityAssurance.this.typeList.setEnabled(true);
                    CorpusQualityAssurance.this.typeCheck.setEnabled(true);
                    return;
                }
            }
        });
        this.featureList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CorpusQualityAssurance.this.measuresType == 1) {
                    if (CorpusQualityAssurance.this.typeList.getSelectedIndices().length == 1 && CorpusQualityAssurance.this.featureList.getSelectedIndices().length == 1) {
                        CorpusQualityAssurance.this.compareAction.setEnabled(true);
                        CorpusQualityAssurance.this.compareAction.putValue("ShortDescription", "Compare annotations between sets A and B");
                    } else {
                        CorpusQualityAssurance.this.compareAction.setEnabled(false);
                        CorpusQualityAssurance.this.compareAction.putValue("ShortDescription", "You must select exactly one type and one feature");
                    }
                }
            }
        });
        this.measureTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                int selectedTab = tabbedPane.getSelectedIndex();
                CorpusQualityAssurance.this.tableTabbedPane.removeAll();
                CorpusQualityAssurance.this.openDocumentAction.setEnabled(false);
                CorpusQualityAssurance.this.openAnnotationDiffAction.setEnabled(false);
                if (CorpusQualityAssurance.this.optionsButton.isSelected()) {
                    CorpusQualityAssurance.this.optionsButton.doClick();
                }
                if (tabbedPane.getTitleAt(selectedTab).equals("F-Score")) {
                    CorpusQualityAssurance.this.measuresType = 0;
                    CorpusQualityAssurance.this.compareAction.setEnabled(CorpusQualityAssurance.this.keySetName != null && CorpusQualityAssurance.this.responseSetName != null);
                    CorpusQualityAssurance.this.compareAction.putValue("ShortDescription", "Compare annotations between sets A and B");
                    CorpusQualityAssurance.this.tableTabbedPane.addTab("Corpus statistics", null, new JScrollPane(CorpusQualityAssurance.this.annotationTable), "Compare each annotation type for the whole corpus");
                    CorpusQualityAssurance.this.tableTabbedPane.addTab("Document statistics", null, new JScrollPane(CorpusQualityAssurance.this.documentTable), "Compare each documents in the corpus with theirs annotations");
                } else {
                    CorpusQualityAssurance.this.measuresType = 1;
                    CorpusQualityAssurance.this.featureList.getListSelectionListeners()[0].valueChanged(null);
                    CorpusQualityAssurance.this.tableTabbedPane.addTab("Document statistics", null, new JScrollPane(CorpusQualityAssurance.this.document2Table), "Compare each documents in the corpus with theirs annotations");
                    CorpusQualityAssurance.this.tableTabbedPane.addTab("Confusion Matrices", null, new JScrollPane(CorpusQualityAssurance.this.confusionTable), "Describe how annotations in one set are classified in the other and vice versa.");
                }
            }
        });
        this.documentTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean enabled = CorpusQualityAssurance.this.documentTable.getSelectedRow() != -1 && !((String)CorpusQualityAssurance.this.documentTableModel.getValueAt(CorpusQualityAssurance.this.documentTable.getSelectedRow(), 0)).endsWith("summary");
                CorpusQualityAssurance.this.openDocumentAction.setEnabled(enabled);
                CorpusQualityAssurance.this.openAnnotationDiffAction.setEnabled(enabled);
            }
        });
        this.document2Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean enabled = CorpusQualityAssurance.this.document2Table.getSelectedRow() != -1 && !((String)CorpusQualityAssurance.this.document2TableModel.getValueAt(CorpusQualityAssurance.this.document2Table.getSelectedRow(), 0)).endsWith("summary");
                CorpusQualityAssurance.this.openDocumentAction.setEnabled(enabled);
                CorpusQualityAssurance.this.openAnnotationDiffAction.setEnabled(enabled);
            }
        });
        this.documentTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getClickCount() == 2 && CorpusQualityAssurance.this.openDocumentAction.isEnabled()) {
                    CorpusQualityAssurance.this.openDocumentAction.actionPerformed(null);
                }
            }
        });
        this.document2Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getClickCount() == 2 && CorpusQualityAssurance.this.openDocumentAction.isEnabled()) {
                    CorpusQualityAssurance.this.openDocumentAction.actionPerformed(null);
                }
            }
        });
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("F1"), "help");
        actionMap.put("help", new HelpAction());
    }

    protected String createToolTipFromColumnName(String columnName) {
        String tooltip = columnName.equals("Document") || columnName.equals("Annotation") ? null : (columnName.equals("Match") ? "aka Correct" : (columnName.equals("Only A") ? "aka Missing" : (columnName.equals("Only B") ? "aka Spurious" : (columnName.equals("Overlap") ? "aka Partial" : (columnName.equals("Rec.B/A") ? "Recall for B relative to A" : (columnName.equals("Prec.B/A") ? "Precision for B relative to A" : columnName.replaceFirst("s.", "score strict").replaceFirst("l.", "score lenient").replaceFirst("a.", "score average").replaceFirst("B.", " BDM")))))));
        return tooltip;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.corpus = null;
    }

    @Override
    public void setTarget(Object target) {
        if (this.corpus != null && this.corpus != target) {
            this.corpus.removeCorpusListener(this);
        }
        if (!(target instanceof Corpus)) {
            throw new IllegalArgumentException("This view can only be used with a GATE corpus!\n" + target.getClass().toString() + " is not a GATE corpus!");
        }
        this.corpus = (Corpus)target;
        this.corpus.addCorpusListener(this);
        this.corpusChanged = true;
        if (!this.isShowing()) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        Date timeToRun = new Date(System.currentTimeMillis() + 2000L);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                CorpusQualityAssurance.this.readSetsTypesFeatures(0);
            }
        };
        this.timer.schedule(this.timerTask, timeToRun);
    }

    @Override
    public void documentAdded(CorpusEvent e) {
        this.corpusChanged = true;
        if (!this.isShowing()) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        Date timeToRun = new Date(System.currentTimeMillis() + 2000L);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                CorpusQualityAssurance.this.readSetsTypesFeatures(0);
            }
        };
        this.timer.schedule(this.timerTask, timeToRun);
    }

    @Override
    public void documentRemoved(CorpusEvent e) {
        this.corpusChanged = true;
        if (!this.isShowing()) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        Date timeToRun = new Date(System.currentTimeMillis() + 2000L);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                CorpusQualityAssurance.this.readSetsTypesFeatures(0);
            }
        };
        this.timer.schedule(this.timerTask, timeToRun);
    }

    protected void readSetsTypesFeatures(final int documentStart) {
        if (!this.isShowing()) {
            return;
        }
        this.corpusChanged = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CorpusQualityAssurance.this.progressBar.setMaximum(CorpusQualityAssurance.this.corpus.size() - 1);
                CorpusQualityAssurance.this.progressBar.setString("Read sets, types, features");
                CorpusQualityAssurance.this.reloadCacheAction.setEnabled(false);
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(3));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (CorpusQualityAssurance.this.docsSetsTypesFeatures.size() != CorpusQualityAssurance.this.corpus.getDocumentNames().size() || !CorpusQualityAssurance.this.docsSetsTypesFeatures.keySet().containsAll(CorpusQualityAssurance.this.corpus.getDocumentNames())) {
                    if (documentStart == 0) {
                        CorpusQualityAssurance.this.docsSetsTypesFeatures.clear();
                    }
                    for (int i = documentStart; i < CorpusQualityAssurance.this.corpus.size(); ++i) {
                        boolean documentWasLoaded = CorpusQualityAssurance.this.corpus.isDocumentLoaded(i);
                        Document document = (Document)CorpusQualityAssurance.this.corpus.get(i);
                        if (document != null && document.getAnnotationSetNames() != null) {
                            TreeMap setsTypesFeatures = new TreeMap(CorpusQualityAssurance.this.collator);
                            HashSet<String> setNames = new HashSet<String>(document.getAnnotationSetNames());
                            setNames.add("");
                            for (String set : setNames) {
                                TreeMap<Object, TreeSet<Object>> typesFeatures = new TreeMap<Object, TreeSet<Object>>(CorpusQualityAssurance.this.collator);
                                AnnotationSet annotations = document.getAnnotations(set);
                                for (String type : annotations.getAllTypes()) {
                                    TreeSet<Object> features = new TreeSet<Object>(CorpusQualityAssurance.this.collator);
                                    for (Annotation annotation : annotations.get(type)) {
                                        for (Object featureKey : annotation.getFeatures().keySet()) {
                                            features.add((String)featureKey);
                                        }
                                    }
                                    typesFeatures.put(type, features);
                                }
                                setsTypesFeatures.put(set, typesFeatures);
                            }
                            CorpusQualityAssurance.this.docsSetsTypesFeatures.put(document.getName(), setsTypesFeatures);
                        }
                        if (!documentWasLoaded) {
                            CorpusQualityAssurance.this.corpus.unloadDocument(document);
                            Factory.deleteResource(document);
                        }
                        final int progressValue = i + 1;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CorpusQualityAssurance.this.progressBar.setValue(progressValue);
                                if ((progressValue + 1) % 5 == 0) {
                                    CorpusQualityAssurance.this.updateSetList();
                                }
                            }
                        });
                        if (!Thread.interrupted()) continue;
                        return;
                    }
                }
                CorpusQualityAssurance.this.updateSetList();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CorpusQualityAssurance.this.progressBar.setValue(CorpusQualityAssurance.this.progressBar.getMinimum());
                        CorpusQualityAssurance.this.progressBar.setString("");
                        CorpusQualityAssurance.this.setCursor(Cursor.getPredefinedCursor(0));
                        CorpusQualityAssurance.this.reloadCacheAction.setEnabled(true);
                    }
                });
            }
        };
        this.readSetsTypesFeaturesThread = new Thread(runnable, "readSetsTypesFeatures");
        this.readSetsTypesFeaturesThread.setPriority(1);
        this.readSetsTypesFeaturesThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSetList() {
        final TreeSet<Object> setsNames = new TreeSet<Object>(this.collator);
        boolean firstLoop = true;
        Map<String, TreeMap<String, TreeMap<String, TreeSet<String>>>> map = this.docsSetsTypesFeatures;
        synchronized (map) {
            for (String document : this.docsSetsTypesFeatures.keySet()) {
                Set<String> sets = this.docsSetsTypesFeatures.get(document).keySet();
                if (!sets.isEmpty()) {
                    if (this.setCheck.isSelected() && !firstLoop) {
                        setsNames.retainAll(sets);
                    } else {
                        setsNames.addAll(sets);
                    }
                } else if (this.setCheck.isSelected()) break;
                firstLoop = false;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                setsNames.remove("");
                setsNames.add("[Default set]");
                String keySetNamePrevious = CorpusQualityAssurance.this.keySetName;
                String responseSetNamePrevious = CorpusQualityAssurance.this.responseSetName;
                CorpusQualityAssurance.this.setList.setModel(new ExtendedListModel(setsNames.toArray()));
                if (setsNames.size() > 0) {
                    int index;
                    if (keySetNamePrevious != null && (index = CorpusQualityAssurance.this.setList.getNextMatch(keySetNamePrevious, 0, Position.Bias.Forward)) != -1) {
                        CorpusQualityAssurance.this.setList.setSelectedIndex(index);
                    }
                    if (responseSetNamePrevious != null && (index = CorpusQualityAssurance.this.setList.getNextMatch(responseSetNamePrevious, 0, Position.Bias.Forward)) != -1) {
                        CorpusQualityAssurance.this.setList.setSelectedIndex(index);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void compareAnnotation() {
        int progressValuePrevious = -1;
        if (this.readSetsTypesFeaturesThread != null && this.readSetsTypesFeaturesThread.isAlive()) {
            progressValuePrevious = this.progressBar.getValue();
            this.readSetsTypesFeaturesThread.interrupt();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CorpusQualityAssurance.this.progressBar.setMaximum(CorpusQualityAssurance.this.corpus.size() - 1);
                CorpusQualityAssurance.this.progressBar.setString("Compare annotations");
                CorpusQualityAssurance.this.setList.setEnabled(false);
                CorpusQualityAssurance.this.setCheck.setEnabled(false);
                CorpusQualityAssurance.this.typeList.setEnabled(false);
                CorpusQualityAssurance.this.typeCheck.setEnabled(false);
                CorpusQualityAssurance.this.featureList.setEnabled(false);
                CorpusQualityAssurance.this.featureCheck.setEnabled(false);
                CorpusQualityAssurance.this.optionsButton.setEnabled(false);
                CorpusQualityAssurance.this.measureTabbedPane.setEnabled(false);
                CorpusQualityAssurance.this.measureList.setEnabled(false);
                CorpusQualityAssurance.this.exportToHtmlAction.setEnabled(false);
                CorpusQualityAssurance.this.reloadCacheAction.setEnabled(false);
            }
        });
        boolean useBdm = false;
        if (this.measuresType == 0) {
            this.differsByDocThenType.clear();
            this.documentNames.clear();
            for (Object measure : this.measureList.getSelectedValues()) {
                if (!((String)measure).contains("BDM")) continue;
                useBdm = true;
                break;
            }
        }
        ArrayList<ClassificationMeasures> classificationMeasuresList = new ArrayList<ClassificationMeasures>();
        ArrayList<OntologyMeasures> documentOntologyMeasuresList = new ArrayList<OntologyMeasures>();
        ArrayList<OntologyMeasures> annotationOntologyMeasuresList = new ArrayList<OntologyMeasures>();
        for (int row = 0; row < this.corpus.size(); ++row) {
            void var10_26;
            boolean documentWasLoaded = this.corpus.isDocumentLoaded(row);
            Document document = (Document)this.corpus.get(row);
            this.documentNames.add(document.getName());
            Object keys = new HashSet();
            HashSet hashSet = new HashSet();
            if (this.keySetName.equals("[Default set]")) {
                keys = document.getAnnotations();
            } else if (document.getAnnotationSetNames() != null && document.getAnnotationSetNames().contains(this.keySetName)) {
                keys = document.getAnnotations(this.keySetName);
            }
            if (this.responseSetName.equals("[Default set]")) {
                AnnotationSet annotationSet = document.getAnnotations();
            } else if (document.getAnnotationSetNames() != null && document.getAnnotationSetNames().contains(this.responseSetName)) {
                AnnotationSet annotationSet = document.getAnnotations(this.responseSetName);
            }
            if (!documentWasLoaded) {
                this.corpus.unloadDocument(document);
                Factory.deleteResource(document);
            }
            if (this.measuresType == 0) {
                List<String> measuresRow;
                this.types.clear();
                for (Object type : this.typeList.getSelectedValues()) {
                    this.types.add((String)type);
                }
                if (this.typeList.isSelectionEmpty()) {
                    for (int i = 0; i < this.typeList.getModel().getSize(); ++i) {
                        this.types.add((String)this.typeList.getModel().getElementAt(i));
                    }
                }
                HashSet<String> featureSet = new HashSet<String>();
                for (Object feature : this.featureList.getSelectedValues()) {
                    featureSet.add((String)feature);
                }
                HashMap<String, AnnotationDiffer> differsByType = new HashMap<String, AnnotationDiffer>();
                HashSet<Annotation> keysIter = new HashSet();
                HashSet<Annotation> responsesIter = new HashSet();
                for (String type : this.types) {
                    if (!keys.isEmpty() && !this.types.isEmpty()) {
                        keysIter = ((AnnotationSet)keys).get(type);
                    }
                    if (!var10_26.isEmpty() && !this.types.isEmpty()) {
                        responsesIter = ((AnnotationSet)var10_26).get(type);
                    }
                    AnnotationDiffer differ = new AnnotationDiffer();
                    differ.setSignificantFeaturesSet(featureSet);
                    differ.calculateDiff(keysIter, responsesIter);
                    differsByType.put(type, differ);
                }
                this.differsByDocThenType.add(differsByType);
                AnnotationDiffer differ = new AnnotationDiffer(differsByType.values());
                if (useBdm) {
                    OntologyMeasures ontologyMeasures = new OntologyMeasures();
                    ontologyMeasures.setBdmFile(this.bdmFileUrl);
                    ontologyMeasures.calculateBdm(differsByType.values());
                    documentOntologyMeasuresList.add(ontologyMeasures);
                    measuresRow = ontologyMeasures.getMeasuresRow(this.measureList.getSelectedValues(), this.documentNames.get(this.documentNames.size() - 1));
                } else {
                    measuresRow = differ.getMeasuresRow(this.measureList.getSelectedValues(), this.documentNames.get(this.documentNames.size() - 1));
                }
                this.documentTableModel.addRow(measuresRow.toArray());
            } else if (this.measuresType == 1 && !keys.isEmpty() && !var10_26.isEmpty()) {
                ClassificationMeasures classificationMeasures = new ClassificationMeasures();
                classificationMeasures.calculateConfusionMatrix((AnnotationSet)keys, (AnnotationSet)var10_26, (String)this.typeList.getSelectedValue(), (String)this.featureList.getSelectedValue(), this.verboseOptionCheckBox.isSelected());
                classificationMeasuresList.add(classificationMeasures);
                List<String> measuresRow = classificationMeasures.getMeasuresRow(this.measure2List.getSelectedValues(), this.documentNames.get(this.documentNames.size() - 1));
                this.document2TableModel.addRow(measuresRow.toArray());
                List<List<String>> matrix = classificationMeasures.getConfusionMatrix(this.documentNames.get(this.documentNames.size() - 1));
                for (List<String> matrixRow : matrix) {
                    while (this.confusionTableModel.getColumnCount() < matrix.size()) {
                        this.confusionTableModel.addColumn(" ");
                    }
                    this.confusionTableModel.addRow(matrixRow.toArray());
                }
            }
            final int progressValue = row + 1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CorpusQualityAssurance.this.progressBar.setValue(progressValue);
                }
            });
        }
        if (this.measuresType == 0) {
            for (String type : this.types) {
                List<String> measuresRow;
                ArrayList<AnnotationDiffer> arrayList = new ArrayList<AnnotationDiffer>();
                for (HashMap hashMap : this.differsByDocThenType) {
                    arrayList.add((AnnotationDiffer)hashMap.get(type));
                }
                if (useBdm) {
                    OntologyMeasures ontologyMeasures = new OntologyMeasures();
                    ontologyMeasures.setBdmFile(this.bdmFileUrl);
                    ontologyMeasures.calculateBdm(arrayList);
                    annotationOntologyMeasuresList.add(ontologyMeasures);
                    measuresRow = ontologyMeasures.getMeasuresRow(this.measureList.getSelectedValues(), type);
                } else {
                    AnnotationDiffer annotationDiffer = new AnnotationDiffer(arrayList);
                    measuresRow = annotationDiffer.getMeasuresRow(this.measureList.getSelectedValues(), type);
                }
                this.annotationTableModel.addRow(measuresRow.toArray());
            }
        }
        if (this.measuresType == 0) {
            if (useBdm) {
                OntologyMeasures ontologyMeasures = new OntologyMeasures(documentOntologyMeasuresList);
                this.printSummary(ontologyMeasures, this.documentTableModel, 5, this.documentTableModel.getRowCount(), this.measureList.getSelectedValues());
                ontologyMeasures = new OntologyMeasures(annotationOntologyMeasuresList);
                this.printSummary(ontologyMeasures, this.annotationTableModel, 5, this.annotationTableModel.getRowCount(), this.measureList.getSelectedValues());
            } else {
                ArrayList<AnnotationDiffer> differs = new ArrayList<AnnotationDiffer>();
                for (Map map : this.differsByDocThenType) {
                    differs.addAll(map.values());
                }
                AnnotationDiffer differ = new AnnotationDiffer(differs);
                this.printSummary(differ, this.documentTableModel, 5, this.documentTableModel.getRowCount(), this.measureList.getSelectedValues());
                this.printSummary(differ, this.annotationTableModel, 5, this.annotationTableModel.getRowCount(), this.measureList.getSelectedValues());
            }
        } else if (this.measuresType == 1) {
            ClassificationMeasures classificationMeasures = new ClassificationMeasures(classificationMeasuresList);
            this.printSummary(classificationMeasures, this.document2TableModel, 3, this.document2TableModel.getRowCount(), this.measure2List.getSelectedValues());
            List<List<String>> matrix = classificationMeasures.getConfusionMatrix("Whole corpus");
            boolean bl = false;
            for (List<String> list : matrix) {
                void var8_24;
                while (this.confusionTableModel.getColumnCount() < matrix.size()) {
                    this.confusionTableModel.addColumn(" ");
                }
                this.confusionTableModel.insertRow((int)(++var8_24), list.toArray());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CorpusQualityAssurance.this.progressBar.setValue(CorpusQualityAssurance.this.progressBar.getMinimum());
                CorpusQualityAssurance.this.progressBar.setString("");
                CorpusQualityAssurance.this.setList.setEnabled(true);
                CorpusQualityAssurance.this.setCheck.setEnabled(true);
                CorpusQualityAssurance.this.typeList.setEnabled(true);
                CorpusQualityAssurance.this.typeCheck.setEnabled(true);
                CorpusQualityAssurance.this.featureList.setEnabled(true);
                CorpusQualityAssurance.this.featureCheck.setEnabled(true);
                CorpusQualityAssurance.this.optionsButton.setEnabled(true);
                CorpusQualityAssurance.this.measureTabbedPane.setEnabled(true);
                CorpusQualityAssurance.this.measureList.setEnabled(true);
                CorpusQualityAssurance.this.exportToHtmlAction.setEnabled(true);
                CorpusQualityAssurance.this.reloadCacheAction.setEnabled(true);
            }
        });
        if (progressValuePrevious > -1) {
            this.readSetsTypesFeatures(progressValuePrevious);
        }
    }

    protected void printSummary(Object measureObject, DefaultTableModel tableModel, int columnGroupSize, int insertionRow, Object[] measures) {
        int row;
        int col;
        AnnotationDiffer differ = null;
        ClassificationMeasures classificationMeasures = null;
        OntologyMeasures ontologyMeasures = null;
        if (measureObject instanceof AnnotationDiffer) {
            differ = (AnnotationDiffer)measureObject;
        } else if (measureObject instanceof ClassificationMeasures) {
            classificationMeasures = (ClassificationMeasures)measureObject;
        } else if (measureObject instanceof OntologyMeasures) {
            ontologyMeasures = (OntologyMeasures)measureObject;
        }
        NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);
        f.setMaximumFractionDigits(4);
        f.setMinimumFractionDigits(4);
        f.setRoundingMode(RoundingMode.HALF_UP);
        ArrayList<String> values = new ArrayList<String>();
        values.add("Macro summary");
        for (col = 1; col < tableModel.getColumnCount(); ++col) {
            if (col < columnGroupSize) {
                values.add("");
                continue;
            }
            float sumF = 0.0f;
            for (row = 0; row < tableModel.getRowCount(); ++row) {
                try {
                    sumF += Float.parseFloat((String)tableModel.getValueAt(row, col));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            values.add(f.format(sumF / (float)tableModel.getRowCount()));
        }
        tableModel.insertRow(insertionRow, values.toArray());
        values.clear();
        values.add("Micro summary");
        for (col = 1; col < columnGroupSize; ++col) {
            int sum = 0;
            for (row = 0; row < tableModel.getRowCount() - 1; ++row) {
                try {
                    sum += Integer.parseInt((String)tableModel.getValueAt(row, col));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            values.add(Integer.toString(sum));
        }
        if (measureObject instanceof OntologyMeasures) {
            ArrayList<AnnotationDiffer> differs = new ArrayList<AnnotationDiffer>(ontologyMeasures.getDifferByTypeMap().values());
            differ = new AnnotationDiffer(differs);
        }
        for (Object object : measures) {
            float result;
            double beta;
            String measure = (String)object;
            int index = measure.indexOf(45);
            double d = beta = index == -1 ? 1.0 : Double.valueOf(measure.substring(1, index));
            if (measure.endsWith("strict")) {
                values.add(f.format(differ.getPrecisionStrict()));
                values.add(f.format(differ.getRecallStrict()));
                values.add(f.format(differ.getFMeasureStrict(beta)));
                continue;
            }
            if (measure.endsWith("strict BDM")) {
                values.add(f.format(ontologyMeasures.getPrecisionStrictBdm()));
                values.add(f.format(ontologyMeasures.getRecallStrictBdm()));
                values.add(f.format(ontologyMeasures.getFMeasureStrictBdm(beta)));
                continue;
            }
            if (measure.endsWith("lenient")) {
                values.add(f.format(differ.getPrecisionLenient()));
                values.add(f.format(differ.getRecallLenient()));
                values.add(f.format(differ.getFMeasureLenient(beta)));
                continue;
            }
            if (measure.endsWith("lenient BDM")) {
                values.add(f.format(ontologyMeasures.getPrecisionLenientBdm()));
                values.add(f.format(ontologyMeasures.getRecallLenientBdm()));
                values.add(f.format(ontologyMeasures.getFMeasureLenientBdm(beta)));
                continue;
            }
            if (measure.endsWith("average")) {
                values.add(f.format(differ.getPrecisionAverage()));
                values.add(f.format(differ.getRecallAverage()));
                values.add(f.format(differ.getFMeasureAverage(beta)));
                continue;
            }
            if (measure.endsWith("average BDM")) {
                values.add(f.format(ontologyMeasures.getPrecisionAverageBdm()));
                values.add(f.format(ontologyMeasures.getRecallAverageBdm()));
                values.add(f.format(ontologyMeasures.getFMeasureAverageBdm(beta)));
                continue;
            }
            if (measure.equals("Observed agreement")) {
                values.add(f.format(classificationMeasures.getObservedAgreement()));
                continue;
            }
            if (measure.equals("Cohen's Kappa")) {
                result = classificationMeasures.getKappaCohen();
                values.add(Float.isNaN(result) ? "" : f.format(result));
                continue;
            }
            if (!measure.equals("Pi's Kappa")) continue;
            result = classificationMeasures.getKappaPi();
            values.add(Float.isNaN(result) ? "" : f.format(result));
        }
        tableModel.insertRow(insertionRow + 1, values.toArray());
    }

    protected class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", "User guide for this tool");
            this.putValue("SmallIcon", new HelpIcon(MainFrame.ICON_DIMENSION));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.putValue("SmallIcon", new HelpIcon(MainFrame.ICON_DIMENSION, !enabled));
            super.setEnabled(enabled);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().showHelpFrame("sec:eval:corpusqualityassurance", CorpusQualityAssurance.class.getName());
        }
    }

    class ReloadCacheAction
    extends AbstractAction {
        public ReloadCacheAction() {
            super("Reload cache", new RefreshIcon(MainFrame.ICON_DIMENSION));
            this.putValue("ShortDescription", "Reload cache for set, type and feature names list");
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.putValue("SmallIcon", new RefreshIcon(MainFrame.ICON_DIMENSION, !enabled));
            super.setEnabled(enabled);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CorpusQualityAssurance.this.docsSetsTypesFeatures.clear();
            CorpusQualityAssurance.this.readSetsTypesFeatures(0);
        }
    }

    protected class ExportToHtmlAction
    extends AbstractAction {
        final String nl;
        static final String BEGINHTML = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>";
        static final String ENDHTML = "</body></html>";
        static final String BEGINHEAD = "<head><meta content=\"text/html; charset=utf-8\" http-equiv=\"content-type\"><title>";
        static final String ENDHEAD = "</title></head><body>";
        static final String BEGINTABLE = "<table cellpadding=\"0\" border=\"1\">";
        static final String ENDTABLE = "</table>";

        public ExportToHtmlAction() {
            super("Export to HTML");
            this.nl = Strings.getNl();
            this.putValue("ShortDescription", "Export the tables to HTML");
            this.putValue("SmallIcon", new DownloadIcon(MainFrame.ICON_DIMENSION));
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.putValue("SmallIcon", new DownloadIcon(MainFrame.ICON_DIMENSION, !enabled));
            super.setEnabled(enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            XJFileChooser fileChooser = MainFrame.getFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(true);
            fileChooser.setDialogTitle("Choose a file where to export the tables");
            fileChooser.setFileSelectionMode(0);
            ExtensionFileFilter filter = new ExtensionFileFilter("HTML files", "html");
            fileChooser.addChoosableFileFilter(filter);
            String title = CorpusQualityAssurance.this.corpus.getName();
            title = title + "_" + CorpusQualityAssurance.this.keySetName;
            title = title + "-" + CorpusQualityAssurance.this.responseSetName;
            fileChooser.setFileName(title + ".html");
            fileChooser.setResource(CorpusQualityAssurance.class.getName());
            int res = fileChooser.showSaveDialog(CorpusQualityAssurance.this);
            if (res != 0) {
                return;
            }
            File saveFile = fileChooser.getSelectedFile();
            Writer fw = null;
            try {
                fw = new BufferedWriter(new FileWriter(saveFile));
                fw.write(BEGINHTML + this.nl);
                fw.write(BEGINHEAD);
                fw.write(title);
                fw.write(ENDHEAD + this.nl);
                fw.write("<H1>Corpus Quality Assurance</H1>" + this.nl);
                fw.write("<P>Corpus: " + CorpusQualityAssurance.this.corpus.getName() + "<BR>" + this.nl);
                fw.write("Key set: " + CorpusQualityAssurance.this.keySetName + "<BR>" + this.nl);
                fw.write("Response set: " + CorpusQualityAssurance.this.responseSetName + "<BR>" + this.nl);
                fw.write("Types: " + Strings.toString(CorpusQualityAssurance.this.typeList.getSelectedValues()) + "<BR>" + this.nl);
                fw.write("Features: " + Strings.toString(CorpusQualityAssurance.this.featureList.getSelectedValues()) + "</P>" + this.nl);
                fw.write("<P>&nbsp;</P>" + this.nl);
                ArrayList<XJTable> tablesToExport = new ArrayList<XJTable>();
                tablesToExport.add(CorpusQualityAssurance.this.annotationTable);
                tablesToExport.add(CorpusQualityAssurance.this.documentTable);
                tablesToExport.add(CorpusQualityAssurance.this.document2Table);
                tablesToExport.add(CorpusQualityAssurance.this.confusionTable);
                for (JTable jTable : tablesToExport) {
                    fw.write(BEGINTABLE + this.nl + "<TR>" + this.nl);
                    for (int col = 0; col < jTable.getColumnCount(); ++col) {
                        fw.write("<TH align=\"left\">" + jTable.getColumnName(col) + "</TH>" + this.nl);
                    }
                    fw.write("</TR>" + this.nl);
                    for (int row = 0; row < jTable.getRowCount(); ++row) {
                        fw.write("<TR>" + this.nl);
                        for (int col = 0; col < jTable.getColumnCount(); ++col) {
                            String value = (String)jTable.getValueAt(row, col);
                            if (value == null) {
                                value = "";
                            }
                            fw.write("<TD>" + value + "</TD>" + this.nl);
                        }
                        fw.write("</TR>" + this.nl);
                    }
                    fw.write(ENDTABLE + this.nl);
                    fw.write("<P>&nbsp;</P>" + this.nl);
                }
                fw.write(ENDHTML + this.nl);
                fw.flush();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(CorpusQualityAssurance.this, ioe.toString(), "GATE", 0);
                ioe.printStackTrace();
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class OpenAnnotationDiffAction
    extends AbstractAction {
        public OpenAnnotationDiffAction() {
            super("Open annotation diff", new AnnotationDiffIcon(MainFrame.ICON_DIMENSION));
            this.putValue("ShortDescription", "Opens annotation diff for the selected row in the document table");
            this.putValue("MnemonicKey", 39);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.putValue("SmallIcon", new AnnotationDiffIcon(MainFrame.ICON_DIMENSION, !enabled));
            super.setEnabled(enabled);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Document document = (Document)CorpusQualityAssurance.this.corpus.get(CorpusQualityAssurance.this.measuresType == 0 ? CorpusQualityAssurance.this.documentTable.rowViewToModel(CorpusQualityAssurance.this.documentTable.getSelectedRow()) : CorpusQualityAssurance.this.document2Table.rowViewToModel(CorpusQualityAssurance.this.document2Table.getSelectedRow()));
            String documentName = document.getName();
            String annotationType = (String)CorpusQualityAssurance.this.typeList.getSelectedValue();
            HashSet<String> featureSet = new HashSet<String>();
            for (Object feature : CorpusQualityAssurance.this.featureList.getSelectedValues()) {
                featureSet.add((String)feature);
            }
            AnnotationDiffGUI frame = new AnnotationDiffGUI("Annotation Difference", documentName, documentName, CorpusQualityAssurance.this.keySetName, CorpusQualityAssurance.this.responseSetName, annotationType, featureSet);
            frame.pack();
            frame.setLocationRelativeTo(MainFrame.getInstance());
            frame.setVisible(true);
        }
    }

    class OpenDocumentAction
    extends AbstractAction {
        public OpenDocumentAction() {
            super("Open documents", new DocumentIcon(MainFrame.ICON_DIMENSION));
            this.putValue("ShortDescription", "Opens document for the selected row in a document editor");
            this.putValue("MnemonicKey", 38);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.putValue("SmallIcon", new DocumentIcon(MainFrame.ICON_DIMENSION, !enabled));
            super.setEnabled(enabled);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final Document document = (Document)CorpusQualityAssurance.this.corpus.get(CorpusQualityAssurance.this.measuresType == 0 ? CorpusQualityAssurance.this.documentTable.rowViewToModel(CorpusQualityAssurance.this.documentTable.getSelectedRow()) : CorpusQualityAssurance.this.document2Table.rowViewToModel(CorpusQualityAssurance.this.document2Table.getSelectedRow()));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.getInstance().select(document);
                }
            });
        }
    }

    protected class CompareAction
    extends AbstractAction {
        public CompareAction() {
            super("Compare");
            this.putValue("ShortDescription", "Compare annotations between sets A and B");
            this.putValue("MnemonicKey", 10);
            this.putValue("SmallIcon", new ProgressIcon(MainFrame.ICON_DIMENSION));
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.putValue("SmallIcon", new ProgressIcon(MainFrame.ICON_DIMENSION, !enabled));
            super.setEnabled(enabled);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            boolean useBdm = false;
            for (Object measure : CorpusQualityAssurance.this.measureList.getSelectedValues()) {
                if (!((String)measure).contains("BDM")) continue;
                useBdm = true;
                break;
            }
            if (useBdm && CorpusQualityAssurance.this.measuresType == 0 && CorpusQualityAssurance.this.bdmFileUrl == null) {
                new SetBdmFileAction().actionPerformed(null);
                if (CorpusQualityAssurance.this.bdmFileUrl == null) {
                    return;
                }
            }
            CorpusQualityAssurance.this.setCursor(Cursor.getPredefinedCursor(3));
            this.setEnabled(false);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (CorpusQualityAssurance.this.measuresType == 0) {
                        CorpusQualityAssurance.this.documentTableModel = new DefaultTableModel();
                        CorpusQualityAssurance.this.annotationTableModel = new DefaultTableModel();
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Document");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Annotation");
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Match");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Match");
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Only A");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Only A");
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Only B");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Only B");
                        CorpusQualityAssurance.this.documentTableModel.addColumn("Overlap");
                        CorpusQualityAssurance.this.annotationTableModel.addColumn("Overlap");
                        for (Object measure : CorpusQualityAssurance.this.measureList.getSelectedValues()) {
                            String measureString = ((String)measure).replaceFirst("score strict", "s.").replaceFirst("score lenient", "l.").replaceFirst("score average", "a.").replaceFirst(" BDM", "B.");
                            CorpusQualityAssurance.this.documentTableModel.addColumn("Prec.B/A");
                            CorpusQualityAssurance.this.annotationTableModel.addColumn("Prec.B/A");
                            CorpusQualityAssurance.this.documentTableModel.addColumn("Rec.B/A");
                            CorpusQualityAssurance.this.annotationTableModel.addColumn("Rec.B/A");
                            CorpusQualityAssurance.this.documentTableModel.addColumn(measureString);
                            CorpusQualityAssurance.this.annotationTableModel.addColumn(measureString);
                        }
                        CorpusQualityAssurance.this.compareAnnotation();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int col;
                                CorpusQualityAssurance.this.documentTable.setModel(CorpusQualityAssurance.this.documentTableModel);
                                for (col = 0; col < CorpusQualityAssurance.this.documentTable.getColumnCount(); ++col) {
                                    CorpusQualityAssurance.this.documentTable.setComparator(col, CorpusQualityAssurance.this.doubleComparator);
                                }
                                CorpusQualityAssurance.this.documentTable.setComparator(0, CorpusQualityAssurance.this.totalComparator);
                                CorpusQualityAssurance.this.documentTable.setSortedColumn(0);
                                CorpusQualityAssurance.this.annotationTable.setModel(CorpusQualityAssurance.this.annotationTableModel);
                                for (col = 0; col < CorpusQualityAssurance.this.annotationTable.getColumnCount(); ++col) {
                                    CorpusQualityAssurance.this.annotationTable.setComparator(col, CorpusQualityAssurance.this.doubleComparator);
                                }
                                CorpusQualityAssurance.this.annotationTable.setComparator(0, CorpusQualityAssurance.this.totalComparator);
                                CorpusQualityAssurance.this.annotationTable.setSortedColumn(0);
                                CorpusQualityAssurance.this.setCursor(Cursor.getPredefinedCursor(0));
                                CompareAction.this.setEnabled(true);
                            }
                        });
                    } else if (CorpusQualityAssurance.this.measuresType == 1) {
                        CorpusQualityAssurance.this.document2TableModel = new DefaultTableModel();
                        CorpusQualityAssurance.this.document2TableModel.addColumn("Document");
                        CorpusQualityAssurance.this.document2TableModel.addColumn("Agreed");
                        CorpusQualityAssurance.this.document2TableModel.addColumn("Total");
                        for (Object measure : CorpusQualityAssurance.this.measure2List.getSelectedValues()) {
                            CorpusQualityAssurance.this.document2TableModel.addColumn(measure);
                        }
                        CorpusQualityAssurance.this.confusionTableModel = new DefaultTableModel();
                        CorpusQualityAssurance.this.compareAnnotation();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CorpusQualityAssurance.this.document2Table.setSortable(false);
                                CorpusQualityAssurance.this.document2Table.setModel(CorpusQualityAssurance.this.document2TableModel);
                                CorpusQualityAssurance.this.document2Table.setComparator(0, CorpusQualityAssurance.this.totalComparator);
                                CorpusQualityAssurance.this.document2Table.setComparator(1, CorpusQualityAssurance.this.doubleComparator);
                                CorpusQualityAssurance.this.document2Table.setSortedColumn(0);
                                CorpusQualityAssurance.this.document2Table.setSortable(true);
                                CorpusQualityAssurance.this.confusionTable.setModel(CorpusQualityAssurance.this.confusionTableModel);
                                CorpusQualityAssurance.this.setCursor(Cursor.getPredefinedCursor(0));
                                CompareAction.this.setEnabled(true);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runnable, "CompareAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    protected class SetBdmFileAction
    extends AbstractAction {
        public SetBdmFileAction() {
            super("Browse");
            this.putValue("ShortDescription", "Choose a BDM file to compute BDM measures");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            XJFileChooser fileChooser = MainFrame.getFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(true);
            fileChooser.setDialogTitle("Choose a BDM file");
            fileChooser.setFileSelectionMode(0);
            fileChooser.setResource(CorpusQualityAssurance.class.getName() + ".BDMfile");
            int res = fileChooser.showOpenDialog(CorpusQualityAssurance.this);
            if (res != 0) {
                return;
            }
            try {
                CorpusQualityAssurance.this.bdmFileUrl = fileChooser.getSelectedFile().toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    protected static class ToggleSelectionABModel
    extends DefaultListSelectionModel {
        JList list;
        String selectedValueA;
        String selectedValueB;

        public ToggleSelectionABModel(JList list) {
            this.list = list;
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            ExtendedListModel model = (ExtendedListModel)this.list.getModel();
            String value = (String)model.getElementAt(index0);
            if (value.endsWith(" (A)") || value.endsWith(" (B)")) {
                model.removeElementAt(index0);
                model.insertElementAt(value.substring(0, value.length() - " (A)".length()), index0);
                if (value.endsWith(" (A)")) {
                    this.selectedValueA = null;
                } else {
                    this.selectedValueB = null;
                }
                this.removeSelectionInterval(index0, index1);
            } else if (this.selectedValueA == null) {
                model.removeElementAt(index0);
                model.insertElementAt(value + " (A)", index0);
                this.selectedValueA = value;
                this.addSelectionInterval(index0, index1);
            } else if (this.selectedValueB == null) {
                model.removeElementAt(index0);
                model.insertElementAt(value + " (B)", index0);
                this.selectedValueB = value;
                this.addSelectionInterval(index0, index1);
            }
        }

        @Override
        public void clearSelection() {
            this.selectedValueA = null;
            this.selectedValueB = null;
            super.clearSelection();
        }

        public String getSelectedValueA() {
            return this.selectedValueA;
        }

        public String getSelectedValueB() {
            return this.selectedValueB;
        }
    }

    protected static class ToggleSelectionModel
    extends DefaultListSelectionModel {
        boolean gestureStarted = false;

        protected ToggleSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (this.isSelectedIndex(index0) && !this.gestureStarted) {
                super.removeSelectionInterval(index0, index1);
            } else {
                super.addSelectionInterval(index0, index1);
            }
            this.gestureStarted = true;
        }

        @Override
        public void setValueIsAdjusting(boolean isAdjusting) {
            if (!isAdjusting) {
                this.gestureStarted = false;
            }
        }
    }

    protected static class ExtendedListModel
    extends DefaultListModel {
        public ExtendedListModel() {
        }

        public ExtendedListModel(Object[] elements) {
            for (Object element : elements) {
                super.addElement(element);
            }
        }
    }
}

