/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.PhrasePositions;
import gate.creole.annic.apache.lucene.search.PhraseScorer;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;

final class SloppyPhraseScorer
extends PhraseScorer {
    private int slop;

    SloppyPhraseScorer(Weight weight, TermPositions[] tps, Similarity similarity, int slop, byte[] norms) throws IOException {
        super(weight, tps, similarity, norms);
        this.slop = slop;
    }

    @Override
    protected final float phraseFreq() throws IOException {
        this.pq.clear();
        int end = 0;
        PhrasePositions pp = this.first;
        while (pp != null) {
            pp.firstPosition();
            if (pp.position > end) {
                end = pp.position;
            }
            this.pq.put(pp);
            pp = pp.next;
        }
        float freq = 0.0f;
        boolean done = false;
        do {
            int matchLength;
            PhrasePositions pp2 = (PhrasePositions)this.pq.pop();
            int start = pp2.position;
            int next = ((PhrasePositions)this.pq.top()).position;
            int pos = start;
            while (pos <= next) {
                start = pos;
                if (!pp2.nextPosition()) {
                    done = true;
                    break;
                }
                pos = pp2.position;
            }
            if ((matchLength = end - start) <= this.slop) {
                freq += this.getSimilarity().sloppyFreq(matchLength);
            }
            if (pp2.position > end) {
                end = pp2.position;
            }
            this.pq.put(pp2);
        } while (!done);
        return freq;
    }
}

