/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.FieldDoc;
import gate.creole.annic.apache.lucene.search.FieldSortedHitQueue;
import gate.creole.annic.apache.lucene.search.Filter;
import gate.creole.annic.apache.lucene.search.HitCollector;
import gate.creole.annic.apache.lucene.search.HitQueue;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.ScoreDoc;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Sort;
import gate.creole.annic.apache.lucene.search.TopDocs;
import gate.creole.annic.apache.lucene.search.TopFieldDocs;
import gate.creole.annic.apache.lucene.store.Directory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;
    private ArrayList<Integer> queryType = new ArrayList();
    private ArrayList<Integer> frequencies = new ArrayList();
    private ArrayList firstTermPositions = new ArrayList();
    private ArrayList<Integer> documentNumbers = new ArrayList();
    private ArrayList<Integer> patternLengths = new ArrayList();

    public IndexSearcher(String path) throws IOException {
        this(IndexReader.open(path), true);
    }

    public IndexSearcher(Directory directory) throws IOException {
        this(IndexReader.open(directory), true);
    }

    public IndexSearcher(IndexReader r) {
        this(r, false);
    }

    private IndexSearcher(IndexReader r, boolean closeReader) {
        this.reader = r;
        this.closeReader = closeReader;
    }

    @Override
    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    @Override
    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    @Override
    public Document doc(int i) throws IOException {
        return this.reader.document(i);
    }

    @Override
    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    @Override
    public TopDocs search(Query query, Filter filter, int nDocs) throws IOException {
        this.initializeTermPositions();
        Scorer scorer = query.weight(this).scorer(this.reader, this);
        if (scorer == null) {
            return new TopDocs(0, new ScoreDoc[0]);
        }
        final BitSet bits = filter != null ? filter.bits(this.reader) : null;
        final HitQueue hq = new HitQueue(nDocs);
        final int[] totalHits = new int[1];
        scorer.score(new HitCollector(){

            @Override
            public final void collect(int doc, float score) {
                if (score > 0.0f && (bits == null || bits.get(doc))) {
                    totalHits[0] = totalHits[0] + 1;
                    hq.insert(new ScoreDoc(doc, score));
                }
            }
        }, this);
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
        }
        return new TopDocs(totalHits[0], scoreDocs);
    }

    @Override
    public TopFieldDocs search(Query query, Filter filter, int nDocs, Sort sort) throws IOException {
        this.initializeTermPositions();
        Scorer scorer = query.weight(this).scorer(this.reader, this);
        if (scorer == null) {
            return new TopFieldDocs(0, new ScoreDoc[0], sort.fields);
        }
        final BitSet bits = filter != null ? filter.bits(this.reader) : null;
        final FieldSortedHitQueue hq = new FieldSortedHitQueue(this.reader, sort.fields, nDocs);
        final int[] totalHits = new int[1];
        scorer.score(new HitCollector(){

            @Override
            public final void collect(int doc, float score) {
                if (score > 0.0f && (bits == null || bits.get(doc))) {
                    totalHits[0] = totalHits[0] + 1;
                    hq.insert(new FieldDoc(doc, score));
                }
            }
        }, this);
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = hq.fillFields((FieldDoc)hq.pop());
        }
        return new TopFieldDocs(totalHits[0], scoreDocs, hq.getFields());
    }

    @Override
    public void search(Query query, Filter filter, final HitCollector results) throws IOException {
        Scorer scorer;
        this.initializeTermPositions();
        HitCollector collector = results;
        if (filter != null) {
            final BitSet bits = filter.bits(this.reader);
            collector = new HitCollector(){

                @Override
                public final void collect(int doc, float score) {
                    if (bits.get(doc)) {
                        results.collect(doc, score);
                    }
                }
            };
        }
        if ((scorer = query.weight(this).scorer(this.reader, this)) == null) {
            return;
        }
        scorer.score(collector, this);
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    @Override
    public Explanation explain(Query query, int doc) throws IOException {
        return query.weight(this).explain(this.reader, doc);
    }

    public void setFirstTermPositions(int qType, int doc, ArrayList positions, int patternLength, int frequency) {
        this.queryType.add(new Integer(qType));
        this.firstTermPositions.add(positions);
        this.documentNumbers.add(new Integer(doc));
        this.patternLengths.add(new Integer(patternLength));
        this.frequencies.add(new Integer(frequency));
    }

    public void initializeTermPositions() {
        this.queryType = new ArrayList();
        this.firstTermPositions = new ArrayList();
        this.documentNumbers = new ArrayList();
        this.patternLengths = new ArrayList();
        this.frequencies = new ArrayList();
    }

    public ArrayList[] getFirstTermPositions() {
        return new ArrayList[]{this.documentNumbers, this.firstTermPositions, this.patternLengths, this.queryType, this.frequencies};
    }
}

