/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Resource;
import gate.corpora.MimeType;
import gate.corpora.TextualDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.email.EmailDocumentHandler;
import gate.event.StatusListener;
import gate.util.DocumentFormatException;
import gate.util.InvalidOffsetException;
import java.io.IOException;

@CreoleResource(name="GATE EMAIL Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class EmailDocumentFormat
extends TextualDocumentFormat {
    private static final long serialVersionUID = 5738598679165395119L;

    @Override
    public void unpackMarkup(Document doc) throws DocumentFormatException {
        if (doc == null || doc.getSourceUrl() == null && doc.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        this.setNewLineProperty(doc);
        EmailDocumentHandler emailDocHandler = null;
        emailDocHandler = new EmailDocumentHandler(doc, this.markupElementsMap, this.element2StringMap);
        StatusListener statusListener = new StatusListener(){

            @Override
            public void statusChanged(String text) {
                EmailDocumentFormat.this.fireStatusChanged(text);
            }
        };
        emailDocHandler.addStatusListener(statusListener);
        try {
            emailDocHandler.annotateMessages();
            AnnotationSet bodyAnnotations = doc.getAnnotations("Original markups").get("body");
            if (bodyAnnotations != null && !bodyAnnotations.isEmpty()) {
                for (Annotation a : bodyAnnotations) {
                    this.annotateParagraphs(doc, a.getStartNode().getOffset().intValue(), a.getEndNode().getOffset().intValue(), "Original markups");
                }
            }
        }
        catch (IOException e) {
            throw new DocumentFormatException("Couldn't create a buffered reader ", e);
        }
        catch (InvalidOffsetException e) {
            throw new DocumentFormatException(e);
        }
        finally {
            emailDocHandler.removeStatusListener(statusListener);
        }
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        MimeType mime = new MimeType("text", "email");
        mimeString2ClassHandlerMap.put(mime.getType() + "/" + mime.getSubtype(), this);
        mimeString2mimeTypeMap.put(mime.getType() + "/" + mime.getSubtype(), mime);
        suffixes2mimeTypeMap.put("eml", mime);
        suffixes2mimeTypeMap.put("email", mime);
        suffixes2mimeTypeMap.put("mail", mime);
        magic2mimeTypeMap.put("Subject:", mime);
        this.setMimeType(mime);
        return this;
    }
}

