/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.Gate;
import gate.Main;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.gui.MainFrame;
import gate.gui.persistence.XgappUpgradeSelector;
import gate.persist.PersistenceException;
import gate.resources.img.svg.ApplicationIcon;
import gate.swing.XJFileChooser;
import gate.util.ExtensionFileFilter;
import gate.util.maven.SimpleModelResolver;
import gate.util.maven.Utils;
import gate.util.persistence.PersistenceManager;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

@CreoleResource(tool=true, isPrivate=true, autoinstances={@AutoInstance}, name="Upgrade XGapp", comment="Upgrades an XGapp to use new style GATE plugins")
public class UpgradeXGAPP {
    private static final Logger log = Logger.getLogger(UpgradeXGAPP.class);
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
    private static GenericVersionScheme versionScheme = new GenericVersionScheme();
    private static XMLInputFactory inputFactory = XMLInputFactory.newFactory();

    public static Version getDefaultSelection(VersionRangeResult vrr) {
        if (vrr == null) {
            return null;
        }
        List versions = vrr.getVersions();
        boolean isSnapshot = Main.version.toUpperCase().endsWith("-SNAPSHOT");
        for (int i = versions.size() - 1; i >= 0 && !isSnapshot; --i) {
            Version v = (Version)versions.get(i);
            if (v.toString().toUpperCase().endsWith("-SNAPSHOT")) continue;
            return v;
        }
        return (Version)versions.get(versions.size() - 1);
    }

    public static List<UpgradePath> suggest(Document doc) throws IOException, JDOMException {
        ArrayList<UpgradePath> upgrades = new ArrayList<UpgradePath>();
        Element root = doc.getRootElement();
        Element pluginList = root.getChild("urlList").getChild("localList");
        List plugins = pluginList.getChildren();
        for (Element plugin : plugins) {
            switch (plugin.getName()) {
                case "gate.util.persistence.PersistenceManager-URLHolder": {
                    String urlString = plugin.getChild("urlString").getValue();
                    String[] parts = urlString.split("/");
                    String oldName = parts[parts.length - 1];
                    String newName = UpgradeXGAPP.mapDirectoryNameToPlugin(oldName);
                    VersionRangeResult versions = UpgradeXGAPP.getPluginVersions("uk.ac.gate.plugins", newName);
                    upgrades.add(new UpgradePath(plugin, urlString, versions == null ? null : "uk.ac.gate.plugins", newName, versions, null, UpgradeXGAPP.getDefaultSelection(versions)));
                    break;
                }
                case "gate.creole.Plugin-Maven": {
                    String group = plugin.getChild("group").getValue();
                    String artifact = plugin.getChild("artifact").getValue();
                    String version = plugin.getChild("version").getValue();
                    String oldCreoleURI = "creole://" + group + ";" + artifact + ";" + version + "/";
                    VersionRangeResult versions = UpgradeXGAPP.getPluginVersions(group, artifact);
                    if (versions == null || versions.getVersions() == null || versions.getVersions().isEmpty()) break;
                    try {
                        Version currentVersion = versionScheme.parseVersion(version);
                        upgrades.add(new UpgradePath(plugin, oldCreoleURI, group, artifact, versions, currentVersion, UpgradeXGAPP.getDefaultSelection(versions)));
                    }
                    catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {}
                    break;
                }
            }
        }
        return upgrades;
    }

    public static String mapDirectoryNameToPlugin(String oldName) {
        if ("Lang_French".equals(oldName)) {
            return "lang-french-compat";
        }
        if ("Lang_German".equals(oldName)) {
            return "lang-german-compat";
        }
        return oldName.toLowerCase().replaceAll("[\\s_]+", "-");
    }

    public static void upgrade(Document doc, List<UpgradePath> upgrades) throws JDOMException {
        Element root = doc.getRootElement();
        Element pluginList = root.getChild("urlList").getChild("localList");
        for (UpgradePath upgrade : upgrades) {
            if (!upgrade.getUpgradeStrategy().upgradePlugin) continue;
            int pluginIndex = pluginList.indexOf((Content)upgrade.getOldElement());
            pluginList.setContent(pluginIndex, (Content)upgrade.getNewElement());
        }
        XPath jarXPath = XPath.newInstance((String)"//gate.util.persistence.PersistenceManager-URLHolder/urlString | //gate.util.persistence.PersistenceManager-RRPersistence/uriString");
        block1: for (Element element : jarXPath.selectNodes((Object)doc)) {
            String urlString = element.getValue();
            for (UpgradePath upgrade : upgrades) {
                if (!upgrade.getUpgradeStrategy().upgradeResources || !urlString.startsWith(upgrade.getOldPath())) continue;
                String urlSuffix = urlString.substring(upgrade.getOldPath().length());
                urlString = upgrade.newPathFor(urlSuffix);
                Element rr = new Element("gate.util.persistence.PersistenceManager-RRPersistence");
                Element uriString = new Element("uriString");
                uriString.setText(urlString);
                rr.addContent((Content)uriString);
                Element parent = element.getParentElement().getParentElement();
                parent.removeContent((Content)element.getParentElement());
                parent.addContent((Content)rr);
                continue block1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionRangeResult getPluginVersions(String group, String artifact) {
        try {
            DefaultArtifact artifactObj = new DefaultArtifact(group, artifact, "jar", "[0,)");
            List<RemoteRepository> repos = Utils.getRepositoryList();
            RepositorySystem repoSystem = Utils.getRepositorySystem();
            DefaultRepositorySystemSession repoSession = Utils.getRepositorySession(repoSystem, null);
            VersionRangeRequest request = new VersionRangeRequest((Artifact)artifactObj, repos, null);
            VersionRangeResult versionResult = repoSystem.resolveVersionRange((RepositorySystemSession)repoSession, request);
            if (versionResult.getVersions().isEmpty()) {
                return null;
            }
            List versions = versionResult.getVersions();
            Iterator it = versions.iterator();
            while (it.hasNext()) {
                Version version = (Version)it.next();
                try {
                    Version pluginMinGate;
                    Serializable artifactURL;
                    ArtifactRequest artifactRequest;
                    URL creoleUrl = null;
                    ArtifactResult artifactResult = null;
                    try {
                        artifactObj = new DefaultArtifact(group, artifact, "creole", "jar", version.toString());
                        ArtifactRequest artifactRequest2 = new ArtifactRequest((Artifact)artifactObj, repos, null);
                        artifactResult = repoSystem.resolveArtifact((RepositorySystemSession)repoSession, artifactRequest2);
                        URL tryCreoleUrl = new URL("jar:" + artifactResult.getArtifact().getFile().toURI().toURL() + "!/META-INF/gate/creole.xml");
                        InputStream creoleStream = tryCreoleUrl.openStream();
                        Throwable throwable = null;
                        if (creoleStream != null) {
                            if (throwable != null) {
                                try {
                                    creoleStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                creoleStream.close();
                            }
                        }
                        creoleUrl = tryCreoleUrl;
                    }
                    catch (ArtifactResolutionException e) {
                        artifactObj = new DefaultArtifact(group, artifact, "jar", version.toString());
                        artifactRequest = new ArtifactRequest((Artifact)artifactObj, repos, null);
                        artifactResult = repoSystem.resolveArtifact((RepositorySystemSession)repoSession, artifactRequest);
                        artifactURL = new URL("jar:" + artifactResult.getArtifact().getFile().toURI().toURL() + "!/");
                        URL tryCreoleUrl = new URL("jar:" + artifactResult.getArtifact().getFile().toURI().toURL() + "!/META-INF/gate/creole.xml");
                        try {
                            InputStream creoleStream = tryCreoleUrl.openStream();
                            Object object = null;
                            try {
                                creoleUrl = tryCreoleUrl;
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (creoleStream != null) {
                                    if (object != null) {
                                        try {
                                            creoleStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        creoleStream.close();
                                    }
                                }
                            }
                        }
                        catch (IOException ex) {
                            URL directoryXmlFileUrl = new URL((URL)artifactURL, "creole.xml");
                            try (InputStream creoleStream = directoryXmlFileUrl.openStream();){
                                creoleUrl = directoryXmlFileUrl;
                            }
                        }
                    }
                    String minGateVersion = null;
                    InputStream creoleStream = creoleUrl.openStream();
                    artifactURL = null;
                    try (XMLStreamReader xsr2 = inputFactory.createXMLStreamReader(creoleStream);){
                        xsr2.nextTag();
                        minGateVersion = xsr2.getAttributeValue("", "GATE-MIN");
                    }
                    catch (Throwable xsr2) {
                        artifactURL = xsr2;
                        throw xsr2;
                    }
                    finally {
                        if (creoleStream != null) {
                            if (artifactURL != null) {
                                try {
                                    creoleStream.close();
                                }
                                catch (Throwable xsr2) {
                                    ((Throwable)artifactURL).addSuppressed(xsr2);
                                }
                            } else {
                                creoleStream.close();
                            }
                        }
                    }
                    if (minGateVersion == null) {
                        artifactObj = new SubArtifact((Artifact)artifactObj, "", "pom");
                        artifactRequest = new ArtifactRequest((Artifact)artifactObj, repos, null);
                        artifactResult = repoSystem.resolveArtifact((RepositorySystemSession)repoSession, artifactRequest);
                        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
                        req.setProcessPlugins(false);
                        req.setPomFile(artifactResult.getArtifact().getFile());
                        req.setModelResolver((ModelResolver)new SimpleModelResolver(repoSystem, (RepositorySystemSession)repoSession, repos));
                        req.setValidationLevel(0);
                        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
                        Model model = modelBuilder.build((ModelBuildingRequest)req).getEffectiveModel();
                        for (Dependency effectiveDependency : model.getDependencies()) {
                            if (!effectiveDependency.getGroupId().equals("uk.ac.gate") || !effectiveDependency.getArtifactId().equals("gate-core")) continue;
                            minGateVersion = effectiveDependency.getVersion();
                        }
                    }
                    if (minGateVersion == null || Gate.VERSION.compareTo((Object)(pluginMinGate = versionScheme.parseVersion(minGateVersion))) >= 0) continue;
                    it.remove();
                }
                catch (IOException | XMLStreamException | ModelBuildingException | ArtifactResolutionException | InvalidVersionSpecificationException e) {
                    e.printStackTrace();
                    it.remove();
                }
            }
            versionResult.setVersions(versions);
            return versionResult;
        }
        catch (SettingsBuildingException | VersionRangeResolutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveUpgradePaths(List<UpgradePath> paths, URI xgappUri, File outputFile) throws IOException {
        try (PrintWriter w = new PrintWriter(Files.newBufferedWriter(outputFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));){
            for (UpgradePath path : paths) {
                StringBuilder line = new StringBuilder();
                String oldPath = path.getOldPath();
                if (oldPath.startsWith("$") && !oldPath.startsWith("$gate")) {
                    try {
                        oldPath = PersistenceManager.URLHolder.unpackPersistentRepresentation(xgappUri, oldPath).toString();
                    }
                    catch (PersistenceException e) {
                        throw new FileNotFoundException("Couldn't translate " + oldPath + " to a URI" + (oldPath.startsWith("$res") ? " - please set resources home" : ""));
                    }
                }
                line.append(oldPath);
                line.append('\t');
                line.append(path.getUpgradeStrategy().name());
                if (path.getUpgradeStrategy().upgradePlugin) {
                    line.append('\t');
                    line.append(path.getGroupID());
                    line.append('\t');
                    line.append(path.getArtifactID());
                    line.append('\t');
                    line.append(path.getSelectedVersion());
                }
                w.println(line);
            }
        }
    }

    public static void loadUpgradePaths(List<UpgradePath> paths, URI xgappUri, File inputFile) throws IOException {
        HashMap<String, List> pathsByOldPath = new HashMap<String, List>();
        for (UpgradePath path : paths) {
            String oldPath = path.getOldPath();
            if (oldPath.startsWith("$") && !oldPath.startsWith("$gate")) {
                try {
                    oldPath = PersistenceManager.URLHolder.unpackPersistentRepresentation(xgappUri, oldPath).toString();
                }
                catch (PersistenceException e) {
                    throw new FileNotFoundException("Couldn't translate " + oldPath + " to a URI" + (oldPath.startsWith("$res") ? " - please set resources home" : ""));
                }
            }
            pathsByOldPath.computeIfAbsent(oldPath, k -> new ArrayList()).add(path);
        }
        try (BufferedReader r = Files.newBufferedReader(inputFile.toPath(), StandardCharsets.UTF_8);){
            String line;
            int lineNo = 0;
            while ((line = r.readLine()) != null) {
                ++lineNo;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String[] fields = line.split("\\s+", 5);
                if (fields.length < 2) {
                    throw new IllegalArgumentException("Malformed upgrade file at line " + lineNo + ", expected either \"oldPlugin  SKIP\" or \"oldPlugin  UPGRADE/PLUGIN_ONLY  group  artifact  version\" but found \"" + line + "\"");
                }
                String oldPath = fields[0];
                List thesePaths = (List)pathsByOldPath.get(oldPath);
                if (thesePaths == null) continue;
                UpgradePath.UpgradeStrategy strategy = UpgradePath.UpgradeStrategy.valueOf(fields[1]);
                String groupId = null;
                String artifactId = null;
                String version = null;
                if (fields.length >= 5) {
                    groupId = fields[2];
                    artifactId = fields[3];
                    version = fields[4];
                }
                VersionRangeResult vrr = groupId == null ? null : UpgradeXGAPP.getPluginVersions(groupId, artifactId);
                List versions = vrr == null ? null : vrr.getVersions();
                for (UpgradePath path : thesePaths) {
                    path.setUpgradeStrategy(strategy);
                    if (groupId == null || versions == null || versions.isEmpty()) continue;
                    path.setGroupID(groupId);
                    path.setArtifactID(artifactId);
                    path.setVersionRangeResult(vrr);
                    try {
                        path.setSelectedVersion(version == null ? null : versionScheme.parseVersion(version));
                    }
                    catch (IllegalArgumentException | InvalidVersionSpecificationException e) {
                        path.setSelectedVersion(UpgradeXGAPP.getDefaultSelection(vrr));
                        log.warn((Object)("Version " + version + " not valid for plugin " + groupId + ":" + artifactId + ", using " + path.getSelectedVersion() + " instead"));
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ERROR);
        Logger.getLogger((String)"gate").setLevel(Level.INFO);
        if (args.length == 0) {
            System.err.println("Usage:");
            System.err.println();
            System.err.println("  java [java_options] gate.util.persistence.UpgradeXGAPP <xgapp> [<script>]");
            System.err.println();
            System.err.println(" <xgapp>  - the xgapp file to upgrade");
            System.err.println(" <script> - (optional) a TSV file specifying any specific actions to take");
            System.err.println("            for certain plugins.  Typically this file would have been created");
            System.err.println("            by saving settings while upgrading an xgapp in the GUI.");
            System.err.println();
            System.err.println("The upgraded xgapp will replace the original one, with the original saved");
            System.err.println("with an extra .bak extension.");
            System.err.println();
            System.err.println("Note: if the xgapp references any plugins using $resourceshome$ or");
            System.err.println("$sysprop:...$ style URLs then you must pass the appropriate -D arguments to");
            System.err.println("java to set the relevant properties (-Dgate.user.resourceshome=... in the");
            System.err.println("case of $resourceshome$).");
            System.exit(1);
        }
        SAXBuilder builder = new SAXBuilder(false);
        File gappFile = new File(args[0]).getCanonicalFile();
        System.out.println("Upgrading xgapp file " + gappFile);
        Document doc = builder.build(gappFile);
        List<UpgradePath> upgrades = UpgradeXGAPP.suggest(doc);
        if (args.length > 1) {
            System.out.println("Loading upgrade script from " + args[1]);
            UpgradeXGAPP.loadUpgradePaths(upgrades, gappFile.toURI(), new File(args[1]));
        }
        Iterator<UpgradePath> it = upgrades.iterator();
        while (it.hasNext()) {
            UpgradePath upgrade = it.next();
            if (!upgrade.getUpgradeStrategy().upgradePlugin || upgrade.getSelectedVersion().equals(upgrade.getCurrentVersion())) {
                it.remove();
                continue;
            }
            System.out.println("Upgrading " + upgrade.getOldPath() + " to " + upgrade.getNewPath() + (upgrade.getUpgradeStrategy().upgradeResources ? " (including resource references)" : " (plugin only)"));
        }
        if (upgrades.isEmpty()) {
            System.out.println("Nothing to do :(");
            return;
        }
        UpgradeXGAPP.upgrade(doc, upgrades);
        if (!gappFile.renameTo(new File(gappFile.getPath() + ".bak"))) {
            System.err.println("unable to back up existing xgapp");
            return;
        }
        try (FileOutputStream out = new FileOutputStream(gappFile);){
            outputter.output(doc, (OutputStream)out);
        }
        System.out.println("Done!");
    }

    public static class UpgradeAction
    extends AbstractAction {
        private static final long serialVersionUID = 5104380211427809600L;

        public UpgradeAction() {
            super("Upgrade XGapp", new ApplicationIcon(24, 24));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XJFileChooser fileChooser = MainFrame.getFileChooser();
            ExtensionFileFilter filter = new ExtensionFileFilter("GATE Application files (.gapp, .xgapp)", ".gapp", ".xgapp");
            fileChooser.resetChoosableFileFilters();
            fileChooser.addChoosableFileFilter(filter);
            fileChooser.setFileFilter(filter);
            fileChooser.setDialogTitle("Select an XGapp to Upgrade");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setResource("lastapplication");
            if (fileChooser.showOpenDialog(MainFrame.getInstance()) != 0) {
                return;
            }
            try {
                File originalXGapp = fileChooser.getSelectedFile().getCanonicalFile();
                MainFrame.lockGUI("Gathering details of plugins");
                new Thread(() -> {
                    List<UpgradePath> upgrades;
                    Document doc;
                    try {
                        try {
                            SAXBuilder builder = new SAXBuilder(false);
                            doc = builder.build(originalXGapp);
                            upgrades = UpgradeXGAPP.suggest(doc);
                        }
                        catch (Exception e) {
                            log.error((Object)"Problem parsing GAPP file", (Throwable)e);
                            MainFrame.unlockGUI();
                            return;
                        }
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                    SwingUtilities.invokeLater(() -> {
                        if (upgrades.isEmpty()) {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "No upgradeable plugins found!", "Upgrade XGapp", 2);
                        } else if (new XgappUpgradeSelector(originalXGapp.toURI(), upgrades).showDialog(MainFrame.getInstance())) {
                            Iterator it = upgrades.iterator();
                            while (it.hasNext()) {
                                UpgradePath upgrade = (UpgradePath)it.next();
                                if (!upgrade.getUpgradeStrategy().upgradePlugin || upgrade.getSelectedVersion().equals(upgrade.getCurrentVersion())) {
                                    it.remove();
                                    continue;
                                }
                                System.out.println("Upgrading " + upgrade.getOldPath() + " to " + upgrade.getNewPath());
                            }
                            if (upgrades.isEmpty()) {
                                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Nothing to do!", "Upgrade XGapp", 1);
                                return;
                            }
                            new Thread(() -> {
                                MainFrame.lockGUI("Upgrading application");
                                try {
                                    UpgradeXGAPP.upgrade(doc, upgrades);
                                    if (!originalXGapp.renameTo(new File(originalXGapp.getAbsolutePath() + ".bak"))) {
                                        System.err.println("unable to back up existing xgapp");
                                        return;
                                    }
                                    try (FileOutputStream out = new FileOutputStream(originalXGapp);){
                                        outputter.output(doc, (OutputStream)out);
                                    }
                                }
                                catch (Exception e) {
                                    log.error((Object)"Error upgrading application", (Throwable)e);
                                }
                                finally {
                                    MainFrame.unlockGUI();
                                }
                            }).start();
                        }
                    });
                }).start();
            }
            catch (IOException e) {
                log.error((Object)("Can't canonicalise file " + fileChooser.getSelectedFile()), (Throwable)e);
            }
        }
    }

    public static class UpgradePath {
        private Element oldEntry;
        private String groupID;
        private String artifactID;
        private Version selected;
        private Version current;
        private VersionRangeResult versions;
        private String oldPath;
        private UpgradeStrategy upgradeStrategy;

        public UpgradePath(Element oldEntry, String oldPath, String groupID, String artifactID, VersionRangeResult versions, Version current, Version selected) {
            this.oldEntry = oldEntry;
            this.oldPath = oldPath.endsWith("/") ? oldPath : oldPath + "/";
            this.groupID = groupID;
            this.artifactID = artifactID;
            this.versions = versions;
            this.selected = selected;
            this.current = current;
            this.upgradeStrategy = versions == null ? UpgradeStrategy.SKIP : UpgradeStrategy.UPGRADE;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setSelectedVersion(Version version) {
            if (this.versions == null) {
                if (version != null) throw new IllegalArgumentException("Supplied version isn't valid");
                this.selected = null;
            } else if (!this.versions.getVersions().contains(version)) {
                throw new IllegalArgumentException("Supplied version isn't valid");
            }
            this.selected = version;
        }

        public Version getSelectedVersion() {
            return this.selected;
        }

        public Version getCurrentVersion() {
            return this.current;
        }

        public String toString() {
            return this.oldPath + " can be upgraded to one of the following versions of " + this.groupID + ":" + this.artifactID + " " + this.versions;
        }

        public String getNewPath() {
            return "creole://" + this.groupID + ";" + this.artifactID + ";" + Objects.toString(this.selected) + "/";
        }

        public String newPathFor(String urlSuffix) {
            return this.getNewPath() + (urlSuffix.startsWith("resources/") ? "" : "resources/") + urlSuffix;
        }

        public String getOldPath() {
            return this.oldPath;
        }

        public String getGroupID() {
            return this.groupID;
        }

        public void setGroupID(String groupID) {
            this.groupID = groupID;
        }

        public String getArtifactID() {
            return this.artifactID;
        }

        public void setArtifactID(String artifactID) {
            this.artifactID = artifactID;
        }

        public List<Version> getVersions() {
            return this.versions.getVersions();
        }

        public void setVersionRangeResult(VersionRangeResult result) {
            this.versions = result;
        }

        public UpgradeStrategy getUpgradeStrategy() {
            return this.upgradeStrategy;
        }

        public void setUpgradeStrategy(UpgradeStrategy upgradeStrategy) {
            this.upgradeStrategy = upgradeStrategy;
        }

        protected Element getNewElement() {
            Element mavenPlugin = new Element("gate.creole.Plugin-Maven");
            Element groupElement = new Element("group");
            groupElement.setText(this.groupID);
            Element artifactElement = new Element("artifact");
            artifactElement.setText(this.artifactID);
            Element versionElement = new Element("version");
            versionElement.setText(this.selected.toString());
            mavenPlugin.addContent((Content)groupElement);
            mavenPlugin.addContent((Content)artifactElement);
            mavenPlugin.addContent((Content)versionElement);
            return mavenPlugin;
        }

        protected Element getOldElement() {
            return this.oldEntry;
        }

        public static enum UpgradeStrategy {
            UPGRADE("Upgrade", "Replace all references to the old plugin with the new one", true, true),
            PLUGIN_ONLY("Plugin only", "Load the new plugin, but use resources from the old location (for example if you have copied a core GATE plugin and modified its files in-place)", true, false),
            SKIP("Skip", "Do nothing with this plugin", false, false);

            public final String label;
            public final String tooltip;
            public final boolean upgradePlugin;
            public final boolean upgradeResources;

            private UpgradeStrategy(String label, String tooltip, boolean upgradePlugin, boolean upgradeResources) {
                this.label = label;
                this.tooltip = tooltip;
                this.upgradePlugin = upgradePlugin;
                this.upgradeResources = upgradeResources;
            }

            public String toString() {
                return this.label;
            }
        }
    }
}

