/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private List<String> acceptedExtensions = new ArrayList<String>();
    private String description;

    public ExtensionFileFilter() {
    }

    public ExtensionFileFilter(String description, String ... extensions) {
        this.setDescription(description);
        for (String extension : extensions) {
            this.addExtension(extension);
        }
    }

    @Override
    public boolean accept(File f) {
        String name = f.getName();
        if (f.isDirectory()) {
            return true;
        }
        for (String acceptedExtension : this.acceptedExtensions) {
            if (!name.endsWith(acceptedExtension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description == null ? this.toString() : this.description;
    }

    public void addExtension(String extension) {
        this.acceptedExtensions.add(extension);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getExtensions() {
        return this.acceptedExtensions.toArray(new String[this.acceptedExtensions.size()]);
    }

    public String toString() {
        return "Filter for " + Arrays.toString(this.acceptedExtensions.toArray());
    }
}

