/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationSchema;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.FeaturesSchemaEditor;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.annedit.SearchAndAnnotatePanel;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;

public class AnnotationEditor
extends AbstractVisualResource
implements OwnedAnnotationEditor {
    protected JWindow popupWindow;
    protected JToggleButton pinnedButton;
    protected JComboBox<String> typeCombo;
    protected FeaturesSchemaEditor featuresEditor;
    protected JScrollPane featuresScroller;
    protected JButton solButton;
    protected JButton sorButton;
    protected JButton delButton;
    protected JButton eolButton;
    protected JButton eorButton;
    protected JButton dismissButton;
    protected Timer hideTimer;
    protected MouseEvent pressed;
    protected static final int HIDE_DELAY = 3000;
    protected static final int SHIFT_INCREMENT = 5;
    protected static final int CTRL_SHIFT_INCREMENT = 10;
    protected Map<String, AnnotationSchema> schemasByType;
    private AnnotationEditorOwner owner;
    protected Annotation ann;
    protected AnnotationSet set;
    protected AnnotationEditor annotationEditorInstance;
    private ActionMap actionMap;
    private StartOffsetLeftAction solAction;
    private StartOffsetRightAction sorAction;
    private DeleteAnnotationAction delAction;
    private EndOffsetLeftAction eolAction;
    private EndOffsetRightAction eorAction;
    private ComponentOrientation currentOrientation = null;
    private final String SOL_DESC = "<html><b>Extend start</b><small><br>LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>";
    private final String SOR_DESC = "<html><b>Shrink start</b><small><br>RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>";
    private final String EOL_DESC = "<html><b>Shrink end</b><small><br>ALT + LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>";
    private final String EOR_DESC = "<html><b>Extend end</b><small><br>ALT + RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>";
    private final String[] SOL_KEY_STROKES = new String[]{"LEFT", "shift LEFT", "control shift released LEFT"};
    private final String[] SOR_KEY_STROKES = new String[]{"RIGHT", "shift RIGHT", "control shift released RIGHT"};
    private final String[] EOL_KEY_STROKES = new String[]{"LEFT", "alt LEFT", "control alt released LEFT"};
    private final String[] EOR_KEY_STROKES = new String[]{"RIGHT", "alt RIGHT", "control alt released RIGHT"};

    @Override
    public Resource init() throws ResourceInstantiationException {
        super.init();
        this.initData();
        this.initGUI();
        this.initListeners();
        this.annotationEditorInstance = this;
        return this;
    }

    protected void initData() {
        this.schemasByType = new HashMap<String, AnnotationSchema>();
        List<LanguageResource> schemas = Gate.getCreoleRegister().getLrInstances("gate.creole.AnnotationSchema");
        for (AnnotationSchema annotationSchema : schemas) {
            this.schemasByType.put(annotationSchema.getAnnotationName(), annotationSchema);
        }
        CreoleListener creoleListener = new CreoleListener(){

            @Override
            public void resourceLoaded(CreoleEvent e) {
                Resource newResource = e.getResource();
                if (newResource instanceof AnnotationSchema) {
                    AnnotationSchema aSchema = (AnnotationSchema)newResource;
                    AnnotationEditor.this.schemasByType.put(aSchema.getAnnotationName(), aSchema);
                }
            }

            @Override
            public void resourceUnloaded(CreoleEvent e) {
                AnnotationSchema aSchema;
                Resource newResource = e.getResource();
                if (newResource instanceof AnnotationSchema && AnnotationEditor.this.schemasByType.containsValue(aSchema = (AnnotationSchema)newResource)) {
                    AnnotationEditor.this.schemasByType.remove(aSchema.getAnnotationName());
                }
            }

            @Override
            public void datastoreOpened(CreoleEvent e) {
            }

            @Override
            public void datastoreCreated(CreoleEvent e) {
            }

            @Override
            public void datastoreClosed(CreoleEvent e) {
            }

            @Override
            public void resourceRenamed(Resource resource, String oldName, String newName) {
            }
        };
        Gate.getCreoleRegister().addCreoleListener(creoleListener);
    }

    protected void initGUI() {
        this.popupWindow = new JWindow(SwingUtilities.getWindowAncestor(this.owner.getTextComponent())){

            @Override
            public void pack() {
                if (this.isVisible()) {
                    int maxHeight = MainFrame.getInstance().getHeight();
                    int otherHeight = this.getHeight() - AnnotationEditor.this.featuresScroller.getHeight();
                    if (AnnotationEditor.this.featuresScroller.getPreferredSize().height > (maxHeight -= otherHeight)) {
                        AnnotationEditor.this.featuresScroller.setMaximumSize(new Dimension(AnnotationEditor.this.featuresScroller.getMaximumSize().width, maxHeight));
                        AnnotationEditor.this.featuresScroller.setPreferredSize(new Dimension(AnnotationEditor.this.featuresScroller.getPreferredSize().width, maxHeight));
                    }
                }
                super.pack();
            }

            @Override
            public void setVisible(boolean b) {
                super.setVisible(b);
                if (b) {
                    AnnotationEditor.this.typeCombo.requestFocus();
                }
            }
        };
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pane.setLayout(new GridBagLayout());
        pane.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        this.popupWindow.setContentPane(pane);
        Insets insets0 = new Insets(0, 0, 0, 0);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.gridx = -1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = insets0;
        this.solButton = new JButton();
        this.solButton.setContentAreaFilled(false);
        this.solButton.setBorderPainted(false);
        this.solButton.setMargin(insets0);
        pane.add((Component)this.solButton, constraints);
        this.sorButton = new JButton();
        this.sorButton.setContentAreaFilled(false);
        this.sorButton.setBorderPainted(false);
        this.sorButton.setMargin(insets0);
        pane.add((Component)this.sorButton, constraints);
        this.delButton = new JButton();
        this.delButton.setContentAreaFilled(false);
        this.delButton.setBorderPainted(false);
        this.delButton.setMargin(insets0);
        constraints.insets = new Insets(0, 20, 0, 20);
        pane.add((Component)this.delButton, constraints);
        constraints.insets = insets0;
        this.eolButton = new JButton();
        this.eolButton.setContentAreaFilled(false);
        this.eolButton.setBorderPainted(false);
        this.eolButton.setMargin(insets0);
        pane.add((Component)this.eolButton, constraints);
        this.eorButton = new JButton();
        this.eorButton.setContentAreaFilled(false);
        this.eorButton.setBorderPainted(false);
        this.eorButton.setMargin(insets0);
        pane.add((Component)this.eorButton, constraints);
        this.pinnedButton = new JToggleButton(MainFrame.getIcon("pin"));
        this.pinnedButton.setSelectedIcon(MainFrame.getIcon("pin-in"));
        this.pinnedButton.setSelected(false);
        this.pinnedButton.setBorderPainted(false);
        this.pinnedButton.setContentAreaFilled(false);
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 13;
        pane.add((Component)this.pinnedButton, constraints);
        this.dismissButton = new JButton();
        this.dismissButton.setBorder(null);
        constraints.anchor = 12;
        pane.add((Component)this.dismissButton, constraints);
        constraints.anchor = 10;
        constraints.insets = insets0;
        this.typeCombo = new JComboBox();
        this.typeCombo.setEditable(true);
        this.typeCombo.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        constraints.fill = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 7;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(3, 2, 2, 2);
        pane.add(this.typeCombo, constraints);
        this.featuresEditor = new FeaturesSchemaEditor();
        this.featuresEditor.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        try {
            this.featuresEditor.init();
        }
        catch (ResourceInstantiationException rie) {
            throw new GateRuntimeException(rie);
        }
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.featuresScroller = new JScrollPane(this.featuresEditor);
        pane.add((Component)this.featuresScroller, constraints);
        SearchAndAnnotatePanel searchPanel = new SearchAndAnnotatePanel(pane.getBackground(), this, this.popupWindow);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        pane.add((Component)searchPanel, constraints);
        this.popupWindow.pack();
    }

    protected void initListeners() {
        this.featuresEditor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AnnotationEditor.this.popupWindow.pack();
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AnnotationEditor.this.hideTimer.stop();
            }
        };
        this.typeCombo.getEditor().getEditorComponent().addKeyListener(keyAdapter);
        MouseAdapter windowMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationEditor.this.hideTimer.stop();
            }

            @Override
            public void mousePressed(MouseEvent me) {
                AnnotationEditor.this.pressed = me;
            }
        };
        MouseMotionAdapter windowMouseMotionListener = new MouseMotionAdapter(){
            Point location;

            @Override
            public void mouseDragged(MouseEvent me) {
                this.location = AnnotationEditor.this.popupWindow.getLocation(this.location);
                int x = this.location.x - AnnotationEditor.this.pressed.getX() + me.getX();
                int y = this.location.y - AnnotationEditor.this.pressed.getY() + me.getY();
                AnnotationEditor.this.popupWindow.setLocation(x, y);
                AnnotationEditor.this.pinnedButton.setSelected(true);
            }
        };
        this.popupWindow.getRootPane().addMouseListener(windowMouseListener);
        this.popupWindow.getRootPane().addMouseMotionListener(windowMouseMotionListener);
        InputMap inputMap = ((JComponent)this.popupWindow.getContentPane()).getInputMap(1);
        this.actionMap = ((JComponent)this.popupWindow.getContentPane()).getActionMap();
        this.solAction = new StartOffsetLeftAction("", MainFrame.getIcon("extend-left"), "<html><b>Extend start</b><small><br>LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 37);
        this.solButton.setAction(this.solAction);
        this.setShortCuts(inputMap, this.SOL_KEY_STROKES, "solAction");
        this.actionMap.put("solAction", this.solAction);
        this.sorAction = new StartOffsetRightAction("", MainFrame.getIcon("extend-right"), "<html><b>Shrink start</b><small><br>RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 39);
        this.sorButton.setAction(this.sorAction);
        this.setShortCuts(inputMap, this.SOR_KEY_STROKES, "sorAction");
        this.actionMap.put("sorAction", this.sorAction);
        this.delAction = new DeleteAnnotationAction("", MainFrame.getIcon("remove-annotation"), "Delete the annotation", 127);
        this.delButton.setAction(this.delAction);
        inputMap.put(KeyStroke.getKeyStroke("alt DELETE"), "delAction");
        this.actionMap.put("delAction", this.delAction);
        this.eolAction = new EndOffsetLeftAction("", MainFrame.getIcon("extend-left"), "<html><b>Shrink end</b><small><br>ALT + LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 37);
        this.eolButton.setAction(this.eolAction);
        this.setShortCuts(inputMap, this.EOL_KEY_STROKES, "eolAction");
        this.actionMap.put("eolAction", this.eolAction);
        this.eorAction = new EndOffsetRightAction("", MainFrame.getIcon("extend-right"), "<html><b>Extend end</b><small><br>ALT + RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 39);
        this.eorButton.setAction(this.eorAction);
        this.setShortCuts(inputMap, this.EOR_KEY_STROKES, "eorAction");
        this.actionMap.put("eorAction", this.eorAction);
        this.pinnedButton.setToolTipText("<html>Press to pin window in place&nbsp;&nbsp;<font color=#667799><small>Ctrl-P&nbsp;&nbsp;</small></font></html>");
        inputMap.put(KeyStroke.getKeyStroke("control P"), "toggle pin");
        this.actionMap.put("toggle pin", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationEditor.this.pinnedButton.doClick();
            }
        });
        DismissAction dismissAction = new DismissAction("", null, "Close the window", 27);
        this.dismissButton.setAction(dismissAction);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "dismissAction");
        inputMap.put(KeyStroke.getKeyStroke("alt ESCAPE"), "dismissAction");
        this.actionMap.put("dismissAction", dismissAction);
        ApplyAction applyAction = new ApplyAction("Apply", null, "", 10);
        inputMap.put(KeyStroke.getKeyStroke("alt ENTER"), "applyAction");
        this.actionMap.put("applyAction", applyAction);
        this.typeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String newType = AnnotationEditor.this.typeCombo.getSelectedItem().toString();
                if (AnnotationEditor.this.ann == null || AnnotationEditor.this.ann.getType().equals(newType)) {
                    return;
                }
                Integer oldId = AnnotationEditor.this.ann.getId();
                Annotation oldAnn = AnnotationEditor.this.ann;
                AnnotationEditor.this.set.remove(AnnotationEditor.this.ann);
                try {
                    AnnotationEditor.this.set.add(oldId, oldAnn.getStartNode().getOffset(), oldAnn.getEndNode().getOffset(), newType, oldAnn.getFeatures());
                    Annotation newAnn = AnnotationEditor.this.set.get(oldId);
                    AnnotationEditor.this.getOwner().selectAnnotation(new AnnotationDataImpl(AnnotationEditor.this.set, newAnn));
                    AnnotationEditor.this.editAnnotation(newAnn, AnnotationEditor.this.set);
                    AnnotationEditor.this.owner.annotationChanged(newAnn, AnnotationEditor.this.set, oldAnn.getType());
                }
                catch (InvalidOffsetException ioe) {
                    throw new GateRuntimeException(ioe);
                }
            }
        });
        this.hideTimer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationEditor.this.annotationEditorInstance.setVisible(false);
            }
        });
        this.hideTimer.setRepeats(false);
        AncestorListener textAncestorListener = new AncestorListener(){
            private boolean wasShowing = false;

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (this.wasShowing) {
                    AnnotationEditor.this.annotationEditorInstance.setVisible(true);
                }
                this.wasShowing = false;
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (AnnotationEditor.this.isShowing()) {
                    this.wasShowing = true;
                    AnnotationEditor.this.popupWindow.dispose();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        };
        this.owner.getTextComponent().addAncestorListener(textAncestorListener);
    }

    @Override
    public boolean isActive() {
        return this.popupWindow.isVisible();
    }

    @Override
    public void editAnnotation(Annotation ann, AnnotationSet set) {
        this.ann = ann;
        this.set = set;
        if (ann == null) {
            this.typeCombo.setModel(new DefaultComboBoxModel());
            this.featuresEditor.setSchema(new AnnotationSchema());
            this.popupWindow.validate();
            return;
        }
        String annType = ann.getType();
        HashSet<String> types = new HashSet<String>(this.schemasByType.keySet());
        types.add(annType);
        types.addAll(set.getAllTypes());
        ArrayList<String> typeList = new ArrayList<String>(types);
        Collections.sort(typeList);
        this.typeCombo.setModel(new DefaultComboBoxModel<String>(typeList.toArray(new String[typeList.size()])));
        this.typeCombo.setSelectedItem(annType);
        this.featuresEditor.setSchema(this.schemasByType.get(annType));
        this.featuresEditor.setTargetFeatures(ann.getFeatures());
        this.setEditingEnabled(true);
        this.popupWindow.pack();
        this.setVisible(true);
        if (!this.pinnedButton.isSelected()) {
            this.hideTimer.restart();
        }
    }

    @Override
    public Annotation getAnnotationCurrentlyEdited() {
        return this.ann;
    }

    @Override
    public boolean editingFinished() {
        return true;
    }

    @Override
    public boolean isShowing() {
        return this.popupWindow.isShowing();
    }

    @Override
    public void setVisible(boolean setVisible) {
        super.setVisible(setVisible);
        if (setVisible) {
            this.placeDialog(this.ann.getStartNode().getOffset().intValue(), this.ann.getEndNode().getOffset().intValue());
        } else {
            this.popupWindow.setVisible(false);
            this.pinnedButton.setSelected(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnnotationEditor.this.owner.getTextComponent().requestFocus();
                }
            });
        }
    }

    @Override
    public void placeDialog(int start, int end) {
        if (this.popupWindow.isVisible() && this.pinnedButton.isSelected()) {
            Point where = this.popupWindow.getLocation();
            this.popupWindow.pack();
            if (where != null) {
                this.popupWindow.setLocation(where);
            }
        } else {
            try {
                Rectangle startRect = this.owner.getTextComponent().modelToView(start);
                Rectangle endRect = this.owner.getTextComponent().modelToView(end);
                Point topLeft = this.owner.getTextComponent().getLocationOnScreen();
                int x = topLeft.x + startRect.x;
                int y = topLeft.y + endRect.y + endRect.height;
                Rectangle visRect = this.owner.getTextComponent().getVisibleRect();
                int maxY = topLeft.y + visRect.y + visRect.height;
                this.popupWindow.pack();
                if (this.currentOrientation == ComponentOrientation.RIGHT_TO_LEFT && (x -= this.popupWindow.getSize().width) < 0) {
                    x = 0;
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                boolean revalidate = false;
                if (this.popupWindow.getSize().width > screenSize.width) {
                    this.popupWindow.setSize(screenSize.width, this.popupWindow.getSize().height);
                    revalidate = true;
                }
                if (this.popupWindow.getSize().height > screenSize.height) {
                    this.popupWindow.setSize(this.popupWindow.getSize().width, screenSize.height);
                    revalidate = true;
                }
                if (revalidate) {
                    this.popupWindow.validate();
                }
                int maxX = screenSize.width - this.popupWindow.getSize().width;
                if (maxY + this.popupWindow.getSize().height > screenSize.height) {
                    maxY = screenSize.height - this.popupWindow.getSize().height;
                }
                if (y > maxY) {
                    y = maxY;
                }
                if (x > maxX) {
                    x = maxX;
                }
                this.popupWindow.setLocation(x, y);
            }
            catch (BadLocationException ble) {
                throw new GateRuntimeException(ble);
            }
        }
        if (!this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(true);
        }
    }

    protected void moveAnnotation(AnnotationSet set, Annotation oldAnnotation, Long newStartOffset, Long newEndOffset) throws InvalidOffsetException {
        Annotation tempAnn = null;
        if (set.get(oldAnnotation.getType()).size() == 1) {
            Integer tempAnnId = set.add(oldAnnotation.getStartNode(), oldAnnotation.getStartNode(), oldAnnotation.getType(), oldAnnotation.getFeatures());
            tempAnn = set.get(tempAnnId);
        }
        Integer oldID = oldAnnotation.getId();
        set.remove(oldAnnotation);
        set.add(oldID, newStartOffset, newEndOffset, oldAnnotation.getType(), oldAnnotation.getFeatures());
        Annotation newAnn = set.get(oldID);
        this.getOwner().selectAnnotation(new AnnotationDataImpl(set, newAnn));
        this.editAnnotation(newAnn, set);
        if (tempAnn != null) {
            set.remove(tempAnn);
        }
        this.owner.annotationChanged(newAnn, set, null);
    }

    @Override
    public AnnotationSet getAnnotationSetCurrentlyEdited() {
        return this.set;
    }

    @Override
    public AnnotationEditorOwner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(AnnotationEditorOwner owner) {
        this.owner = owner;
    }

    @Override
    public void setPinnedMode(boolean pinned) {
        this.pinnedButton.setSelected(pinned);
    }

    @Override
    public void setEditingEnabled(boolean isEditingEnabled) {
        this.solButton.setEnabled(isEditingEnabled);
        this.sorButton.setEnabled(isEditingEnabled);
        this.delButton.setEnabled(isEditingEnabled);
        this.eolButton.setEnabled(isEditingEnabled);
        this.eorButton.setEnabled(isEditingEnabled);
        this.typeCombo.setEnabled(isEditingEnabled);
        if (this.featuresEditor.isEditing()) {
            this.featuresEditor.getColumnModel().getColumn(this.featuresEditor.getEditingColumn()).getCellEditor().cancelCellEditing();
        }
        this.featuresEditor.setEnabled(isEditingEnabled);
        if (isEditingEnabled) {
            Color tableBG = this.featuresEditor.getBackground();
            tableBG = new Color(tableBG.getRGB());
            this.featuresEditor.setBackground(tableBG);
        }
        final boolean isEditingEnabledF = isEditingEnabled;
        for (int col = 0; col < this.featuresEditor.getColumnCount(); ++col) {
            final TableCellRenderer previousTcr = this.featuresEditor.getColumnModel().getColumn(col).getCellRenderer();
            TableCellRenderer tcr = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = previousTcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    c.setEnabled(isEditingEnabledF);
                    return c;
                }
            };
            this.featuresEditor.getColumnModel().getColumn(col).setCellRenderer(tcr);
        }
        if (isEditingEnabled) {
            this.actionMap.put("solAction", this.solAction);
            this.actionMap.put("sorAction", this.sorAction);
            this.actionMap.put("delAction", this.delAction);
            this.actionMap.put("eolAction", this.eolAction);
            this.actionMap.put("eorAction", this.eorAction);
        } else {
            this.actionMap.put("solAction", null);
            this.actionMap.put("sorAction", null);
            this.actionMap.put("delAction", null);
            this.actionMap.put("eolAction", null);
            this.actionMap.put("eorAction", null);
        }
        this.changeOrientation(this.currentOrientation);
    }

    @Override
    public void cancelAction() throws GateException {
    }

    @Override
    public boolean canDisplayAnnotationType(String annotationType) {
        return true;
    }

    @Override
    public void okAction() throws GateException {
    }

    @Override
    public boolean supportsCancel() {
        return false;
    }

    @Override
    public void changeOrientation(ComponentOrientation orientation) {
        if (orientation == null) {
            return;
        }
        this.currentOrientation = orientation;
        InputMap inputMap = ((JComponent)this.popupWindow.getContentPane()).getInputMap(1);
        Action solAction = this.actionMap.get("solAction");
        Action sorAction = this.actionMap.get("sorAction");
        Action eolAction = this.actionMap.get("eolAction");
        Action eorAction = this.actionMap.get("eorAction");
        if (orientation == ComponentOrientation.RIGHT_TO_LEFT) {
            this.solButton.setAction(eorAction);
            this.solButton.setToolTipText("<html><b>Extend end</b><small><br>ALT + RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>");
            this.setShortCuts(inputMap, this.SOL_KEY_STROKES, "eorAction");
            this.solButton.setIcon(MainFrame.getIcon("extend-left"));
            this.sorButton.setAction(eolAction);
            this.sorButton.setToolTipText("<html><b>Shrink end</b><small><br>ALT + LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>");
            this.setShortCuts(inputMap, this.SOR_KEY_STROKES, "eolAction");
            this.sorButton.setIcon(MainFrame.getIcon("extend-right"));
            this.eolButton.setAction(sorAction);
            this.eolButton.setToolTipText("<html><b>Shrink start</b><small><br>RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>");
            this.setShortCuts(inputMap, this.EOL_KEY_STROKES, "sorAction");
            this.eolButton.setIcon(MainFrame.getIcon("extend-left"));
            this.eorButton.setAction(solAction);
            this.eorButton.setToolTipText("<html><b>Extend start</b><small><br>LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>");
            this.setShortCuts(inputMap, this.EOR_KEY_STROKES, "solAction");
            this.eorButton.setIcon(MainFrame.getIcon("extend-right"));
        } else {
            this.solButton.setAction(solAction);
            this.solButton.setToolTipText("<html><b>Extend start</b><small><br>LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>");
            this.setShortCuts(inputMap, this.SOL_KEY_STROKES, "solAction");
            this.solButton.setIcon(MainFrame.getIcon("extend-left"));
            this.sorButton.setAction(sorAction);
            this.sorButton.setToolTipText("<html><b>Shrink start</b><small><br>RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>");
            this.setShortCuts(inputMap, this.SOR_KEY_STROKES, "sorAction");
            this.sorButton.setIcon(MainFrame.getIcon("extend-right"));
            this.eolButton.setAction(eolAction);
            this.eolButton.setToolTipText("<html><b>Shrink end</b><small><br>ALT + LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>");
            this.setShortCuts(inputMap, this.EOL_KEY_STROKES, "eolAction");
            this.eolButton.setIcon(MainFrame.getIcon("extend-left"));
            this.eorButton.setAction(eorAction);
            this.eorButton.setToolTipText("<html><b>Extend end</b><small><br>ALT + RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>");
            this.setShortCuts(inputMap, this.EOR_KEY_STROKES, "eorAction");
            this.eorButton.setIcon(MainFrame.getIcon("extend-right"));
        }
    }

    private void setShortCuts(InputMap inputMap, String[] keyStrokes, String action) {
        for (String aKeyStroke : keyStrokes) {
            inputMap.put(KeyStroke.getKeyStroke(aKeyStroke), action);
        }
    }

    protected class ApplyAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public ApplyAction(String text, Icon icon, String desc, int mnemonic) {
            super(text, icon, desc, mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AnnotationEditor.this.annotationEditorInstance.setVisible(false);
        }
    }

    protected class DismissAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public DismissAction(String text, Icon icon, String desc, int mnemonic) {
            super(text, icon, desc, mnemonic);
            Icon exitIcon = UIManager.getIcon("InternalFrame.closeIcon");
            if (exitIcon == null) {
                exitIcon = MainFrame.getIcon("exit");
            }
            this.putValue("SmallIcon", exitIcon);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AnnotationEditor.this.annotationEditorInstance.setVisible(false);
        }
    }

    protected class DeleteAnnotationAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public DeleteAnnotationAction(String text, Icon icon, String desc, int mnemonic) {
            super(text, icon, desc, mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AnnotationEditor.this.set.remove(AnnotationEditor.this.ann);
            AnnotationEditor.this.editAnnotation(null, AnnotationEditor.this.set);
            if (!AnnotationEditor.this.pinnedButton.isSelected()) {
                AnnotationEditor.this.annotationEditorInstance.setVisible(false);
            } else {
                AnnotationEditor.this.setEditingEnabled(false);
            }
        }
    }

    protected class EndOffsetRightAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public EndOffsetRightAction(String text, Icon icon, String desc, int mnemonic) {
            super(text, icon, desc, mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            long newValue;
            long maxOffset = AnnotationEditor.this.owner.getDocument().getContent().size();
            int increment = 1;
            if ((evt.getModifiers() & 1) > 0) {
                increment = 5;
                if ((evt.getModifiers() & 2) > 0) {
                    increment = 10;
                }
            }
            if ((newValue = AnnotationEditor.this.ann.getEndNode().getOffset() + (long)increment) > maxOffset) {
                newValue = maxOffset;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, AnnotationEditor.this.ann.getStartNode().getOffset(), new Long(newValue));
            }
            catch (InvalidOffsetException ioe) {
                throw new GateRuntimeException(ioe);
            }
        }
    }

    protected class EndOffsetLeftAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public EndOffsetLeftAction(String text, Icon icon, String desc, int mnemonic) {
            super(text, icon, desc, mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            long newValue;
            long startOffset = AnnotationEditor.this.ann.getStartNode().getOffset();
            int increment = 1;
            if ((evt.getModifiers() & 1) > 0) {
                increment = 5;
                if ((evt.getModifiers() & 2) > 0) {
                    increment = 10;
                }
            }
            if ((newValue = AnnotationEditor.this.ann.getEndNode().getOffset() - (long)increment) < startOffset) {
                newValue = startOffset;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, AnnotationEditor.this.ann.getStartNode().getOffset(), new Long(newValue));
            }
            catch (InvalidOffsetException ioe) {
                throw new GateRuntimeException(ioe);
            }
        }
    }

    protected class StartOffsetRightAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public StartOffsetRightAction(String text, Icon icon, String desc, int mnemonic) {
            super(text, icon, desc, mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            long newValue;
            long endOffset = AnnotationEditor.this.ann.getEndNode().getOffset();
            int increment = 1;
            if ((evt.getModifiers() & 1) > 0) {
                increment = 5;
                if ((evt.getModifiers() & 2) > 0) {
                    increment = 10;
                }
            }
            if ((newValue = AnnotationEditor.this.ann.getStartNode().getOffset() + (long)increment) > endOffset) {
                newValue = endOffset;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, new Long(newValue), AnnotationEditor.this.ann.getEndNode().getOffset());
            }
            catch (InvalidOffsetException ioe) {
                throw new GateRuntimeException(ioe);
            }
        }
    }

    protected class StartOffsetLeftAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public StartOffsetLeftAction(String text, Icon icon, String desc, int mnemonic) {
            super(text, icon, desc, mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            long newValue;
            int increment = 1;
            if ((evt.getModifiers() & 1) > 0) {
                increment = 5;
                if ((evt.getModifiers() & 2) > 0) {
                    increment = 10;
                }
            }
            if ((newValue = AnnotationEditor.this.ann.getStartNode().getOffset() - (long)increment) < 0L) {
                newValue = 0L;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, new Long(newValue), AnnotationEditor.this.ann.getEndNode().getOffset());
            }
            catch (InvalidOffsetException ioe) {
                throw new GateRuntimeException(ioe);
            }
        }
    }

    protected abstract class AnnotationAction
    extends AbstractAction {
        public AnnotationAction(String text, Icon icon, String desc, int mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }
    }
}

