/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.lucene.QueryParser;
import gate.creole.ir.SearchException;
import java.util.List;

public class PatternValidator {
    private int patLen = 0;

    public int getPatternLength() {
        return this.patLen;
    }

    public int validate(List<String> queryTokens, List<Token> annotations, int from, QueryParser queryParser) throws SearchException {
        this.patLen = 0;
        int enOffset = -1;
        int stOffset = -1;
        int position = -1;
        for (int i = 0; i < queryTokens.size(); ++i) {
            queryParser.position = 0;
            List<?>[] termpositions = queryParser.createTerms(queryTokens.get(i));
            List<?> terms = termpositions[0];
            List<?> consider = termpositions[2];
            for (int k = 0; k < terms.size(); ++k) {
                Token tk;
                int j;
                boolean found;
                Term term = (Term)terms.get(k);
                if (((Boolean)consider.get(k)).booleanValue()) {
                    ++this.patLen;
                    found = false;
                    for (j = from; j < annotations.size(); ++j) {
                        tk = annotations.get(j);
                        if (!this.isEqual(tk, term) || enOffset != -1 && tk.startOffset() != enOffset && tk.startOffset() != enOffset + 1 || tk.getPosition() <= position) continue;
                        found = true;
                        position = tk.getPosition();
                        enOffset = tk.endOffset();
                        stOffset = tk.startOffset();
                        break;
                    }
                    if (found) continue;
                    return -1;
                }
                found = false;
                for (j = 0; j < annotations.size(); ++j) {
                    tk = annotations.get(j);
                    if (tk.getPosition() != position || tk.endOffset() != enOffset || tk.startOffset() != stOffset || !this.isEqual(tk, term)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return -1;
            }
        }
        return enOffset;
    }

    private boolean isEqual(Token tk, Term term) {
        return term.text().equals(tk.termText()) && term.type().equals(tk.type());
    }
}

