/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import gate.creole.annic.SearchException;
import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.lucene.LuceneIndexSearcher;
import gate.creole.annic.lucene.LuceneQueryResult;
import gate.creole.annic.lucene.LuceneSearcher;
import gate.creole.annic.lucene.PatternValidator;
import gate.creole.annic.lucene.QueryParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LuceneSearchThread {
    private static boolean DEBUG = false;
    private int contextWindow;
    private String indexLocation;
    private QueryParser queryParser;
    private String baseTokenAnnotationType;
    private LuceneSearcher luceneSearcher;
    public boolean finished = false;
    private int serializedFileIDIndex = 0;
    private int queryItemIndex = 0;
    private List<String> serializedFilesIDsList = new ArrayList<String>();
    private Map<String, List<QueryItem>> searchResultInfoMap = new HashMap<String, List<QueryItem>>();
    private int ftpIndex = 0;
    private boolean success = false;
    private boolean fwdIterationEnded = false;
    private String serializedFileIDInUse = null;
    private List<Token> tokenStreamInUse = null;
    private String query = null;
    private List<?> ftp;

    private String getCompatibleName(String name) {
        return name.replaceAll("[\\/:\\*\\?\"<>|]", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean search(String query, int patternWindow, String indexLocation, String corpusToSearchIn, String annotationSetToSearchIn, LuceneSearcher luceneSearcher) throws SearchException {
        this.query = query;
        this.contextWindow = patternWindow;
        this.indexLocation = indexLocation;
        this.queryParser = new QueryParser();
        this.luceneSearcher = luceneSearcher;
        this.searchResultInfoMap = new HashMap<String, List<QueryItem>>();
        this.serializedFileIDIndex = 0;
        this.queryItemIndex = 0;
        this.serializedFilesIDsList = new ArrayList<String>();
        this.ftpIndex = -1;
        this.success = false;
        this.fwdIterationEnded = false;
        try {
            StringBuilder temp = new StringBuilder();
            for (int i = 0; i < indexLocation.length(); ++i) {
                if (indexLocation.charAt(i) == '\\') {
                    temp.append("/");
                    continue;
                }
                temp.append(indexLocation.charAt(i));
            }
            indexLocation = temp.toString();
            File locationFile = new File(indexLocation);
            if (!locationFile.isDirectory()) {
                System.out.println("Skipping the invalid Index Location :" + indexLocation);
                return false;
            }
            if (!indexLocation.endsWith("/")) {
                indexLocation = indexLocation + "/";
            }
            if (!(locationFile = new File(indexLocation + "LuceneIndexDefinition.xml")).exists()) {
                System.out.println("Index Definition file not found - Skipping the invalid Index Location :" + indexLocation + "LuceneIndexDefinition.xml");
                return false;
            }
            Map indexInformation = null;
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            try (FileReader fileReader = new FileReader(indexLocation + "LuceneIndexDefinition.xml");){
                indexInformation = (Map)xstream.fromXML((Reader)fileReader);
            }
            String indexedWithANNICIndexPR = (String)indexInformation.get("CorpusIndexFeature");
            if (indexedWithANNICIndexPR == null || !indexedWithANNICIndexPR.equals("AnnicIR")) {
                System.out.println("This corpus was not indexed by Annic Index PR - Skipping the invalid Index");
                return false;
            }
            this.baseTokenAnnotationType = ((String)indexInformation.get("BASE_TOKEN_ANNOTATION_TYPE")).trim();
            int separatorIndex = this.baseTokenAnnotationType.lastIndexOf(46);
            if (separatorIndex >= 0) {
                this.baseTokenAnnotationType = this.baseTokenAnnotationType.substring(separatorIndex + 1);
            }
            Query[] luceneQueries = this.queryParser.parse("contents", query, this.baseTokenAnnotationType, corpusToSearchIn, annotationSetToSearchIn);
            if (this.queryParser.needValidation()) {
                if (DEBUG) {
                    System.out.println("Validation enabled!");
                }
            } else if (DEBUG) {
                System.out.println("Validation disabled!");
            }
            try (LuceneIndexSearcher searcher = new LuceneIndexSearcher(indexLocation);){
                for (int luceneQueryIndex = 0; luceneQueryIndex < luceneQueries.length; ++luceneQueryIndex) {
                    searcher.initializeTermPositions();
                    Hits hits = searcher.search(luceneQueries[luceneQueryIndex]);
                    ArrayList[] firstTermPositions = searcher.getFirstTermPositions();
                    if (firstTermPositions[0].size() == 0) continue;
                    for (int hitIndex = 0; hitIndex < hits.length(); ++hitIndex) {
                        int index = firstTermPositions[0].indexOf(hits.id(hitIndex));
                        List ftp = (List)firstTermPositions[1].get(index);
                        int patLen = (Integer)firstTermPositions[2].get(index);
                        int qType = (Integer)firstTermPositions[3].get(index);
                        String serializedFileID = hits.doc(hitIndex).get("DOCUMENT_ID_FOR_SERIALIZED_FILE");
                        QueryItem queryItem = new QueryItem();
                        queryItem.annotationSetName = hits.doc(hitIndex).get("ANNOTATION_SET_ID").intern();
                        queryItem.id = hits.id(hitIndex);
                        queryItem.documentID = hits.doc(hitIndex).get("DOCUMENT_ID").intern();
                        queryItem.ftp = ftp;
                        queryItem.patLen = patLen;
                        queryItem.qType = qType;
                        queryItem.query = luceneQueries[luceneQueryIndex];
                        queryItem.queryString = this.queryParser.getQueryString(luceneQueryIndex).intern();
                        List<QueryItem> queryItemsList = this.searchResultInfoMap.get(serializedFileID);
                        if (queryItemsList == null) {
                            queryItemsList = new ArrayList<QueryItem>();
                            queryItemsList.add(queryItem);
                            this.searchResultInfoMap.put(serializedFileID, queryItemsList);
                            this.serializedFilesIDsList.add(serializedFileID);
                            continue;
                        }
                        queryItemsList.add(queryItem);
                    }
                }
            }
            this.success = this.searchResultInfoMap.size() > 0;
        }
        catch (gate.creole.ir.SearchException | IOException e) {
            throw new SearchException(e);
        }
        return this.success;
    }

    public List<Pattern> next(int numberOfResults) throws Exception {
        if (!this.success) {
            return null;
        }
        if (this.fwdIterationEnded) {
            return null;
        }
        int noOfResultsToFetch = numberOfResults;
        ArrayList<Pattern> toReturn = new ArrayList<Pattern>();
        while (this.serializedFileIDIndex < this.serializedFilesIDsList.size()) {
            block13: {
                String serializedFileID = this.serializedFilesIDsList.get(this.serializedFileIDIndex);
                List<QueryItem> queryItemsList = this.searchResultInfoMap.get(serializedFileID);
                if (!queryItemsList.isEmpty()) {
                    String folder = queryItemsList.get((int)0).documentID.intern();
                    if (this.serializedFileIDInUse == null || !this.serializedFileIDInUse.equals(serializedFileID) || this.tokenStreamInUse == null) {
                        this.serializedFileIDInUse = serializedFileID;
                        try {
                            this.tokenStreamInUse = this.getTokenStreamFromDisk(this.indexLocation, this.getCompatibleName(folder), this.getCompatibleName(serializedFileID));
                        }
                        catch (Exception e) {
                            break block13;
                        }
                    }
                    while (this.queryItemIndex < queryItemsList.size()) {
                        QueryItem queryItem = queryItemsList.get(this.queryItemIndex);
                        int qType = queryItem.qType;
                        int patLen = queryItem.patLen;
                        if (this.ftp == null) {
                            this.ftp = queryItem.ftp;
                        } else {
                            qType = 1;
                            patLen = 1;
                        }
                        PatternResult patternResult = this.getPatternResult(this.tokenStreamInUse, queryItem.annotationSetName, patLen, qType, this.contextWindow, queryItem.queryString, this.baseTokenAnnotationType, noOfResultsToFetch);
                        if (patternResult.numberOfPatterns != 0) {
                            if (noOfResultsToFetch != -1) {
                                noOfResultsToFetch -= patternResult.numberOfPatterns;
                            }
                            List<Pattern> annicPatterns = this.createAnnicPatterns(new LuceneQueryResult(this.removeUnitNumber(serializedFileID), patternResult.annotationSetName, patternResult.firstTermPositions, patternResult.patternLegths, queryItem.qType, patternResult.gateAnnotations, queryItem.queryString));
                            toReturn.addAll(annicPatterns);
                            if (numberOfResults != -1 && noOfResultsToFetch == 0) {
                                return toReturn;
                            }
                        }
                        ++this.queryItemIndex;
                        this.ftpIndex = -1;
                        this.ftp = null;
                    }
                }
            }
            ++this.serializedFileIDIndex;
            this.queryItemIndex = 0;
            this.ftp = null;
        }
        this.fwdIterationEnded = true;
        return toReturn;
    }

    private List<Pattern> createAnnicPatterns(LuceneQueryResult aResult) {
        ArrayList<Pattern> annicPatterns = new ArrayList<Pattern>();
        List<?> firstTermPositions = aResult.getFirstTermPositions();
        if (firstTermPositions != null && firstTermPositions.size() > 0) {
            List<Integer> patternLength = aResult.patternLength();
            List<Pattern> pats = this.locatePatterns((String)aResult.getDocumentID(), aResult.getAnnotationSetName(), aResult.getGateAnnotations(), firstTermPositions, patternLength, aResult.getQuery());
            annicPatterns.addAll(pats);
        }
        return annicPatterns;
    }

    private List<Pattern> locatePatterns(String docID, String annotationSetName, List<List<PatternAnnotation>> gateAnnotations, List<?> firstTermPositions, List<Integer> patternLength, String queryString) {
        ArrayList<Pattern> pats = new ArrayList<Pattern>();
        for (int i = 0; i < gateAnnotations.size(); ++i) {
            int j;
            List<PatternAnnotation> annotations = gateAnnotations.get(i);
            if (annotations.size() == 0) continue;
            int smallest = Integer.MAX_VALUE;
            int highest = -1;
            for (int j2 = 0; j2 < annotations.size(); ++j2) {
                PatternAnnotation ga = annotations.get(j2);
                if (ga.getStartOffset() < smallest) {
                    smallest = ga.getStartOffset();
                }
                if (ga.getEndOffset() <= highest) continue;
                highest = ga.getEndOffset();
            }
            char[] patternText = new char[highest - smallest];
            for (j = 0; j < patternText.length; ++j) {
                patternText[j] = 32;
            }
            for (j = 0; j < annotations.size(); ++j) {
                PatternAnnotation ga = annotations.get(j);
                if (ga.getText() == null) continue;
                int k = ga.getStartOffset() - smallest;
                for (int m = 0; m < ga.getText().length() && k < patternText.length; ++m, ++k) {
                    patternText[k] = ga.getText().charAt(m);
                }
                if (this.luceneSearcher.annotationTypesMap.keySet().contains(ga.getType())) {
                    List<String> aFeatures = this.luceneSearcher.annotationTypesMap.get(ga.getType());
                    Map<String, String> features = ga.getFeatures();
                    if (features != null) {
                        for (String feature : features.keySet()) {
                            if (aFeatures.contains(feature)) continue;
                            aFeatures.add(feature);
                        }
                    }
                    this.luceneSearcher.annotationTypesMap.put(ga.getType(), aFeatures);
                    continue;
                }
                Map<String, String> features = ga.getFeatures();
                ArrayList<String> aFeatures = new ArrayList<String>();
                aFeatures.add("All");
                if (features != null) {
                    aFeatures.addAll(features.keySet());
                }
                this.luceneSearcher.annotationTypesMap.put(ga.getType(), aFeatures);
            }
            int stPos = (Integer)firstTermPositions.get(i);
            int endOffset = patternLength.get(i);
            int patStart = Integer.MAX_VALUE;
            for (int j3 = 0; j3 < annotations.size(); ++j3) {
                PatternAnnotation ga = annotations.get(j3);
                if (ga.getPosition() != stPos || ga.getStartOffset() >= patStart) continue;
                patStart = ga.getStartOffset();
            }
            if (patStart == Integer.MAX_VALUE || patStart < smallest || endOffset > highest) continue;
            Pattern ap = new Pattern(docID, annotationSetName, new String(patternText), patStart, endOffset, smallest, highest, annotations, queryString);
            pats.add(ap);
        }
        return pats;
    }

    private String removeUnitNumber(String documentID) {
        int index = documentID.lastIndexOf("-");
        if (index == -1) {
            return documentID;
        }
        return documentID.substring(0, index);
    }

    /*
     * Exception decompiling
     */
    private List<Token> getTokenStreamFromDisk(String indexDirectory, String documentFolder, String documentID) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PatternResult getPatternResult(List<Token> subTokens, String annotationSetName, int patLen, int qType, int patWindow, String query, String baseTokenAnnotationType, int numberOfResultsToFetch) {
        if (qType == 1) {
            return this.getPatternResult(subTokens, annotationSetName, patLen, patWindow, query, baseTokenAnnotationType, numberOfResultsToFetch);
        }
        String annotText = (String)this.ftp.get(0);
        String annotType = (String)this.ftp.get(1);
        ArrayList positions = new ArrayList();
        for (int j = 0; j < subTokens.size(); ++j) {
            Token token = subTokens.get(j);
            String type = token.termText();
            String text = token.type();
            if (annotType.equals("*")) {
                if (!type.equals(annotText) || !annotType.equals(text)) continue;
                positions.add(token.getPosition());
                continue;
            }
            if (!annotText.equals(type) || !annotType.equals(text)) continue;
            positions.add(token.getPosition());
        }
        this.ftp = positions;
        return this.getPatternResult(subTokens, annotationSetName, 1, patWindow, query, baseTokenAnnotationType, numberOfResultsToFetch);
    }

    private PatternResult getPatternResult(List<Token> subTokens, String annotationSetName, int patLen, int patWindow, String query, String baseTokenAnnotationType, int noOfResultsToFetch) {
        ArrayList<List<PatternAnnotation>> tokens = new ArrayList<List<PatternAnnotation>>();
        ArrayList<Integer> patLens = new ArrayList<Integer>();
        ++this.ftpIndex;
        int ftpIndexATB = this.ftpIndex;
        while (this.ftpIndex < this.ftp.size() && (noOfResultsToFetch == -1 || noOfResultsToFetch > 0)) {
            block29: {
                Token token;
                Token token2;
                int k;
                Token token3;
                int j;
                int pos = (Integer)this.ftp.get(this.ftpIndex);
                for (j = 0; j < subTokens.size() && (token3 = subTokens.get(j)).getPosition() != pos; ++j) {
                }
                int counter = 0;
                int leftstart = -1;
                for (k = j - 1; k >= 0; --k) {
                    Token token4 = subTokens.get(k);
                    if (token4.getPosition() < pos && token4.termText().equals(baseTokenAnnotationType) && token4.type().equals("*")) {
                        ++counter;
                        leftstart = token4.startOffset();
                        j = k;
                    }
                    if (counter == patWindow) break;
                }
                --pos;
                if (leftstart > -1) {
                    boolean breakNow = false;
                    for (k = j; k < subTokens.size(); ++k) {
                        Token token5 = subTokens.get(k);
                        if (token5.getPosition() == pos) {
                            breakNow = true;
                            continue;
                        }
                        if (breakNow) break;
                    }
                }
                int leftEnd = leftstart == -1 ? -1 : k - 1;
                int upto = -1;
                int tempPos = 0;
                if (this.queryParser.needValidation()) {
                    try {
                        int jj;
                        PatternValidator vp;
                        List<String> queryTokens = this.luceneSearcher.getQueryTokens(query);
                        if (queryTokens == null) {
                            queryTokens = new QueryParser().findTokens(query);
                            this.luceneSearcher.addQueryTokens(query, queryTokens);
                        }
                        if ((upto = (vp = new PatternValidator()).validate(queryTokens, subTokens, k, new QueryParser())) == -1) {
                            this.ftp.remove(this.ftpIndex);
                            --this.ftpIndex;
                            break block29;
                        }
                        boolean breaknow = false;
                        tempPos = subTokens.get(jj).getPosition();
                        for (jj = leftEnd + 1; jj < subTokens.size(); ++jj) {
                            token2 = subTokens.get(jj);
                            if (token2.endOffset() == upto) {
                                tempPos = token2.getPosition();
                                breaknow = true;
                                continue;
                            }
                            if (breaknow) break;
                        }
                        patLens.add(upto);
                        k = jj;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    counter = 0;
                    while (counter < patLen && k < subTokens.size()) {
                        Token token6 = subTokens.get(k);
                        if (token6.termText().equals(baseTokenAnnotationType) && token6.type().equals("*")) {
                            ++counter;
                            upto = token6.endOffset();
                            tempPos = token6.getPosition();
                        }
                        ++k;
                    }
                    patLens.add(upto);
                    ++k;
                }
                int maxEndOffset = upto;
                while (k < subTokens.size() && (token = subTokens.get(k)).getPosition() != tempPos + 1) {
                    ++k;
                }
                counter = 0;
                while (k < subTokens.size()) {
                    token = subTokens.get(k);
                    if (token.startOffset() >= upto && token.termText().equals(baseTokenAnnotationType) && token.type().equals("*")) {
                        ++counter;
                        maxEndOffset = token.endOffset();
                    }
                    if (counter == patWindow) break;
                    ++k;
                }
                if (k < subTokens.size()) {
                    tempPos = subTokens.get(k).getPosition();
                    while (k < subTokens.size() && (token = subTokens.get(k)).getPosition() == tempPos) {
                        ++k;
                    }
                }
                if (k >= subTokens.size()) {
                    k = subTokens.size() - 1;
                }
                ArrayList<PatternAnnotation> patternGateAnnotations = new ArrayList<PatternAnnotation>();
                PatternAnnotation ga = null;
                for (int m = j; m <= k; ++m) {
                    token2 = subTokens.get(m);
                    String text = token2.termText();
                    int st = token2.startOffset();
                    int end = token2.endOffset();
                    String type = token2.type();
                    int position = token2.getPosition();
                    if (type.equals("*")) {
                        ga = new PatternAnnotation();
                        ga.setType(text);
                        ga.setStOffset(st);
                        ga.setEnOffset(end);
                        ga.setPosition(position);
                        if (ga.getEndOffset() > maxEndOffset) continue;
                        patternGateAnnotations.add(ga);
                        continue;
                    }
                    if (type.equals("**")) continue;
                    int index = type.indexOf(".");
                    String feature = type.substring(index + 1, type.length());
                    if (feature.equals("string")) {
                        ga.setText(text);
                    }
                    ga.addFeature(feature, text);
                }
                tokens.add(patternGateAnnotations);
                if (noOfResultsToFetch != -1) {
                    --noOfResultsToFetch;
                }
            }
            ++this.ftpIndex;
        }
        if (noOfResultsToFetch == 0 && this.ftpIndex < this.ftp.size()) {
            --this.ftpIndex;
        }
        PatternResult pr = new PatternResult();
        pr.annotationSetName = annotationSetName;
        pr.gateAnnotations = tokens;
        pr.firstTermPositions = new ArrayList();
        for (int i = 0; i < pr.gateAnnotations.size(); ++i) {
            pr.firstTermPositions.add(this.ftp.get(i + ftpIndexATB));
        }
        pr.patternLegths = patLens;
        pr.numberOfPatterns = pr.gateAnnotations.size();
        return pr;
    }

    private boolean areTheyEqual(List ftp, List ftp1, int qType) {
        if (qType == 1) {
            if (ftp.size() == ftp1.size()) {
                for (int i = 0; i < ftp.size(); ++i) {
                    int pos1;
                    int pos = (Integer)ftp.get(i);
                    if (pos == (pos1 = ((Integer)ftp1.get(i)).intValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        String annotText = (String)ftp.get(0);
        String annotType = (String)ftp.get(1);
        String annotText1 = (String)ftp1.get(0);
        String annotType1 = (String)ftp1.get(1);
        return annotText1.equals(annotText) && annotType1.equals(annotType);
    }

    public String getQuery() {
        return this.query;
    }

    private static class QueryItem {
        float score;
        int id;
        String documentID;
        List ftp;
        int patLen;
        int qType;
        Query query;
        String queryString;
        String annotationSetName;

        private QueryItem() {
        }
    }

    private static class PatternResult {
        int numberOfPatterns;
        List<List<PatternAnnotation>> gateAnnotations;
        String annotationSetName;
        List firstTermPositions;
        List<Integer> patternLegths;

        private PatternResult() {
        }
    }
}

