/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractLanguageResource;
import gate.creole.FeatureSchema;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

@CreoleResource(name="Annotation Schema", comment="An annotation type and its features.", helpURL="http://gate.ac.uk/userguide/sec:corpora:schemas")
public class AnnotationSchema
extends AbstractLanguageResource {
    private static final long serialVersionUID = 3499202938128514949L;
    public static final String FILE_URL_PARAM_NAME = "xmlFileUrl";
    private static Map<String, Class<?>> xSchema2JavaMap;
    private static Map<Class<?>, String> java2xSchemaMap;
    protected String annotationName = null;
    protected Set<FeatureSchema> featureSchemaSet = null;
    protected URL xmlFileUrl;
    private transient AnnotationSchema lastIncluded = null;

    private static void setUpStaticData() throws ResourceInstantiationException {
        xSchema2JavaMap = new HashMap();
        java2xSchemaMap = new HashMap();
        xSchema2JavaMap.put("string", String.class);
        xSchema2JavaMap.put("integer", Integer.class);
        xSchema2JavaMap.put("int", Integer.class);
        xSchema2JavaMap.put("boolean", Boolean.class);
        xSchema2JavaMap.put("float", Float.class);
        xSchema2JavaMap.put("double", Double.class);
        xSchema2JavaMap.put("short", Short.class);
        xSchema2JavaMap.put("byte", Byte.class);
        java2xSchemaMap.put(String.class, "string");
        java2xSchemaMap.put(Integer.class, "integer");
        java2xSchemaMap.put(Boolean.class, "boolean");
        java2xSchemaMap.put(Float.class, "float");
        java2xSchemaMap.put(Double.class, "double");
        java2xSchemaMap.put(Short.class, "short");
        java2xSchemaMap.put(Byte.class, "byte");
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public void setAnnotationName(String annotationName) {
        this.annotationName = annotationName;
    }

    public Set<FeatureSchema> getFeatureSchemaSet() {
        return this.featureSchemaSet;
    }

    public void setFeatureSchemaSet(Set<FeatureSchema> featureSchemaSet) {
        this.featureSchemaSet = featureSchemaSet;
    }

    public FeatureSchema getFeatureSchema(String featureName) {
        if (this.featureSchemaSet == null) {
            return null;
        }
        for (FeatureSchema fs : this.featureSchemaSet) {
            if (!fs.getFeatureName().equals(featureName)) continue;
            return fs;
        }
        return null;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        if (xSchema2JavaMap == null || java2xSchemaMap == null) {
            AnnotationSchema.setUpStaticData();
        }
        if (this.xmlFileUrl != null) {
            this.fromXSchema(this.xmlFileUrl);
            if (this.annotationName == null) {
                Factory.deleteResource(this);
                if (this.lastIncluded != null) {
                    return this.lastIncluded;
                }
                throw new ResourceInstantiationException("The specified XML Schema doesn't define any annotation types");
            }
        }
        return this;
    }

    @CreoleParameter(comment="The url to the definition file", suffixes="xml;xsd")
    public void setXmlFileUrl(URL xmlFileUrl) {
        this.xmlFileUrl = xmlFileUrl;
    }

    public URL getXmlFileUrl() {
        return this.xmlFileUrl;
    }

    public void fromXSchema(URL anXSchemaURL) throws ResourceInstantiationException {
        Document jDom = null;
        SAXBuilder saxBuilder = new SAXBuilder(false);
        try {
            try {
                jDom = saxBuilder.build(anXSchemaURL);
            }
            catch (JDOMException je) {
                throw new ResourceInstantiationException((Exception)((Object)je));
            }
        }
        catch (IOException ex) {
            throw new ResourceInstantiationException(ex);
        }
        this.workWithJDom(jDom);
    }

    public void fromXSchema(InputStream anXSchemaInputStream) throws ResourceInstantiationException {
        Document jDom = null;
        SAXBuilder saxBuilder = new SAXBuilder(false);
        try {
            try {
                jDom = saxBuilder.build(anXSchemaInputStream);
            }
            catch (JDOMException je) {
                throw new ResourceInstantiationException((Exception)((Object)je));
            }
        }
        catch (IOException ex) {
            throw new ResourceInstantiationException(ex);
        }
        this.workWithJDom(jDom);
    }

    private void workWithJDom(Document jDom) throws ResourceInstantiationException {
        Namespace namespace;
        Element rootElement = jDom.getRootElement();
        List rootElementChildrenList = rootElement.getChildren("element", namespace = rootElement.getNamespace());
        if (rootElementChildrenList.size() > 1) {
            throw new ResourceInstantiationException("Each Annotation must be defined in a separate XML Schema file");
        }
        for (Element childElement : rootElementChildrenList) {
            this.createAnnotationSchemaObject(childElement, namespace);
        }
        rootElementChildrenList = rootElement.getChildren("include", namespace);
        for (Element childElement : rootElementChildrenList) {
            try {
                String url = childElement.getAttributeValue("schemaLocation");
                FeatureMap params = Factory.newFeatureMap();
                params.put(FILE_URL_PARAM_NAME, new URL(this.xmlFileUrl, url));
                this.lastIncluded = (AnnotationSchema)Factory.createResource("gate.creole.AnnotationSchema", params);
            }
            catch (Exception e) {
                throw new ResourceInstantiationException(e);
            }
        }
    }

    private void createAnnotationSchemaObject(Element anElement, Namespace namespace) {
        Element complexTypeElement;
        this.annotationName = anElement.getAttributeValue("name");
        if (this.annotationName == null) {
            this.annotationName = "UnknownElement";
        }
        if ((complexTypeElement = anElement.getChild("complexType", namespace)) != null) {
            List complexTypeCildrenList = complexTypeElement.getChildren("attribute", namespace);
            Iterator complexTypeCildrenIterator = complexTypeCildrenList.iterator();
            if (complexTypeCildrenIterator.hasNext()) {
                this.featureSchemaSet = new LinkedHashSet<FeatureSchema>();
            }
            while (complexTypeCildrenIterator.hasNext()) {
                Element childElement = (Element)complexTypeCildrenIterator.next();
                this.createAndAddFeatureSchemaObject(childElement, namespace);
            }
        }
    }

    public void createAndAddFeatureSchemaObject(Element anAttributeElement, Namespace namespace) {
        Element restrictionElement;
        Element simpleTypeElement;
        String featureTypeName;
        String featureName = null;
        Class<?> featureType = null;
        String featureUse = null;
        String featureValue = null;
        HashSet<String> featurePermittedValuesSet = null;
        featureName = anAttributeElement.getAttributeValue("name");
        if (featureName == null) {
            featureName = "UnknownFeature";
        }
        if ((featureTypeName = anAttributeElement.getAttributeValue("type")) != null) {
            featureType = xSchema2JavaMap.get(featureTypeName);
        }
        if ((featureUse = anAttributeElement.getAttributeValue("use")) == null) {
            featureUse = "optional";
        }
        if ((featureValue = anAttributeElement.getAttributeValue("value")) == null) {
            featureValue = "";
        }
        if ((simpleTypeElement = anAttributeElement.getChild("simpleType", namespace)) != null && (restrictionElement = simpleTypeElement.getChild("restriction", namespace)) != null) {
            featureTypeName = restrictionElement.getAttributeValue("base");
            if (featureTypeName == null) {
                featureTypeName = "string";
            }
            featureType = xSchema2JavaMap.get(featureTypeName);
            List enumerationElementChildrenList = restrictionElement.getChildren("enumeration", namespace);
            Iterator enumerationChildrenIterator = enumerationElementChildrenList.iterator();
            if (enumerationChildrenIterator.hasNext()) {
                featurePermittedValuesSet = new HashSet<String>();
            }
            while (enumerationChildrenIterator.hasNext()) {
                Element enumerationElement = (Element)enumerationChildrenIterator.next();
                String permissibleValue = enumerationElement.getAttributeValue("value");
                featurePermittedValuesSet.add(permissibleValue);
            }
        }
        if (simpleTypeElement == null && featureType == null) {
            featureType = xSchema2JavaMap.get("string");
        }
        FeatureSchema featureSchema = new FeatureSchema(featureName, featureType != null ? featureType : String.class, featureValue, featureUse, featurePermittedValuesSet);
        this.featureSchemaSet.add(featureSchema);
    }

    public String toXSchema() {
        StringBuffer schemaString = new StringBuffer();
        schemaString.append("<?xml version=\"1.0\"?>\n<schema xmlns=\"http://www.w3.org/2000/10/XMLSchema\">\n <element name=\"" + this.annotationName + "\"");
        if (this.featureSchemaSet == null) {
            schemaString.append("/>\n");
        } else {
            schemaString.append(">\n  <complexType>\n");
            for (FeatureSchema fs : this.featureSchemaSet) {
                schemaString.append(fs.toXSchema(java2xSchemaMap));
            }
            schemaString.append("  </complexType>\n");
            schemaString.append(" </element>\n");
        }
        schemaString.append("</schema>\n");
        return schemaString.toString();
    }
}

