/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Factory;
import gate.FeatureMap;

class Annotandum {
    protected Long startOffset;
    protected Long endOffset;
    protected String type;
    protected FeatureMap features;

    protected Annotandum(String type, Long startOffset, Long endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type;
        this.features = Factory.newFeatureMap();
    }

    protected Annotandum(String type, Long startOffset, Long endOffset, int column, boolean chunky) {
        this.features = Factory.newFeatureMap();
        this.features.put("column", column);
        this.features.put("kind", chunky ? "chunk" : "token");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type;
    }

    protected Annotandum(String type, Long startOffset, Long endOffset, FeatureMap features) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type;
        this.features = features;
    }

    protected static Annotandum makeToken(long start, long end, String string) {
        int length = (int)(end - start);
        FeatureMap features = Factory.newFeatureMap();
        features.put("length", length);
        features.put("string", string);
        return new Annotandum("Token", start, end, features);
    }

    protected static Annotandum makeSpaceToken(long start) {
        long end = start + 1L;
        FeatureMap features = Factory.newFeatureMap();
        features.put("length", 1);
        features.put("string", " ");
        return new Annotandum("SpaceToken", start, end, features);
    }
}

