/*
 * Decompiled with CFR 0.152.
 */
package gate.config;

import gate.CreoleRegister;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.util.GateException;
import gate.util.GateSaxException;
import gate.util.Strings;
import gate.xml.SimpleErrorHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigXmlHandler
extends DefaultHandler {
    private Stack<String> contentStack = new Stack();
    private Attributes currentAttributes;
    private FeatureMap currentAttributeMap;
    private static final boolean DEBUG = false;
    private URL sourceUrl;
    private SimpleErrorHandler _seh = new SimpleErrorHandler();
    private StringBuffer contentBuffer = new StringBuffer("");
    private boolean readCharacterStatus = false;
    private CreoleRegister register = Gate.getCreoleRegister();

    public ConfigXmlHandler(URL configUrl) {
        this.sourceUrl = configUrl;
    }

    @Override
    public void startDocument() throws GateSaxException {
    }

    @Override
    public void endDocument() throws GateSaxException {
        if (!this.contentStack.isEmpty()) {
            StringBuffer errorMessage = new StringBuffer("document ended but element stack not empty:");
            while (!this.contentStack.isEmpty()) {
                errorMessage.append(Strings.getNl() + "  " + this.contentStack.pop());
            }
            throw new GateSaxException(errorMessage.toString());
        }
    }

    private String attributes2String(Attributes atts) {
        StringBuffer strBuf = new StringBuffer("");
        if (atts == null) {
            return strBuf.toString();
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String attName = atts.getQName(i);
            String attValue = atts.getValue(i);
            strBuf.append(" ");
            strBuf.append(attName);
            strBuf.append("=");
            strBuf.append(attValue);
        }
        return strBuf.toString();
    }

    @Override
    public void startElement(String uri, String qName, String elementName, Attributes atts) throws SAXException {
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        this.currentAttributes = atts;
        this.currentAttributeMap = this.attributeListToParameterList();
        if (elementName.toUpperCase().equals(Gate.getUserConfigElement())) {
            Gate.getUserConfig().putAll(this.currentAttributeMap);
        }
    }

    @Override
    public void endElement(String uri, String qName, String elementName) throws GateSaxException, SAXException {
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        if (!elementName.toUpperCase().equals("GATE")) {
            if (elementName.toUpperCase().equals("CREOLE-DIRECTORY")) {
                String dirUrlName = this.contentStack.pop();
                try {
                    this.register.registerDirectories(new URL(dirUrlName));
                }
                catch (MalformedURLException e) {
                    throw new GateSaxException("bad URL " + dirUrlName + e);
                }
                catch (GateException e) {
                    throw new GateSaxException("unable to register directory", e);
                }
            } else if (!elementName.toUpperCase().equals("GATECONFIG")) {
                throw new GateSaxException("Unknown config data element: " + elementName + "; encountered while parsing " + this.sourceUrl);
            }
        }
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        if (!this.readCharacterStatus) {
            this.contentBuffer = new StringBuffer(new String(text, start, length));
        } else {
            this.contentBuffer.append(new String(text, start, length));
        }
        this.readCharacterStatus = true;
    }

    public void charactersAction(char[] text, int start, int length) throws SAXException {
        String content = new String(text, start, length).trim();
        if (content.length() == 0) {
            return;
        }
        this.contentStack.push(content);
    }

    protected FeatureMap attributeListToParameterList() {
        FeatureMap params = Factory.newFeatureMap();
        int len = this.currentAttributes.getLength();
        for (int i = 0; i < len; ++i) {
            params.put(this.currentAttributes.getQName(i), this.currentAttributes.getValue(i));
        }
        return params;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this._seh.error(ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this._seh.fatalError(ex);
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this._seh.warning(ex);
    }
}

