/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.PersistenceManager;
import gate.util.persistence.ResourcePersistence;
import java.util.Iterator;
import java.util.List;

public class PRPersistence
extends ResourcePersistence {
    protected Object runtimeParams;
    static final long serialVersionUID = 2031381604712340552L;

    @Override
    public void extractDataFromSource(Object source) throws PersistenceException {
        if (!(source instanceof ProcessingResource)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + ProcessingResource.class.getName() + " objects!\n" + source.getClass().getName() + " is not a " + ProcessingResource.class.getName());
        }
        super.extractDataFromSource(source);
        Resource res = (Resource)source;
        ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(res.getClass().getName());
        if (rData == null) {
            throw new PersistenceException("Could not find CREOLE data for " + res.getClass().getName());
        }
        ParameterList params = rData.getParameterList();
        try {
            this.runtimeParams = Factory.newFeatureMap();
            Iterator<List<Parameter>> parDisjIter = params.getRuntimeParameters().iterator();
            while (parDisjIter.hasNext()) {
                for (Parameter parameter : parDisjIter.next()) {
                    String parName = parameter.getName();
                    Object parValue = res.getParameterValue(parName);
                    if (!PRPersistence.storeParameterValue(parValue, parameter.getDefaultValue())) continue;
                    ((FeatureMap)this.runtimeParams).put(parName, parValue);
                }
            }
            this.runtimeParams = PersistenceManager.getPersistentRepresentation(this.runtimeParams);
        }
        catch (ParameterException | ResourceInstantiationException rie) {
            throw new PersistenceException(rie);
        }
    }

    @Override
    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        Object res = super.createObject();
        if (this.runtimeParams != null) {
            this.runtimeParams = PersistenceManager.getTransientRepresentation(this.runtimeParams, this.containingControllerName, this.initParamOverrides);
            ((Resource)res).setParameterValues((FeatureMap)this.runtimeParams);
        }
        return res;
    }
}

