/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.event.StatusListener;
import gate.swing.MenuLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class XJMenu
extends JMenu {
    protected StatusListener listener;
    private String description;

    public XJMenu() {
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(Action a) {
        super(a);
        this.setToolTipText(null);
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(Action a, StatusListener listener) {
        super(a);
        this.description = (String)a.getValue("ShortDescription");
        this.listener = listener;
        this.setToolTipText(null);
        this.initListeners();
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(String s) {
        super(s);
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(String s, String description, StatusListener listener) {
        super(s);
        this.description = description;
        this.listener = listener;
        this.initListeners();
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    public XJMenu(String s, boolean b) {
        super(s, b);
        this.getPopupMenu().setLayout(new MenuLayout());
    }

    @Override
    public void setPopupMenuVisible(boolean aFlag) {
        super.setPopupMenuVisible(aFlag);
        if (!aFlag) {
            return;
        }
        MenuLayout layout = (MenuLayout)this.getPopupMenu().getLayout();
        for (int i = 0; i < this.getMenuComponents().length; ++i) {
            Component component = this.getMenuComponents()[i];
            if (!(component instanceof JSeparator)) continue;
            JSeparator separator = (JSeparator)component;
            int column = layout.getColumnForComponentIndex(i);
            int preferredWidth = layout.getPreferredWidthForColumn(column);
            separator.setPreferredSize(new Dimension(preferredWidth, separator.getHeight()));
        }
        this.getPopupMenu().revalidate();
    }

    protected void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                XJMenu.this.listener.statusChanged("");
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                XJMenu.this.listener.statusChanged(XJMenu.this.description);
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                XJMenu.this.listener.statusChanged("");
            }

            @Override
            public void menuSelected(MenuEvent e) {
            }
        });
    }
}

