/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.swing.TreeTableModel;
import gate.swing.XJTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class JTreeTable
extends XJTable {
    protected CustomJTree tree;
    protected TreeTableModel treeTableModel;
    protected TreeTableModelAdapter modelAdapter;

    public JTreeTable(TreeTableModel model) {
        this.treeTableModel = model;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        super.setSortable(false);
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.tree = new CustomJTree();
        this.tree.setModel(this.treeTableModel);
        this.tree.setEditable(false);
        this.modelAdapter = new TreeTableModelAdapter(this.treeTableModel);
        super.setModel(this.modelAdapter);
        this.tree.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                JTreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.setAutoCreateColumnsFromModel(false);
        this.getColumnModel().getColumn(0).setCellRenderer(new TreeTableCellRenderer());
        this.getColumnModel().getColumn(0).setCellEditor(new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setRowMargin(0);
    }

    protected void initListeners() {
        this.addMouseListener(new MouseHandler());
        this.getColumnModel().getColumn(0).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("width")) {
                    int width = ((Number)e.getNewValue()).intValue();
                    int height = JTreeTable.this.tree.getSize().height;
                    JTreeTable.this.tree.setSize(width, height);
                }
            }
        });
    }

    @Override
    public void setSortable(boolean b) {
        throw new UnsupportedOperationException("A JTreeTable component cannot be sortable!\nThe rows order is defined by the tree structure.");
    }

    public JTree getTree() {
        return this.tree;
    }

    public void expandPath(TreePath path) {
        this.tree.expandPath(path);
    }

    public void expandRow(int row) {
        this.tree.expandRow(row);
    }

    class CustomJTree
    extends JTree {
        protected int visibleRow;

        CustomJTree() {
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setRowHeight(0);
        }

        public void setVisibleRow(int row) {
            this.visibleRow = row;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle rowBounds = this.getRowBounds(this.visibleRow);
            g.translate(0, -rowBounds.y);
            Rectangle oldClip = g.getClipBounds();
            int newY = Math.max(oldClip.y, rowBounds.y);
            int newHeight = Math.min(rowBounds.height - (rowBounds.y - newY), oldClip.height);
            g.setClip(oldClip.x, newY, oldClip.width, newHeight);
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, this.getRowBounds((int)this.visibleRow).height);
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void setRootVisible(boolean rootVisible) {
            boolean oldValue = this.isRootVisible();
            if (oldValue != rootVisible) {
                super.setRootVisible(rootVisible);
                JTreeTable.this.modelAdapter.fireTableDataChanged();
            }
        }
    }

    class TreeTableModelAdapter
    extends AbstractTableModel {
        public TreeTableModelAdapter(TreeTableModel treeTableModel) {
            JTreeTable.this.tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
            JTreeTable.this.tree.getModel().addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        @Override
        public int getColumnCount() {
            return JTreeTable.this.treeTableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return JTreeTable.this.treeTableModel.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return JTreeTable.this.treeTableModel.getColumnClass(column);
        }

        @Override
        public int getRowCount() {
            return JTreeTable.this.tree.getRowCount();
        }

        protected Object nodeForRow(int row) {
            TreePath treePath = JTreeTable.this.tree.getPathForRow(row);
            return treePath.getLastPathComponent();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return JTreeTable.this.treeTableModel;
            }
            return JTreeTable.this.treeTableModel.getValueAt(this.nodeForRow(row), column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return JTreeTable.this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Object node = this.nodeForRow(row);
            JTreeTable.this.treeTableModel.setValueAt(value, node, column);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (JTreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(e));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (JTreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(e));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (JTreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(e));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (JTreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(e));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (JTreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(e));
            }
        }

        protected MouseEvent convertEvent(MouseEvent e) {
            int column = 0;
            int row = JTreeTable.this.rowAtPoint(e.getPoint());
            Rectangle tableCellRect = JTreeTable.this.getCellRect(row, column, false);
            Rectangle treeCellRect = JTreeTable.this.tree.getRowBounds(row);
            int dx = 0;
            if (tableCellRect != null) {
                dx = -tableCellRect.x;
            }
            int dy = 0;
            if (tableCellRect != null && treeCellRect != null) {
                dy = treeCellRect.y - tableCellRect.y;
            }
            e.translatePoint(dx, dy);
            return new MouseEvent(JTreeTable.this.tree, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
        }
    }

    class TreeTableCellEditor
    extends DefaultCellEditor {
        TreeCellEditor editor;
        Component editorComponent;

        TreeTableCellEditor() {
            super(new JTextField());
            this.editor = JTreeTable.this.tree.getCellEditor();
            this.setClickCountToStart(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editor = JTreeTable.this.tree.getCellEditor();
            this.editor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    TreeTableCellEditor.this.fireEditingStopped();
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                    TreeTableCellEditor.this.fireEditingCanceled();
                }
            });
            this.editorComponent = this.editor.getTreeCellEditorComponent(JTreeTable.this.tree, JTreeTable.this.tree.getPathForRow(row).getLastPathComponent(), isSelected, JTreeTable.this.tree.isExpanded(row), JTreeTable.this.tree.getModel().isLeaf(JTreeTable.this.tree.getPathForRow(row).getLastPathComponent()), row);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(JTreeTable.this.tree.getRowBounds((int)row).x));
            box.add(this.editorComponent);
            return box;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor == null ? null : this.editor.getCellEditorValue();
        }

        @Override
        public boolean stopCellEditing() {
            return this.editor == null ? true : this.editor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (this.editor != null) {
                this.editor.cancelCellEditing();
            }
        }
    }

    public class TreeTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTreeTable.this.tree.setVisibleRow(row);
            return JTreeTable.this.tree;
        }
    }
}

