/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class OntologyIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        Shape shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(37.045452, 17.544512);
        shape.curveTo(54.045452, 39.544514, 54.045452, 39.544514, 54.045452, 39.544514);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0455467f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(10.116883, 40.56625);
        shape.lineTo(24.974026, 19.522774);
        shape.lineTo(24.974026, 19.522774);
        shape.lineTo(24.974026, 19.522774);
        shape.lineTo(24.974026, 19.522774);
        shape.lineTo(24.974026, 19.522774);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OntologyIcon.getColor(255, 0, 0, 255, disabled);
        shape = new Rectangle2D.Double(43.16930389404297, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(43.16930389404297, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new RadialGradientPaint(new Point2D.Double(57.67424011230469, 18.084186553955078), 32.5f, new Point2D.Double(57.67424011230469, 18.084186553955078), new float[]{0.0f, 1.0f}, new Color[]{OntologyIcon.getColor(255, 146, 0, 255, disabled), OntologyIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-0.052389f, 4.064497E-4f, -0.003612995f, -0.489369f, 65.58754f, 48.62901f));
        shape = new Rectangle2D.Double(43.16930389404297, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(43.16930389404297, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        float alpha__0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_4 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new RadialGradientPaint(new Point2D.Double(68.20856475830078, 14.831014633178711), 32.5f, new Point2D.Double(68.20856475830078, 14.831014633178711), new float[]{0.0f, 1.0f}, new Color[]{OntologyIcon.getColor(255, 146, 0, 255, disabled), OntologyIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.251259E-4f, -0.05370551f, 0.567265f, 0.001388834f, 48.73617f, 40.55626f));
        shape = new Rectangle2D.Double(43.16930389404297, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(43.16930389404297, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_4;
        g.setTransform(defaultTransform__0_0_4);
        g.setClip(clip__0_0_4);
        float alpha__0_0_5 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_5 = g.getClip();
        AffineTransform defaultTransform__0_0_5 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OntologyIcon.getColor(255, 0, 0, 255, disabled);
        shape = new Rectangle2D.Double(21.71475601196289, 3.694979429244995, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(21.71475601196289, 3.694979429244995, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_5;
        g.setTransform(defaultTransform__0_0_5);
        g.setClip(clip__0_0_5);
        float alpha__0_0_6 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_6 = g.getClip();
        AffineTransform defaultTransform__0_0_6 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new RadialGradientPaint(new Point2D.Double(57.67424011230469, 18.084186553955078), 32.5f, new Point2D.Double(57.67424011230469, 18.084186553955078), new float[]{0.0f, 1.0f}, new Color[]{OntologyIcon.getColor(255, 146, 0, 255, disabled), OntologyIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-0.052389f, 4.064497E-4f, -0.003612995f, -0.489369f, 44.133f, 16.62901f));
        shape = new Rectangle2D.Double(21.71475601196289, 3.694979429244995, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(21.71475601196289, 3.694979429244995, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_6;
        g.setTransform(defaultTransform__0_0_6);
        g.setClip(clip__0_0_6);
        float alpha__0_0_7 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_7 = g.getClip();
        AffineTransform defaultTransform__0_0_7 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new RadialGradientPaint(new Point2D.Double(68.20856475830078, 14.831014633178711), 32.5f, new Point2D.Double(68.20856475830078, 14.831014633178711), new float[]{0.0f, 1.0f}, new Color[]{OntologyIcon.getColor(255, 146, 0, 255, disabled), OntologyIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.251259E-4f, -0.05370551f, 0.567265f, 0.001388834f, 27.28163f, 8.556262f));
        shape = new Rectangle2D.Double(21.71475601196289, 3.694979429244995, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(21.71475601196289, 3.694979429244995, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_7;
        g.setTransform(defaultTransform__0_0_7);
        g.setClip(clip__0_0_7);
        float alpha__0_0_8 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_8 = g.getClip();
        AffineTransform defaultTransform__0_0_8 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = OntologyIcon.getColor(255, 0, 0, 255, disabled);
        shape = new Rectangle2D.Double(0.2543855f, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(0.2543855f, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_8;
        g.setTransform(defaultTransform__0_0_8);
        g.setClip(clip__0_0_8);
        float alpha__0_0_9 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_9 = g.getClip();
        AffineTransform defaultTransform__0_0_9 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new RadialGradientPaint(new Point2D.Double(57.67424011230469, 18.084186553955078), 32.5f, new Point2D.Double(57.67424011230469, 18.084186553955078), new float[]{0.0f, 1.0f}, new Color[]{OntologyIcon.getColor(255, 146, 0, 255, disabled), OntologyIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-0.052389f, 4.064497E-4f, -0.003612995f, -0.489369f, 22.67263f, 48.62901f));
        shape = new Rectangle2D.Double(0.2543855f, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(0.2543855f, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_9;
        g.setTransform(defaultTransform__0_0_9);
        g.setClip(clip__0_0_9);
        float alpha__0_0_10 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_10 = g.getClip();
        AffineTransform defaultTransform__0_0_10 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new RadialGradientPaint(new Point2D.Double(68.20856475830078, 14.831014633178711), 32.5f, new Point2D.Double(68.20856475830078, 14.831014633178711), new float[]{0.0f, 1.0f}, new Color[]{OntologyIcon.getColor(255, 146, 0, 255, disabled), OntologyIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.251259E-4f, -0.05370551f, 0.567265f, 0.001388834f, 5.869625f, 40.55626f));
        shape = new Rectangle2D.Double(0.3027527630329132, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.fill(shape);
        paint = OntologyIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.3269536f, 0, 0, 4.0f, null, 0.0f);
        shape = new Rectangle2D.Double(0.3027527630329132, 35.69498062133789, 20.667221069335938, 21.18605613708496);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_10;
        g.setTransform(defaultTransform__0_0_10);
        g.setClip(clip__0_0_10);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 1;
    }

    public static int getOrigY() {
        return 4;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public OntologyIcon() {
        this(OntologyIcon.getOrigWidth(), OntologyIcon.getOrigHeight(), false);
    }

    public OntologyIcon(boolean disabled) {
        this(OntologyIcon.getOrigWidth(), OntologyIcon.getOrigHeight(), disabled);
    }

    public OntologyIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public OntologyIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public OntologyIcon(int width, int height) {
        this(width, height, false);
    }

    public OntologyIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)OntologyIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)OntologyIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        OntologyIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

