/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class AddIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = AddIcon.getColor(117, 161, 208, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(27.514357, 37.542683);
        shape.lineTo(27.514357, 28.515722);
        shape.lineTo(37.49282, 28.475542);
        shape.lineTo(37.49282, 21.480219);
        shape.lineTo(27.523285, 21.480219);
        shape.lineTo(27.514357, 11.520049);
        shape.lineTo(20.498081, 11.53121);
        shape.lineTo(20.502546, 21.462362);
        shape.lineTo(10.51292, 21.536022);
        shape.lineTo(10.477206, 28.50456);
        shape.lineTo(20.511475, 28.475542);
        shape.lineTo(20.518171, 37.515896);
        shape.lineTo(27.514357, 37.542683);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = AddIcon.getColor(52, 101, 164, 255, disabled);
        stroke = new BasicStroke(1.0000004f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(27.514357, 37.542683);
        shape.lineTo(27.514357, 28.515722);
        shape.lineTo(37.49282, 28.475542);
        shape.lineTo(37.49282, 21.480219);
        shape.lineTo(27.523285, 21.480219);
        shape.lineTo(27.514357, 11.520049);
        shape.lineTo(20.498081, 11.53121);
        shape.lineTo(20.502546, 21.462362);
        shape.lineTo(10.51292, 21.536022);
        shape.lineTo(10.477206, 28.50456);
        shape.lineTo(20.511475, 28.475542);
        shape.lineTo(20.518171, 37.515896);
        shape.lineTo(27.514357, 37.542683);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.40860215f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(34.89284896850586, 36.42298889160156), new Point2D.Double(45.918697357177734, 48.54798889160156), new float[]{0.0f, 1.0f}, new Color[]{AddIcon.getColor(114, 159, 207, 255, disabled), AddIcon.getColor(81, 135, 214, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -18.01785f, -13.57119f));
        shape = new GeneralPath();
        shape.moveTo(26.498701, 36.53392);
        shape.lineTo(26.498701, 27.499739);
        shape.lineTo(36.501305, 27.499739);
        shape.lineTo(36.494606, 22.47531);
        shape.lineTo(26.50763, 22.47531);
        shape.lineTo(26.50763, 12.480335);
        shape.lineTo(21.512796, 12.498193);
        shape.lineTo(21.521725, 22.47531);
        shape.lineTo(11.495536, 22.493166);
        shape.lineTo(11.46875, 27.466255);
        shape.lineTo(21.533142, 27.475185);
        shape.lineTo(21.51975, 36.50267);
        shape.lineTo(26.498701, 36.53392);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = new LinearGradientPaint(new Point2D.Double(16.874998092651367, 22.85179901123047), new Point2D.Double(27.900846481323242, 34.9768f), new float[]{0.0f, 1.0f}, new Color[]{AddIcon.getColor(255, 255, 255, 255, disabled), AddIcon.getColor(255, 255, 255, 87, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        stroke = new BasicStroke(1.0000006f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.498701, 36.53392);
        shape.lineTo(26.498701, 27.499739);
        shape.lineTo(36.501305, 27.499739);
        shape.lineTo(36.494606, 22.47531);
        shape.lineTo(26.50763, 22.47531);
        shape.lineTo(26.50763, 12.480335);
        shape.lineTo(21.512796, 12.498193);
        shape.lineTo(21.521725, 22.47531);
        shape.lineTo(11.495536, 22.493166);
        shape.lineTo(11.46875, 27.466255);
        shape.lineTo(21.533142, 27.475185);
        shape.lineTo(21.51975, 36.50267);
        shape.lineTo(26.498701, 36.53392);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.31182796f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = AddIcon.getColor(255, 255, 255, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(11.0, 25.0);
        shape.curveTo(11.0, 26.9375, 36.984375, 24.03125, 36.984375, 24.96875);
        shape.lineTo(36.984375, 21.96875);
        shape.lineTo(27.0, 22.0);
        shape.lineTo(27.0, 12.034772);
        shape.lineTo(21.0, 12.034772);
        shape.lineTo(21.0, 22.0);
        shape.lineTo(11.0, 22.0);
        shape.lineTo(11.0, 25.0);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 10;
    }

    public static int getOrigY() {
        return 12;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public AddIcon() {
        this(AddIcon.getOrigWidth(), AddIcon.getOrigHeight(), false);
    }

    public AddIcon(boolean disabled) {
        this(AddIcon.getOrigWidth(), AddIcon.getOrigHeight(), disabled);
    }

    public AddIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public AddIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public AddIcon(int width, int height) {
        this(width, height, false);
    }

    public AddIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)AddIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)AddIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        AddIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

