/*
 * Decompiled with CFR 0.152.
 */
package gate.relations;

import gate.relations.Relation;
import gate.relations.RelationSet;
import java.util.ArrayList;
import java.util.TreeSet;

public class RelationsUtils {
    public static int[] transitiveClosure(RelationSet relSet, String relationName, int annotationId) {
        Object constraint;
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (int pos = 0; pos < relSet.getMaximumArity(); ++pos) {
            constraint = new int[pos + 1];
            for (int i = 0; i < pos; ++i) {
                constraint[i] = -1;
            }
            constraint[pos] = annotationId;
            relations.addAll(relSet.getRelations(relationName, (int[])constraint));
        }
        TreeSet<Integer> closure = new TreeSet<Integer>();
        closure.add(annotationId);
        constraint = relations.iterator();
        while (constraint.hasNext()) {
            Relation rel = (Relation)constraint.next();
            for (int annId : rel.getMembers()) {
                closure.add(annId);
            }
        }
        int[] res = new int[closure.size()];
        int i = 0;
        Object object = closure.iterator();
        while (object.hasNext()) {
            int annId = (Integer)object.next();
            res[i++] = annId;
        }
        return res;
    }
}

