/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.AnnotationSet;
import gate.Document;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.DocumentEvent;
import gate.event.DocumentListener;
import gate.event.RelationSetEvent;
import gate.event.RelationSetListener;
import gate.gui.MainFrame;
import gate.relations.RelationSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.JToolBar;

@CreoleResource(name="Relation Viewer", guiType=GuiType.LARGE, resourceDisplayed="gate.Document")
public class RelationSetView
extends AbstractVisualResource
implements DocumentListener,
AnnotationSetListener,
RelationSetListener {
    private static final long serialVersionUID = 2976754146115707386L;
    private JTextPane text = new JTextPane();
    private Document doc = null;

    @Override
    public Resource init() {
        this.setLayout(new BorderLayout());
        this.text.setEditable(false);
        this.add((Component)this.text, "Center");
        JButton btnRefresh = new JButton("Refresh", MainFrame.getIcon("Refresh"));
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RelationSetView.this.refresh();
            }
        });
        JToolBar toolbar = new JToolBar(0);
        toolbar.setFloatable(false);
        toolbar.add(btnRefresh);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Currently this view is not automatically updated"));
        return this;
    }

    private void refresh() {
        if (this.doc == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        RelationSet relations = this.doc.getAnnotations().getRelations();
        if (relations.size() > 0) {
            builder.append(relations).append("\n\n");
        }
        for (String name : this.doc.getAnnotationSetNames()) {
            relations = this.doc.getAnnotations(name).getRelations();
            if (relations.size() <= 0) continue;
            builder.append(name).append(":\n").append(relations).append("\n\n");
        }
        this.text.setText(builder.toString());
    }

    @Override
    public void setTarget(Object target) {
        AnnotationSet as;
        if (this.doc != null) {
            this.doc.removeDocumentListener(this);
            this.doc.getAnnotations().removeAnnotationSetListener(this);
            this.doc.getAnnotations().getRelations().removeRelationSetListener(this);
            for (String name : this.doc.getAnnotationSetNames()) {
                as = this.doc.getAnnotations(name);
                as.removeAnnotationSetListener(this);
                as.getRelations().removeRelationSetListener(this);
            }
        }
        this.doc = (Document)target;
        this.doc.addDocumentListener(this);
        this.doc.getAnnotations().addAnnotationSetListener(this);
        this.doc.getAnnotations().getRelations().addRelationSetListener(this);
        for (String name : this.doc.getAnnotationSetNames()) {
            as = this.doc.getAnnotations(name);
            as.addAnnotationSetListener(this);
            as.getRelations().addRelationSetListener(this);
        }
        this.refresh();
    }

    @Override
    public void annotationSetAdded(DocumentEvent e) {
        this.doc.getAnnotations(e.getAnnotationSetName()).addAnnotationSetListener(this);
        this.refresh();
    }

    @Override
    public void annotationSetRemoved(DocumentEvent e) {
        this.doc.getAnnotations(e.getAnnotationSetName()).removeAnnotationSetListener(this);
        this.refresh();
    }

    @Override
    public void contentEdited(DocumentEvent e) {
    }

    @Override
    public void annotationAdded(AnnotationSetEvent e) {
        this.refresh();
    }

    @Override
    public void annotationRemoved(AnnotationSetEvent e) {
        this.refresh();
    }

    @Override
    public void relationAdded(RelationSetEvent e) {
        this.refresh();
    }

    @Override
    public void relationRemoved(RelationSetEvent e) {
        this.refresh();
    }
}

