/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.annedit;

import gate.Annotation;
import gate.Factory;
import gate.FeatureMap;
import gate.event.AnnotationSetListener;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.annedit.SearchExpressionsAction;
import gate.resources.img.svg.ClosedIcon;
import gate.resources.img.svg.ExpandedIcon;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Highlighter;

public class SearchAndAnnotatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private OwnedAnnotationEditor annotationEditor;
    private Window annotationEditorWindow;
    protected AnnotationSetListener annotationSetListener;
    protected Box searchBox;
    protected JPanel searchPane;
    protected JTextField searchTextField;
    protected JCheckBox searchRegExpChk;
    protected JButton helpRegExpButton;
    protected JCheckBox searchCaseSensChk;
    protected JCheckBox searchWholeWordsChk;
    protected JCheckBox searchHighlightsChk;
    protected JCheckBox searchEnabledCheck;
    protected Matcher matcher;
    protected FindFirstAction findFirstAction;
    protected FindPreviousAction findPreviousAction;
    protected FindNextAction findNextAction;
    protected AnnotateMatchAction annotateMatchAction;
    protected AnnotateAllMatchesAction annotateAllMatchesAction;
    protected UndoAnnotateAllMatchesAction undoAnnotateAllMatchesAction;
    protected int nextMatchStartsFrom;
    protected String content;
    protected LinkedList<Vector<Integer>> matchedIndexes;
    protected LinkedList<Annotation> annotateAllAnnotationsID;
    protected SmallButton firstSmallButton;
    protected SmallButton annotateAllMatchesSmallButton;

    public SearchAndAnnotatePanel(Color color, OwnedAnnotationEditor annotationEditor, Window window) {
        this.annotationEditor = annotationEditor;
        this.annotationEditorWindow = window;
        this.initGui(color);
        this.searchBox.remove(this.searchPane);
        this.searchCaseSensChk.setVisible(false);
        this.searchRegExpChk.setVisible(false);
        this.searchWholeWordsChk.setVisible(false);
        this.searchHighlightsChk.setVisible(false);
        this.getOwner().getTextComponent().requestFocusInWindow();
        this.initListeners();
        this.content = this.getOwner().getDocument().getContent().toString();
    }

    protected void initGui(Color color) {
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BoxLayout(mainPane, 1));
        mainPane.setBackground(color);
        mainPane.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)mainPane, "Center");
        this.searchBox = Box.createVerticalBox();
        String aTitle = "Open Search & Annotate tool";
        JLabel label = new JLabel(aTitle);
        this.searchBox.setMinimumSize(new Dimension(label.getPreferredSize().width, 0));
        this.searchBox.setAlignmentX(0.0f);
        JPanel firstLinePane = new JPanel();
        firstLinePane.setAlignmentX(0.0f);
        firstLinePane.setAlignmentY(0.0f);
        firstLinePane.setLayout(new BoxLayout(firstLinePane, 1));
        firstLinePane.setBackground(color);
        Box hBox = Box.createHorizontalBox();
        this.searchEnabledCheck = new JCheckBox(aTitle, new ClosedIcon(12, 12), false);
        this.searchEnabledCheck.setSelectedIcon(new ExpandedIcon(12, 12));
        this.searchEnabledCheck.setBackground(color);
        this.searchEnabledCheck.setToolTipText("<html>Allows to search for an expression and<br>annotate one or all the matches.</html>");
        hBox.add(this.searchEnabledCheck);
        hBox.add(Box.createHorizontalStrut(5));
        this.searchCaseSensChk = new JCheckBox("Case", true);
        this.searchCaseSensChk.setToolTipText("Case sensitive search.");
        this.searchCaseSensChk.setBackground(color);
        hBox.add(this.searchCaseSensChk);
        hBox.add(Box.createHorizontalStrut(5));
        this.searchRegExpChk = new JCheckBox("Regexp", false);
        this.searchRegExpChk.setToolTipText("Regular expression search.");
        this.searchRegExpChk.setBackground(color);
        hBox.add(this.searchRegExpChk);
        hBox.add(Box.createHorizontalStrut(5));
        this.searchWholeWordsChk = new JCheckBox("Whole", false);
        this.searchWholeWordsChk.setBackground(color);
        this.searchWholeWordsChk.setToolTipText("Whole word search.");
        hBox.add(this.searchWholeWordsChk);
        hBox.add(Box.createHorizontalStrut(5));
        this.searchHighlightsChk = new JCheckBox("Highlights", false);
        this.searchHighlightsChk.setToolTipText("Restrict the search on the highlighted annotations.");
        this.searchHighlightsChk.setBackground(color);
        hBox.add(this.searchHighlightsChk);
        hBox.add(Box.createHorizontalGlue());
        firstLinePane.add(hBox);
        this.searchBox.add(firstLinePane);
        this.searchPane = new JPanel();
        this.searchPane.setAlignmentX(0.0f);
        this.searchPane.setAlignmentY(0.0f);
        this.searchPane.setLayout(new BoxLayout(this.searchPane, 1));
        this.searchPane.setBackground(color);
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(3, 0, 5, 0));
        hBox.add(Box.createHorizontalStrut(5));
        this.searchTextField = new JTextField(10);
        this.searchTextField.setToolTipText("Enter an expression to search for.");
        this.searchTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.searchTextField.getPreferredSize().height));
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchAndAnnotatePanel.this.findFirstAction.actionPerformed(null);
            }
        });
        hBox.add(this.searchTextField);
        hBox.add(Box.createHorizontalStrut(2));
        this.helpRegExpButton = new JButton("?");
        this.helpRegExpButton.setMargin(new Insets(0, 2, 0, 2));
        this.helpRegExpButton.setToolTipText("GATE search expression builder.");
        this.helpRegExpButton.addActionListener(new SearchExpressionsAction(this.searchTextField, this.annotationEditorWindow, this.searchRegExpChk));
        hBox.add(this.helpRegExpButton);
        hBox.add(Box.createHorizontalGlue());
        this.searchPane.add(hBox);
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.findFirstAction = new FindFirstAction();
        this.firstSmallButton = new SmallButton(this.findFirstAction);
        hBox.add(this.firstSmallButton);
        hBox.add(Box.createHorizontalStrut(5));
        this.findPreviousAction = new FindPreviousAction();
        this.findPreviousAction.setEnabled(false);
        hBox.add(new SmallButton(this.findPreviousAction));
        hBox.add(Box.createHorizontalStrut(5));
        this.findNextAction = new FindNextAction();
        this.findNextAction.setEnabled(false);
        hBox.add(new SmallButton(this.findNextAction));
        hBox.add(Box.createHorizontalStrut(5));
        this.annotateMatchAction = new AnnotateMatchAction();
        this.annotateMatchAction.setEnabled(false);
        hBox.add(new SmallButton(this.annotateMatchAction));
        hBox.add(Box.createHorizontalStrut(5));
        this.annotateAllMatchesAction = new AnnotateAllMatchesAction();
        this.undoAnnotateAllMatchesAction = new UndoAnnotateAllMatchesAction();
        this.annotateAllMatchesSmallButton = new SmallButton(this.annotateAllMatchesAction);
        this.annotateAllMatchesAction.setEnabled(false);
        this.undoAnnotateAllMatchesAction.setEnabled(false);
        hBox.add(this.annotateAllMatchesSmallButton);
        hBox.add(Box.createHorizontalStrut(5));
        this.searchPane.add(hBox);
        this.searchBox.add(this.searchPane);
        mainPane.add(this.searchBox);
    }

    protected void initListeners() {
        this.searchEnabledCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchAndAnnotatePanel.this.searchEnabledCheck.isSelected()) {
                    if (!SearchAndAnnotatePanel.this.searchBox.isAncestorOf(SearchAndAnnotatePanel.this.searchPane)) {
                        String searchText = SearchAndAnnotatePanel.this.searchTextField.getText();
                        if ((searchText == null || searchText.trim().length() == 0) && SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited() != null && SearchAndAnnotatePanel.this.getOwner() != null) {
                            String annText = SearchAndAnnotatePanel.this.getOwner().getDocument().getContent().toString().substring(SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getStartNode().getOffset().intValue(), SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getEndNode().getOffset().intValue());
                            SearchAndAnnotatePanel.this.searchTextField.setText(annText);
                        }
                        SearchAndAnnotatePanel.this.searchBox.add(SearchAndAnnotatePanel.this.searchPane);
                    }
                    SearchAndAnnotatePanel.this.searchEnabledCheck.setText("");
                    SearchAndAnnotatePanel.this.searchCaseSensChk.setVisible(true);
                    SearchAndAnnotatePanel.this.searchRegExpChk.setVisible(true);
                    SearchAndAnnotatePanel.this.searchWholeWordsChk.setVisible(true);
                    SearchAndAnnotatePanel.this.searchHighlightsChk.setVisible(true);
                    SearchAndAnnotatePanel.this.searchTextField.requestFocusInWindow();
                    SearchAndAnnotatePanel.this.searchTextField.selectAll();
                    SearchAndAnnotatePanel.this.annotationEditorWindow.pack();
                    SearchAndAnnotatePanel.this.annotationEditor.setPinnedMode(true);
                } else if (SearchAndAnnotatePanel.this.searchBox.isAncestorOf(SearchAndAnnotatePanel.this.searchPane)) {
                    SearchAndAnnotatePanel.this.searchEnabledCheck.setText("Open Search & Annotate tool");
                    SearchAndAnnotatePanel.this.searchBox.remove(SearchAndAnnotatePanel.this.searchPane);
                    SearchAndAnnotatePanel.this.searchCaseSensChk.setVisible(false);
                    SearchAndAnnotatePanel.this.searchRegExpChk.setVisible(false);
                    SearchAndAnnotatePanel.this.searchWholeWordsChk.setVisible(false);
                    SearchAndAnnotatePanel.this.searchHighlightsChk.setVisible(false);
                    if (SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited() != null) {
                        SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(true);
                    }
                    SearchAndAnnotatePanel.this.annotationEditorWindow.pack();
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (SearchAndAnnotatePanel.this.searchTextField.getText().trim().length() == 0 && SearchAndAnnotatePanel.this.getOwner().getTextComponent().getSelectedText() != null) {
                    SearchAndAnnotatePanel.this.searchTextField.setText(SearchAndAnnotatePanel.this.getOwner().getTextComponent().getSelectedText());
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
        this.searchCaseSensChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
        this.searchRegExpChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
        this.searchWholeWordsChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
        this.searchHighlightsChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchAndAnnotatePanel.this.enableActions(false);
            }
        });
    }

    private void enableActions(boolean state) {
        this.findPreviousAction.setEnabled(state);
        this.findNextAction.setEnabled(state);
        this.annotateMatchAction.setEnabled(state);
        this.annotateAllMatchesAction.setEnabled(state);
        if (this.annotateAllMatchesSmallButton.getAction().equals(this.undoAnnotateAllMatchesAction)) {
            this.annotateAllMatchesSmallButton.setAction(this.annotateAllMatchesAction);
        }
    }

    private boolean isAnnotationEditorReady() {
        if (!this.annotationEditor.editingFinished() || this.getOwner() == null || this.annotationEditor.getAnnotationCurrentlyEdited() == null || this.annotationEditor.getAnnotationSetCurrentlyEdited() == null) {
            this.annotationEditorWindow.setVisible(false);
            JOptionPane.showMessageDialog(this.annotationEditorWindow, this.annotationEditor.getAnnotationCurrentlyEdited() == null ? "Please select an existing annotation\nor create a new one then select it." : "Please set all required features in the feature table.", "GATE", 1);
            this.annotationEditorWindow.setVisible(true);
            return false;
        }
        return true;
    }

    public AnnotationEditorOwner getOwner() {
        return this.annotationEditor.getOwner();
    }

    protected class SmallButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public SmallButton(Action a) {
            super(a);
            this.setMargin(new Insets(0, 2, 0, 2));
        }
    }

    protected class UndoAnnotateAllMatchesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAnnotateAllMatchesAction() {
            super("Undo");
            super.putValue("ShortDescription", "Undo previous annotate all action.");
            super.putValue("MnemonicKey", 85);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (Annotation annotation : SearchAndAnnotatePanel.this.annotateAllAnnotationsID) {
                SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().remove(annotation);
            }
            if (SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited() == null) {
                SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(false);
            }
            SearchAndAnnotatePanel.this.annotateAllMatchesSmallButton.setAction(SearchAndAnnotatePanel.this.annotateAllMatchesAction);
            SearchAndAnnotatePanel.this.annotateAllMatchesAction.setEnabled(false);
        }
    }

    protected class AnnotateAllMatchesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AnnotateAllMatchesAction() {
            super("Ann. all next");
            super.putValue("ShortDescription", "Annotates all the following matches.");
            super.putValue("MnemonicKey", 76);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            SearchAndAnnotatePanel.this.annotateAllAnnotationsID = new LinkedList();
            boolean found = false;
            int start = -1;
            int end = -1;
            SearchAndAnnotatePanel.this.nextMatchStartsFrom = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getCaretPosition();
            do {
                found = false;
                while (SearchAndAnnotatePanel.this.matcher.find(SearchAndAnnotatePanel.this.nextMatchStartsFrom) && !found) {
                    start = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.start(1) : SearchAndAnnotatePanel.this.matcher.start();
                    int n = end = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.end(1) : SearchAndAnnotatePanel.this.matcher.end();
                    if (SearchAndAnnotatePanel.this.searchHighlightsChk.isSelected()) {
                        Highlighter.Highlight[] highlights;
                        for (Highlighter.Highlight h : highlights = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getHighlighter().getHighlights()) {
                            if (h.getStartOffset() > start || h.getEndOffset() < end) continue;
                            found = true;
                            break;
                        }
                    } else {
                        found = true;
                    }
                    SearchAndAnnotatePanel.this.nextMatchStartsFrom = end;
                }
                if (!found) continue;
                this.annotateCurrentMatch(start, end);
            } while (found && !SearchAndAnnotatePanel.this.matcher.hitEnd());
            SearchAndAnnotatePanel.this.annotateAllMatchesSmallButton.setAction(SearchAndAnnotatePanel.this.undoAnnotateAllMatchesAction);
            SearchAndAnnotatePanel.this.undoAnnotateAllMatchesAction.setEnabled(true);
        }

        private void annotateCurrentMatch(int start, int end) {
            FeatureMap features = Factory.newFeatureMap();
            features.put("safe.regex", "true");
            if (SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getFeatures() != null) {
                features.putAll(SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getFeatures());
            }
            try {
                Integer id = SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().add(new Long(start), new Long(end), SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getType(), features);
                Annotation newAnn = SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().get(id);
                SearchAndAnnotatePanel.this.annotateAllAnnotationsID.add(newAnn);
            }
            catch (InvalidOffsetException e) {
                throw new GateRuntimeException(e);
            }
        }
    }

    protected class AnnotateMatchAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AnnotateMatchAction() {
            super("Annotate");
            super.putValue("ShortDescription", "Annotates the current match.");
            super.putValue("MnemonicKey", 65);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            int start = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getSelectionStart();
            int end = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getSelectionEnd();
            FeatureMap features = Factory.newFeatureMap();
            if (SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getFeatures() != null) {
                features.putAll(SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getFeatures());
            }
            try {
                Integer id = SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().add(new Long(start), new Long(end), SearchAndAnnotatePanel.this.annotationEditor.getAnnotationCurrentlyEdited().getType(), features);
                Annotation newAnn = SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited().get(id);
                SearchAndAnnotatePanel.this.getOwner().getTextComponent().select(end, end);
                SearchAndAnnotatePanel.this.getOwner().selectAnnotation(new AnnotationDataImpl(SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited(), newAnn));
                SearchAndAnnotatePanel.this.annotationEditor.editAnnotation(newAnn, SearchAndAnnotatePanel.this.annotationEditor.getAnnotationSetCurrentlyEdited());
                SearchAndAnnotatePanel.this.annotateAllMatchesAction.setEnabled(true);
                if (SearchAndAnnotatePanel.this.annotateAllMatchesSmallButton.getAction().equals(SearchAndAnnotatePanel.this.undoAnnotateAllMatchesAction)) {
                    SearchAndAnnotatePanel.this.annotateAllMatchesSmallButton.setAction(SearchAndAnnotatePanel.this.annotateAllMatchesAction);
                }
            }
            catch (InvalidOffsetException e) {
                throw new GateRuntimeException(e);
            }
        }
    }

    protected class FindNextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FindNextAction() {
            super("Next");
            super.putValue("ShortDescription", "Finds the next occurrence.");
            super.putValue("MnemonicKey", 78);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(false);
            boolean found = false;
            int start = -1;
            int end = -1;
            SearchAndAnnotatePanel.this.nextMatchStartsFrom = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getCaretPosition();
            while (SearchAndAnnotatePanel.this.matcher.find(SearchAndAnnotatePanel.this.nextMatchStartsFrom) && !found) {
                start = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.start(1) : SearchAndAnnotatePanel.this.matcher.start();
                end = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.end(1) : SearchAndAnnotatePanel.this.matcher.end();
                found = false;
                if (SearchAndAnnotatePanel.this.searchHighlightsChk.isSelected()) {
                    Highlighter.Highlight[] highlights;
                    for (Highlighter.Highlight h : highlights = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getHighlighter().getHighlights()) {
                        if (h.getStartOffset() > start || h.getEndOffset() < end) continue;
                        found = true;
                        break;
                    }
                } else {
                    found = true;
                }
                SearchAndAnnotatePanel.this.nextMatchStartsFrom = end;
            }
            if (found) {
                Vector<Integer> v = new Vector<Integer>(2);
                v.add(start);
                v.add(end);
                SearchAndAnnotatePanel.this.matchedIndexes.add(v);
                SearchAndAnnotatePanel.this.getOwner().getTextComponent().select(start, end);
                SearchAndAnnotatePanel.this.annotationEditor.placeDialog(start, end);
                SearchAndAnnotatePanel.this.findPreviousAction.setEnabled(true);
            } else {
                SearchAndAnnotatePanel.this.findNextAction.setEnabled(false);
                SearchAndAnnotatePanel.this.annotateMatchAction.setEnabled(false);
            }
        }
    }

    protected class FindPreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FindPreviousAction() {
            super("Prev.");
            super.putValue("ShortDescription", "Finds the previous occurrence.");
            super.putValue("MnemonicKey", 80);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(false);
            SearchAndAnnotatePanel.this.matchedIndexes.removeLast();
            if (SearchAndAnnotatePanel.this.matchedIndexes.size() == 1) {
                SearchAndAnnotatePanel.this.findPreviousAction.setEnabled(false);
            }
            Vector<Integer> v = SearchAndAnnotatePanel.this.matchedIndexes.getLast();
            int start = v.firstElement();
            int end = v.lastElement();
            SearchAndAnnotatePanel.this.getOwner().getTextComponent().select(start, end);
            SearchAndAnnotatePanel.this.annotationEditor.placeDialog(start, end);
            SearchAndAnnotatePanel.this.nextMatchStartsFrom = start;
            SearchAndAnnotatePanel.this.findNextAction.setEnabled(true);
            SearchAndAnnotatePanel.this.annotateMatchAction.setEnabled(true);
        }
    }

    protected class FindFirstAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FindFirstAction() {
            super("First");
            super.putValue("ShortDescription", "Finds the first occurrence.");
            super.putValue("MnemonicKey", 70);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Pattern pattern;
            if (!SearchAndAnnotatePanel.this.isAnnotationEditorReady()) {
                return;
            }
            SearchAndAnnotatePanel.this.annotationEditor.setPinnedMode(true);
            SearchAndAnnotatePanel.this.annotationEditor.setEditingEnabled(false);
            String patternText = SearchAndAnnotatePanel.this.searchTextField.getText();
            try {
                String prefixPattern = SearchAndAnnotatePanel.this.searchWholeWordsChk.isSelected() ? "\\b" : "";
                prefixPattern = prefixPattern + (SearchAndAnnotatePanel.this.searchRegExpChk.isSelected() ? "" : "\\Q");
                String suffixPattern = SearchAndAnnotatePanel.this.searchRegExpChk.isSelected() ? "" : "\\E";
                suffixPattern = suffixPattern + (SearchAndAnnotatePanel.this.searchWholeWordsChk.isSelected() ? "\\b" : "");
                patternText = prefixPattern + patternText + suffixPattern;
                pattern = SearchAndAnnotatePanel.this.searchCaseSensChk.isSelected() ? Pattern.compile(patternText) : Pattern.compile(patternText, 2);
            }
            catch (PatternSyntaxException e) {
                SearchAndAnnotatePanel.this.annotationEditorWindow.setVisible(false);
                JOptionPane.showMessageDialog(SearchAndAnnotatePanel.this.annotationEditorWindow, "Invalid regular expression.\n\n" + e.toString().replaceFirst("^.+PatternSyntaxException: ", ""), "GATE", 1);
                SearchAndAnnotatePanel.this.annotationEditorWindow.setVisible(true);
                return;
            }
            SearchAndAnnotatePanel.this.matcher = pattern.matcher(SearchAndAnnotatePanel.this.content);
            boolean found = false;
            int start = -1;
            int end = -1;
            SearchAndAnnotatePanel.this.nextMatchStartsFrom = 0;
            while (SearchAndAnnotatePanel.this.matcher.find(SearchAndAnnotatePanel.this.nextMatchStartsFrom) && !found) {
                start = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.start(1) : SearchAndAnnotatePanel.this.matcher.start();
                end = SearchAndAnnotatePanel.this.matcher.groupCount() > 0 ? SearchAndAnnotatePanel.this.matcher.end(1) : SearchAndAnnotatePanel.this.matcher.end();
                found = false;
                if (SearchAndAnnotatePanel.this.searchHighlightsChk.isSelected()) {
                    Highlighter.Highlight[] highlights;
                    for (Highlighter.Highlight h : highlights = SearchAndAnnotatePanel.this.getOwner().getTextComponent().getHighlighter().getHighlights()) {
                        if (h.getStartOffset() > start || h.getEndOffset() < end) continue;
                        found = true;
                        break;
                    }
                } else {
                    found = true;
                }
                SearchAndAnnotatePanel.this.nextMatchStartsFrom = end;
            }
            if (found) {
                SearchAndAnnotatePanel.this.findNextAction.setEnabled(true);
                SearchAndAnnotatePanel.this.annotateMatchAction.setEnabled(true);
                SearchAndAnnotatePanel.this.annotateAllMatchesAction.setEnabled(false);
                SearchAndAnnotatePanel.this.matchedIndexes = new LinkedList();
                Vector<Integer> v = new Vector<Integer>(2);
                v.add(start);
                v.add(end);
                SearchAndAnnotatePanel.this.matchedIndexes.add(v);
                SearchAndAnnotatePanel.this.getOwner().getTextComponent().select(start, end);
                SearchAndAnnotatePanel.this.annotationEditor.placeDialog(start, end);
            } else {
                SearchAndAnnotatePanel.this.findNextAction.setEnabled(false);
                SearchAndAnnotatePanel.this.annotateMatchAction.setEnabled(false);
            }
            SearchAndAnnotatePanel.this.findPreviousAction.setEnabled(false);
        }
    }
}

