/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Document;
import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.TextualDocument;
import gate.VisualResource;
import gate.creole.AbstractResource;
import gate.creole.AnnotationSchema;
import gate.creole.ConditionalController;
import gate.creole.ConditionalSerialAnalyserController;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.RunningStrategy;
import gate.creole.SerialAnalyserController;
import gate.creole.ir.IndexedCorpus;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.ActionsPublisher;
import gate.gui.CorpusFillerComponent;
import gate.gui.DocumentExportMenu;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.OkCancelDialog;
import gate.gui.ResourceHelper;
import gate.gui.SingleConcatenatedFileInputDialog;
import gate.persist.LuceneDataStoreImpl;
import gate.persist.PersistenceException;
import gate.swing.XJFileChooser;
import gate.swing.XJMenuItem;
import gate.swing.XJPopupMenu;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.GateRuntimeException;
import gate.util.NameBearer;
import gate.util.ant.packager.PackageGappTask;
import gate.util.persistence.PersistenceManager;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

public class NameBearerHandle
implements Handle,
StatusListener,
ProgressListener {
    String tooltipText;
    NameBearer target;
    protected List<ActionsPublisher> actionPublishers;
    protected List<JComponent> staticPopupItems;
    Window window;
    ResourceData rData;
    Icon icon;
    JComponent smallView;
    JComponent largeView;
    protected boolean viewsBuilt = false;
    protected CorpusFillerComponent corpusFiller;
    protected SingleConcatenatedFileInputDialog scfInputDialog;
    StatusListener sListenerProxy;
    private transient Vector<ProgressListener> progressListeners;
    private transient Vector<StatusListener> statusListeners;

    public NameBearerHandle(NameBearer target, Window window) {
        this.target = target;
        this.window = window;
        this.actionPublishers = new ArrayList<ActionsPublisher>();
        this.sListenerProxy = new ProxyStatusListener();
        if (target instanceof Resource) {
            this.rData = (ResourceData)Gate.getCreoleRegister().get(target.getClass().getName());
            String iconName = (String)((Resource)target).getFeatures().get("gate.gui.icon");
            if (iconName != null) {
                this.icon = MainFrame.getIcon(iconName);
            }
            if (this.icon == null) {
                this.icon = this.rData != null ? MainFrame.getIcon(this.rData.getIcon(), this.rData.getResourceClassLoader()) : MainFrame.getIcon("lr");
            }
            if (this.rData != null) {
                this.tooltipText = "<HTML> <b>" + this.rData.getComment() + "</b><br>(<i>" + this.rData.getClassName() + "</i>)</HTML>";
            }
        } else if (target instanceof DataStore) {
            this.icon = MainFrame.getIcon(((DataStore)target).getIconName());
            this.tooltipText = ((DataStore)target).getComment();
        }
        if (target instanceof ActionsPublisher) {
            this.actionPublishers.add((ActionsPublisher)((Object)target));
        }
        this.buildStaticPopupItems();
        this.viewsBuilt = false;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String getTitle() {
        return this.target == null ? null : this.target.getName();
    }

    @Override
    public boolean viewsBuilt() {
        return this.viewsBuilt;
    }

    @Override
    public JComponent getSmallView() {
        if (!this.viewsBuilt) {
            this.buildViews();
        }
        return this.smallView;
    }

    @Override
    public JComponent getLargeView() {
        if (!this.viewsBuilt) {
            this.buildViews();
        }
        return this.largeView;
    }

    @Override
    public JPopupMenu getPopup() {
        XJPopupMenu popup = new XJPopupMenu();
        for (JComponent anItem : this.staticPopupItems) {
            if (anItem == null) {
                popup.addSeparator();
                continue;
            }
            popup.add(anItem);
        }
        for (ActionsPublisher aPublisher : this.actionPublishers) {
            if (aPublisher.getActions() == null) continue;
            for (Action anAction : aPublisher.getActions()) {
                if (anAction == null) {
                    popup.addSeparator();
                    continue;
                }
                popup.add(new XJMenuItem(anAction, this.sListenerProxy));
            }
        }
        if (this.target instanceof Resource) {
            Set<String> toolTypes = Gate.getCreoleRegister().getToolTypes();
            for (String type : toolTypes) {
                List<Resource> instances = ((ResourceData)Gate.getCreoleRegister().get(type)).getInstantiations();
                for (Resource res : instances) {
                    if (!(res instanceof ResourceHelper)) continue;
                    for (Action anAction : ((ResourceHelper)res).getActions(this)) {
                        if (anAction == null) {
                            popup.addSeparator();
                            continue;
                        }
                        popup.add(new XJMenuItem(anAction, this.sListenerProxy));
                    }
                }
            }
        }
        return popup;
    }

    @Override
    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String text) {
        this.tooltipText = text;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    public Action getCloseAction() {
        return new CloseAction();
    }

    public Action getCloseRecursivelyAction() {
        return new CloseRecursivelyAction();
    }

    protected void buildStaticPopupItems() {
        this.staticPopupItems = new ArrayList<JComponent>();
        if (this.target instanceof ProcessingResource && !(this.target instanceof Controller)) {
            this.staticPopupItems.add(null);
            this.staticPopupItems.add(new XJMenuItem(new ReloadAction(), this.sListenerProxy));
            this.staticPopupItems.add(new XJMenuItem(new ApplicationWithPRAction(), this.sListenerProxy));
        } else if (this.target instanceof LanguageResource) {
            this.staticPopupItems.add(null);
            if (this.target instanceof Document) {
                this.staticPopupItems.add(new XJMenuItem(new CreateCorpusForDocAction(), this.sListenerProxy));
            }
            if (this.target instanceof TextualDocument) {
                this.staticPopupItems.add(null);
                this.staticPopupItems.add(new DocumentExportMenu(this));
            } else if (this.target instanceof Corpus) {
                this.corpusFiller = new CorpusFillerComponent();
                this.scfInputDialog = new SingleConcatenatedFileInputDialog();
                this.staticPopupItems.add(new XJMenuItem(new PopulateCorpusAction(), this.sListenerProxy));
                this.staticPopupItems.add(new XJMenuItem(new PopulateCorpusFromSingleConcatenatedFileAction(), this.sListenerProxy));
                this.staticPopupItems.add(null);
                this.staticPopupItems.add(new DocumentExportMenu(this));
            }
            if (((LanguageResource)this.target).getDataStore() != null) {
                this.staticPopupItems.add(new XJMenuItem(new SaveAction(), this.sListenerProxy));
            }
            if (!(this.target instanceof AnnotationSchema)) {
                this.staticPopupItems.add(new XJMenuItem(new SaveToAction(), this.sListenerProxy));
            }
        }
        if (this.target instanceof Controller) {
            this.staticPopupItems.add(null);
            if (this.target instanceof SerialAnalyserController) {
                this.staticPopupItems.add(new XJMenuItem(new MakeConditionalAction(), this.sListenerProxy));
            }
            this.staticPopupItems.add(new XJMenuItem(new DumpToFileAction(), this.sListenerProxy));
            this.staticPopupItems.add(new XJMenuItem(new ExportApplicationAction(), this.sListenerProxy));
        }
    }

    protected void buildViews() {
        List<String> smallViewNames;
        this.viewsBuilt = true;
        this.fireStatusChanged("Building views...");
        List<String> largeViewNames = Gate.getCreoleRegister().getLargeVRsForResource(this.target.getClass().getName());
        if (largeViewNames != null && !largeViewNames.isEmpty()) {
            this.largeView = new JTabbedPane(3);
            Iterator<String> classNameIter = largeViewNames.iterator();
            while (classNameIter.hasNext()) {
                try {
                    String className = classNameIter.next();
                    ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(className);
                    FeatureMap params = Factory.newFeatureMap();
                    FeatureMap features = Factory.newFeatureMap();
                    Gate.setHiddenAttribute(features, true);
                    VisualResource view = (VisualResource)Factory.createResource(className, params, features);
                    try {
                        view.setTarget(this.target);
                    }
                    catch (IllegalArgumentException iae) {
                        Factory.deleteResource(view);
                        view = null;
                    }
                    if (view == null) continue;
                    view.setHandle(this);
                    ((JTabbedPane)this.largeView).add((Component)((Object)view), rData.getName());
                    if (!(view instanceof ActionsPublisher)) continue;
                    this.actionPublishers.add((ActionsPublisher)((Object)view));
                }
                catch (ResourceInstantiationException rie) {
                    rie.printStackTrace(Err.getPrintWriter());
                }
            }
            ((JTabbedPane)this.largeView).setSelectedIndex(0);
        }
        if ((smallViewNames = Gate.getCreoleRegister().getSmallVRsForResource(this.target.getClass().getName())) != null && !smallViewNames.isEmpty()) {
            this.smallView = new JTabbedPane(3);
            Iterator<String> classNameIter = smallViewNames.iterator();
            while (classNameIter.hasNext()) {
                try {
                    String className = classNameIter.next();
                    ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(className);
                    FeatureMap params = Factory.newFeatureMap();
                    FeatureMap features = Factory.newFeatureMap();
                    Gate.setHiddenAttribute(features, true);
                    VisualResource view = (VisualResource)Factory.createResource(className, params, features);
                    try {
                        view.setTarget(this.target);
                    }
                    catch (IllegalArgumentException iae) {
                        Factory.deleteResource(view);
                        view = null;
                    }
                    if (view == null) continue;
                    view.setHandle(this);
                    ((JTabbedPane)this.smallView).add((Component)((Object)view), rData.getName());
                    if (!(view instanceof ActionsPublisher)) continue;
                    this.actionPublishers.add((ActionsPublisher)((Object)view));
                }
                catch (ResourceInstantiationException rie) {
                    rie.printStackTrace(Err.getPrintWriter());
                }
            }
            ((JTabbedPane)this.smallView).setSelectedIndex(0);
        }
        this.fireStatusChanged("Views built!");
        JComponent largeView = this.getLargeView();
        if (largeView != null) {
            largeView.getActionMap().put("Close resource", new CloseAction());
            if (this.target instanceof Controller) {
                largeView.getActionMap().put("Close recursively", new CloseRecursivelyAction());
            }
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public synchronized void removeProgressListener(ProgressListener l) {
        if (this.progressListeners != null && this.progressListeners.contains(l)) {
            Vector v = (Vector)this.progressListeners.clone();
            v.removeElement(l);
            this.progressListeners = v;
        }
    }

    public synchronized void addProgressListener(ProgressListener l) {
        Vector v;
        Vector vector = v = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.progressListeners = v;
        }
    }

    @Override
    public void removeViews() {
        int i;
        Component[] vrs;
        if (this.largeView != null) {
            if (this.largeView instanceof VisualResource) {
                if (this.largeView instanceof ActionsPublisher) {
                    this.actionPublishers.remove((ActionsPublisher)((Object)this.largeView));
                }
                Factory.deleteResource((VisualResource)((Object)this.largeView));
            } else {
                vrs = ((JTabbedPane)this.largeView).getComponents();
                for (i = 0; i < vrs.length; ++i) {
                    if (!(vrs[i] instanceof VisualResource)) continue;
                    if (vrs[i] instanceof ActionsPublisher) {
                        this.actionPublishers.remove(vrs[i]);
                    }
                    Factory.deleteResource((VisualResource)((Object)vrs[i]));
                }
            }
            this.largeView = null;
        }
        if (this.smallView != null) {
            if (this.smallView instanceof VisualResource) {
                if (this.smallView instanceof ActionsPublisher) {
                    this.actionPublishers.remove((ActionsPublisher)((Object)this.smallView));
                }
                Factory.deleteResource((VisualResource)((Object)this.smallView));
            } else {
                vrs = ((JTabbedPane)this.smallView).getComponents();
                for (i = 0; i < vrs.length; ++i) {
                    if (!(vrs[i] instanceof VisualResource)) continue;
                    if (vrs[i] instanceof ActionsPublisher) {
                        this.actionPublishers.remove(vrs[i]);
                    }
                    Factory.deleteResource((VisualResource)((Object)vrs[i]));
                }
            }
            this.smallView = null;
        }
        this.viewsBuilt = false;
    }

    @Override
    public void cleanup() {
        this.removeViews();
        this.target = null;
    }

    public void fireProgressChanged(int e) {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).progressChanged(e);
            }
        }
    }

    public void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).processFinished();
            }
        }
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    public void fireStatusChanged(String e) {
        if (this.statusListeners != null) {
            Vector<StatusListener> listeners = this.statusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).statusChanged(e);
            }
        }
    }

    @Override
    public void statusChanged(String e) {
        this.fireStatusChanged(e);
    }

    @Override
    public void progressChanged(int e) {
        this.fireProgressChanged(e);
    }

    @Override
    public void processFinished() {
        this.fireProcessFinished();
    }

    @Override
    public Window getWindow() {
        return this.window;
    }

    class ProxyStatusListener
    implements StatusListener {
        ProxyStatusListener() {
        }

        @Override
        public void statusChanged(String text) {
            NameBearerHandle.this.fireStatusChanged(text);
        }
    }

    class CreateCorpusForDocAction
    extends AbstractAction {
        private static final long serialVersionUID = -3698451324578510407L;

        public CreateCorpusForDocAction() {
            super("New Corpus with this Document");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Corpus corpus = Factory.newCorpus("Corpus for " + NameBearerHandle.this.target.getName());
                corpus.add((Document)NameBearerHandle.this.target);
            }
            catch (ResourceInstantiationException rie) {
                Err.println("Exception creating corpus");
                rie.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class PopulateCorpusFromSingleConcatenatedFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 2342321851865139492L;

        PopulateCorpusFromSingleConcatenatedFileAction() {
            super("Populate from Single Concatenated File");
            this.putValue("ShortDescription", "Fills this corpus by extracting multiple documents from a single file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NameBearerHandle.this.scfInputDialog.reset();
            final boolean answer = OkCancelDialog.showDialog(NameBearerHandle.this.window, NameBearerHandle.this.scfInputDialog, "Populate from Single Concatenated File");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (answer) {
                        String message = null;
                        if (NameBearerHandle.this.scfInputDialog.getUrlString().trim().length() == 0) {
                            message = "file URL cannot be empty";
                        } else if (NameBearerHandle.this.scfInputDialog.getDocumentRootElement().trim().length() == 0) {
                            message = "document root element cannot be empty";
                        }
                        if (message != null) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), message, "GATE", 0);
                            return;
                        }
                        long startTime = System.currentTimeMillis();
                        URL url = null;
                        try {
                            url = new URL(NameBearerHandle.this.scfInputDialog.getUrlString());
                            ((Corpus)NameBearerHandle.this.target).populate(url, NameBearerHandle.this.scfInputDialog.getDocumentRootElement(), NameBearerHandle.this.scfInputDialog.getEncoding(), NameBearerHandle.this.scfInputDialog.getNumOfDocumentsToFetch(), NameBearerHandle.this.scfInputDialog.getDocumentNamePrefix(), NameBearerHandle.this.scfInputDialog.getDocumentMimeType(), NameBearerHandle.this.scfInputDialog.includeRootElement());
                            if (((Corpus)NameBearerHandle.this.target).getDataStore() != null) {
                                ((LanguageResource)NameBearerHandle.this.target).getDataStore().sync((LanguageResource)NameBearerHandle.this.target);
                            }
                            long endTime = System.currentTimeMillis();
                            NameBearerHandle.this.fireStatusChanged("Corpus populated in " + NumberFormat.getInstance().format((double)(endTime - startTime) / 1000.0) + " seconds!");
                        }
                        catch (MalformedURLException mue) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Invalid URL!\n See \"Messages\" tab for details!", "GATE", 0);
                            mue.printStackTrace(Err.getPrintWriter());
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "I/O error!\n See \"Messages\" tab for details!", "GATE", 0);
                            ioe.printStackTrace(Err.getPrintWriter());
                        }
                        catch (ResourceInstantiationException rie) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Could not create document!\n See \"Messages\" tab for details!", "GATE", 0);
                            rie.printStackTrace(Err.getPrintWriter());
                        }
                        catch (PersistenceException pe) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Corpus couldn't be synchronized!\n See \"Messages\" tab for details!", "GATE", 0);
                            pe.printStackTrace(Err.getPrintWriter());
                        }
                        catch (SecurityException pe) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Corpus couldn't be synchronized!\n See \"Messages\" tab for details!", "GATE", 0);
                            pe.printStackTrace(Err.getPrintWriter());
                        }
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "PopulateCorpusFromSingleConcatenatedFileAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class PopulateCorpusAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        PopulateCorpusAction() {
            super("Populate");
            this.putValue("ShortDescription", "Fills this corpus with documents from a directory");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NameBearerHandle.this.corpusFiller.setExtensions(new ArrayList<String>());
            NameBearerHandle.this.corpusFiller.setEncoding("");
            final boolean answer = OkCancelDialog.showDialog(NameBearerHandle.this.window, NameBearerHandle.this.corpusFiller, "Select a directory and allowed extensions");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (answer) {
                        long startTime = System.currentTimeMillis();
                        try {
                            String mimeType;
                            ExtensionFileFilter filter;
                            URL url = new URL(NameBearerHandle.this.corpusFiller.getUrlString());
                            List<String> extensions = NameBearerHandle.this.corpusFiller.getExtensions();
                            if (extensions == null || extensions.isEmpty()) {
                                filter = null;
                            } else {
                                filter = new ExtensionFileFilter();
                                Iterator<String> extIter = NameBearerHandle.this.corpusFiller.getExtensions().iterator();
                                while (extIter.hasNext()) {
                                    filter.addExtension(extIter.next());
                                }
                            }
                            String encoding = NameBearerHandle.this.corpusFiller.getEncoding();
                            if (encoding != null && encoding.trim().length() == 0) {
                                encoding = null;
                            }
                            if ((mimeType = NameBearerHandle.this.corpusFiller.getMimeType()) != null && mimeType.trim().length() == 0) {
                                mimeType = null;
                            }
                            ((Corpus)NameBearerHandle.this.target).populate(url, filter, encoding, mimeType, NameBearerHandle.this.corpusFiller.isRecurseDirectories());
                            if (((Corpus)NameBearerHandle.this.target).getDataStore() != null) {
                                ((LanguageResource)NameBearerHandle.this.target).getDataStore().sync((LanguageResource)NameBearerHandle.this.target);
                            }
                            long endTime = System.currentTimeMillis();
                            NameBearerHandle.this.fireStatusChanged("Corpus populated in " + NumberFormat.getInstance().format((double)(endTime - startTime) / 1000.0) + " seconds!");
                        }
                        catch (MalformedURLException mue) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid URL!\n See \"Messages\" tab for details!", "GATE", 0);
                                    mue.printStackTrace(Err.getPrintWriter());
                                }
                            });
                        }
                        catch (IOException ioe) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "I/O error!\n See \"Messages\" tab for details!", "GATE", 0);
                                    ioe.printStackTrace(Err.getPrintWriter());
                                }
                            });
                        }
                        catch (ResourceInstantiationException rie) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Could not create document!\n See \"Messages\" tab for details!", "GATE", 0);
                                    rie.printStackTrace(Err.getPrintWriter());
                                }
                            });
                        }
                        catch (PersistenceException pe) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Corpus couldn't be synchronized!\n See \"Messages\" tab for details!", "GATE", 0);
                                    pe.printStackTrace(Err.getPrintWriter());
                                }
                            });
                        }
                        catch (SecurityException pe) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Corpus couldn't be synchronized!\n See \"Messages\" tab for details!", "GATE", 0);
                                    pe.printStackTrace(Err.getPrintWriter());
                                }
                            });
                        }
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "PopulateCorpusAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class ReloadAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ReloadAction() {
            super("Reinitialise");
            this.putValue("ShortDescription", "Reloads this resource");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!(NameBearerHandle.this.target instanceof ProcessingResource)) {
                        return;
                    }
                    if (NameBearerHandle.this.target instanceof Controller) {
                        return;
                    }
                    try {
                        long startTime = System.currentTimeMillis();
                        NameBearerHandle.this.fireStatusChanged("Reinitialising " + NameBearerHandle.this.target.getName());
                        HashMap<String, EventListener> listeners = new HashMap<String, EventListener>();
                        StatusListener sListener = new StatusListener(){

                            @Override
                            public void statusChanged(String text) {
                                NameBearerHandle.this.fireStatusChanged(text);
                            }
                        };
                        listeners.put("gate.event.StatusListener", sListener);
                        ProgressListener pListener = new ProgressListener(){

                            @Override
                            public void progressChanged(int value) {
                                NameBearerHandle.this.fireProgressChanged(value);
                            }

                            @Override
                            public void processFinished() {
                                NameBearerHandle.this.fireProcessFinished();
                            }
                        };
                        listeners.put("gate.event.ProgressListener", pListener);
                        ProcessingResource res = (ProcessingResource)NameBearerHandle.this.target;
                        try {
                            AbstractResource.setResourceListeners(res, listeners);
                        }
                        catch (Exception e) {
                            e.printStackTrace(Err.getPrintWriter());
                        }
                        NameBearerHandle.this.fireProgressChanged(0);
                        res.reInit();
                        try {
                            AbstractResource.removeResourceListeners(res, listeners);
                        }
                        catch (Exception e) {
                            e.printStackTrace(Err.getPrintWriter());
                        }
                        long endTime = System.currentTimeMillis();
                        NameBearerHandle.this.fireStatusChanged(NameBearerHandle.this.target.getName() + " reinitialised in " + NumberFormat.getInstance().format((double)(endTime - startTime) / 1000.0) + " seconds");
                        NameBearerHandle.this.fireProcessFinished();
                    }
                    catch (ResourceInstantiationException rie) {
                        NameBearerHandle.this.fireStatusChanged("reinitialisation failed");
                        rie.printStackTrace(Err.getPrintWriter());
                        NameBearerHandle.this.fireProcessFinished();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Reload failed!\n See \"Messages\" tab for details!", "GATE", 0);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "DefaultResourceHandle1");
            thread.setPriority(1);
            thread.start();
        }
    }

    class ApplicationWithPRAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ApplicationWithPRAction() {
            super("Create Application");
            this.putValue("ShortDescription", "Creates a corpus pipeline application with the given PR");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!(NameBearerHandle.this.target instanceof ProcessingResource)) {
                        return;
                    }
                    if (NameBearerHandle.this.target instanceof Controller) {
                        return;
                    }
                    try {
                        ConditionalSerialAnalyserController newController = (ConditionalSerialAnalyserController)Factory.createResource("gate.creole.ConditionalSerialAnalyserController");
                        ProcessingResource pr = (ProcessingResource)NameBearerHandle.this.target;
                        newController.add(pr);
                        newController.setName(pr.getName());
                    }
                    catch (ResourceInstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "DefaultResourceHandle1");
            thread.setPriority(1);
            thread.start();
        }
    }

    class SaveToAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveToAction() {
            super("Save to Datastore...");
            this.putValue("ShortDescription", "Save this resource to a datastore");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            block23: {
                try {
                    DataStoreRegister dsReg = Gate.getDataStoreRegister();
                    HashMap<String, DataStore> dsByName = new HashMap<String, DataStore>();
                    for (DataStore oneDS : dsReg) {
                        String name = oneDS.getName();
                        if (name == null) {
                            name = oneDS.getStorageUrl();
                            try {
                                URL tempURL = new URL(name);
                                name = tempURL.getFile();
                            }
                            catch (MalformedURLException ex) {
                                throw new GateRuntimeException();
                            }
                        }
                        dsByName.put(name, oneDS);
                    }
                    ArrayList dsNames = new ArrayList(dsByName.keySet());
                    if (dsNames.isEmpty()) {
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "There are no open datastores!\n Please open a datastore first!", "GATE", 0);
                        break block23;
                    }
                    Object answer = JOptionPane.showInputDialog(NameBearerHandle.this.getLargeView(), "Select the datastore", "GATE", 3, null, dsNames.toArray(), dsNames.get(0));
                    if (answer == null) {
                        return;
                    }
                    DataStore ds = (DataStore)dsByName.get(answer);
                    if (ds == null) {
                        Err.prln("The datastore does not exists. Saving procedure has FAILED! This should never happen again!");
                        return;
                    }
                    DataStore ownDS = ((LanguageResource)NameBearerHandle.this.target).getDataStore();
                    if (ds == ownDS) {
                        MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                        StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                        if (sListener != null) {
                            sListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                        }
                        double timeBefore = System.currentTimeMillis();
                        ds.sync((LanguageResource)NameBearerHandle.this.target);
                        double timeAfter = System.currentTimeMillis();
                        if (sListener != null) {
                            sListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((timeAfter - timeBefore) / 1000.0) + " seconds");
                        }
                        break block23;
                    }
                    StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                    MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                    if (sListener != null) {
                        sListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                    }
                    double timeBefore = System.currentTimeMillis();
                    LanguageResource lr = ds.adopt((LanguageResource)NameBearerHandle.this.target);
                    ds.sync(lr);
                    if (ds instanceof LuceneDataStoreImpl && lr instanceof IndexedCorpus) {
                        Object persistanceID = lr.getLRPersistenceId();
                        String lrType = lr.getClass().getName();
                        String lrName = lr.getName();
                        Factory.deleteResource(lr);
                        FeatureMap params = Factory.newFeatureMap();
                        params.put("DataStore", ds);
                        params.put("LRPersistenceId", persistanceID);
                        FeatureMap features = Factory.newFeatureMap();
                        try {
                            lr = (LanguageResource)Factory.createResource(lrType, params, features, lrName);
                        }
                        catch (ResourceInstantiationException rie) {
                            throw new GateRuntimeException("Could not load the corpus", rie);
                        }
                    }
                    double timeAfter = System.currentTimeMillis();
                    if (sListener != null) {
                        sListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((timeAfter - timeBefore) / 1000.0) + " seconds");
                    }
                    if (lr != NameBearerHandle.this.target) {
                        Factory.deleteResource((LanguageResource)NameBearerHandle.this.target);
                    }
                }
                catch (PersistenceException pe) {
                    MainFrame.unlockGUI();
                    JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + pe.toString(), "GATE", 0);
                }
                finally {
                    MainFrame.unlockGUI();
                }
            }
        }
    }

    class ExportApplicationAction
    extends AbstractAction {
        private Logger log;
        private static final long serialVersionUID = 1L;

        public ExportApplicationAction() {
            super("Export for GATE Cloud");
            this.log = Logger.getLogger((String)"gate.gui.ExportApplicationAction");
            this.putValue("ShortDescription", "Saves the resources of this application in a ZIP file");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            XJFileChooser fileChooser = MainFrame.getFileChooser();
            ExtensionFileFilter filter = new ExtensionFileFilter("ZIP file", "zip");
            fileChooser.addChoosableFileFilter(filter);
            fileChooser.setDialogTitle("Select a file where to save the application " + (NameBearerHandle.this.target instanceof CorpusController && ((CorpusController)NameBearerHandle.this.target).getCorpus() != null ? "WITH" : "WITHOUT") + " corpus.");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setResource("application.zip." + NameBearerHandle.this.target.getName());
            if (fileChooser.showSaveDialog(NameBearerHandle.this.largeView) == 0) {
                File checkFile = fileChooser.getSelectedFile();
                if (!checkFile.getName().toLowerCase().endsWith(".zip")) {
                    checkFile = new File(checkFile.getParent(), checkFile.getName() + ".zip");
                }
                final File targetZipFile = checkFile;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Project project = new Project();
                            ExporterBuildListener buildListener = new ExporterBuildListener();
                            Gate.setExecutable(buildListener);
                            project.addBuildListener((BuildListener)buildListener);
                            project.init();
                            MainFrame.lockGUI("Exporting application...");
                            File temporaryDirectory = File.createTempFile("gapp-packager", "", null);
                            if (!temporaryDirectory.delete() || !temporaryDirectory.mkdir()) {
                                throw new IOException("Unable to create temporary directory.\n" + temporaryDirectory.getCanonicalPath());
                            }
                            temporaryDirectory = temporaryDirectory.getCanonicalFile();
                            File originalGapp = new File(temporaryDirectory, "original.xgapp");
                            File targetGapp = new File(temporaryDirectory, "application.xgapp");
                            File mavenCache = new File(temporaryDirectory, "maven-cache.gate");
                            PersistenceManager.saveObjectToFile(NameBearerHandle.this.target, originalGapp, false, true);
                            PackageGappTask task = new PackageGappTask();
                            task.setProject(project);
                            task.setSrc(originalGapp);
                            task.setDestFile(targetGapp);
                            task.setMavenCache(mavenCache);
                            task.setCopyPlugins(true);
                            task.setCopyResourceDirs(true);
                            task.setOnUnresolved(PackageGappTask.UnresolvedAction.recover);
                            task.init();
                            task.perform();
                            Zip zipTask = new Zip();
                            zipTask.setProject(project);
                            zipTask.setDestFile(targetZipFile);
                            FileSet fs = new FileSet();
                            fs.setProject(project);
                            zipTask.addFileset(fs);
                            fs.setDir(temporaryDirectory);
                            fs.setExcludes("original.xgapp");
                            zipTask.perform();
                            Delete deleteTask = new Delete();
                            deleteTask.setProject(project);
                            deleteTask.setDir(temporaryDirectory);
                            deleteTask.perform();
                        }
                        catch (Exception e) {
                            MainFrame.unlockGUI();
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Error!\n" + e.toString(), "GATE", 0);
                            e.printStackTrace(Err.getPrintWriter());
                        }
                        finally {
                            MainFrame.unlockGUI();
                            Gate.setExecutable(null);
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                thread.start();
            }
        }

        class ExporterBuildListener
        implements BuildListener,
        Executable {
            private boolean interrupted = false;

            ExporterBuildListener() {
            }

            @Override
            public boolean isInterrupted() {
                return this.interrupted;
            }

            @Override
            public void interrupt() {
                this.interrupted = true;
            }

            public void taskFinished(BuildEvent buildEvent) {
                if (buildEvent.getException() != null) {
                    NameBearerHandle.this.statusChanged("Error exporting application");
                } else {
                    NameBearerHandle.this.statusChanged("Export complete");
                }
            }

            public void messageLogged(BuildEvent buildEvent) {
                if (this.interrupted) {
                    this.interrupted = false;
                    throw new BuildException("Export interrupted");
                }
                if (buildEvent.getPriority() <= 2) {
                    NameBearerHandle.this.statusChanged(buildEvent.getMessage());
                }
                ExportApplicationAction.this.log.debug((Object)(buildEvent.getPriority() + ": " + buildEvent.getMessage()));
            }

            public void buildStarted(BuildEvent buildEvent) {
            }

            public void buildFinished(BuildEvent buildEvent) {
            }

            public void targetStarted(BuildEvent buildEvent) {
            }

            public void targetFinished(BuildEvent buildEvent) {
            }

            public void taskStarted(BuildEvent buildEvent) {
            }

            @Override
            public void execute() {
            }
        }
    }

    class DumpToFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DumpToFileAction() {
            super("Save Application State");
            this.putValue("ShortDescription", "Saves the data needed to recreate this application");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            final XJFileChooser fileChooser = MainFrame.getFileChooser();
            ExtensionFileFilter filter = new ExtensionFileFilter("GATE Application files", "gapp");
            fileChooser.addChoosableFileFilter(filter);
            fileChooser.setDialogTitle("Select a file where to save the application " + (NameBearerHandle.this.target instanceof CorpusController && ((CorpusController)NameBearerHandle.this.target).getCorpus() != null ? "WITH" : "WITHOUT") + " corpus.");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setResource("application." + NameBearerHandle.this.target.getName());
            if (fileChooser.showSaveDialog(NameBearerHandle.this.largeView) == 0) {
                final File file = fileChooser.getSelectedFile();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Map<String, String> locations = fileChooser.getLocations();
                            PersistenceManager.saveObjectToFile(NameBearerHandle.this.target, file, true, true);
                            locations.put("lastapplication", file.getAbsolutePath());
                            String list = locations.get("applications");
                            if (list == null) {
                                list = "";
                            }
                            list = list.replaceFirst("\\Q" + NameBearerHandle.this.target.getName() + "\\E(;|$)", "");
                            list = NameBearerHandle.this.target.getName() + ";" + list;
                            locations.put("applications", list);
                            fileChooser.setLocations(locations);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Error!\n" + e.toString(), "GATE", 0);
                            e.printStackTrace(Err.getPrintWriter());
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                thread.start();
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            super("Save to its Datastore");
            this.putValue("ShortDescription", "Save back to its datastore");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    DataStore ds = ((LanguageResource)NameBearerHandle.this.target).getDataStore();
                    if (ds != null) {
                        try {
                            MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                            StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                            if (sListener != null) {
                                sListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                            }
                            double timeBefore = System.currentTimeMillis();
                            ((LanguageResource)NameBearerHandle.this.target).getDataStore().sync((LanguageResource)NameBearerHandle.this.target);
                            double timeAfter = System.currentTimeMillis();
                            if (sListener == null) return;
                            sListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((timeAfter - timeBefore) / 1000.0) + " seconds");
                            return;
                        }
                        catch (PersistenceException pe) {
                            MainFrame.unlockGUI();
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + pe.toString(), "GATE", 0);
                            return;
                        }
                        catch (SecurityException se) {
                            MainFrame.unlockGUI();
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + se.toString(), "GATE", 0);
                            return;
                        }
                        finally {
                            MainFrame.unlockGUI();
                        }
                    } else {
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "This resource has not been loaded from a datastore.\nPlease use the \"Save to Datastore...\" option.\n", "GATE", 0);
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    class MakeConditionalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public MakeConditionalAction() {
            super("Make Pipeline Conditional");
            this.putValue("ShortDescription", "Convert to a Conditional Corpus Pipeline");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SerialAnalyserController existingController = (SerialAnalyserController)NameBearerHandle.this.target;
            try {
                ConditionalSerialAnalyserController newController = (ConditionalSerialAnalyserController)Factory.createResource("gate.creole.ConditionalSerialAnalyserController");
                newController.getFeatures().putAll(existingController.getFeatures());
                newController.setName(existingController.getName());
                Iterator it = existingController.getPRs().iterator();
                while (it.hasNext()) {
                    newController.add((ProcessingResource)it.next());
                }
                List empty = Collections.emptyList();
                existingController.setPRs(empty);
                Factory.deleteResource(existingController);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Error!\n" + ex.toString(), "GATE", 0);
                ex.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class CloseRecursivelyAction
    extends AbstractAction {
        private static final long serialVersionUID = 6110698764173549317L;

        public CloseRecursivelyAction() {
            super("Close Recursively");
            this.putValue("ShortDescription", "Close this application and recursively all contained resources");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift F4"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Factory.deleteResource((Resource)NameBearerHandle.this.target);
            NameBearerHandle.this.statusListeners.clear();
            NameBearerHandle.this.progressListeners.clear();
        }
    }

    class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -89664884870963556L;

        public CloseAction() {
            super("Close");
            this.putValue("ShortDescription", "Close this resource");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F4"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NameBearerHandle.this.target instanceof Controller) {
                List empty = Collections.emptyList();
                ((Controller)NameBearerHandle.this.target).setPRs(empty);
                if (NameBearerHandle.this.target instanceof ConditionalController) {
                    List<RunningStrategy> emptyRS = Collections.emptyList();
                    ((ConditionalController)NameBearerHandle.this.target).setRunningStrategies(emptyRS);
                }
            }
            if (NameBearerHandle.this.target instanceof Resource) {
                Factory.deleteResource((Resource)NameBearerHandle.this.target);
            } else if (NameBearerHandle.this.target instanceof DataStore) {
                try {
                    ((DataStore)NameBearerHandle.this.target).close();
                }
                catch (PersistenceException pe) {
                    JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Error!\n" + pe.toString(), "GATE", 0);
                }
            }
            NameBearerHandle.this.statusListeners.clear();
            NameBearerHandle.this.progressListeners.clear();
        }
    }
}

