/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import gate.swing.XJTextPane;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.OptionsMap;
import gate.util.Out;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LogArea
extends XJTextPane {
    protected LogArea thisLogArea = null;
    protected JPopupMenu popup = null;
    protected Position startPos;
    protected Position endPos;
    protected PrintStream originalOut;
    protected PrintStream originalErr;
    protected SelectAllAction selectAllAction = null;
    protected CopyAction copyAction = null;
    protected ClearAllAction clearAllAction = null;
    private JComponent logTab = null;
    private JToggleButton btnScrollLock = null;
    private SpinnerNumberModel logSizeModel = null;
    private JCheckBox cboLogSize;
    private JCheckBox cboAppend;
    private OptionsMap userConfig = Gate.getUserConfig();
    private PrintWriter logFileWriter = null;
    private File logFile;

    public LogArea() {
        this.thisLogArea = this;
        this.setEditable(false);
        DefaultCaret caret = new DefaultCaret();
        caret.setUpdatePolicy(1);
        this.setCaret(caret);
        LogAreaOutputStream err = new LogAreaOutputStream(true);
        LogAreaOutputStream out = new LogAreaOutputStream(false);
        try {
            Err.setPrintWriter(new UTF8PrintWriter(err, true));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        try {
            Out.setPrintWriter(new UTF8PrintWriter(out, true));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        this.originalOut = System.out;
        try {
            System.setOut(new UTF8PrintStream(out, true));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        this.originalErr = System.err;
        try {
            System.setErr(new UTF8PrintStream(err, true));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace(this.originalErr);
        }
        this.popup = new JPopupMenu();
        this.selectAllAction = new SelectAllAction();
        this.copyAction = new CopyAction();
        this.clearAllAction = new ClearAllAction();
        this.startPos = this.getDocument().getStartPosition();
        this.endPos = this.getDocument().getEndPosition();
        this.popup.add(this.selectAllAction);
        this.popup.add(this.copyAction);
        this.popup.addSeparator();
        this.popup.add(this.clearAllAction);
        this.initListeners();
    }

    public JComponent getComponentToDisplay() {
        if (this.logTab != null) {
            return this.logTab;
        }
        this.logTab = new JPanel(new BorderLayout());
        JToolBar toolbar = new JToolBar(0);
        toolbar.setFloatable(false);
        JButton btnClear = new JButton(MainFrame.getIcon("ClearLog"));
        btnClear.setToolTipText("Clear Log");
        btnClear.addActionListener(this.clearAllAction);
        this.btnScrollLock = new JToggleButton(MainFrame.getIcon("ScrollLock"), (boolean)this.userConfig.getBoolean("ScrollLock", Boolean.FALSE));
        this.btnScrollLock.setToolTipText("Scroll Lock");
        this.btnScrollLock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogArea.this.userConfig.put((Object)"ScrollLock", (Object)LogArea.this.btnScrollLock.isSelected());
            }
        });
        this.logSizeModel = new SpinnerNumberModel(this.userConfig.getInt("LogSize", 80000), 0, Integer.MAX_VALUE, 1);
        this.logSizeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                LogArea.this.userConfig.put((Object)"LogSize", LogArea.this.logSizeModel.getValue());
            }
        });
        final JSpinner spinLogSize = new JSpinner(this.logSizeModel);
        if (spinLogSize.getEditor() instanceof JSpinner.DefaultEditor) {
            JFormattedTextField textField = ((JSpinner.DefaultEditor)spinLogSize.getEditor()).getTextField();
            textField.setColumns(5);
        }
        this.cboLogSize = new JCheckBox("Max Log Size (chars)", (boolean)this.userConfig.getBoolean("LimitLogSize", Boolean.TRUE));
        this.cboLogSize.setOpaque(false);
        spinLogSize.setEnabled(this.cboLogSize.isSelected());
        this.cboLogSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                spinLogSize.setEnabled(LogArea.this.cboLogSize.isSelected());
                LogArea.this.userConfig.put((Object)"LimitLogSize", (Object)LogArea.this.cboLogSize.isSelected());
            }
        });
        toolbar.add(this.cboLogSize);
        toolbar.add(spinLogSize);
        toolbar.addSeparator();
        Icon fileIcon = MainFrame.getIcon("OpenFile");
        final JButton btnLogFile = new JButton(fileIcon);
        BufferedImage disabledIcon = new BufferedImage(fileIcon.getIconWidth(), fileIcon.getIconHeight(), 2);
        Graphics2D g2d = disabledIcon.createGraphics();
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.1f));
        fileIcon.paintIcon(null, g2d, 0, 0);
        btnLogFile.setDisabledIcon(new ImageIcon(disabledIcon));
        btnLogFile.setToolTipText("Select Log File");
        btnLogFile.setEnabled(this.userConfig.getBoolean("LogToFile", Boolean.FALSE));
        final JTextField txtLogFile = new JTextField(20);
        this.logFile = this.userConfig.getFile("LogFile");
        if (this.logFile != null) {
            try {
                if (btnLogFile.isEnabled()) {
                    this.logFileWriter = new PrintWriter(new FileWriter(this.logFile, true));
                }
                txtLogFile.setText(this.logFile.getAbsolutePath());
            }
            catch (IOException ioe) {
                this.logFile = null;
            }
        }
        btnLogFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XJFileChooser fileChooser = MainFrame.getFileChooser();
                ExtensionFileFilter filter = new ExtensionFileFilter("Log Files (*.txt)", "txt");
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setFileSelectionMode(0);
                fileChooser.setDialogTitle("Log File");
                if (fileChooser.showSaveDialog(MainFrame.getInstance()) != 0) {
                    return;
                }
                File logFile = fileChooser.getSelectedFile();
                if (logFile == null) {
                    return;
                }
                try {
                    LogArea.this.logFileWriter = new PrintWriter(new FileWriter(logFile, true));
                    LogArea.this.userConfig.put((Object)"LogFile", logFile);
                    txtLogFile.setText(logFile.getAbsolutePath());
                }
                catch (IOException ioe) {
                    logFile = null;
                    LogArea.this.logFileWriter = null;
                    txtLogFile.setText("");
                    LogArea.this.userConfig.remove("LogFile");
                    ioe.printStackTrace();
                }
            }
        });
        txtLogFile.setEditable(false);
        txtLogFile.setEnabled(btnLogFile.isEnabled());
        this.cboAppend = new JCheckBox("Append To", btnLogFile.isEnabled());
        this.cboAppend.setOpaque(false);
        this.cboAppend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    LogArea.this.logFileWriter = LogArea.this.cboAppend.isSelected() && LogArea.this.logFile != null ? new PrintWriter(new FileWriter(LogArea.this.logFile, true)) : null;
                    btnLogFile.setEnabled(LogArea.this.cboAppend.isSelected());
                    txtLogFile.setEnabled(LogArea.this.cboAppend.isSelected());
                    LogArea.this.userConfig.put((Object)"LogToFile", (Object)LogArea.this.cboAppend.isSelected());
                }
                catch (IOException e) {
                    LogArea.this.logFile = null;
                    LogArea.this.logFileWriter = null;
                    txtLogFile.setText("");
                    LogArea.this.userConfig.remove("LogFile");
                    e.printStackTrace();
                }
            }
        });
        toolbar.add(this.cboAppend);
        toolbar.add(txtLogFile);
        toolbar.add(btnLogFile);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(btnClear);
        toolbar.add(this.btnScrollLock);
        this.logTab.add((Component)new JScrollPane(this), "Center");
        this.logTab.add((Component)toolbar, "South");
        return this.logTab;
    }

    @Override
    public void setDocument(Document d) {
        super.setDocument(d);
        this.startPos = d.getStartPosition();
        this.endPos = d.getEndPosition();
    }

    @Override
    public void setStyledDocument(StyledDocument d) {
        this.setDocument(d);
    }

    @Override
    public void initListeners() {
        super.initListeners();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    LogArea.this.popup.show(LogArea.this.thisLogArea, e.getPoint().x, e.getPoint().y);
                }
            }
        });
    }

    public PrintStream getOriginalErr() {
        return this.originalErr;
    }

    public PrintStream getOriginalOut() {
        return this.originalOut;
    }

    private void handleBadLocationException(BadLocationException e, String textToInsert, Style style) {
        this.originalErr.println("BadLocationException encountered when writing to the log area: " + e);
        this.originalErr.println("trying to recover...");
        DefaultStyledDocument newDocument = new DefaultStyledDocument();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("An error occurred when trying to write a message to the log area.  The log\n");
            sb.append("has been cleared to try and recover from this problem.\n\n");
            sb.append(textToInsert);
            newDocument.insertString(0, sb.toString(), style);
        }
        catch (BadLocationException e2) {
            e2.printStackTrace(this.originalErr);
            return;
        }
        this.setDocument(newDocument);
    }

    class LogAreaOutputStream
    extends OutputStream {
        private boolean isErr = false;
        private Style style = null;

        public LogAreaOutputStream(boolean anIsErr) {
            this.isErr = anIsErr;
            if (this.isErr) {
                this.style = LogArea.this.addStyle("error", LogArea.this.getStyle("default"));
                StyleConstants.setForeground(this.style, Color.red);
            } else {
                this.style = LogArea.this.addStyle("out", LogArea.this.getStyle("default"));
                StyleConstants.setForeground(this.style, Color.black);
            }
        }

        @Override
        public void write(int charCode) {
            char c = (char)(charCode &= 0xFF);
            SwingUtilities.invokeLater(new SwingWriter(String.valueOf(c), this.style));
        }

        @Override
        public void write(byte[] data, int offset, int length) {
            try {
                SwingUtilities.invokeLater(new SwingWriter(new String(data, offset, length, "UTF-8"), this.style));
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace(LogArea.this.originalErr);
            }
        }
    }

    protected class ClearAllAction
    extends AbstractAction {
        public ClearAllAction() {
            super("Clear all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                LogArea.this.thisLogArea.getDocument().remove(LogArea.this.startPos.getOffset(), LogArea.this.endPos.getOffset() - LogArea.this.startPos.getOffset() - 1);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    public static class UTF8PrintStream
    extends PrintStream {
        public UTF8PrintStream(OutputStream out) throws UnsupportedEncodingException {
            this(out, true);
        }

        public UTF8PrintStream(OutputStream out, boolean autoFlush) throws UnsupportedEncodingException {
            super(out, autoFlush);
        }

        @Override
        public void print(String s) {
            try {
                this.write((s == null ? "null" : s).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException ioe) {
                this.setError();
            }
        }

        @Override
        public void print(char[] s) {
            this.print(String.valueOf(s));
        }
    }

    public static class UTF8PrintWriter
    extends PrintWriter {
        public UTF8PrintWriter(OutputStream out) throws UnsupportedEncodingException {
            this(out, true);
        }

        public UTF8PrintWriter(OutputStream out, boolean autoFlush) throws UnsupportedEncodingException {
            super((Writer)new BufferedWriter(new OutputStreamWriter(out, "UTF-8")), autoFlush);
        }
    }

    protected class SwingWriter
    implements Runnable {
        String text;
        Style style;

        SwingWriter(String text, Style style) {
            this.text = text;
            this.style = style;
        }

        @Override
        public void run() {
            if (LogArea.this.cboAppend.isSelected() && LogArea.this.logFileWriter != null) {
                LogArea.this.logFileWriter.print(this.text);
                LogArea.this.logFileWriter.flush();
            }
            try {
                LogArea.this.getDocument().insertString(LogArea.this.endPos.getOffset() - 1, this.text, this.style);
                if (LogArea.this.cboLogSize.isSelected() && LogArea.this.getDocument().getLength() > LogArea.this.logSizeModel.getNumber().intValue()) {
                    int index = LogArea.this.getText().indexOf("\n", LogArea.this.getDocument().getLength() - LogArea.this.logSizeModel.getNumber().intValue()) + 1;
                    LogArea.this.getDocument().remove(0, index != 0 ? index : LogArea.this.getDocument().getLength() - LogArea.this.logSizeModel.getNumber().intValue());
                }
                if (!LogArea.this.btnScrollLock.isSelected()) {
                    LogArea.this.setCaretPosition(LogArea.this.getDocument().getLength());
                }
            }
            catch (BadLocationException e) {
                LogArea.this.handleBadLocationException(e, this.text, this.style);
            }
        }
    }

    protected class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogArea.this.thisLogArea.copy();
        }
    }

    protected class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super("Select all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogArea.this.thisLogArea.selectAll();
        }
    }
}

