/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.TextualDocumentView;
import gate.resources.img.svg.AnnotationDiffIcon;
import gate.resources.img.svg.DocumentIcon;
import gate.resources.img.svg.DownIcon;
import gate.resources.img.svg.RightArrowIcon;
import gate.resources.img.svg.RunIcon;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.AnnotationDiffer;
import gate.util.ExtensionFileFilter;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.SimpleFeatureMapImpl;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.BadLocationException;

public class AnnotationDiffGUI
extends JFrame {
    protected AnnotationDiffer differ;
    protected List<AnnotationDiffer.Pairing> pairings;
    protected List<Boolean> keyCopyValueRows;
    protected List<Boolean> resCopyValueRows;
    protected List<Resource> documents;
    protected Document keyDoc;
    protected Document resDoc;
    protected List<AnnotationSet> keySets;
    protected List<AnnotationSet> resSets;
    protected AnnotationSet keySet;
    protected AnnotationSet resSet;
    protected Set<String> significantFeatures;
    protected DiffAction diffAction;
    protected CopyToTargetSetAction copyToTargetSetAction;
    protected HTMLExportAction htmlExportAction;
    protected ShowDocumentAction showDocumentAction;
    protected JComboBox<String> keyDocCombo;
    protected JComboBox<String> resDocCombo;
    protected JComboBox<String> keySetCombo;
    protected JComboBox<String> resSetCombo;
    protected JComboBox<String> annTypeCombo;
    protected DefaultListModel<String> featureslistModel;
    protected JList<String> featuresList;
    protected JRadioButton allFeaturesBtn;
    protected JRadioButton someFeaturesBtn;
    protected JRadioButton noFeaturesBtn;
    protected JTextField weightTxt;
    protected JButton doDiffBtn;
    protected JScrollPane scroller;
    protected DiffTableModel diffTableModel;
    protected XJTable diffTable;
    protected JTabbedPane bottomTabbedPane;
    protected JPanel statisticsPane;
    protected JLabel correctLbl;
    protected JLabel partiallyCorrectLbl;
    protected JLabel missingLbl;
    protected JLabel falsePozLbl;
    protected JLabel recallStrictLbl;
    protected JLabel precisionStrictLbl;
    protected JLabel fmeasureStrictLbl;
    protected JLabel recallLenientLbl;
    protected JLabel precisionLenientLbl;
    protected JLabel fmeasureLenientLbl;
    protected JLabel recallAveLbl;
    protected JLabel precisionAveLbl;
    protected JLabel fmeasureAveLbl;
    protected JTextField consensusASTextField;
    protected JButton copyToConsensusBtn;
    protected JLabel statusLabel;
    protected JButton htmlExportBtn;
    protected JButton showDocumentBtn;
    protected JProgressBar progressBar;
    protected static final Color PARTIALLY_CORRECT_BG = new Color(173, 215, 255);
    protected static final Color MISSING_BG = new Color(255, 173, 181);
    protected static final Color FALSE_POSITIVE_BG = new Color(255, 231, 173);
    protected static final String[] matchLabel = new String[5];
    protected final int maxCellLength = 40;
    protected boolean isStandalone;

    public AnnotationDiffGUI(String title) {
        super(title);
        this.setIconImage(new AnnotationDiffIcon(64, 64).getImage());
        MainFrame.getGuiRoots().add(this);
        this.setDefaultCloseOperation(2);
        this.initLocalData();
        this.initGUI();
        this.initListeners();
        this.populateGUI();
    }

    public AnnotationDiffGUI(String title, final String keyDocumentName, final String responseDocumentName, final String keyAnnotationSetName, final String responseAnnotationSetName, final String annotationType, final Set<String> featureNames) {
        super(title);
        this.setIconImage(new AnnotationDiffIcon(64, 64).getImage());
        MainFrame.getGuiRoots().add(this);
        this.setDefaultCloseOperation(2);
        this.initLocalData();
        this.initGUI();
        this.initListeners();
        this.populateGUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnnotationDiffGUI.this.keyDocCombo.setSelectedItem(keyDocumentName);
                AnnotationDiffGUI.this.resDocCombo.setSelectedItem(responseDocumentName);
                if (keyAnnotationSetName != null) {
                    AnnotationDiffGUI.this.keySetCombo.setSelectedItem(keyAnnotationSetName);
                }
                if (responseAnnotationSetName != null) {
                    AnnotationDiffGUI.this.resSetCombo.setSelectedItem(responseAnnotationSetName);
                }
                if (annotationType != null) {
                    AnnotationDiffGUI.this.annTypeCombo.setSelectedItem(annotationType);
                }
                AnnotationDiffGUI.this.significantFeatures.clear();
                if (featureNames == null || featureNames.isEmpty()) {
                    AnnotationDiffGUI.this.noFeaturesBtn.setSelected(true);
                } else {
                    AnnotationDiffGUI.this.significantFeatures.addAll(featureNames);
                    AnnotationDiffGUI.this.someFeaturesBtn.setSelected(true);
                }
                if (keyAnnotationSetName != null && responseAnnotationSetName != null && annotationType != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Date timeToRun = new Date(System.currentTimeMillis() + 1000L);
                            Timer timer = new Timer("Annotation diff init timer", true);
                            timer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    AnnotationDiffGUI.this.diffAction.actionPerformed(new ActionEvent(this, -1, "corpus quality"));
                                }
                            }, timeToRun);
                        }
                    });
                }
            }
        });
    }

    protected void initLocalData() {
        this.differ = new AnnotationDiffer();
        this.pairings = new ArrayList<AnnotationDiffer.Pairing>();
        this.keyCopyValueRows = new ArrayList<Boolean>();
        this.resCopyValueRows = new ArrayList<Boolean>();
        this.significantFeatures = new HashSet<String>();
        this.keyDoc = null;
        this.resDoc = null;
        Component root = SwingUtilities.getRoot(this);
        this.isStandalone = root instanceof MainFrame;
    }

    protected void initGUI() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        JLabel keyDocLabel = new JLabel("Key doc:");
        keyDocLabel.setToolTipText("Key document");
        this.getContentPane().add((Component)keyDocLabel, constraints);
        this.keyDocCombo = new JComboBox();
        this.keyDocCombo.setPrototypeDisplayValue("long_document_name");
        this.keyDocCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Rectangle textRectangle = new Rectangle(AnnotationDiffGUI.this.keyDocCombo.getSize().width, this.getPreferredSize().height);
                    String shortText = SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), value.toString(), null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getHorizontalTextPosition(), this.getVerticalTextPosition(), textRectangle, new Rectangle(), textRectangle, this.getIconTextGap());
                    if (shortText.equals(value)) {
                        if (index == -1) {
                            AnnotationDiffGUI.this.keyDocCombo.setToolTipText(null);
                        } else {
                            this.setToolTipText(null);
                        }
                    } else if (index == -1) {
                        AnnotationDiffGUI.this.keyDocCombo.setToolTipText(value.toString());
                    } else {
                        this.setToolTipText(value.toString());
                    }
                }
                return this;
            }
        });
        constraints.weightx = 3.0;
        this.getContentPane().add(this.keyDocCombo, constraints);
        constraints.weightx = 1.0;
        JLabel keySetLabel = new JLabel("Key set:");
        keySetLabel.setToolTipText("Key annotation set");
        this.getContentPane().add((Component)keySetLabel, constraints);
        this.keySetCombo = new JComboBox();
        this.keySetCombo.setPrototypeDisplayValue("long_set_name");
        this.getContentPane().add(this.keySetCombo, constraints);
        JLabel typeLabel = new JLabel("Type:");
        typeLabel.setToolTipText("Annotation type");
        this.getContentPane().add((Component)typeLabel, constraints);
        this.annTypeCombo = new JComboBox();
        this.annTypeCombo.setPrototypeDisplayValue("very_long_type");
        constraints.gridwidth = 3;
        this.getContentPane().add(this.annTypeCombo, constraints);
        constraints.gridwidth = 1;
        JLabel weightLabel = new JLabel("Weight");
        weightLabel.setToolTipText("F-measure weight");
        this.getContentPane().add((Component)weightLabel, constraints);
        this.diffAction = new DiffAction();
        this.diffAction.setEnabled(false);
        this.doDiffBtn = new JButton(this.diffAction);
        this.doDiffBtn.setDisabledIcon(new RunIcon(MainFrame.ICON_DIMENSION, true));
        this.doDiffBtn.setForeground((Color)UIManager.getDefaults().get("Button.disabledText"));
        this.doDiffBtn.setToolTipText("Choose two annotation sets that have at least one annotation type in common.");
        constraints.gridheight = 2;
        this.getContentPane().add((Component)this.doDiffBtn, constraints);
        constraints.gridheight = 1;
        ++constraints.gridy;
        constraints.gridx = 0;
        JLabel responseDocLabel = new JLabel("Resp. doc:");
        responseDocLabel.setToolTipText("Response document");
        this.getContentPane().add((Component)responseDocLabel, constraints);
        constraints.gridx = -1;
        this.resDocCombo = new JComboBox();
        this.resDocCombo.setPrototypeDisplayValue("long_document_name");
        this.resDocCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Rectangle textRectangle = new Rectangle(AnnotationDiffGUI.this.resDocCombo.getSize().width, this.getPreferredSize().height);
                    String shortText = SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), value.toString(), null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getHorizontalTextPosition(), this.getVerticalTextPosition(), textRectangle, new Rectangle(), textRectangle, this.getIconTextGap());
                    if (shortText.equals(value)) {
                        if (index == -1) {
                            AnnotationDiffGUI.this.resDocCombo.setToolTipText(null);
                        } else {
                            this.setToolTipText(null);
                        }
                    } else if (index == -1) {
                        AnnotationDiffGUI.this.resDocCombo.setToolTipText(value.toString());
                    } else {
                        this.setToolTipText(value.toString());
                    }
                }
                return this;
            }
        });
        constraints.weightx = 3.0;
        this.getContentPane().add(this.resDocCombo, constraints);
        constraints.weightx = 1.0;
        JLabel responseSetLabel = new JLabel("Resp. set:");
        responseSetLabel.setToolTipText("Response annotation set");
        this.getContentPane().add((Component)responseSetLabel, constraints);
        this.resSetCombo = new JComboBox();
        this.resSetCombo.setPrototypeDisplayValue("long_set_name");
        this.getContentPane().add(this.resSetCombo, constraints);
        this.getContentPane().add((Component)new JLabel("Features:"), constraints);
        ButtonGroup btnGrp = new ButtonGroup();
        this.allFeaturesBtn = new JRadioButton("all");
        this.allFeaturesBtn.setOpaque(false);
        this.allFeaturesBtn.setMargin(new Insets(0, 0, 0, 1));
        this.allFeaturesBtn.setIconTextGap(1);
        btnGrp.add(this.allFeaturesBtn);
        constraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.allFeaturesBtn, constraints);
        this.someFeaturesBtn = new JRadioButton("some");
        this.someFeaturesBtn.setOpaque(false);
        this.someFeaturesBtn.setMargin(new Insets(0, 0, 0, 1));
        this.someFeaturesBtn.setIconTextGap(1);
        btnGrp.add(this.someFeaturesBtn);
        this.getContentPane().add((Component)this.someFeaturesBtn, constraints);
        this.noFeaturesBtn = new JRadioButton("none");
        this.noFeaturesBtn.setOpaque(false);
        this.noFeaturesBtn.setMargin(new Insets(0, 0, 0, 1));
        this.noFeaturesBtn.setIconTextGap(1);
        btnGrp.add(this.noFeaturesBtn);
        this.getContentPane().add((Component)this.noFeaturesBtn, constraints);
        constraints.insets = new Insets(2, 2, 2, 2);
        this.noFeaturesBtn.setSelected(true);
        this.weightTxt = new JTextField("1.0");
        this.weightTxt.setToolTipText("<html>Relative weight of precision and recall aka beta.<ul><li>1 weights equally precision and recall<li>0.5 weights precision twice as much as recall<li>2 weights recall twice as much as precision</ul></html>");
        constraints.fill = 2;
        this.getContentPane().add((Component)this.weightTxt, constraints);
        constraints.fill = 0;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.diffTableModel = new DiffTableModel();
        this.diffTable = new XJTable(this.diffTableModel);
        this.diffTable.setDefaultRenderer(String.class, new DiffTableCellRenderer());
        this.diffTable.setDefaultRenderer(Boolean.class, new DiffTableCellRenderer());
        this.diffTable.setAutoResizeMode(0);
        this.diffTable.setComparator(5, new Comparator<String>(){

            @Override
            public int compare(String label1, String label2) {
                int match1 = 0;
                while (!label1.equals(matchLabel[match1])) {
                    ++match1;
                }
                int match2 = 0;
                while (!label2.equals(matchLabel[match2])) {
                    ++match2;
                }
                return match1 - match2;
            }
        });
        this.diffTable.setSelectionMode(2);
        this.diffTable.setRowSelectionAllowed(true);
        this.diffTable.setColumnSelectionAllowed(true);
        this.diffTable.setEnableHidingColumns(true);
        this.diffTable.hideColumn(4);
        this.diffTable.hideColumn(6);
        Comparator<String> startEndComparator = new Comparator<String>(){

            @Override
            public int compare(String no1, String no2) {
                int n2;
                if (no1.trim().equals("") && no2.trim().equals("")) {
                    return 0;
                }
                if (no1.trim().equals("")) {
                    return -1;
                }
                if (no2.trim().equals("")) {
                    return 1;
                }
                int n1 = Integer.parseInt(no1);
                if (n1 == (n2 = Integer.parseInt(no2))) {
                    return 0;
                }
                if (n1 > n2) {
                    return 1;
                }
                return -1;
            }
        };
        this.diffTable.setComparator(0, startEndComparator);
        this.diffTable.setComparator(1, startEndComparator);
        this.diffTable.setComparator(7, startEndComparator);
        this.diffTable.setComparator(8, startEndComparator);
        this.diffTable.setSortable(true);
        this.diffTable.setSortedColumn(5);
        this.diffTable.setAscending(true);
        this.scroller = new JScrollPane(this.diffTable);
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.getContentPane().add((Component)this.scroller, constraints);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        this.bottomTabbedPane = new JTabbedPane(3, 0);
        this.statisticsPane = new JPanel(new GridBagLayout());
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.insets = new Insets(2, 2, 2, 2);
        constraints2.gridx = 0;
        constraints2.anchor = 17;
        JLabel lbl = new JLabel("Correct:");
        lbl.setToolTipText("Correct:");
        lbl.setBackground(this.diffTable.getBackground());
        this.statisticsPane.add((Component)lbl, constraints2);
        lbl = new JLabel("Partially correct:");
        lbl.setToolTipText("Partially correct:");
        lbl.setBackground(PARTIALLY_CORRECT_BG);
        lbl.setOpaque(true);
        this.statisticsPane.add((Component)lbl, constraints2);
        lbl = new JLabel("Missing:");
        lbl.setToolTipText("Missing:");
        lbl.setBackground(MISSING_BG);
        lbl.setOpaque(true);
        this.statisticsPane.add((Component)lbl, constraints2);
        lbl = new JLabel("False positives:");
        lbl.setToolTipText("False positives:");
        lbl.setBackground(FALSE_POSITIVE_BG);
        lbl.setOpaque(true);
        this.statisticsPane.add((Component)lbl, constraints2);
        ++constraints2.gridx;
        this.correctLbl = new JLabel("0");
        this.statisticsPane.add((Component)this.correctLbl, constraints2);
        this.partiallyCorrectLbl = new JLabel("0");
        this.statisticsPane.add((Component)this.partiallyCorrectLbl, constraints2);
        this.missingLbl = new JLabel("0");
        this.statisticsPane.add((Component)this.missingLbl, constraints2);
        this.falsePozLbl = new JLabel("0");
        this.statisticsPane.add((Component)this.falsePozLbl, constraints2);
        ++constraints2.gridx;
        constraints2.insets = new Insets(4, 30, 4, 4);
        this.statisticsPane.add(Box.createGlue());
        lbl = new JLabel("Strict:");
        this.statisticsPane.add((Component)lbl, constraints2);
        lbl = new JLabel("Lenient:");
        this.statisticsPane.add((Component)lbl, constraints2);
        lbl = new JLabel("Average:");
        this.statisticsPane.add((Component)lbl, constraints2);
        ++constraints2.gridx;
        constraints2.insets = new Insets(4, 4, 4, 4);
        lbl = new JLabel("Recall");
        this.statisticsPane.add((Component)lbl, constraints2);
        this.recallStrictLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.recallStrictLbl, constraints2);
        this.recallLenientLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.recallLenientLbl, constraints2);
        this.recallAveLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.recallAveLbl, constraints2);
        ++constraints2.gridx;
        lbl = new JLabel("Precision");
        this.statisticsPane.add((Component)lbl, constraints2);
        this.precisionStrictLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.precisionStrictLbl, constraints2);
        this.precisionLenientLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.precisionLenientLbl, constraints2);
        this.precisionAveLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.precisionAveLbl, constraints2);
        ++constraints2.gridx;
        lbl = new JLabel("F-measure");
        lbl.setToolTipText("<html>F-measure =<br>   ((weight\u00b2 + 1) * precision * recall)<br> / (weight\u00b2 * precision + recall))</html>");
        this.statisticsPane.add((Component)lbl, constraints2);
        this.fmeasureStrictLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.fmeasureStrictLbl, constraints2);
        this.fmeasureLenientLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.fmeasureLenientLbl, constraints2);
        this.fmeasureAveLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.fmeasureAveLbl, constraints2);
        this.bottomTabbedPane.add("Statistics", this.statisticsPane);
        JPanel adjudicationPane = new JPanel(new GridBagLayout());
        constraints2 = new GridBagConstraints();
        constraints2.insets = new Insets(2, 2, 2, 2);
        constraints2.gridy = 0;
        adjudicationPane.add((Component)new JLabel("Target set:"), constraints2);
        this.consensusASTextField = new JTextField("consensus", 15);
        this.consensusASTextField.setToolTipText("Annotation set name where to copy the selected annotations");
        adjudicationPane.add((Component)this.consensusASTextField, constraints2);
        ++constraints2.gridy;
        constraints2.gridx = 0;
        this.copyToTargetSetAction = new CopyToTargetSetAction();
        this.copyToTargetSetAction.setEnabled(false);
        this.copyToConsensusBtn = new JButton(this.copyToTargetSetAction);
        this.copyToConsensusBtn.setDisabledIcon(new RightArrowIcon(MainFrame.ICON_DIMENSION, true));
        constraints2.gridwidth = 2;
        adjudicationPane.add((Component)this.copyToConsensusBtn, constraints2);
        this.bottomTabbedPane.add("Adjudication", adjudicationPane);
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        constraints2 = new GridBagConstraints();
        constraints2.insets = new Insets(2, 2, 2, 2);
        constraints2.gridx = 0;
        constraints2.gridy = 0;
        constraints2.gridheight = 3;
        constraints2.anchor = 17;
        bottomPanel.add((Component)this.bottomTabbedPane, constraints2);
        constraints2.gridheight = 1;
        ++constraints2.gridx;
        this.statusLabel = new JLabel();
        this.statusLabel.setBackground(this.diffTable.getBackground());
        constraints2.insets = new Insets(2, 6, 6, 2);
        bottomPanel.add((Component)this.statusLabel, constraints2);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        if (!this.isStandalone) {
            this.showDocumentAction = new ShowDocumentAction();
            this.showDocumentAction.setEnabled(false);
            this.showDocumentBtn = new JButton(this.showDocumentAction);
            this.showDocumentBtn.setDisabledIcon(new DocumentIcon(MainFrame.ICON_DIMENSION, true));
            this.showDocumentBtn.setToolTipText("Use first the \"Compare\" button then select an annotation in the table.");
            toolbar.add(this.showDocumentBtn);
        }
        this.htmlExportAction = new HTMLExportAction();
        this.htmlExportAction.setEnabled(false);
        this.htmlExportBtn = new JButton(this.htmlExportAction);
        this.htmlExportBtn.setDisabledIcon(new DownIcon(MainFrame.ICON_DIMENSION, true));
        this.htmlExportBtn.setToolTipText("Use first the \"Compare\" button.");
        toolbar.add(this.htmlExportBtn);
        if (!this.isStandalone) {
            toolbar.add(new HelpAction());
        }
        ++constraints2.gridy;
        constraints2.fill = 0;
        constraints2.anchor = 18;
        bottomPanel.add((Component)toolbar, constraints2);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimumSize(new Dimension(5, 5));
        this.progressBar.setBackground(this.diffTable.getBackground());
        this.progressBar.setOpaque(true);
        ++constraints2.gridy;
        constraints2.anchor = 16;
        bottomPanel.add((Component)this.progressBar, constraints2);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)bottomPanel, constraints);
        constraints.insets = new Insets(2, 2, 2, 2);
        Color background = this.diffTable.getBackground();
        this.getContentPane().setBackground(background);
        this.scroller.setBackground(background);
        this.scroller.getViewport().setBackground(background);
        this.statisticsPane.setBackground(background);
        adjudicationPane.setBackground(background);
        bottomPanel.setBackground(background);
        this.bottomTabbedPane.setBackground(background);
        this.featureslistModel = new DefaultListModel();
        this.featuresList = new JList<String>(this.featureslistModel);
        this.featuresList.setSelectionMode(2);
        this.keySetCombo.requestFocusInWindow();
    }

    protected void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                new CloseAction().actionPerformed(null);
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                AnnotationDiffGUI.this.populateGUI();
            }
        });
        this.keyDocCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int keyDocSelectedIndex = AnnotationDiffGUI.this.keyDocCombo.getSelectedIndex();
                if (keyDocSelectedIndex == -1) {
                    return;
                }
                Document newDoc = (Document)AnnotationDiffGUI.this.documents.get(keyDocSelectedIndex);
                if (AnnotationDiffGUI.this.keyDoc == newDoc) {
                    return;
                }
                AnnotationDiffGUI.this.pairings.clear();
                AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                AnnotationDiffGUI.this.copyToTargetSetAction.setEnabled(false);
                AnnotationDiffGUI.this.keyDoc = newDoc;
                AnnotationDiffGUI.this.keySets = new ArrayList<AnnotationSet>();
                ArrayList<String> keySetNames = new ArrayList<String>();
                AnnotationDiffGUI.this.keySets.add(AnnotationDiffGUI.this.keyDoc.getAnnotations());
                keySetNames.add("[Default set]");
                if (AnnotationDiffGUI.this.keyDoc.getNamedAnnotationSets() != null) {
                    Iterator<String> iterator = AnnotationDiffGUI.this.keyDoc.getNamedAnnotationSets().keySet().iterator();
                    while (iterator.hasNext()) {
                        String o;
                        String name = o = iterator.next();
                        keySetNames.add(name);
                        AnnotationDiffGUI.this.keySets.add(AnnotationDiffGUI.this.keyDoc.getAnnotations(name));
                    }
                }
                AnnotationDiffGUI.this.keySetCombo.setModel(new DefaultComboBoxModel<String>(keySetNames.toArray(new String[keySetNames.size()])));
                if (!keySetNames.isEmpty()) {
                    AnnotationDiffGUI.this.keySetCombo.setSelectedIndex(0);
                    if (AnnotationDiffGUI.this.resSetCombo.getItemCount() > 0) {
                        for (int res = 0; res < AnnotationDiffGUI.this.resSetCombo.getItemCount(); ++res) {
                            AnnotationDiffGUI.this.resSetCombo.setSelectedIndex(res);
                            for (int key = 0; key < AnnotationDiffGUI.this.keySetCombo.getItemCount(); ++key) {
                                if (AnnotationDiffGUI.this.keyDoc.equals(AnnotationDiffGUI.this.resDoc) && AnnotationDiffGUI.this.resSetCombo.getItemAt(res).equals(AnnotationDiffGUI.this.keySetCombo.getItemAt(key))) continue;
                                AnnotationDiffGUI.this.keySetCombo.setSelectedIndex(key);
                                if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() != null) break;
                            }
                            if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() != null) break;
                        }
                        if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() == null) {
                            AnnotationDiffGUI.this.statusLabel.setText("There is no annotation type in common.");
                            AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                        } else if (AnnotationDiffGUI.this.statusLabel.getText().equals("There is no annotation type in common.")) {
                            AnnotationDiffGUI.this.statusLabel.setText("The first annotation sets with annotation type in common have been automatically selected.");
                            AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        }
                    }
                }
            }
        });
        this.resDocCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int resDocSelectedIndex = AnnotationDiffGUI.this.resDocCombo.getSelectedIndex();
                if (resDocSelectedIndex == -1) {
                    return;
                }
                Document newDoc = (Document)AnnotationDiffGUI.this.documents.get(resDocSelectedIndex);
                if (AnnotationDiffGUI.this.resDoc == newDoc) {
                    return;
                }
                AnnotationDiffGUI.this.resDoc = newDoc;
                AnnotationDiffGUI.this.pairings.clear();
                AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                AnnotationDiffGUI.this.copyToTargetSetAction.setEnabled(false);
                AnnotationDiffGUI.this.resSets = new ArrayList<AnnotationSet>();
                ArrayList<String> resSetNames = new ArrayList<String>();
                AnnotationDiffGUI.this.resSets.add(AnnotationDiffGUI.this.resDoc.getAnnotations());
                resSetNames.add("[Default set]");
                if (AnnotationDiffGUI.this.resDoc.getNamedAnnotationSets() != null) {
                    Iterator<String> iterator = AnnotationDiffGUI.this.resDoc.getNamedAnnotationSets().keySet().iterator();
                    while (iterator.hasNext()) {
                        String o;
                        String name = o = iterator.next();
                        resSetNames.add(name);
                        AnnotationDiffGUI.this.resSets.add(AnnotationDiffGUI.this.resDoc.getAnnotations(name));
                    }
                }
                AnnotationDiffGUI.this.resSetCombo.setModel(new DefaultComboBoxModel<String>(resSetNames.toArray(new String[resSetNames.size()])));
                if (!resSetNames.isEmpty()) {
                    AnnotationDiffGUI.this.resSetCombo.setSelectedIndex(0);
                    if (AnnotationDiffGUI.this.keySetCombo.getItemCount() > 0) {
                        for (int res = 0; res < AnnotationDiffGUI.this.resSetCombo.getItemCount(); ++res) {
                            AnnotationDiffGUI.this.resSetCombo.setSelectedIndex(res);
                            for (int key = 0; key < AnnotationDiffGUI.this.keySetCombo.getItemCount(); ++key) {
                                if (AnnotationDiffGUI.this.keyDoc.equals(AnnotationDiffGUI.this.resDoc) && AnnotationDiffGUI.this.resSetCombo.getItemAt(res).equals(AnnotationDiffGUI.this.keySetCombo.getItemAt(key))) continue;
                                AnnotationDiffGUI.this.keySetCombo.setSelectedIndex(key);
                                if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() != null) break;
                            }
                            if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() != null) break;
                        }
                        if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() == null) {
                            AnnotationDiffGUI.this.statusLabel.setText("There is no annotations in common.");
                            AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                        } else if (AnnotationDiffGUI.this.statusLabel.getText().equals("There is no annotations in common.")) {
                            AnnotationDiffGUI.this.statusLabel.setText("The first annotation sets with annotations in common have been selected.");
                            AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        }
                    }
                }
            }
        });
        ActionListener setComboActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationDiffGUI.this.keySet = AnnotationDiffGUI.this.keySets == null || AnnotationDiffGUI.this.keySets.isEmpty() ? null : AnnotationDiffGUI.this.keySets.get(AnnotationDiffGUI.this.keySetCombo.getSelectedIndex());
                AnnotationDiffGUI.this.resSet = AnnotationDiffGUI.this.resSets == null || AnnotationDiffGUI.this.resSets.isEmpty() ? null : AnnotationDiffGUI.this.resSets.get(AnnotationDiffGUI.this.resSetCombo.getSelectedIndex());
                HashSet keyTypes = AnnotationDiffGUI.this.keySet == null || AnnotationDiffGUI.this.keySet.isEmpty() ? new HashSet() : AnnotationDiffGUI.this.keySet.getAllTypes();
                HashSet resTypes = AnnotationDiffGUI.this.resSet == null || AnnotationDiffGUI.this.resSet.isEmpty() ? new HashSet() : AnnotationDiffGUI.this.resSet.getAllTypes();
                HashSet types = new HashSet(keyTypes);
                types.retainAll(resTypes);
                ArrayList typesList = new ArrayList(types);
                Collections.sort(typesList);
                AnnotationDiffGUI.this.annTypeCombo.setModel(new DefaultComboBoxModel<String>(typesList.toArray(new String[typesList.size()])));
                if (typesList.size() > 0) {
                    AnnotationDiffGUI.this.annTypeCombo.setSelectedIndex(0);
                    AnnotationDiffGUI.this.diffAction.setEnabled(true);
                    AnnotationDiffGUI.this.doDiffBtn.setForeground((Color)UIManager.getDefaults().get("Button.foreground"));
                    AnnotationDiffGUI.this.doDiffBtn.setToolTipText((String)AnnotationDiffGUI.this.diffAction.getValue("ShortDescription"));
                } else {
                    AnnotationDiffGUI.this.diffAction.setEnabled(false);
                    AnnotationDiffGUI.this.doDiffBtn.setForeground((Color)UIManager.getDefaults().get("Button.disabledText"));
                    AnnotationDiffGUI.this.doDiffBtn.setToolTipText("Choose two annotation sets that have at least one annotation type in common.");
                }
            }
        };
        this.keySetCombo.addActionListener(setComboActionListener);
        this.resSetCombo.addActionListener(setComboActionListener);
        this.someFeaturesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AnnotationDiffGUI.this.someFeaturesBtn.isSelected()) {
                    if (AnnotationDiffGUI.this.keySet == null || AnnotationDiffGUI.this.keySet.isEmpty() || AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() == null) {
                        return;
                    }
                    Iterator<Annotation> annIter = AnnotationDiffGUI.this.keySet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem()).iterator();
                    HashSet<String> featureSet = new HashSet<String>();
                    while (annIter.hasNext()) {
                        Annotation ann = annIter.next();
                        FeatureMap someFeatures = ann.getFeatures();
                        if (someFeatures == null) continue;
                        for (Object feature : someFeatures.keySet()) {
                            featureSet.add((String)feature);
                        }
                    }
                    ArrayList featureList = new ArrayList(featureSet);
                    Collections.sort(featureList);
                    AnnotationDiffGUI.this.featureslistModel.clear();
                    Iterator featIter = featureList.iterator();
                    int index = 0;
                    while (featIter.hasNext()) {
                        String aFeature = (String)featIter.next();
                        AnnotationDiffGUI.this.featureslistModel.addElement(aFeature);
                        if (AnnotationDiffGUI.this.significantFeatures.contains(aFeature)) {
                            AnnotationDiffGUI.this.featuresList.addSelectionInterval(index, index);
                        }
                        ++index;
                    }
                    int ret = JOptionPane.showConfirmDialog(AnnotationDiffGUI.this, new JScrollPane(AnnotationDiffGUI.this.featuresList), "Select features", 2, 3);
                    if (ret == 0) {
                        int[] selIdxs;
                        AnnotationDiffGUI.this.significantFeatures.clear();
                        for (int selIdx : selIdxs = AnnotationDiffGUI.this.featuresList.getSelectedIndices()) {
                            AnnotationDiffGUI.this.significantFeatures.add(AnnotationDiffGUI.this.featureslistModel.get(selIdx));
                        }
                    }
                }
            }
        });
        this.diffTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (AnnotationDiffGUI.this.diffTableModel.getRowCount() > 0) {
                    AnnotationDiffGUI.this.htmlExportAction.setEnabled(true);
                    AnnotationDiffGUI.this.htmlExportBtn.setToolTipText((String)AnnotationDiffGUI.this.htmlExportAction.getValue("ShortDescription"));
                    AnnotationDiffGUI.this.showDocumentAction.setEnabled(true);
                    AnnotationDiffGUI.this.showDocumentBtn.setToolTipText((String)AnnotationDiffGUI.this.showDocumentAction.getValue("ShortDescription"));
                } else {
                    AnnotationDiffGUI.this.htmlExportAction.setEnabled(false);
                    AnnotationDiffGUI.this.htmlExportBtn.setToolTipText("Use first the \"Compare\" button.");
                    AnnotationDiffGUI.this.showDocumentAction.setEnabled(false);
                    AnnotationDiffGUI.this.showDocumentBtn.setToolTipText("Use first the \"Compare\" button then select an annotation in the table.");
                }
            }
        });
        this.diffTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean enabled;
                int row = AnnotationDiffGUI.this.diffTable.rowViewToModel(AnnotationDiffGUI.this.diffTable.getSelectedRow());
                if (row == -1) {
                    AnnotationDiffGUI.this.showDocumentAction.setEnabled(false);
                    return;
                }
                AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(row);
                Annotation key = pairing.getKey();
                Annotation response = pairing.getResponse();
                int column = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(AnnotationDiffGUI.this.diffTable.getSelectedColumn());
                switch (column) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        enabled = key != null;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        enabled = response != null;
                        break;
                    }
                    default: {
                        enabled = false;
                    }
                }
                AnnotationDiffGUI.this.showDocumentAction.setEnabled(enabled);
            }
        });
        this.diffTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                boolean enabled;
                int row = AnnotationDiffGUI.this.diffTable.rowViewToModel(AnnotationDiffGUI.this.diffTable.getSelectedRow());
                if (row == -1) {
                    AnnotationDiffGUI.this.showDocumentAction.setEnabled(false);
                    return;
                }
                AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(row);
                Annotation key = pairing.getKey();
                Annotation response = pairing.getResponse();
                int column = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(AnnotationDiffGUI.this.diffTable.getSelectedColumn());
                switch (column) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        enabled = key != null;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        enabled = response != null;
                        break;
                    }
                    default: {
                        enabled = false;
                    }
                }
                AnnotationDiffGUI.this.showDocumentAction.setEnabled(enabled);
            }
        });
        this.diffTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int[] cols;
                if (e.getKeyCode() != 32 || !AnnotationDiffGUI.this.diffTable.isColumnSelected(4) && !AnnotationDiffGUI.this.diffTable.isColumnSelected(6)) {
                    return;
                }
                e.consume();
                for (int col : cols = new int[]{4, 6}) {
                    for (int row : AnnotationDiffGUI.this.diffTable.getSelectedRows()) {
                        if (!AnnotationDiffGUI.this.diffTable.isCellSelected(row, col) || !AnnotationDiffGUI.this.diffTable.isCellEditable(row, col)) continue;
                        AnnotationDiffGUI.this.diffTable.setValueAt((Boolean)AnnotationDiffGUI.this.diffTable.getValueAt(row, col) == false, row, col);
                        AnnotationDiffGUI.this.diffTableModel.fireTableCellUpdated(row, col);
                    }
                }
            }
        });
        this.diffTable.addMouseListener(new MouseAdapter(){
            private JPopupMenu mousePopup;
            JMenuItem menuItem;

            @Override
            public void mousePressed(MouseEvent e) {
                this.showContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showContextMenu(e);
            }

            private void showContextMenu(MouseEvent e) {
                int col = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(AnnotationDiffGUI.this.diffTable.columnAtPoint(e.getPoint()));
                if (!e.isPopupTrigger() || col != 4 && col != 6) {
                    return;
                }
                this.mousePopup = new JPopupMenu();
                for (final String tick : new String[]{"Tick", "Untick"}) {
                    this.menuItem = new JMenuItem(tick + " selected check boxes");
                    this.menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            int keyCol = AnnotationDiffGUI.this.diffTable.convertColumnIndexToView(4);
                            int responseCol = AnnotationDiffGUI.this.diffTable.convertColumnIndexToView(6);
                            for (int row = 0; row < AnnotationDiffGUI.this.diffTable.getRowCount(); ++row) {
                                int rowModel = AnnotationDiffGUI.this.diffTable.rowViewToModel(row);
                                AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(rowModel);
                                if (AnnotationDiffGUI.this.diffTable.isCellSelected(row, keyCol) && pairing.getKey() != null) {
                                    AnnotationDiffGUI.this.diffTable.setValueAt(tick.equals("Tick"), row, keyCol);
                                }
                                if (!AnnotationDiffGUI.this.diffTable.isCellSelected(row, responseCol) || pairing.getResponse() == null) continue;
                                AnnotationDiffGUI.this.diffTable.setValueAt(tick.equals("Tick"), row, responseCol);
                            }
                            AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                        }
                    });
                    this.mousePopup.add(this.menuItem);
                }
                this.mousePopup.addSeparator();
                String[] types = new String[]{"correct", "partially correct", "missing", "false positives", "mismatch"};
                String[] symbols = new String[]{"=", "~", "-?", "?-", "<>"};
                for (int i = 0; i < types.length; ++i) {
                    this.menuItem = new JMenuItem("Tick " + types[i] + " annotations");
                    final String symbol = symbols[i];
                    this.menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            int matchCol = AnnotationDiffGUI.this.diffTable.convertColumnIndexToView(5);
                            for (int row = 0; row < AnnotationDiffGUI.this.diffTable.getRowCount(); ++row) {
                                int rowModel = AnnotationDiffGUI.this.diffTable.rowViewToModel(row);
                                AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(rowModel);
                                if (AnnotationDiffGUI.this.diffTable.getValueAt(row, matchCol).equals(symbol) && pairing.getKey() != null) {
                                    AnnotationDiffGUI.this.keyCopyValueRows.set(AnnotationDiffGUI.this.diffTable.rowViewToModel(row), true);
                                    continue;
                                }
                                if (!AnnotationDiffGUI.this.diffTable.getValueAt(row, matchCol).equals(symbol) || pairing.getResponse() == null) continue;
                                AnnotationDiffGUI.this.resCopyValueRows.set(AnnotationDiffGUI.this.diffTable.rowViewToModel(row), true);
                            }
                            AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                        }
                    });
                    this.mousePopup.add(this.menuItem);
                }
                this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.consensusASTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String target = AnnotationDiffGUI.this.consensusASTextField.getText().trim();
                if (target.length() == 0) {
                    AnnotationDiffGUI.this.consensusASTextField.setText("consensus");
                }
                if (AnnotationDiffGUI.this.keyDoc != null && AnnotationDiffGUI.this.keyDoc.getAnnotationSetNames().contains(target)) {
                    AnnotationDiffGUI.this.statusLabel.setText("Be careful, the annotation set " + target + " already exists.");
                    AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                }
            }
        });
        this.bottomTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AnnotationDiffGUI.this.bottomTabbedPane.getSelectedIndex() == 0) {
                    AnnotationDiffGUI.this.diffTable.hideColumn(4);
                    AnnotationDiffGUI.this.diffTable.hideColumn(6);
                } else {
                    int middleIndex = Math.round(AnnotationDiffGUI.this.diffTable.getColumnCount() / 2);
                    AnnotationDiffGUI.this.diffTable.showColumn(4, middleIndex);
                    AnnotationDiffGUI.this.diffTable.showColumn(6, middleIndex + 2);
                    AnnotationDiffGUI.this.diffTable.getColumnModel().getColumn(4).setPreferredWidth(10);
                    AnnotationDiffGUI.this.diffTable.getColumnModel().getColumn(6).setPreferredWidth(10);
                    AnnotationDiffGUI.this.diffTable.doLayout();
                }
            }
        });
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("F1"), "Help");
        actionMap.put("Help", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HelpAction().actionPerformed(null);
            }
        });
    }

    @Override
    public void pack() {
        super.pack();
        this.setSize(this.getWidth(), this.getHeight() + 300);
    }

    protected void populateGUI() {
        try {
            this.documents = Gate.getCreoleRegister().getAllInstances("gate.Document");
        }
        catch (GateException ge) {
            throw new GateRuntimeException(ge);
        }
        ArrayList<String> documentNames = new ArrayList<String>(this.documents.size());
        for (Resource document : this.documents) {
            documentNames.add(document.getName());
        }
        Object keyDocSelectedItem = this.keyDocCombo.getSelectedItem();
        Object resDocSelectedItem = this.resDocCombo.getSelectedItem();
        this.keyDocCombo.setModel(new DefaultComboBoxModel<String>(documentNames.toArray(new String[documentNames.size()])));
        this.resDocCombo.setModel(new DefaultComboBoxModel<String>(documentNames.toArray(new String[documentNames.size()])));
        if (!this.documents.isEmpty()) {
            this.keyDocCombo.setSelectedItem(keyDocSelectedItem);
            if (this.keyDocCombo.getSelectedIndex() == -1) {
                this.keyDocCombo.setSelectedIndex(0);
            }
            this.resDocCombo.setSelectedItem(resDocSelectedItem);
            if (this.resDocCombo.getSelectedIndex() == -1) {
                this.resDocCombo.setSelectedIndex(0);
            }
            this.statusLabel.setText(this.documents.size() + " documents loaded");
            if (this.annTypeCombo.getSelectedItem() == null) {
                this.statusLabel.setText(this.statusLabel.getText() + ". Choose two annotation sets to compare.");
            }
            this.statusLabel.setForeground(Color.BLACK);
        } else {
            this.statusLabel.setText("You must load at least one document.");
            this.statusLabel.setForeground(Color.RED);
        }
    }

    static {
        AnnotationDiffGUI.matchLabel[0] = "=";
        AnnotationDiffGUI.matchLabel[1] = "~";
        AnnotationDiffGUI.matchLabel[2] = "-?";
        AnnotationDiffGUI.matchLabel[3] = "?-";
        AnnotationDiffGUI.matchLabel[4] = "<>";
    }

    protected class DiffTableModel
    extends AbstractTableModel {
        protected static final int COL_COUNT = 11;
        protected static final int COL_KEY_START = 0;
        protected static final int COL_KEY_END = 1;
        protected static final int COL_KEY_STRING = 2;
        protected static final int COL_KEY_FEATURES = 3;
        protected static final int COL_KEY_COPY = 4;
        protected static final int COL_MATCH = 5;
        protected static final int COL_RES_COPY = 6;
        protected static final int COL_RES_START = 7;
        protected static final int COL_RES_END = 8;
        protected static final int COL_RES_STRING = 9;
        protected static final int COL_RES_FEATURES = 10;

        protected DiffTableModel() {
        }

        @Override
        public int getRowCount() {
            return AnnotationDiffGUI.this.pairings.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 4: {
                    return Boolean.class;
                }
                case 6: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 11;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Start";
                }
                case 1: {
                    return "End";
                }
                case 2: {
                    return "Key";
                }
                case 3: {
                    return "Features";
                }
                case 4: {
                    return "K";
                }
                case 5: {
                    return "=?";
                }
                case 6: {
                    return "R";
                }
                case 7: {
                    return "Start";
                }
                case 8: {
                    return "End";
                }
                case 9: {
                    return "Response";
                }
                case 10: {
                    return "Features";
                }
            }
            return "?";
        }

        public Color getBackgroundAt(int row, int column) {
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(row);
            switch (pairing.getType()) {
                case 0: {
                    return AnnotationDiffGUI.this.diffTable.getBackground();
                }
                case 1: {
                    return PARTIALLY_CORRECT_BG;
                }
                case 4: {
                    if (column < 5) {
                        return MISSING_BG;
                    }
                    if (column > 5) {
                        return FALSE_POSITIVE_BG;
                    }
                    return AnnotationDiffGUI.this.diffTable.getBackground();
                }
                case 2: {
                    return MISSING_BG;
                }
                case 3: {
                    return FALSE_POSITIVE_BG;
                }
            }
            return AnnotationDiffGUI.this.diffTable.getBackground();
        }

        @Override
        public Object getValueAt(int row, int column) {
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(row);
            Annotation key = pairing.getKey();
            Annotation res = pairing.getResponse();
            switch (column) {
                case 0: {
                    return key == null ? "" : key.getStartNode().getOffset().toString();
                }
                case 1: {
                    return key == null ? "" : key.getEndNode().getOffset().toString();
                }
                case 2: {
                    String keyStr = "";
                    try {
                        if (key != null && AnnotationDiffGUI.this.keyDoc != null) {
                            keyStr = AnnotationDiffGUI.this.keyDoc.getContent().getContent(key.getStartNode().getOffset(), key.getEndNode().getOffset()).toString();
                        }
                    }
                    catch (InvalidOffsetException ioe) {
                        throw new GateRuntimeException(ioe);
                    }
                    if (keyStr.length() > 40) {
                        keyStr = keyStr.substring(0, 20) + "..." + keyStr.substring(keyStr.length() - 20);
                    }
                    keyStr = keyStr.replaceAll("(?:\r?\n)|\r", "\u2193");
                    keyStr = keyStr.replaceAll("\t", "\u2192");
                    keyStr = keyStr.replaceAll(" ", "\u00b7");
                    return keyStr;
                }
                case 3: {
                    return key == null ? "" : key.getFeatures().toString();
                }
                case 4: {
                    return AnnotationDiffGUI.this.keyCopyValueRows.get(row);
                }
                case 5: {
                    return matchLabel[pairing.getType()];
                }
                case 6: {
                    return AnnotationDiffGUI.this.resCopyValueRows.get(row);
                }
                case 7: {
                    return res == null ? "" : res.getStartNode().getOffset().toString();
                }
                case 8: {
                    return res == null ? "" : res.getEndNode().getOffset().toString();
                }
                case 9: {
                    String resStr = "";
                    try {
                        if (res != null && AnnotationDiffGUI.this.resDoc != null) {
                            resStr = AnnotationDiffGUI.this.resDoc.getContent().getContent(res.getStartNode().getOffset(), res.getEndNode().getOffset()).toString();
                        }
                    }
                    catch (InvalidOffsetException ioe) {
                        throw new GateRuntimeException(ioe);
                    }
                    if (resStr.length() > 40) {
                        resStr = resStr.substring(0, 20) + "..." + resStr.substring(resStr.length() - 20);
                    }
                    resStr = resStr.replaceAll("(?:\r?\n)|\r", "\u2193");
                    resStr = resStr.replaceAll("\t", "\u2192");
                    resStr = resStr.replaceAll(" ", "\u00b7");
                    return resStr;
                }
                case 10: {
                    return res == null ? "" : res.getFeatures().toString();
                }
            }
            return "?";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (AnnotationDiffGUI.this.pairings.size() == 0) {
                return false;
            }
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(rowIndex);
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    return pairing.getKey() != null;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    return pairing.getResponse() != null;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(rowIndex);
            AnnotationSet keyAS = AnnotationDiffGUI.this.keyDoc.getAnnotations((String)AnnotationDiffGUI.this.keySetCombo.getSelectedItem());
            AnnotationSet responseAS = AnnotationDiffGUI.this.resDoc.getAnnotations((String)AnnotationDiffGUI.this.resSetCombo.getSelectedItem());
            Annotation key = pairing.getKey();
            Annotation res = pairing.getResponse();
            String step = (String)AnnotationDiffGUI.this.keyDoc.getFeatures().get("anndiffsteps");
            if (step == null) {
                step = "0";
            }
            int id = -1;
            try {
                switch (columnIndex) {
                    case 0: {
                        if (Long.valueOf((String)aValue).equals(key.getStartNode().getOffset())) break;
                        id = keyAS.add(Long.valueOf((String)aValue), key.getEndNode().getOffset(), key.getType(), (FeatureMap)((SimpleFeatureMapImpl)key.getFeatures()).clone());
                        keyAS.get(id).getFeatures().put("anndiffmodified", "true");
                        if (key.getFeatures().containsKey("anndiffmodified")) {
                            keyAS.remove(key);
                        } else {
                            key.getFeatures().put("anndiffstep", step);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("Start offset changed: " + key.getStartNode().getOffset() + " -> " + aValue + ".");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 1: {
                        if (Long.valueOf((String)aValue).equals(key.getEndNode().getOffset())) break;
                        id = keyAS.add(key.getStartNode().getOffset(), Long.valueOf((String)aValue), key.getType(), (FeatureMap)((SimpleFeatureMapImpl)key.getFeatures()).clone());
                        keyAS.get(id).getFeatures().put("anndiffmodified", "true");
                        if (key.getFeatures().containsKey("anndiffmodified")) {
                            keyAS.remove(key);
                        } else {
                            key.getFeatures().put("anndiffstep", step);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("End offset changed: " + key.getEndNode().getOffset() + " -> " + aValue + ".");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 3: {
                        String keysValues = (String)aValue;
                        keysValues = keysValues.replaceAll("\\s+", " ").replaceAll("[}{]", "");
                        FeatureMap features = Factory.newFeatureMap();
                        if (keysValues.length() != 0) {
                            for (String keyValue : keysValues.split(",")) {
                                String[] keyOrValue = keyValue.split("=");
                                if (keyOrValue.length != 2) {
                                    throw new NumberFormatException();
                                }
                                features.put(keyOrValue[0].trim(), keyOrValue[1].trim());
                            }
                        }
                        if (features.equals(key.getFeatures())) break;
                        id = keyAS.add(key.getStartNode().getOffset(), key.getEndNode().getOffset(), key.getType(), features);
                        keyAS.get(id).getFeatures().put("anndiffmodified", "true");
                        if (key.getFeatures().containsKey("anndiffmodified")) {
                            keyAS.remove(key);
                        } else {
                            key.getFeatures().put("anndiffstep", step);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("Features changed.");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 4: {
                        AnnotationDiffGUI.this.keyCopyValueRows.set(rowIndex, (Boolean)aValue);
                        break;
                    }
                    case 6: {
                        AnnotationDiffGUI.this.resCopyValueRows.set(rowIndex, (Boolean)aValue);
                        break;
                    }
                    case 7: {
                        if (Long.valueOf((String)aValue).equals(res.getStartNode().getOffset())) break;
                        id = responseAS.add(Long.valueOf((String)aValue), res.getEndNode().getOffset(), res.getType(), (FeatureMap)((SimpleFeatureMapImpl)res.getFeatures()).clone());
                        responseAS.get(id).getFeatures().put("anndiffmodified", "true");
                        if (res.getFeatures().containsKey("anndiffmodified")) {
                            responseAS.remove(res);
                        } else {
                            res.getFeatures().put("anndiffstep", step);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("Start offset changed: " + res.getStartNode().getOffset() + " -> " + aValue + ".");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 8: {
                        if (Long.valueOf((String)aValue).equals(res.getEndNode().getOffset())) break;
                        id = responseAS.add(res.getStartNode().getOffset(), Long.valueOf((String)aValue), res.getType(), (FeatureMap)((SimpleFeatureMapImpl)res.getFeatures()).clone());
                        responseAS.get(id).getFeatures().put("anndiffmodified", "true");
                        if (res.getFeatures().containsKey("anndiffmodified")) {
                            responseAS.remove(res);
                        } else {
                            res.getFeatures().put("anndiffstep", step);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("End offset changed: " + res.getEndNode().getOffset() + " -> " + aValue + ".");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 10: {
                        String keysValues = (String)aValue;
                        keysValues = keysValues.replaceAll("\\s+", " ").replaceAll("[}{]", "");
                        FeatureMap features = Factory.newFeatureMap();
                        if (keysValues.length() != 0) {
                            for (String keyValue : keysValues.split(",")) {
                                String[] keyOrValue = keyValue.split("=");
                                if (keyOrValue.length != 2) {
                                    throw new NumberFormatException();
                                }
                                features.put(keyOrValue[0].trim(), keyOrValue[1].trim());
                            }
                        }
                        if (features.equals(res.getFeatures())) break;
                        id = responseAS.add(res.getStartNode().getOffset(), res.getEndNode().getOffset(), res.getType(), features);
                        responseAS.get(id).getFeatures().put("anndiffmodified", "true");
                        if (res.getFeatures().containsKey("anndiffmodified")) {
                            responseAS.remove(res);
                        } else {
                            res.getFeatures().put("anndiffstep", step);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("Features changed.");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                    }
                }
            }
            catch (InvalidOffsetException e) {
                AnnotationDiffGUI.this.statusLabel.setText("This offset is incorrect. No changes have been made.");
                AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                return;
            }
            catch (NumberFormatException e) {
                AnnotationDiffGUI.this.statusLabel.setText("The format is incorrect. No changes have been made.");
                AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                return;
            }
            if (id != -1) {
                AnnotationDiffGUI.this.diffAction.actionPerformed(new ActionEvent(this, id, "setvalue"));
            }
        }
    }

    protected class DiffTableCellRenderer
    extends DefaultTableCellRenderer {
        protected DiffTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String tip;
            int rowModel = AnnotationDiffGUI.this.diffTable.rowViewToModel(row);
            int colModel = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(column);
            Component component = value instanceof Boolean ? new JCheckBox() : super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            if (AnnotationDiffGUI.this.pairings.size() == 0 || rowModel >= AnnotationDiffGUI.this.pairings.size()) {
                return component;
            }
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(rowModel);
            component.setBackground(isSelected ? table.getSelectionBackground() : AnnotationDiffGUI.this.diffTableModel.getBackgroundAt(rowModel, column));
            component.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            if (!(component instanceof JComponent)) {
                return component;
            }
            try {
                switch (colModel) {
                    case 2: {
                        Annotation key = pairing.getKey();
                        if (key == null) {
                            tip = null;
                            break;
                        }
                        tip = AnnotationDiffGUI.this.keyDoc.getContent().getContent(key.getStartNode().getOffset(), key.getEndNode().getOffset()).toString();
                        if (tip.length() > 1000) {
                            tip = tip.substring(0, 500) + "<br>...<br>" + tip.substring(tip.length() - 500);
                        }
                        tip = AnnotationDiffGUI.this.keyDoc.getContent().getContent(Math.max(0L, key.getStartNode().getOffset() - 40L), Math.max(0L, key.getStartNode().getOffset())).toString() + "<strong>" + tip + "</strong>" + AnnotationDiffGUI.this.keyDoc.getContent().getContent(Math.min(AnnotationDiffGUI.this.keyDoc.getContent().size(), key.getEndNode().getOffset()), Math.min(AnnotationDiffGUI.this.keyDoc.getContent().size(), key.getEndNode().getOffset() + 40L)).toString();
                        tip = tip.replaceAll("\\s*\n\\s*", "<br>");
                        tip = tip.replaceAll("\\s+", " ");
                        tip = "<html><table width=\"" + (tip.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\"><tr><td>" + tip + "</td></tr><tr><td>";
                        tip = tip + "<small><i>\u2193 = new line, \u2192 = tab, \u00b7 = space</i></small>";
                        tip = tip + "</td></tr></table></html>";
                        break;
                    }
                    case 3: {
                        if (pairing.getKey() == null) {
                            tip = null;
                            break;
                        }
                        String features = pairing.getKey().getFeatures().toString();
                        tip = features + "<br><small><i>To edit, double-click or press F2.</i></small>";
                        tip = "<html><table width=\"" + (tip.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\"><tr><td>" + tip + "</td></tr></table></html>";
                        if (features.length() > 40) {
                            features = features.substring(0, 20) + "..." + features.substring(features.length() - 20);
                        }
                        ((JLabel)component).setText(features);
                        break;
                    }
                    case 4: {
                        tip = pairing.getKey() == null ? "<html>There is no key annotation." : "<html>Select this key annotation to copy.";
                        tip = tip + "<br><small><i>Space key invert the selected check boxes state.<br>Right-click for context menu.</i></small></html>";
                        component.setEnabled(pairing.getKey() != null);
                        ((JCheckBox)component).setSelected(AnnotationDiffGUI.this.keyCopyValueRows.get(rowModel));
                        break;
                    }
                    case 5: {
                        tip = value.equals("=") ? "correct" : (value.equals("~") ? "partially correct" : (value.equals("-?") ? "missing" : (value.equals("?-") ? "false positives" : (value.equals("<>") ? "mismatch" : ""))));
                        break;
                    }
                    case 6: {
                        tip = pairing.getResponse() == null ? "<html>There is no response annotation." : "<html>Select this response annotation to copy.";
                        tip = tip + "<br><small><i>Space key invert the selected check boxes state.<br>Right-click for context menu.</i></small></html>";
                        component.setEnabled(pairing.getResponse() != null);
                        ((JCheckBox)component).setSelected(AnnotationDiffGUI.this.resCopyValueRows.get(rowModel));
                        break;
                    }
                    case 9: {
                        Annotation response = pairing.getResponse();
                        if (response == null) {
                            tip = null;
                            break;
                        }
                        tip = AnnotationDiffGUI.this.resDoc.getContent().getContent(response.getStartNode().getOffset(), response.getEndNode().getOffset()).toString();
                        if (tip.length() > 1000) {
                            tip = tip.substring(0, 500) + "<br>...<br>" + tip.substring(tip.length() - 500);
                        }
                        tip = AnnotationDiffGUI.this.resDoc.getContent().getContent(Math.max(0L, response.getStartNode().getOffset() - 40L), Math.max(0L, response.getStartNode().getOffset())).toString() + "<strong>" + tip + "</strong>" + AnnotationDiffGUI.this.resDoc.getContent().getContent(Math.min(AnnotationDiffGUI.this.resDoc.getContent().size(), response.getEndNode().getOffset()), Math.min(AnnotationDiffGUI.this.resDoc.getContent().size(), response.getEndNode().getOffset() + 40L)).toString();
                        tip = tip.replaceAll("\\s*\n\\s*", "<br>");
                        tip = tip.replaceAll("\\s+", " ");
                        tip = "<html><table width=\"" + (tip.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\"><tr><td>" + tip + "</td></tr><tr><td>";
                        tip = tip + "<small><i>\u2193 = new line, \u2192 = tab, \u00b7 = space</i></small>";
                        tip = tip + "</td></tr></table></html>";
                        break;
                    }
                    case 10: {
                        if (pairing.getResponse() == null) {
                            tip = null;
                            break;
                        }
                        String features = pairing.getResponse().getFeatures().toString();
                        tip = features + "<br><small><i>To edit, double-click or press F2.</i></small>";
                        tip = "<html><table width=\"" + (tip.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\"><tr><td>" + tip + "</td></tr></table></html>";
                        if (features.length() > 40) {
                            features = features.substring(0, 20) + "..." + features.substring(features.length() - 20);
                        }
                        ((JLabel)component).setText(features);
                        break;
                    }
                    default: {
                        Annotation ann;
                        Annotation annotation = ann = colModel < 5 ? pairing.getKey() : pairing.getResponse();
                        if (ann == null) {
                            tip = null;
                            break;
                        }
                        tip = "<html><small><i>To edit, double-click or press F2.</i></small></html>";
                        break;
                    }
                }
            }
            catch (InvalidOffsetException ioe) {
                throw new GateRuntimeException(ioe);
            }
            ((JComponent)component).setToolTipText(tip);
            return component;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MainFrame.getGuiRoots().remove(AnnotationDiffGUI.this);
            AnnotationDiffGUI.this.dispose();
        }
    }

    protected class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", "User guide for this tool");
            this.putValue("SmallIcon", MainFrame.getIcon("Help"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.getInstance().showHelpFrame("sec:eval:annotationdiff", AnnotationDiffGUI.class.getName());
        }
    }

    protected class ShowDocumentAction
    extends AbstractAction {
        public ShowDocumentAction() {
            this.putValue("ShortDescription", "Show the selected annotation in the document editor.");
            this.putValue("SmallIcon", MainFrame.getIcon("document"));
            this.putValue("MnemonicKey", 38);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int rowModel = AnnotationDiffGUI.this.diffTable.rowViewToModel(AnnotationDiffGUI.this.diffTable.getSelectedRow());
            boolean isKeySelected = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(AnnotationDiffGUI.this.diffTable.getSelectedColumn()) < 5;
            final Document doc = isKeySelected ? AnnotationDiffGUI.this.keyDoc : AnnotationDiffGUI.this.resDoc;
            final Annotation annotation = isKeySelected ? AnnotationDiffGUI.this.pairings.get(rowModel).getKey() : AnnotationDiffGUI.this.pairings.get(rowModel).getResponse();
            final String asname = isKeySelected ? AnnotationDiffGUI.this.keySet.getName() : AnnotationDiffGUI.this.resSet.getName();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.getInstance().select(doc);
                    Date timeToRun = new Date(System.currentTimeMillis() + 1000L);
                    Timer timer = new Timer("Annotation diff show document timer", true);
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            ShowDocumentAction.this.showExpressionInDocument(doc, annotation, asname);
                        }
                    }, timeToRun);
                }
            });
        }

        private void showExpressionInDocument(Document doc, Annotation annotation, String asname) {
            try {
                AbstractDocumentView t = null;
                for (Resource r : Gate.getCreoleRegister().getAllInstances("gate.gui.docview.TextualDocumentView")) {
                    if (!((TextualDocumentView)r).getDocument().getName().equals(doc.getName())) continue;
                    t = (TextualDocumentView)r;
                    break;
                }
                if (t != null && t.getOwner() != null) {
                    t.getOwner().setRightView(0);
                    try {
                        ((TextualDocumentView)t).getTextView().scrollRectToVisible(((TextualDocumentView)t).getTextView().modelToView(annotation.getStartNode().getOffset().intValue()));
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                        return;
                    }
                    ((TextualDocumentView)t).getTextView().select(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue());
                }
                for (Resource r : Gate.getCreoleRegister().getAllInstances("gate.gui.docview.AnnotationSetsView")) {
                    AnnotationSetsView asv = (AnnotationSetsView)r;
                    if (asv.getDocument() == null || !asv.isActive() || !asv.getDocument().getName().equals(doc.getName())) continue;
                    String type = annotation.getType();
                    if (asname == null && doc.getAnnotations().getAllTypes().contains(type)) {
                        asv.setTypeSelected(null, type, true);
                        continue;
                    }
                    if (!doc.getAnnotationSetNames().contains(asname) || !doc.getAnnotations(asname).getAllTypes().contains(type)) continue;
                    asv.setTypeSelected(asname, type, true);
                }
                AnnotationDiffGUI.this.diffTable.requestFocusInWindow();
            }
            catch (GateException e) {
                e.printStackTrace();
            }
        }
    }

    protected class HTMLExportAction
    extends AbstractAction {
        static final String HEADER_1 = "<html><head><title>";
        static final String HEADER_2 = "</title></head><body>";
        static final String HEADER_3 = "<table cellpadding=\"0\" border=\"1\">";
        static final String FOOTER = "</table></body></html>";

        public HTMLExportAction() {
            this.putValue("ShortDescription", "Export the results to HTML");
            this.putValue("SmallIcon", MainFrame.getIcon("Download"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            XJFileChooser fileChooser = MainFrame.getFileChooser() != null ? MainFrame.getFileChooser() : new XJFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(true);
            fileChooser.setDialogTitle("Choose a file to export the results");
            fileChooser.setFileSelectionMode(0);
            ExtensionFileFilter filter = new ExtensionFileFilter("HTML files", "html");
            fileChooser.addChoosableFileFilter(filter);
            String fileName = AnnotationDiffGUI.this.resDoc.getSourceUrl() != null ? new File(AnnotationDiffGUI.this.resDoc.getSourceUrl().getFile()).getName() : AnnotationDiffGUI.this.resDoc.getName();
            fileName = fileName + "_" + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString() + ".html";
            fileChooser.setFileName(fileName);
            fileChooser.setResource(AnnotationDiffGUI.class.getName());
            int res = fileChooser.showSaveDialog(AnnotationDiffGUI.this);
            if (res != 0) {
                return;
            }
            File saveFile = fileChooser.getSelectedFile();
            try {
                String nl = Strings.getNl();
                BufferedWriter fw = new BufferedWriter(new FileWriter(saveFile));
                fw.write(HEADER_1);
                fw.write(AnnotationDiffGUI.this.resDoc.getName() + " " + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString() + " annotations");
                fw.write(HEADER_2 + nl);
                fw.write("<H2>Annotation Diff - comparing " + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString() + " annotations</H2>");
                fw.write("<TABLE cellpadding=\"5\" border=\"0\"");
                fw.write(nl);
                fw.write("<TR>" + nl);
                fw.write("\t<TH align=\"left\">&nbsp;</TH>" + nl);
                fw.write("\t<TH align=\"left\">Document</TH>" + nl);
                fw.write("\t<TH align=\"left\">Annotation Set</TH>" + nl);
                fw.write("</TR>" + nl);
                fw.write("<TR>" + nl);
                fw.write("\t<TH align=\"left\">Key</TH>" + nl);
                fw.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.keyDoc.getName() + "</TD>" + nl);
                fw.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.keySet.getName() + "</TD>" + nl);
                fw.write("</TR>" + nl);
                fw.write("<TR>" + nl);
                fw.write("\t<TH align=\"left\">Response</TH>" + nl);
                fw.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.resDoc.getName() + "</TD>" + nl);
                fw.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.resSet.getName() + "</TD>" + nl);
                fw.write("</TR>" + nl);
                fw.write("</TABLE>" + nl);
                fw.write("<BR><BR><BR>" + nl);
                NumberFormat format = NumberFormat.getInstance();
                format.setMaximumFractionDigits(4);
                fw.write("Recall: " + format.format(AnnotationDiffGUI.this.differ.getRecallStrict()) + "<br>" + nl);
                fw.write("Precision: " + format.format(AnnotationDiffGUI.this.differ.getPrecisionStrict()) + "<br>" + nl);
                fw.write("F-measure: " + format.format(AnnotationDiffGUI.this.differ.getFMeasureStrict(1.0)) + "<br>" + nl);
                fw.write("<br>");
                fw.write("Correct: " + AnnotationDiffGUI.this.differ.getCorrectMatches() + "<br>" + nl);
                fw.write("Partially correct: " + AnnotationDiffGUI.this.differ.getPartiallyCorrectMatches() + "<br>" + nl);
                fw.write("Missing: " + AnnotationDiffGUI.this.differ.getMissing() + "<br>" + nl);
                fw.write("False positives: " + AnnotationDiffGUI.this.differ.getSpurious() + "<br>" + nl);
                fw.write(HEADER_3 + nl + "<TR>" + nl);
                int maxColIdx = AnnotationDiffGUI.this.diffTable.getColumnCount() - 1;
                for (int col = 0; col <= maxColIdx; ++col) {
                    fw.write("\t<TH align=\"left\">" + AnnotationDiffGUI.this.diffTable.getColumnName(col) + "</TH>" + nl);
                }
                fw.write("</TR>");
                int rowCnt = AnnotationDiffGUI.this.diffTableModel.getRowCount();
                for (int row = 0; row < rowCnt; ++row) {
                    fw.write("<TR>");
                    for (int col = 0; col <= maxColIdx; ++col) {
                        Color bgCol = AnnotationDiffGUI.this.diffTableModel.getBackgroundAt(AnnotationDiffGUI.this.diffTable.rowViewToModel(row), AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(col));
                        fw.write("\t<TD bgcolor=\"#" + Integer.toHexString(bgCol.getRGB()).substring(2) + "\">" + AnnotationDiffGUI.this.diffTable.getValueAt(row, col) + "</TD>" + nl);
                    }
                    fw.write("</TR>");
                }
                fw.write(FOOTER);
                ((Writer)fw).flush();
                ((Writer)fw).close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(AnnotationDiffGUI.this, ioe.toString(), "GATE", 0);
                ioe.printStackTrace();
            }
        }
    }

    protected class CopyToTargetSetAction
    extends AbstractAction {
        public CopyToTargetSetAction() {
            super("Copy selection to target set");
            this.putValue("ShortDescription", "<html>Move selected annotations to the target annotation set<br>and hide their paired annotations if not moved.&nbsp;&nbsp;<font color=\"#667799\"><small>Alt-Right</small></font></html>");
            this.putValue("MnemonicKey", 39);
            this.putValue("SmallIcon", MainFrame.getIcon("RightArrow"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String step = (String)AnnotationDiffGUI.this.keyDoc.getFeatures().get("anndiffsteps");
            if (step == null) {
                step = "0";
            }
            AnnotationSet target = AnnotationDiffGUI.this.keyDoc.getAnnotations(AnnotationDiffGUI.this.consensusASTextField.getText().trim());
            AnnotationSet keyAS = AnnotationDiffGUI.this.keyDoc.getAnnotations((String)AnnotationDiffGUI.this.keySetCombo.getSelectedItem());
            AnnotationSet responseAS = AnnotationDiffGUI.this.resDoc.getAnnotations((String)AnnotationDiffGUI.this.resSetCombo.getSelectedItem());
            int countCopied = 0;
            int countMarked = 0;
            for (int row = 0; row < AnnotationDiffGUI.this.pairings.size(); ++row) {
                FeatureMap features;
                if (AnnotationDiffGUI.this.keyCopyValueRows.get(row).booleanValue()) {
                    Annotation key = AnnotationDiffGUI.this.pairings.get(row).getKey();
                    key.getFeatures().put("anndiffstep", step);
                    features = (FeatureMap)((SimpleFeatureMapImpl)key.getFeatures()).clone();
                    features.put("anndiffsource", AnnotationDiffGUI.this.keySetCombo.getSelectedItem());
                    try {
                        target.add(key.getStartNode().getOffset(), key.getEndNode().getOffset(), key.getType(), features);
                    }
                    catch (InvalidOffsetException e) {
                        e.printStackTrace();
                    }
                    if (key.getFeatures().containsKey("anndiffmodified")) {
                        keyAS.remove(key);
                    }
                    ++countCopied;
                    if (AnnotationDiffGUI.this.pairings.get(row).getResponse() != null && !AnnotationDiffGUI.this.resCopyValueRows.get(row).booleanValue()) {
                        AnnotationDiffGUI.this.pairings.get(row).getResponse().getFeatures().put("anndiffstep", step);
                        ++countMarked;
                    }
                }
                if (!AnnotationDiffGUI.this.resCopyValueRows.get(row).booleanValue()) continue;
                Annotation response = AnnotationDiffGUI.this.pairings.get(row).getResponse();
                response.getFeatures().put("anndiffstep", step);
                features = (FeatureMap)((SimpleFeatureMapImpl)response.getFeatures()).clone();
                features.put("anndiffsource", AnnotationDiffGUI.this.resSetCombo.getSelectedItem());
                try {
                    target.add(response.getStartNode().getOffset(), response.getEndNode().getOffset(), response.getType(), features);
                }
                catch (InvalidOffsetException e) {
                    e.printStackTrace();
                }
                if (response.getFeatures().containsKey("anndiffmodified")) {
                    responseAS.remove(response);
                }
                ++countCopied;
                if (AnnotationDiffGUI.this.pairings.get(row).getKey() == null || AnnotationDiffGUI.this.keyCopyValueRows.get(row).booleanValue()) continue;
                AnnotationDiffGUI.this.pairings.get(row).getKey().getFeatures().put("anndiffstep", step);
                ++countMarked;
            }
            if (countCopied > 0) {
                step = String.valueOf(Integer.parseInt(step) + 1);
                AnnotationDiffGUI.this.keyDoc.getFeatures().put("anndiffsteps", step);
                AnnotationDiffGUI.this.diffAction.actionPerformed(new ActionEvent(this, -1, "copy"));
                AnnotationDiffGUI.this.statusLabel.setText(countCopied + " annotations copied to " + AnnotationDiffGUI.this.consensusASTextField.getText().trim() + " and " + countMarked + " hidden");
                AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
            } else {
                AnnotationDiffGUI.this.diffTable.requestFocusInWindow();
                AnnotationDiffGUI.this.statusLabel.setText("Tick checkboxes in the columns K(ey) and R(esponse)");
                AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
            }
        }
    }

    protected class DiffAction
    extends AbstractAction {
        public DiffAction() {
            super("Compare");
            this.putValue("ShortDescription", "Compare annotations between key and response sets");
            this.putValue("MnemonicKey", 10);
            this.putValue("SmallIcon", MainFrame.getIcon("Run"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final int rowView = AnnotationDiffGUI.this.diffTable.getSelectedRow();
            final int colView = AnnotationDiffGUI.this.diffTable.getSelectedColumn();
            final int id = evt.getID();
            final String command = evt.getActionCommand();
            AnnotationDiffGUI.this.progressBar.setIndeterminate(true);
            AnnotationDiffGUI.this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    HashSet<Annotation> keys = new HashSet<Annotation>(AnnotationDiffGUI.this.keySet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem()));
                    HashSet<Annotation> responses = new HashSet<Annotation>(AnnotationDiffGUI.this.resSet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem()));
                    int countHidden = 0;
                    if (AnnotationDiffGUI.this.bottomTabbedPane.getSelectedIndex() == 1) {
                        for (Annotation annotation : new ArrayList<Annotation>(keys)) {
                            if (!annotation.getFeatures().containsKey("anndiffstep")) continue;
                            keys.remove(annotation);
                            ++countHidden;
                        }
                        for (Annotation annotation : new ArrayList<Annotation>(responses)) {
                            if (!annotation.getFeatures().containsKey("anndiffstep")) continue;
                            responses.remove(annotation);
                            ++countHidden;
                        }
                    }
                    if (AnnotationDiffGUI.this.someFeaturesBtn.isSelected()) {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(AnnotationDiffGUI.this.significantFeatures);
                    } else if (AnnotationDiffGUI.this.allFeaturesBtn.isSelected()) {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(null);
                    } else {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(new HashSet<String>());
                    }
                    AnnotationDiffGUI.this.pairings.clear();
                    AnnotationDiffGUI.this.pairings.addAll(AnnotationDiffGUI.this.differ.calculateDiff(keys, responses));
                    AnnotationDiffGUI.this.keyCopyValueRows.clear();
                    AnnotationDiffGUI.this.keyCopyValueRows.addAll(Collections.nCopies(AnnotationDiffGUI.this.pairings.size(), false));
                    AnnotationDiffGUI.this.resCopyValueRows.clear();
                    AnnotationDiffGUI.this.resCopyValueRows.addAll(Collections.nCopies(AnnotationDiffGUI.this.pairings.size(), false));
                    if (command.equals("setvalue")) {
                        int row = 0;
                        for (AnnotationDiffer.Pairing pairing : AnnotationDiffGUI.this.pairings) {
                            if (pairing.getKey() != null && pairing.getKey().getFeatures().containsKey("anndiffmodified")) {
                                AnnotationDiffGUI.this.keyCopyValueRows.set(row, true);
                            }
                            if (pairing.getResponse() != null && pairing.getResponse().getFeatures().containsKey("anndiffmodified")) {
                                AnnotationDiffGUI.this.resCopyValueRows.set(row, true);
                            }
                            ++row;
                        }
                    }
                    final int countHiddenF = countHidden;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                            AnnotationDiffGUI.this.correctLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getCorrectMatches()));
                            AnnotationDiffGUI.this.partiallyCorrectLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getPartiallyCorrectMatches()));
                            AnnotationDiffGUI.this.missingLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getMissing()));
                            AnnotationDiffGUI.this.falsePozLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getSpurious()));
                            NumberFormat f = NumberFormat.getInstance();
                            f.setMaximumFractionDigits(2);
                            f.setMinimumFractionDigits(2);
                            AnnotationDiffGUI.this.recallStrictLbl.setText(f.format(AnnotationDiffGUI.this.differ.getRecallStrict()));
                            AnnotationDiffGUI.this.recallLenientLbl.setText(f.format(AnnotationDiffGUI.this.differ.getRecallLenient()));
                            AnnotationDiffGUI.this.recallAveLbl.setText(f.format(AnnotationDiffGUI.this.differ.getRecallAverage()));
                            AnnotationDiffGUI.this.precisionStrictLbl.setText(f.format(AnnotationDiffGUI.this.differ.getPrecisionStrict()));
                            AnnotationDiffGUI.this.precisionLenientLbl.setText(f.format(AnnotationDiffGUI.this.differ.getPrecisionLenient()));
                            AnnotationDiffGUI.this.precisionAveLbl.setText(f.format(AnnotationDiffGUI.this.differ.getPrecisionAverage()));
                            double weight = Double.parseDouble(AnnotationDiffGUI.this.weightTxt.getText());
                            AnnotationDiffGUI.this.fmeasureStrictLbl.setText(f.format(AnnotationDiffGUI.this.differ.getFMeasureStrict(weight)));
                            AnnotationDiffGUI.this.fmeasureLenientLbl.setText(f.format(AnnotationDiffGUI.this.differ.getFMeasureLenient(weight)));
                            AnnotationDiffGUI.this.fmeasureAveLbl.setText(f.format(AnnotationDiffGUI.this.differ.getFMeasureAverage(weight)));
                            AnnotationDiffGUI.this.copyToTargetSetAction.setEnabled(AnnotationDiffGUI.this.keyDoc.equals(AnnotationDiffGUI.this.resDoc));
                            if (AnnotationDiffGUI.this.keyDoc.equals(AnnotationDiffGUI.this.resDoc)) {
                                AnnotationDiffGUI.this.copyToConsensusBtn.setToolTipText((String)AnnotationDiffGUI.this.copyToTargetSetAction.getValue("ShortDescription"));
                            } else {
                                AnnotationDiffGUI.this.copyToConsensusBtn.setToolTipText("Key and response document must be the same");
                            }
                            if (!command.equals("setvalue") && !command.equals("copy")) {
                                AnnotationDiffGUI.this.statusLabel.setText(AnnotationDiffGUI.this.pairings.size() + " pairings have been found (" + countHiddenF + " annotations are hidden)");
                                AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                            }
                            AnnotationDiffGUI.this.diffTable.requestFocusInWindow();
                            AnnotationDiffGUI.this.progressBar.setIndeterminate(false);
                            AnnotationDiffGUI.this.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
                            AnnotationDiffGUI.this.showDocumentAction.setEnabled(false);
                            if (!command.equals("setvalue") && !command.equals("copy")) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (command.equals("setvalue")) {
                                        for (int row = 0; row < AnnotationDiffGUI.this.diffTable.getRowCount(); ++row) {
                                            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(AnnotationDiffGUI.this.diffTable.rowViewToModel(row));
                                            if ((pairing.getKey() == null || pairing.getKey().getId() != id) && (pairing.getResponse() == null || pairing.getResponse().getId() != id)) continue;
                                            AnnotationDiffGUI.this.diffTable.changeSelection(row, colView, false, false);
                                            break;
                                        }
                                    } else if (command.equals("copy")) {
                                        AnnotationDiffGUI.this.diffTable.changeSelection(rowView, colView, false, false);
                                    }
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            AnnotationDiffGUI.this.diffTable.scrollRectToVisible(AnnotationDiffGUI.this.diffTable.getCellRect(AnnotationDiffGUI.this.diffTable.getSelectedRow(), AnnotationDiffGUI.this.diffTable.getSelectedColumn(), true));
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            };
            Thread thread = new Thread(runnable, "DiffAction");
            thread.setPriority(1);
            thread.start();
        }
    }
}

