/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Gate;
import gate.creole.FeatureMethod;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Err;
import gate.util.Files;
import gate.util.GateException;
import gate.util.Out;
import gate.util.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class BootStrap {
    protected static final String oldResource = "creole/bootstrap/";
    protected static final String nameProject = "Template";
    protected static final String newLine = Strings.getNl();
    protected Map<String, String> names = new HashMap<String, String>();
    protected Map<String, String> oldNames = new HashMap<String, String>();
    protected List<String> listMethodsResource = new ArrayList<String>();
    protected List<String> listPackages = new ArrayList<String>();
    protected Set<String> allPackages = null;
    protected Map<Integer, String> fields = null;
    protected char[] cbuffer = new char[65000];
    protected static final int BUFF_SIZE = 65000;

    public BootStrap() {
        this.allPackages = new HashSet<String>();
        this.fields = new HashMap<Integer, String>();
    }

    public String changeKeyValue(String text, Map<String, String> map) {
        Set<String> keys = map.keySet();
        for (String key : keys) {
            String value = map.get(key);
            text = text.replaceAll(key, value);
        }
        return text;
    }

    public String determineTypePackage(String text) {
        int index = text.lastIndexOf(".");
        int ind = text.lastIndexOf(";");
        String type = new String();
        String packageName = new String();
        if (index != -1) {
            if (ind != -1) {
                type = text.substring(index + 1, text.length() - 1) + "[]";
                packageName = text.substring(2, index) + ".*";
            } else {
                packageName = text.substring(0, index) + ".*";
                type = text.substring(index + 1, text.length());
            }
            if (!this.allPackages.contains(packageName) && packageName.compareTo("java.lang.*") != 0) {
                this.allPackages.add(packageName);
            }
        } else {
            type = text;
        }
        return type;
    }

    public String getInterfacesAndClass(String typeResource, Set<String> interfacesList) throws ClassNotFoundException {
        String abstractClass = null;
        String interfacesAndClass = null;
        Class<?> currentClass = null;
        if (typeResource.equals("ProcessingResource")) {
            abstractClass = "AbstractProcessingResource";
        } else if (typeResource.equals("VisualResource")) {
            abstractClass = "AbstractVisualResource";
        } else if (typeResource.equals("LanguageResource")) {
            abstractClass = "AbstractLanguageResource";
        }
        interfacesAndClass = " extends " + abstractClass;
        List<FeatureMethod> methodsInterfaces = new ArrayList<FeatureMethod>();
        if (interfacesList != null) {
            interfacesAndClass = interfacesAndClass + newLine + "  implements ";
            for (String nameInterface : interfacesList) {
                String nameClass = null;
                int index = nameInterface.lastIndexOf(".");
                if (index != -1) {
                    currentClass = Class.forName(nameInterface);
                    nameClass = nameInterface.substring(index + 1, nameInterface.length());
                } else {
                    nameClass = nameInterface;
                    currentClass = Class.forName("gate." + nameInterface);
                }
                this.allPackages.add(currentClass.getPackage().getName() + ".*");
                interfacesAndClass = interfacesAndClass + nameClass + ", ";
                methodsInterfaces = this.featuresClass(currentClass, methodsInterfaces);
            }
        }
        if (!interfacesList.contains("gate." + typeResource)) {
            interfacesAndClass = interfacesAndClass + typeResource;
        } else if (interfacesAndClass.endsWith(", ")) {
            interfacesAndClass = interfacesAndClass.substring(0, interfacesAndClass.length() - 2);
        }
        List<FeatureMethod> methodsClassExtend = new ArrayList<FeatureMethod>();
        Class<?> currentClassExtend = Class.forName("gate.creole." + abstractClass);
        methodsClassExtend = this.featuresClass(currentClassExtend, methodsClassExtend);
        this.getMethodsAndFields(methodsClassExtend, methodsInterfaces);
        return interfacesAndClass;
    }

    public List<FeatureMethod> featuresClass(Class<?> currentClass, List<FeatureMethod> methodsList) {
        Method[] listMethodsCurrentClass = currentClass.getMethods();
        for (int i = 0; i < listMethodsCurrentClass.length; ++i) {
            int k;
            FeatureMethod featureMethod = new FeatureMethod();
            featureMethod.setNameMethod(listMethodsCurrentClass[i].getName());
            featureMethod.setValueReturn(listMethodsCurrentClass[i].getReturnType().getName());
            Class<?>[] parameters = listMethodsCurrentClass[i].getParameterTypes();
            Class<?>[] exceptions = listMethodsCurrentClass[i].getExceptionTypes();
            ArrayList<String> aux = new ArrayList<String>();
            for (k = 0; k < parameters.length; ++k) {
                aux.add(parameters[k].getName());
            }
            featureMethod.setParameterTypes(aux);
            aux = new ArrayList();
            for (k = 0; k < exceptions.length; ++k) {
                aux.add(exceptions[k].getName());
            }
            featureMethod.setExceptionTypes(aux);
            if (methodsList.contains(featureMethod)) continue;
            methodsList.add(featureMethod);
        }
        return methodsList;
    }

    public void getMethodsAndFields(List<FeatureMethod> methodsExtendList, List<FeatureMethod> methodsInterfacesList) {
        int j = 0;
        for (int i = 0; i < methodsInterfacesList.size(); ++i) {
            int k;
            FeatureMethod featureMethod = methodsInterfacesList.get(i);
            if (methodsExtendList.contains(featureMethod)) continue;
            String nameMethod = featureMethod.getNameMethod();
            List<String> valTypes = featureMethod.getParameterTypes();
            String typeReturn = this.determineTypePackage(featureMethod.getValueReturn());
            List<String> valException = featureMethod.getExceptionTypes();
            String declaration = "public " + typeReturn + " " + nameMethod + "(";
            if (valTypes.size() == 0) {
                declaration = declaration + ")";
            } else {
                for (k = 0; k < valTypes.size(); ++k) {
                    String type = valTypes.get(k);
                    declaration = type.endsWith("[]") ? declaration + this.determineTypePackage(type.substring(0, type.length() - 2)) + " parameter" + k : declaration + this.determineTypePackage(valTypes.get(k)) + " parameter" + k;
                    declaration = k == valTypes.size() - 1 ? declaration + ")" : declaration + ", ";
                }
            }
            if (valException.size() == 0) {
                if (!typeReturn.equals("void")) {
                    declaration = !typeReturn.endsWith("[]") ? declaration + "{ return " + typeReturn.toLowerCase() + j + "; }" : declaration + "{ return " + typeReturn.toLowerCase().substring(0, typeReturn.length() - 2) + j + "; }";
                    this.fields.put(new Integer(j), typeReturn);
                    ++j;
                } else {
                    declaration = declaration + " {}";
                }
            } else {
                declaration = declaration + newLine + "                throws ";
                for (k = 0; k < valException.size(); ++k) {
                    declaration = declaration + this.determineTypePackage(valException.get(k));
                    if (k == valException.size() - 1) {
                        if (!typeReturn.equals("void")) {
                            declaration = !typeReturn.endsWith("[]") ? declaration + "{ return " + typeReturn.toLowerCase() + j + "; }" : declaration + "{ return " + typeReturn.toLowerCase().substring(0, typeReturn.length() - 2) + j + "; }";
                            this.fields.put(new Integer(j), typeReturn);
                            ++j;
                            continue;
                        }
                        declaration = declaration + " {}";
                        continue;
                    }
                    declaration = declaration + ", ";
                }
            }
            this.listMethodsResource.add(declaration);
        }
    }

    public String displayMethodsAndFields(List<String> methods, Map<Integer, String> fields) {
        String methodsFields = "";
        Iterator<String> iterator = this.listMethodsResource.iterator();
        while (iterator.hasNext()) {
            methodsFields = methodsFields + newLine + iterator.next() + newLine;
        }
        for (Integer index : fields.keySet()) {
            String type = fields.get(index);
            if (type.endsWith("[]")) {
                methodsFields = methodsFields + newLine + "protected " + type + " " + type.substring(0, type.length() - 2).toLowerCase() + index.toString() + ";";
                continue;
            }
            methodsFields = methodsFields + newLine + "protected " + type + " " + type.toLowerCase() + index.toString() + ";";
        }
        return methodsFields;
    }

    public Map<String, String> createNames(String packageName, String resourceName, String className, String stringPackages, String interfacesAndClass) {
        String packages = this.namesPackages(this.allPackages);
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        int day = calendar.get(5);
        String date = day + "/" + month + "/" + year;
        String user = System.getProperty("user.name");
        this.names.put(nameProject, resourceName);
        this.names.put(nameProject.toUpperCase(), resourceName.toUpperCase());
        this.names.put(nameProject.toLowerCase(), resourceName.toLowerCase());
        this.names.put("___CLASSNAME___", className);
        this.names.put("___INTERFACES___", interfacesAndClass);
        this.names.put("___CONTENT___", this.displayMethodsAndFields(this.listMethodsResource, this.fields));
        this.names.put("___DATE___", date);
        this.names.put("___AUTHOR___", user);
        this.names.put("___ALLPACKAGES___", stringPackages);
        this.names.put("___PACKAGE___", packageName);
        this.names.put("___PACKAGETOP___", this.listPackages.get(0));
        this.names.put("___RESOURCE___", resourceName);
        this.names.put("___GATECLASSPATH___", System.getProperty("path.separator") + System.getProperty("java.class.path"));
        File gateHome = Gate.getGateHome();
        if (gateHome == null) {
            this.names.put("___GATEHOME___", Gate.runningOnUnix() ? "/path/to/gate" : "C:/Program Files/GATE");
        } else {
            this.names.put("___GATEHOME___", gateHome.getPath().replace('\\', '/'));
        }
        if (packages.length() == 0) {
            this.names.put("import ___packages___.*;", "");
        } else {
            this.names.put("import ___packages___.*;", packages);
        }
        this.oldNames.put("___PACKAGE___", "template");
        this.oldNames.put("___ALLPACKAGES___", "template");
        this.oldNames.put("___PACKAGETOP___", "template");
        return this.names;
    }

    public String namesPackages(Set<String> listPackages) {
        Iterator<String> iterator = listPackages.iterator();
        String packages = new String();
        while (iterator.hasNext()) {
            String currentPackage = iterator.next();
            if (currentPackage.equals("gate.*") || currentPackage.equals("gate.creole.*") || currentPackage.equals("gate.util.*") || currentPackage.equals("java.util.*")) continue;
            packages = packages + newLine + "import " + currentPackage + ";";
        }
        return packages;
    }

    public List<String> determinePath(String packageName) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(packageName, ".");
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
        return list;
    }

    public void verifyInput(String className, String pathNewProject) throws GateException {
        char[] classNameChars = className.toCharArray();
        for (int i = 0; i < classNameChars.length; ++i) {
            if (Character.isLetterOrDigit(classNameChars[i])) continue;
            throw new GateException("Only letters and digits in the class name");
        }
        File dir = new File(pathNewProject);
        if (!dir.isDirectory()) {
            throw new GateException("The folder is not a directory");
        }
    }

    public void executableFile(String nameFile) throws IOException, InterruptedException {
        Runtime rt;
        Process proc;
        int exitVal;
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Windows") && (exitVal = (proc = (rt = Runtime.getRuntime()).exec("chmod 711 " + nameFile)).waitFor()) != 0) {
            Out.prln("Warning: it is necessary to make executable the following file: " + nameFile);
        }
    }

    public void createResource(String resourceName, String packageName, String typeResource, String className, Set<String> interfacesList, String pathNewProject) throws IOException, ClassNotFoundException, GateException, InterruptedException {
        File newFile = null;
        Properties properties = new Properties();
        String newPathFile = null;
        String oldPathFile = null;
        this.verifyInput(className, pathNewProject);
        String interfacesAndClass = this.getInterfacesAndClass(typeResource, interfacesList);
        this.listPackages = this.determinePath(packageName);
        if (!pathNewProject.endsWith("/")) {
            pathNewProject = pathNewProject + "/";
        }
        String stringPackages = this.listPackages.get(0);
        for (int i = 1; i < this.listPackages.size(); ++i) {
            stringPackages = stringPackages + "/" + this.listPackages.get(i);
        }
        this.createNames(packageName, resourceName, className, stringPackages, interfacesAndClass);
        InputStream inputStream = Files.getGateResourceAsStream("creole/bootstrap/file-list.properties");
        properties.load(inputStream);
        inputStream.close();
        String oldDirectories = properties.getProperty("directories");
        StringTokenizer token = new StringTokenizer(oldDirectories, ",");
        while (token.hasMoreTokens()) {
            String propPathDirectory = token.nextToken();
            if (propPathDirectory.endsWith("___ALLPACKAGES___")) {
                newPathFile = propPathDirectory.substring(0, propPathDirectory.length() - 18);
                newPathFile = this.changeKeyValue(newPathFile, this.names);
                for (int i = 0; i < this.listPackages.size(); ++i) {
                    newPathFile = newPathFile + "/" + this.listPackages.get(i);
                    newFile = new File(pathNewProject + newPathFile);
                    newFile.mkdir();
                }
                continue;
            }
            newPathFile = this.changeKeyValue(propPathDirectory, this.names);
            newFile = new File(pathNewProject + newPathFile);
            newFile.mkdir();
        }
        Enumeration<?> keyProperties = properties.propertyNames();
        while (keyProperties.hasMoreElements()) {
            String key = (String)keyProperties.nextElement();
            if (key.equals("directories")) continue;
            String oldFiles = properties.getProperty(key);
            token = new StringTokenizer(oldFiles, ",");
            while (token.hasMoreTokens()) {
                String propPathFiles = token.nextToken();
                oldPathFile = this.changeKeyValue(propPathFiles, this.oldNames);
                newPathFile = this.changeKeyValue(propPathFiles, this.names);
                if (newPathFile.endsWith("jav")) {
                    newPathFile = newPathFile + "a";
                }
                newFile = new File(pathNewProject + newPathFile);
                FileWriter fileWriter = new FileWriter(newFile);
                InputStream currentInputStream = Files.getGateResourceAsStream(oldResource + oldPathFile);
                BomStrippingInputStreamReader inputStreamReader = new BomStrippingInputStreamReader(currentInputStream);
                int charRead = 0;
                String text = null;
                while ((charRead = ((Reader)inputStreamReader).read(this.cbuffer, 0, 65000)) != -1) {
                    text = new String(this.cbuffer, 0, charRead);
                    text = this.changeKeyValue(text, this.names);
                    fileWriter.write(text, 0, text.length());
                }
                ((Reader)inputStreamReader).close();
                currentInputStream.close();
                fileWriter.close();
                if (!newPathFile.endsWith("configure") && !newPathFile.endsWith(".sh")) continue;
                this.executableFile(pathNewProject + newPathFile);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("path.separator"));
        System.out.println("intre");
        System.out.println(System.getProperty("java.class.path"));
        BootStrap bootStrap = new BootStrap();
        HashSet<String> interfaces = new HashSet<String>();
        interfaces.add("gate.Document");
        interfaces.add("gate.ProcessingResource");
        try {
            bootStrap.createResource("morph", "creole.sheffield.ac.lisa", "LanguageResource", "Documente", interfaces, "z:/test");
        }
        catch (GateException ge) {
            ge.printStackTrace(Err.getPrintWriter());
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace(Err.getPrintWriter());
        }
        catch (IOException ioe) {
            ioe.printStackTrace(Err.getPrintWriter());
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(Err.getPrintWriter());
        }
    }
}

