/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Controller;
import gate.Corpus;
import gate.CreoleProxy;
import gate.DataStore;
import gate.Document;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.SimpleDocument;
import gate.VisualResource;
import gate.annotation.ImmutableAnnotationSetImpl;
import gate.creole.AbstractProcessingResource;
import gate.creole.AbstractResource;
import gate.creole.AnnotationSchema;
import gate.creole.CustomDuplication;
import gate.creole.ParameterException;
import gate.creole.ParameterList;
import gate.creole.Plugin;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.util.SimpleFeatureMapImpl;
import gate.util.Strings;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class Factory {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DUPLICATION = false;
    private static final Logger log = Logger.getLogger(Factory.class);
    private static CreoleProxy creoleProxy;
    private static long dupIndex;

    public static Resource createResource(String resourceClassName) throws ResourceInstantiationException {
        ResourceData resData = (ResourceData)Gate.getCreoleRegister().get(resourceClassName);
        if (resData == null) {
            Set<Plugin> plugins = Gate.getPlugins(resourceClassName);
            StringBuilder msg = new StringBuilder();
            msg.append("Couldn't get resource data for ").append(resourceClassName).append(".\n\n");
            if (plugins.isEmpty()) {
                msg.append("You may need first to load the plugin that contains your resource.\n");
                msg.append("For example, to create a gate.creole.tokeniser.DefaultTokeniser\n");
                msg.append("you need first to load the ANNIE plugin.\n\n");
            } else if (plugins.size() == 1) {
                msg.append(resourceClassName).append(" can be found in the ").append(plugins.iterator().next().getName()).append(" plugin\n\n");
            } else {
                msg.append(resourceClassName).append(" can be found in the following plugins\n   ");
                for (Plugin dInfo : plugins) {
                    msg.append(dInfo.getName()).append(", ");
                }
                msg.setLength(msg.length() - 2);
                msg.append("\n\n");
            }
            msg.append("Go to the menu File->Manage CREOLE plugins or use the method\n");
            msg.append("\"registerPlugin\" on Gate.getCreoleRegister()");
            throw new ResourceInstantiationException(msg.toString());
        }
        ParameterList paramList = resData.getParameterList();
        FeatureMap parameterValues = null;
        try {
            parameterValues = paramList.getInitimeDefaults();
        }
        catch (ParameterException e) {
            throw new ResourceInstantiationException("Couldn't get default parameters for " + resourceClassName + ": " + e);
        }
        return Factory.createResource(resourceClassName, parameterValues);
    }

    public static Resource createResource(String resourceClassName, FeatureMap parameterValues) throws ResourceInstantiationException {
        return Factory.createResource(resourceClassName, parameterValues, null, null);
    }

    public static Resource createResource(String resourceClassName, FeatureMap parameterValues, FeatureMap features) throws ResourceInstantiationException {
        return Factory.createResource(resourceClassName, parameterValues, features, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource createResource(String resourceClassName, FeatureMap parameterValues, FeatureMap features, String resourceName) throws ResourceInstantiationException {
        FeatureMap parameters;
        DataStore dataStore;
        ResourceData resData = (ResourceData)Gate.getCreoleRegister().get(resourceClassName);
        if (resData == null) {
            Set<Plugin> plugins = Gate.getPlugins(resourceClassName);
            StringBuilder msg = new StringBuilder();
            msg.append("Couldn't get resource data for ").append(resourceClassName).append(".\n\n");
            if (plugins.isEmpty()) {
                msg.append("You may need first to load the plugin that contains your resource.\n");
                msg.append("For example, to create a gate.creole.tokeniser.DefaultTokeniser\n");
                msg.append("you need first to load the ANNIE plugin.\n\n");
            } else if (plugins.size() == 1) {
                msg.append(resourceClassName).append(" can be found in the ").append(plugins.iterator().next().getName()).append(" plugin\n\n");
            } else {
                msg.append(resourceClassName).append(" can be found in the following plugins\n   ");
                for (Plugin dInfo : plugins) {
                    msg.append(dInfo.getName()).append(", ");
                }
                msg.setLength(msg.length() - 2);
                msg.append("\n\n");
            }
            msg.append("Go to the menu File->Manage CREOLE plugins or use the method\n");
            msg.append("Gate.getCreoleRegister().registerDirectories(pluginDirectoryURL).");
            throw new ResourceInstantiationException(msg.toString());
        }
        Class<? extends Resource> resClass = null;
        try {
            resClass = resData.getResourceClass();
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInstantiationException("Couldn't get resource class from the resource data:" + Strings.getNl() + e);
        }
        Resource res = null;
        if (LanguageResource.class.isAssignableFrom(resClass) && (dataStore = (DataStore)parameterValues.get("DataStore")) != null) {
            if (dataStore instanceof SerialDataStore && !Serializable.class.isAssignableFrom(resClass)) {
                throw new ResourceInstantiationException("Resource cannot be (de-)serialized: " + resClass.getName());
            }
            Object instanceId = parameterValues.get("LRPersistenceId");
            if (instanceId == null) {
                throw new ResourceInstantiationException("No instance id for " + resClass);
            }
            try {
                res = dataStore.getLr(resClass.getName(), instanceId);
            }
            catch (PersistenceException pe) {
                throw new ResourceInstantiationException("Bad read from DB: " + pe);
            }
            catch (SecurityException se) {
                throw new ResourceInstantiationException("Insufficient permissions: " + se);
            }
            resData.addInstantiation(res);
            if (features != null) {
                if (res.getFeatures() == null) {
                    res.setFeatures(Factory.newFeatureMap());
                }
                res.getFeatures().putAll(features);
            }
            if (res.getName() == null) {
                res.setName(resourceName == null ? resData.getName() + "_" + Gate.genSym() : resourceName);
            }
            creoleProxy.fireResourceLoaded(new CreoleEvent(res, 1));
            return res;
        }
        try {
            res = resClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ResourceInstantiationException("Couldn't create resource instance, access denied: " + e);
        }
        catch (InstantiationException e) {
            throw new ResourceInstantiationException("Couldn't create resource instance due to newInstance() failure: " + e);
        }
        if (!LanguageResource.class.isAssignableFrom(resClass)) {
            if (ProcessingResource.class.isAssignableFrom(resClass)) {
                try {
                    parameters = Factory.newFeatureMap();
                    parameters.putAll(resData.getParameterList().getRuntimeDefaults());
                    res.setParameterValues(parameters);
                }
                catch (ParameterException pe) {
                    throw new ResourceInstantiationException("Could not set the runtime parameters to their default values for: " + res.getClass().getName() + " :\n" + pe.toString());
                }
            } else if (VisualResource.class.isAssignableFrom(resClass) || Controller.class.isAssignableFrom(resClass)) {
                // empty if block
            }
        }
        try {
            parameters = Factory.newFeatureMap();
            parameters.putAll(resData.getParameterList().getInitimeDefaults());
            parameters.putAll(parameterValues);
            res.setParameterValues(parameters);
        }
        catch (ParameterException pe) {
            throw new ResourceInstantiationException("Could not set the init parameters for: " + res.getClass().getName() + " :\n" + pe.toString());
        }
        if (resourceName != null && resourceName.trim().length() > 0) {
            res.setName(resourceName);
        } else if (res.getName() == null) {
            try {
                Method m;
                URL sourceUrl = null;
                if (res instanceof SimpleDocument) {
                    sourceUrl = ((SimpleDocument)res).getSourceUrl();
                } else if (res instanceof AnnotationSchema) {
                    sourceUrl = ((AnnotationSchema)res).getXmlFileUrl();
                } else if (res.getClass().getName().startsWith("gate.creole.ontology.owlim.")) {
                    m = resClass.getMethod("getRdfXmlURL", new Class[0]);
                    sourceUrl = (URL)m.invoke((Object)res, new Object[0]);
                    if (sourceUrl == null) {
                        m = resClass.getMethod("getN3URL", new Class[0]);
                        sourceUrl = (URL)m.invoke((Object)res, new Object[0]);
                    }
                    if (sourceUrl == null) {
                        m = resClass.getMethod("getNtriplesURL", new Class[0]);
                        sourceUrl = (URL)m.invoke((Object)res, new Object[0]);
                    }
                    if (sourceUrl == null) {
                        m = resClass.getMethod("getTurtleURL", new Class[0]);
                        sourceUrl = (URL)m.invoke((Object)res, new Object[0]);
                    }
                } else if (res.getClass().getName().startsWith("gate.creole.ontology.impl.")) {
                    m = resClass.getMethod("getSourceURL", new Class[0]);
                    sourceUrl = (URL)m.invoke((Object)res, new Object[0]);
                }
                if (sourceUrl != null) {
                    URI sourceURI = sourceUrl.toURI();
                    resourceName = sourceURI.getPath();
                    if (resourceName == null || resourceName.length() == 0 || resourceName.equals("/")) {
                        resourceName = sourceURI.toString();
                    } else {
                        String subStr;
                        int lastSlash = (resourceName = resourceName.trim()).lastIndexOf(47);
                        if (lastSlash >= 0 && (subStr = resourceName.substring(lastSlash + 1)).trim().length() > 0) {
                            resourceName = subStr;
                        }
                    }
                }
            }
            catch (RuntimeException sourceUrl) {
            }
            catch (Exception sourceUrl) {
            }
            finally {
                if (resourceName == null || resourceName.trim().length() == 0) {
                    resourceName = resData.getName();
                }
            }
            resourceName = resourceName + "_" + Gate.genSym();
            res.setName(resourceName);
        }
        HashMap<String, EventListener> listeners = new HashMap<String, EventListener>(Gate.getListeners());
        if (!listeners.isEmpty()) {
            try {
                AbstractResource.setResourceListeners(res, listeners);
            }
            catch (Exception e) {
                throw new ResourceInstantiationException("Parameterisation failure" + e);
            }
        }
        if (res.getFeatures() == null || res.getFeatures().isEmpty()) {
            FeatureMap fm = Factory.newFeatureMap();
            fm.putAll(resData.getFeatures());
            res.setFeatures(fm);
        }
        if (features != null) {
            res.getFeatures().putAll(features);
        }
        res = res.init();
        if (!listeners.isEmpty()) {
            try {
                AbstractResource.removeResourceListeners(res, listeners);
            }
            catch (Exception e) {
                throw new ResourceInstantiationException("Parameterisation failure" + e);
            }
        }
        resData.addInstantiation(res);
        creoleProxy.fireResourceLoaded(new CreoleEvent(res, 1));
        return res;
    }

    public static void deleteResource(Resource resource) {
        ResourceData rd = (ResourceData)Gate.getCreoleRegister().get(resource.getClass().getName());
        if (rd != null && rd.removeInstantiation(resource)) {
            creoleProxy.fireResourceUnloaded(new CreoleEvent(resource, 2));
            resource.cleanup();
        }
    }

    public static Corpus newCorpus(String name) throws ResourceInstantiationException {
        return (Corpus)Factory.createResource("gate.corpora.CorpusImpl", Factory.newFeatureMap(), Factory.newFeatureMap(), name);
    }

    public static Document newDocument(URL sourceUrl) throws ResourceInstantiationException {
        FeatureMap parameterValues = Factory.newFeatureMap();
        parameterValues.put("sourceUrl", sourceUrl);
        return (Document)Factory.createResource("gate.corpora.DocumentImpl", parameterValues);
    }

    public static Document newDocument(URL sourceUrl, String encoding) throws ResourceInstantiationException {
        FeatureMap parameterValues = Factory.newFeatureMap();
        parameterValues.put("sourceUrl", sourceUrl);
        parameterValues.put("encoding", encoding);
        return (Document)Factory.createResource("gate.corpora.DocumentImpl", parameterValues);
    }

    public static Document newDocument(String content) throws ResourceInstantiationException {
        FeatureMap params = Factory.newFeatureMap();
        params.put("stringContent", content);
        Document doc = (Document)Factory.createResource("gate.corpora.DocumentImpl", params);
        doc.setSourceUrl(null);
        return doc;
    }

    public static AnnotationSet createImmutableAnnotationSet(Document document, Collection<Annotation> annotations) {
        return new ImmutableAnnotationSetImpl(document, annotations);
    }

    public static Resource duplicate(Resource res) throws ResourceInstantiationException {
        DuplicationContext ctx = new DuplicationContext();
        try {
            Resource resource = Factory.duplicate(res, ctx);
            return resource;
        }
        finally {
            ctx.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource duplicate(Resource res, DuplicationContext ctx) throws ResourceInstantiationException {
        block5: {
            block4: {
                long myDupIndex = -1L;
                long startTime = -1L;
                Factory.checkDuplicationContext(ctx);
                if (res != null) break block4;
                Resource resource = null;
                return resource;
            }
            if (!ctx.knownResources.containsKey(res)) break block5;
            Resource resource = ctx.knownResources.get(res);
            return resource;
        }
        Resource newRes = null;
        newRes = res instanceof CustomDuplication ? ((CustomDuplication)((Object)res)).duplicate(ctx) : Factory.defaultDuplicate(res, ctx);
        ctx.knownResources.put(res, newRes);
        Resource resource = newRes;
        return resource;
    }

    public static Resource defaultDuplicate(Resource res, DuplicationContext ctx) throws ResourceInstantiationException {
        Factory.checkDuplicationContext(ctx);
        String className = res.getClass().getName();
        ResourceData resData = (ResourceData)Gate.getCreoleRegister().get(className);
        if (resData == null) {
            throw new ResourceInstantiationException("Could not find CREOLE data for " + className);
        }
        String resName = res.getName();
        FeatureMap newResFeatures = Factory.duplicate(res.getFeatures(), ctx);
        FeatureMap initParams = AbstractResource.getInitParameterValues(res);
        for (String propName : resData.getSharableProperties()) {
            initParams.remove(propName);
        }
        initParams = Factory.duplicate(initParams, ctx);
        for (String propName : resData.getSharableProperties()) {
            initParams.put(propName, res.getParameterValue(propName));
        }
        Resource newResource = Factory.createResource(className, initParams, newResFeatures, resName);
        if (newResource instanceof ProcessingResource) {
            FeatureMap runtimeParams = AbstractProcessingResource.getRuntimeParameterValues(res);
            for (String propName : resData.getSharableProperties()) {
                runtimeParams.remove(propName);
            }
            runtimeParams = Factory.duplicate(runtimeParams, ctx);
            newResource.setParameterValues(runtimeParams);
        }
        return newResource;
    }

    public static FeatureMap duplicate(FeatureMap fm, DuplicationContext ctx) throws ResourceInstantiationException {
        Factory.checkDuplicationContext(ctx);
        FeatureMap newFM = Factory.newFeatureMap();
        for (Map.Entry entry : fm.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Resource) {
                value = Factory.duplicate((Resource)value, ctx);
            }
            newFM.put(entry.getKey(), value);
        }
        return newFM;
    }

    protected static void checkDuplicationContext(DuplicationContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("No DuplicationContext provided");
        }
        if (!ctx.active) {
            throw new IllegalStateException(new Throwable().getStackTrace()[1].getMethodName() + " helper method called outside an active duplicate call");
        }
    }

    public static FeatureMap newFeatureMap() {
        return new SimpleFeatureMapImpl();
    }

    public static DataStore openDataStore(String dataStoreClassName, String storageUrl) throws PersistenceException {
        DataStore ds = Factory.instantiateDataStore(dataStoreClassName, storageUrl);
        ds.open();
        if (Gate.getDataStoreRegister().add(ds)) {
            creoleProxy.fireDatastoreOpened(new CreoleEvent(ds, 4));
        }
        return ds;
    }

    public static DataStore createDataStore(String dataStoreClassName, String storageUrl) throws PersistenceException, UnsupportedOperationException {
        DataStore ds = Factory.instantiateDataStore(dataStoreClassName, storageUrl);
        ds.create();
        ds.open();
        if (Gate.getDataStoreRegister().add(ds)) {
            creoleProxy.fireDatastoreCreated(new CreoleEvent(ds, 3));
        }
        return ds;
    }

    protected static DataStore instantiateDataStore(String dataStoreClassName, String storageUrl) throws PersistenceException {
        DataStore godfreyTheDataStore = null;
        try {
            godfreyTheDataStore = (DataStore)Gate.getClassLoader().loadClass(dataStoreClassName).newInstance();
        }
        catch (Exception e) {
            throw new PersistenceException("Couldn't create DS class: " + e);
        }
        godfreyTheDataStore.setStorageUrl(storageUrl);
        return godfreyTheDataStore;
    }

    public static synchronized void addCreoleListener(CreoleListener l) {
        creoleProxy.addCreoleListener(l);
    }

    static {
        dupIndex = 0L;
        creoleProxy = new CreoleProxy();
    }

    public static class DuplicationContext {
        IdentityHashMap<Resource, Resource> knownResources = new IdentityHashMap();
        boolean active = true;

        DuplicationContext() {
        }
    }
}

