/*
 * Decompiled with CFR 0.152.
 */
package gate.util.ant.packager;

import gate.util.Files;
import gate.util.ant.packager.GappModel;
import gate.util.maven.SimpleMavenCache;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class PackageGappTask
extends Task {
    public static final Comparator<URL> PATH_COMPARATOR = new Comparator<URL>(){

        @Override
        public int compare(URL a, URL b) {
            if (a == null) {
                return b == null ? 0 : -1;
            }
            if (b == null) {
                return 1;
            }
            return a.getPath().compareTo(b.getPath());
        }
    };
    private File destFile;
    private File src;
    private File gateHome;
    private File resourcesHome;
    private File mavenCache;
    private boolean copyPlugins = true;
    private boolean copyResourceDirs = false;
    private List<Path> extraResourcesPaths = new ArrayList<Path>();
    private UnresolvedAction onUnresolved = UnresolvedAction.fail;
    private List<MappingHint> hintTasks = new ArrayList<MappingHint>();
    private Map<URL, String> mappingHints = new LinkedHashMap<URL, String>();

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public File getSrc() {
        return this.src;
    }

    public void setSrc(File src) {
        this.src = src;
    }

    public File getGateHome() {
        return this.gateHome;
    }

    public void setGateHome(File gateHome) {
        this.gateHome = gateHome;
    }

    public File getResourcesHome() {
        return this.resourcesHome;
    }

    public void setResourcesHome(File resourcesHome) {
        this.resourcesHome = resourcesHome;
    }

    public File getMavenCache() {
        return this.mavenCache;
    }

    public void setMavenCache(File mavenCache) {
        this.mavenCache = mavenCache;
    }

    public boolean isCopyPlugins() {
        return this.copyPlugins;
    }

    public void setCopyPlugins(boolean copyPlugins) {
        this.copyPlugins = copyPlugins;
    }

    public boolean isCopyResourceDirs() {
        return this.copyResourceDirs;
    }

    public void setCopyResourceDirs(boolean copyResourceDirs) {
        this.copyResourceDirs = copyResourceDirs;
    }

    public UnresolvedAction getOnUnresolved() {
        return this.onUnresolved;
    }

    public void setOnUnresolved(UnresolvedAction onUnresolved) {
        this.onUnresolved = onUnresolved;
    }

    public MappingHint createHint() {
        MappingHint hint = new MappingHint();
        hint.setProject(this.getProject());
        hint.setTaskName(this.getTaskName());
        hint.setLocation(this.getLocation());
        hint.init();
        this.hintTasks.add(hint);
        return hint;
    }

    public void addExtraResourcesPath(Path path) {
        this.extraResourcesPaths.add(path);
    }

    public void execute() throws BuildException {
        List<GappModel.MavenPlugin> mavenPlugins;
        for (MappingHint h : this.hintTasks) {
            h.perform();
        }
        HashMap<URL, URL> fileCopyMap = new HashMap<URL, URL>();
        HashMap<URL, URL> dirCopyMap = new HashMap<URL, URL>();
        TreeMap<URL, URL> pluginCopyMap = new TreeMap<URL, URL>(PATH_COMPARATOR);
        this.log("Packaging gapp file " + this.src);
        GappModel gappModel = null;
        URL newFileURL = null;
        try {
            URL gateHomeURL = null;
            if (this.gateHome != null) {
                gateHomeURL = this.gateHome.toURI().toURL();
            }
            URL resourcesHomeURL = null;
            if (this.resourcesHome != null) {
                resourcesHomeURL = this.resourcesHome.toURI().toURL();
            }
            gappModel = new GappModel(this.src.toURI().toURL(), gateHomeURL, resourcesHomeURL);
            newFileURL = this.destFile.toURI().toURL();
            gappModel.setGappFileURL(newFileURL);
        }
        catch (MalformedURLException e) {
            throw new BuildException("Couldn't convert src or dest file to URL", (Throwable)e, this.getLocation());
        }
        TreeSet<URL> plugins = new TreeSet<URL>(PATH_COMPARATOR);
        plugins.addAll(gappModel.getPluginURLs());
        TreeSet<URL> resources = new TreeSet<URL>(PATH_COMPARATOR);
        resources.addAll(gappModel.getResourceURLs());
        this.processExtraResourcesPaths(resources);
        if (this.mappingHints != null && !this.mappingHints.isEmpty()) {
            Iterator resourcesIt = resources.iterator();
            block28: while (resourcesIt.hasNext()) {
                URL resource = (URL)resourcesIt.next();
                for (URL hint : this.mappingHints.keySet()) {
                    String hintString = hint.toExternalForm();
                    if (!resource.equals(hint) && (!hintString.endsWith("/") || !resource.toExternalForm().startsWith(hintString))) continue;
                    this.log("Found resource " + resource + " under mapping hint URL " + hint, 3);
                    String hintTarget = this.mappingHints.get(hint);
                    URL newResourceURL = null;
                    if (hintTarget == null) {
                        this.log("  Converting to absolute URL", 3);
                        newResourceURL = resource;
                    } else {
                        try {
                            URL mappedHint = new URL(newFileURL, hintTarget);
                            String resourceRelpath = PersistenceManager.getRelativePath(hint, resource);
                            newResourceURL = new URL(mappedHint, resourceRelpath);
                            fileCopyMap.put(resource, newResourceURL);
                            if (this.copyResourceDirs) {
                                dirCopyMap.put(new URL(resource, "."), new URL(newResourceURL, "."));
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new BuildException("Couldn't construct URL relative to " + hintTarget + " for " + resource, (Throwable)e, this.getLocation());
                        }
                        this.log("  Relocating to " + newResourceURL, 3);
                    }
                    gappModel.updatePathForURL(resource, newResourceURL, hintTarget != null);
                    resourcesIt.remove();
                    continue block28;
                }
            }
        }
        Iterator pluginsIt = plugins.iterator();
        while (pluginsIt.hasNext()) {
            Iterator pluginURL = (URL)pluginsIt.next();
            pluginsIt.remove();
            URL newPluginURL = null;
            Object pluginName = ((URL)((Object)pluginURL)).getFile();
            this.log("Processing plugin " + (String)pluginName, 3);
            SortedMap possibleAncestors = pluginCopyMap.headMap((URL)((Object)pluginURL));
            URL ancestorPlugin = null;
            if (!possibleAncestors.isEmpty()) {
                ancestorPlugin = (URL)((Object)possibleAncestors.lastKey());
            }
            if (ancestorPlugin != null && ((URL)((Object)pluginURL)).toExternalForm().startsWith(ancestorPlugin.toExternalForm())) {
                this.log("  Plugin is located under another plugin " + ancestorPlugin, 3);
                String relPath = PersistenceManager.getRelativePath(ancestorPlugin, pluginURL);
                try {
                    newPluginURL = new URL(pluginCopyMap.get(ancestorPlugin), relPath);
                }
                catch (MalformedURLException e) {
                    throw new BuildException("Couldn't construct URL relative to plugins/ for " + pluginURL, (Throwable)e, this.getLocation());
                }
            }
            boolean addSlash = false;
            if (((String)pluginName).endsWith("/")) {
                addSlash = true;
                pluginName = ((String)pluginName).substring(((String)pluginName).lastIndexOf(47, ((String)pluginName).length() - 2) + 1, ((String)pluginName).length() - 1);
            } else {
                pluginName = ((String)pluginName).substring(((String)pluginName).lastIndexOf(47) + 1);
            }
            this.log("  Plugin name is " + (String)pluginName, 3);
            try {
                newPluginURL = new URL(newFileURL, "plugins/" + (String)pluginName + (addSlash ? "/" : ""));
                if (pluginCopyMap.containsValue(newPluginURL)) {
                    int index = 2;
                    while (pluginCopyMap.containsValue(newPluginURL = new URL(newFileURL, "plugins/" + (String)pluginName + "-" + index++ + (addSlash ? "/" : "")))) {
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new BuildException("Couldn't construct URL relative to plugins/ for " + pluginURL, (Throwable)e, this.getLocation());
            }
            this.log("  Relocating to " + newPluginURL, 3);
            gappModel.updatePathForURL((URL)((Object)pluginURL), newPluginURL, true);
            pluginCopyMap.put((URL)((Object)pluginURL), newPluginURL);
            String pluginUri = ((URL)((Object)pluginURL)).toExternalForm();
            if (!pluginUri.endsWith("/")) {
                pluginUri = pluginUri + "/";
            }
            Iterator resourcesIt = resources.iterator();
            while (resourcesIt.hasNext()) {
                URL resourceURL = (URL)resourcesIt.next();
                try {
                    if (!resourceURL.toExternalForm().startsWith(pluginUri)) continue;
                    resourcesIt.remove();
                    String resourceRelpath = PersistenceManager.getRelativePath(pluginURL, resourceURL);
                    this.log("    Found resource " + resourceURL, 3);
                    URL newResourceURL = null;
                    newResourceURL = new URL(newPluginURL, resourceRelpath);
                    this.log("    Relocating to " + newResourceURL, 3);
                    gappModel.updatePathForURL(resourceURL, newResourceURL, true);
                    fileCopyMap.put(resourceURL, newResourceURL);
                    if (!this.copyResourceDirs) continue;
                    dirCopyMap.put(new URL(resourceURL, "."), new URL(newResourceURL, "."));
                }
                catch (MalformedURLException e) {
                    throw new BuildException("Couldn't construct URL relative to " + newPluginURL + " for " + resourceURL, (Throwable)e, this.getLocation());
                }
            }
        }
        if (!resources.isEmpty()) {
            switch (this.onUnresolved) {
                case fail: {
                    this.log("There were unresolved resources:", 0);
                    for (URL res : resources) {
                        this.log(res.toExternalForm(), 0);
                    }
                    this.log("Either set onUnresolved=\"absolute|recover\" or add the relevant mapping hints", 0);
                    throw new BuildException("There were unresolved resources", this.getLocation());
                }
                case absolute: {
                    this.log("There were unresolved resources, which have been made absolute", 1);
                    for (URL res : resources) {
                        gappModel.updatePathForURL(res, res, false);
                        this.log(res.toExternalForm(), 3);
                    }
                    break;
                }
                case recover: {
                    URL unresolvedResourcesDir = null;
                    try {
                        unresolvedResourcesDir = new URL(newFileURL, "application-resources/");
                    }
                    catch (MalformedURLException e) {
                        throw new BuildException("Can't construct URL relative to " + newFileURL + " for application-resources", (Throwable)e, this.getLocation());
                    }
                    TreeMap<URL, URL> unresolvedResourcesSubDirs = new TreeMap<URL, URL>(PATH_COMPARATOR);
                    this.log("There were unresolved resources, which have been gathered into " + unresolvedResourcesDir, 2);
                    for (URL res : resources) {
                        URL resourceDir = null;
                        try {
                            resourceDir = new URL(res, ".");
                        }
                        catch (MalformedURLException e) {
                            throw new BuildException("Can't construct URL to parent directory of " + res, (Throwable)e, this.getLocation());
                        }
                        URL targetDir = this.getUnresolvedResourcesTarget(unresolvedResourcesSubDirs, unresolvedResourcesDir, resourceDir);
                        String resName = res.getFile();
                        resName = resName.substring(resName.lastIndexOf(47) + 1);
                        URL newResourceURL = null;
                        try {
                            newResourceURL = new URL(targetDir, resName);
                        }
                        catch (MalformedURLException e) {
                            throw new BuildException("Can't construct URL relative to " + unresolvedResourcesDir + " for " + resName, (Throwable)e, this.getLocation());
                        }
                        gappModel.updatePathForURL(res, newResourceURL, true);
                        fileCopyMap.put(res, newResourceURL);
                        if (!this.copyResourceDirs) continue;
                        dirCopyMap.put(resourceDir, targetDir);
                    }
                    break;
                }
                default: {
                    throw new BuildException("Unrecognised UnresolvedAction", this.getLocation());
                }
            }
        }
        try {
            this.log("Writing modified gapp to " + this.destFile);
            gappModel.write();
        }
        catch (IOException e) {
            throw new BuildException("Error writing out modified GAPP file", (Throwable)e, this.getLocation());
        }
        if (fileCopyMap.size() > 0) {
            this.log("Copying " + fileCopyMap.size() + " resources");
        }
        for (Map.Entry resEntry : fileCopyMap.entrySet()) {
            File source = Files.fileFromURL((URL)resEntry.getKey());
            File dest = Files.fileFromURL((URL)resEntry.getValue());
            if (source.isDirectory()) {
                dest.mkdirs();
                continue;
            }
            dest.getParentFile().mkdirs();
            if (!source.isFile()) continue;
            try {
                this.log("Copying " + source + " to " + dest, 3);
                FileUtils.getFileUtils().copyFile(source, dest);
            }
            catch (IOException e) {
                throw new BuildException("Error copying file " + source + " to " + dest, (Throwable)e, this.getLocation());
            }
        }
        if (pluginCopyMap.size() > 0) {
            this.log("Copying " + pluginCopyMap.size() + " plugins");
            if (this.copyPlugins) {
                this.log("Also copying complete plugin contents", 3);
            }
            this.copyDirectories(pluginCopyMap, !this.copyPlugins);
        }
        if (dirCopyMap.size() > 0) {
            this.log("Copying " + dirCopyMap.size() + " resource directories");
            this.copyDirectories(dirCopyMap, false);
        }
        if (this.mavenCache != null && !(mavenPlugins = gappModel.getMavenPlugins()).isEmpty()) {
            this.log("Creating Maven cache at " + this.mavenCache.getAbsolutePath());
            SimpleMavenCache smc = new SimpleMavenCache(this.mavenCache);
            for (GappModel.MavenPlugin plugin : mavenPlugins) {
                this.log("  Cacheing " + plugin.group + ":" + plugin.artifact + ":" + plugin.version, 3);
                DefaultArtifact pluginArtifact = new DefaultArtifact(plugin.group, plugin.artifact, "jar", plugin.version);
                try {
                    smc.cacheArtifact((Artifact)pluginArtifact);
                }
                catch (IOException | ModelBuildingException | SettingsBuildingException | DependencyCollectionException | ArtifactResolutionException | DependencyResolutionException e) {
                    throw new BuildException("Error cacheing plugin " + plugin.group + ":" + plugin.artifact + ":" + plugin.version, e);
                }
            }
        }
    }

    private void processExtraResourcesPaths(Set<URL> resources) {
        for (Path p : this.extraResourcesPaths) {
            for (String resource : p.list()) {
                File resourceFile = new File(resource);
                try {
                    resources.add(resourceFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new BuildException("Couldn't construct URL for extra resource " + resourceFile, (Throwable)e, this.getLocation());
                }
            }
        }
    }

    private void copyDirectories(Map<URL, URL> copyMap, boolean minimalPlugin) {
        for (Map.Entry<URL, URL> copyEntry : copyMap.entrySet()) {
            File source = Files.fileFromURL(copyEntry.getKey());
            if (!source.exists()) {
                return;
            }
            File dest = Files.fileFromURL(copyEntry.getValue());
            Copy copyTask = new Copy();
            copyTask.setProject(this.getProject());
            copyTask.setLocation(this.getLocation());
            copyTask.setTaskName(this.getTaskName());
            copyTask.setTodir(dest);
            dest.mkdirs();
            FileSet fileSet = new FileSet();
            copyTask.addFileset(fileSet);
            fileSet.setDir(source);
            if (minimalPlugin) {
                URL creoleXml;
                PatternSet.NameEntry include = fileSet.createInclude();
                include.setName("creole.xml");
                try {
                    creoleXml = new URL(copyEntry.getKey().toExternalForm() + "/creole.xml");
                }
                catch (MalformedURLException e) {
                    throw new BuildException("Error creating URL for creole.xml in plugin " + copyEntry.getKey());
                }
                for (String jarString : this.getJars(creoleXml)) {
                    PatternSet.NameEntry jarInclude = fileSet.createInclude();
                    jarInclude.setName(jarString);
                }
            }
            copyTask.init();
            copyTask.perform();
        }
    }

    private Set<String> getJars(URL creoleXml) {
        try {
            HashSet<String> jars = new HashSet<String>();
            XPath jarXPath = XPath.newInstance((String)"//*[translate(local-name(), 'jar', 'JAR') = 'JAR']");
            SAXBuilder builder = new SAXBuilder();
            Document creoleDoc = builder.build(creoleXml);
            List jarElts = jarXPath.selectNodes((Object)creoleDoc);
            for (Element e : jarElts) {
                jars.add(e.getTextTrim());
            }
            return jars;
        }
        catch (JDOMException e) {
            throw new BuildException("Error extracting JAR elements from " + creoleXml, (Throwable)e, this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException("Error loading " + creoleXml + " to extract JARs", (Throwable)e, this.getLocation());
        }
    }

    private URL getUnresolvedResourcesTarget(TreeMap<URL, URL> unresolvedResourcesSubDirs, URL unresolvedResourcesDir, URL resourceDir) throws BuildException {
        URL targetDir = unresolvedResourcesSubDirs.get(resourceDir);
        try {
            if (targetDir == null) {
                SortedMap<URL, URL> possibleAncestors = unresolvedResourcesSubDirs.headMap(resourceDir);
                URL nearestAncestor = null;
                if (!possibleAncestors.isEmpty()) {
                    nearestAncestor = possibleAncestors.lastKey();
                }
                if (nearestAncestor != null && resourceDir.toExternalForm().startsWith(nearestAncestor.toExternalForm())) {
                    String relPath = PersistenceManager.getRelativePath(nearestAncestor, resourceDir);
                    targetDir = new URL(unresolvedResourcesSubDirs.get(nearestAncestor), relPath);
                } else {
                    String targetDirName;
                    String resourcePath = resourceDir.getFile();
                    if (resourcePath.endsWith("/")) {
                        resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
                    }
                    if ((targetDirName = resourcePath.substring(resourcePath.lastIndexOf(47) + 1)).length() == 0) {
                        targetDirName = "resources";
                    }
                    if (unresolvedResourcesSubDirs.containsValue(targetDir = new URL(unresolvedResourcesDir, targetDirName + "/"))) {
                        int index = 2;
                        while (unresolvedResourcesSubDirs.containsValue(targetDir = new URL(unresolvedResourcesDir, targetDirName + "-" + index++ + "/"))) {
                        }
                    }
                }
                unresolvedResourcesSubDirs.put(resourceDir, targetDir);
            }
        }
        catch (MalformedURLException e) {
            throw new BuildException("Can't construct target URL for directory " + resourceDir, (Throwable)e, this.getLocation());
        }
        return targetDir;
    }

    public class MappingHint
    extends Property {
        private boolean absolute = false;

        public void setFrom(File from) {
            super.setName(from.getAbsolutePath());
        }

        public void setTo(String to) {
            super.setValue(to);
        }

        public void setAbsolute(boolean absolute) {
            if (absolute) {
                super.setValue("dummy");
            }
            this.absolute = absolute;
        }

        protected void addProperty(String n, String v) {
            this.addProperty(n, (Object)v);
        }

        protected void addProperty(String n, Object vObj) {
            String v = vObj == null ? null : vObj.toString();
            try {
                File source = this.getProject().resolveFile(n);
                if (source.isDirectory() && v != null && !v.endsWith("/")) {
                    v = v + "/";
                }
                PackageGappTask.this.mappingHints.put(source.toURI().toURL(), this.absolute ? null : v);
            }
            catch (MalformedURLException e) {
                PackageGappTask.this.log("Couldn't interpret \"" + n + "\" as a file path, ignored", 1);
            }
        }
    }

    public static enum UnresolvedAction {
        fail,
        absolute,
        recover;

    }
}

