/*
 * Decompiled with CFR 0.152.
 */
package gate.util.ant.packager;

import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.persistence.PersistenceManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class GappModel {
    private Document gappDocument;
    private URL gappFileURL;
    private URL gateHomeURL;
    private URL resourcesHomeURL;
    private Map<URL, List<Element>> pluginRelpathsMap = new HashMap<URL, List<Element>>();
    private Map<URL, List<Element>> resourceRelpathsMap = new HashMap<URL, List<Element>>();
    private List<MavenPlugin> mavenPlugins;
    private static XPath relativeResourcePathElementsXPath;
    private static XPath relativePluginPathElementsXPath;
    private static XPath mavenPluginsXpath;

    public GappModel(URL gappFileURL) {
        this(gappFileURL, null, null);
    }

    public GappModel(URL gappFileURL, URL gateHomeURL) {
        this(gappFileURL, gateHomeURL, null);
    }

    public GappModel(URL gappFileURL, URL gateHomeURL, URL resourcesHomeURL) {
        if (!"file".equals(gappFileURL.getProtocol())) {
            throw new GateRuntimeException("GAPP URL must be a file: URL");
        }
        if (gateHomeURL != null && !"file".equals(gateHomeURL.getProtocol())) {
            throw new GateRuntimeException("GATE home URL must be a file: URL");
        }
        this.gappFileURL = gappFileURL;
        this.gateHomeURL = gateHomeURL;
        this.resourcesHomeURL = resourcesHomeURL;
        try {
            SAXBuilder builder = new SAXBuilder();
            this.gappDocument = builder.build(gappFileURL);
        }
        catch (Exception ex) {
            throw new GateRuntimeException("Error parsing GAPP file", ex);
        }
        if (relativeResourcePathElementsXPath == null) {
            try {
                relativeResourcePathElementsXPath = XPath.newInstance((String)"/gate.util.persistence.GateApplication/application//gate.util.persistence.PersistenceManager-URLHolder/urlString[starts-with(., '$relpath$') or starts-with(., '$resourceshome$') or starts-with(., '$gatehome$')] | /gate.util.persistence.GateApplication/application//*[@class='gate.util.persistence.PersistenceManager$URLHolder']/urlString[starts-with(., '$relpath$') or starts-with(., '$resourceshome$') or starts-with(., '$gatehome$')]");
                relativePluginPathElementsXPath = XPath.newInstance((String)"/gate.util.persistence.GateApplication/urlList//gate.util.persistence.PersistenceManager-URLHolder/urlString[starts-with(., '$relpath$') or starts-with(., '$resourceshome$') or starts-with(., '$gatehome$')]");
                mavenPluginsXpath = XPath.newInstance((String)"/gate.util.persistence.GateApplication/urlList/localList/gate.creole.Plugin-Maven");
            }
            catch (JDOMException jdx) {
                throw new GateRuntimeException("Error creating XPath expression", jdx);
            }
        }
        List resourceRelpaths = null;
        List pluginRelpaths = null;
        try {
            resourceRelpaths = relativeResourcePathElementsXPath.selectNodes((Object)this.gappDocument);
            pluginRelpaths = relativePluginPathElementsXPath.selectNodes((Object)this.gappDocument);
            this.mavenPlugins = mavenPluginsXpath.selectNodes((Object)this.gappDocument).stream().map(elt -> new MavenPlugin((Element)elt)).collect(Collectors.toList());
        }
        catch (JDOMException e) {
            throw new GateRuntimeException("Error extracting 'relpath' URLs from GAPP file", e);
        }
        try {
            this.buildRelpathsMap(resourceRelpaths, this.resourceRelpathsMap);
            this.buildRelpathsMap(pluginRelpaths, this.pluginRelpathsMap);
        }
        catch (MalformedURLException mue) {
            throw new GateRuntimeException("Error parsing relative paths in GAPP file", mue);
        }
    }

    private void buildRelpathsMap(List<Element> relpathElements, Map<URL, List<Element>> relpathsMap) throws MalformedURLException {
        for (Element el : relpathElements) {
            String relativePath;
            String elementText = el.getText();
            URL targetURL = null;
            if (elementText.startsWith("$gatehome$")) {
                if (this.gateHomeURL == null) {
                    throw new GateRuntimeException("Found a $gatehome$ relative path in GAPP file, but no GATE home URL provided to resolve against");
                }
                relativePath = el.getText().substring("$gatehome$".length());
                targetURL = new URL(this.gateHomeURL, relativePath);
            } else if (elementText.startsWith("$resourceshome$")) {
                if (this.gateHomeURL == null) {
                    throw new GateRuntimeException("Found a $resourceshome$ relative path in GAPP file, but no resources home URL provided to resolve against");
                }
                relativePath = el.getText().substring("$resourceshome$".length());
                targetURL = new URL(this.resourcesHomeURL, relativePath);
            } else if (elementText.startsWith("$relpath$")) {
                relativePath = el.getText().substring("$relpath$".length());
                targetURL = new URL(this.gappFileURL, relativePath);
            }
            List<Element> eltsForURL = relpathsMap.get(targetURL);
            if (eltsForURL == null) {
                eltsForURL = new ArrayList<Element>();
                relpathsMap.put(targetURL, eltsForURL);
            }
            eltsForURL.add(el);
        }
    }

    public URL getGappFileURL() {
        return this.gappFileURL;
    }

    public void setGappFileURL(URL gappFileURL) {
        this.gappFileURL = gappFileURL;
    }

    public Document getGappDocument() {
        return this.gappDocument;
    }

    public Set<URL> getPluginURLs() {
        return this.pluginRelpathsMap.keySet();
    }

    public List<MavenPlugin> getMavenPlugins() {
        return this.mavenPlugins;
    }

    public Set<URL> getResourceURLs() {
        return this.resourceRelpathsMap.keySet();
    }

    public void updatePathForURL(URL originalURL, URL newURL, boolean makeRelative) {
        List<Element> resourceEltsToUpdate = this.resourceRelpathsMap.get(originalURL);
        List<Element> pluginEltsToUpdate = this.pluginRelpathsMap.get(originalURL);
        if (resourceEltsToUpdate == null && pluginEltsToUpdate == null) {
            return;
        }
        String newPath = makeRelative ? "$relpath$" + PersistenceManager.getRelativePath(this.gappFileURL, newURL) : newURL.toExternalForm();
        if (resourceEltsToUpdate != null) {
            for (Element e : resourceEltsToUpdate) {
                e.setText(newPath);
            }
        }
        if (pluginEltsToUpdate != null) {
            for (Element e : pluginEltsToUpdate) {
                e.setText(newPath);
            }
        }
    }

    public void finish() {
        try {
            XPath duplicatePluginXPath = XPath.newInstance((String)"/gate.util.persistence.GateApplication/urlList/localList/gate.util.persistence.PersistenceManager-URLHolder[urlString = preceding-sibling::gate.util.persistence.PersistenceManager-URLHolder/urlString]");
            List duplicatePlugins = duplicatePluginXPath.selectNodes((Object)this.gappDocument);
            for (Element e : duplicatePlugins) {
                e.getParentElement().removeContent((Content)e);
            }
        }
        catch (JDOMException e) {
            throw new GateRuntimeException("Error applying XPath expression to remove duplicate plugins", e);
        }
    }

    public void write() throws IOException {
        this.finish();
        File newGappFile = Files.fileFromURL(this.gappFileURL);
        FileOutputStream fos = new FileOutputStream(newGappFile);
        BufferedOutputStream out = new BufferedOutputStream(fos);
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        outputter.output(this.gappDocument, (OutputStream)out);
    }

    public static class MavenPlugin {
        public String group;
        public String artifact;
        public String version;

        MavenPlugin(Element pluginElt) {
            this.group = pluginElt.getChildText("group");
            this.artifact = pluginElt.getChildText("artifact");
            this.version = pluginElt.getChildText("version");
        }
    }
}

